/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;

public class InCategoryOperation
extends AttributeOperation {
    private boolean fInvert;

    public InCategoryOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    public boolean evaluate(Object left, Object right) {
        boolean result = this.internalEvaluate(left, right);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right) {
        if (left instanceof ICategory && right instanceof ICategory) {
            String categoryId = ((ICategory)left).getCategoryId().getInternalRepresentation();
            return categoryId.startsWith(((ICategory)right).getCategoryId().getInternalRepresentation());
        }
        return false;
    }

    public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
        IStringField categoryIdField = (IStringField)context.getReference(true).getField(ICategory.CATEGORY_ID);
        String categoryPath = this.getCategoryPath(context);
        IPredicate predicate = categoryIdField._like((IString)context.getQuery().newStringArg());
        context.addParameter(categoryPath);
        if (this.fInvert) {
            predicate = this.invertNullAware(context, predicate);
        }
        if (context.getAttribute().isStateExtension()) {
            predicate = context.createOldStateExtensionPredicate(predicate);
        }
        return predicate;
    }

    private String getCategoryPath(ITransformationContext context) throws TeamRepositoryException {
        ICategoryHandle categoryHandle = (ICategoryHandle)context.getValue();
        ICategory category = context.getAuditableCommon().resolveAuditable(categoryHandle, ICategory.DEFAULT_PROFILE, null);
        return category.getCategoryId().getSubtreePattern();
    }

    public boolean isNegation() {
        return this.fInvert;
    }
}

