/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.presentations;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.presentations.Messages;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickInformationConfigurationManager
extends CacheHelper {
    private static final String QUICKINFORMATIONCONFIGURATIONCONFIGURATIONDATA = "com.ibm.team.workitem.editor.configuration.quickinformationconfiguration";
    public static final String QUICKINFORMATIONCONFIGURATION = "quickinformationConfiguration";
    public static final String LINKTARGET = "linkTarget";
    public static final String ENDPOINTID = "endpointId";
    private Map<UUID, Map<String, List<QuickInformationConfigurationEntry>>> fEntryCache = new HashMap<UUID, Map<String, List<QuickInformationConfigurationEntry>>>();

    public QuickInformationConfigurationManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public List<QuickInformationConfigurationEntry> getQuickInformationEntries(IProjectAreaHandle projectArea, String quickinformationConfigurationId, IProgressMonitor monitor) throws TeamRepositoryException {
        List<QuickInformationConfigurationEntry> entries;
        this.checkCache(projectArea, monitor);
        Map<String, List<QuickInformationConfigurationEntry>> map = this.fEntryCache.get(projectArea.getItemId());
        if (map == null) {
            map = new HashMap<String, List<QuickInformationConfigurationEntry>>();
        }
        entries = (entries = map.get(quickinformationConfigurationId)) == null ? Collections.emptyList() : Collections.unmodifiableList(entries);
        return entries;
    }

    public Set<String> getQuickinformationConfigurationIds(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, List<QuickInformationConfigurationEntry>> map = this.fEntryCache.get(projectArea.getItemId());
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    private void updateEntries(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, List<Object>> configurationEntries = new HashMap<String, List<Object>>();
        ArrayList<String> configurationIds = new ArrayList<String>();
        IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(QUICKINFORMATIONCONFIGURATIONCONFIGURATIONDATA, monitor);
        if (processConfiguration != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = processConfiguration.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
                if (QUICKINFORMATIONCONFIGURATION.equals(configurationElement.getName()) && (id = configurationElement.getAttribute("id")) != null) {
                    configurationIds.add(id);
                    IProcessConfigurationElement[] iProcessConfigurationElementArray2 = configurationElement.getChildren();
                    int n3 = iProcessConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String typeId;
                        IProcessConfigurationElement element = iProcessConfigurationElementArray2[n4];
                        if ("presentation".equals(element.getName()) && (typeId = element.getAttribute("kind")) != null) {
                            String title = element.getAttribute("title");
                            HashMap<String, String> properties = new HashMap<String, String>();
                            IProcessConfigurationElement[] iProcessConfigurationElementArray3 = element.getChildren();
                            int n5 = iProcessConfigurationElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IProcessConfigurationElement e = iProcessConfigurationElementArray3[n6];
                                if ("property".equals(e.getName())) {
                                    String key = e.getAttribute("key");
                                    String value = e.getAttribute("value");
                                    if (key != null && value != null) {
                                        properties.put(key, value);
                                    }
                                }
                                ++n6;
                            }
                            QuickInformationConfigurationEntry desc = new QuickInformationConfigurationEntry(typeId, title, properties);
                            if (configurationEntries.get(id) == null) {
                                configurationEntries.put(id, new ArrayList());
                            }
                            ((List)configurationEntries.get(id)).add(desc);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        for (String key : configurationEntries.keySet()) {
            configurationEntries.put(key, Collections.unmodifiableList((List)configurationEntries.get(key)));
        }
        this.fEntryCache.put(projectArea.getItemId(), configurationEntries);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.updateEntries(projectAreaHandle, monitor);
    }

    public static IEndPointDescriptor findEndpointDescriptor(List<IEndPointDescriptor> descriptors, String combinedId) {
        String endPointId;
        String linkTypeId = null;
        if (combinedId.contains("/")) {
            linkTypeId = combinedId.substring(0, combinedId.indexOf(47));
            endPointId = combinedId.substring(combinedId.indexOf(47) + 1);
        } else {
            endPointId = combinedId;
        }
        for (IEndPointDescriptor desc : descriptors) {
            if (linkTypeId != null && linkTypeId.equals(desc.getLinkType().getLinkTypeId())) {
                if (endPointId.equals("")) {
                    if (!WorkItemLinkTypes.isSymmetric(desc.getLinkType())) continue;
                    return desc;
                }
                if (endPointId.equals(desc.getId())) {
                    return desc;
                }
                if ("source".equals(endPointId) && desc.isSource()) {
                    return desc;
                }
                if (!"target".equals(endPointId) || !desc.isTarget()) continue;
                return desc;
            }
            if (linkTypeId != null || !endPointId.equals(desc.getId())) continue;
            return desc;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuickInformationConfigurationEntry {
        public static final String HIDDEN_KIND = "Hidden";
        public static final String HIDDEN_DISPLAY_NAME = Messages.getString("QuickInformationConfigurationManager.HIDDEN");
        private String fKind;
        private String fTitle;
        private Map<String, String> fProperties;

        public QuickInformationConfigurationEntry(String kind, String title, Map<String, String> properties) {
            this.fKind = kind;
            this.fTitle = title;
            this.fProperties = properties == null ? new HashMap<String, String>() : properties;
        }

        public String getKind() {
            return this.fKind;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public String getProperty(String key) {
            return this.fProperties.get(key);
        }
    }
}

