/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.presentations;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentationManager;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPresentation {
    private IWorkItem fWorkItem;
    private Map<String, List<AbstractPresentationDescriptor>> fPresentationsMap;
    private Map<String, String> fTabLayouts;
    private String fPresentationId;
    private String fTarget;
    private String fBindingElementType;

    public EditorPresentation(String target, IWorkItem workItem) {
        this.fTarget = target;
        this.fWorkItem = workItem;
    }

    public void resolve(EditorPresentationManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fPresentationsMap = manager.getPresentationsMap(this.fWorkItem.getProjectArea(), monitor);
        this.fTabLayouts = manager.getTabLayouts(this.fWorkItem.getProjectArea(), monitor);
        this.fPresentationId = manager.getPresentationId(this.fTarget, this.fWorkItem, monitor);
        this.fBindingElementType = EditorPresentationManager.getBindingElementType(this.fTarget);
    }

    public Map<String, List<AbstractPresentationDescriptor>> getPresentationsMap() {
        return this.fPresentationsMap;
    }

    public Map<String, String> getTabLayouts() {
        return this.fTabLayouts;
    }

    public String getEditorLayout() {
        return this.fPresentationId;
    }

    public String getPresentationId() {
        return this.fPresentationId;
    }

    public String getBindingElementType() {
        return this.fBindingElementType;
    }
}

