/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.workitem.common.internal.oslc.Namespaces;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeTypeMapping;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import org.eclipse.core.runtime.Assert;

public class LinkAttributeDescriptor
implements IAttributeDescriptor {
    private final IEndPointDescriptor fEndPoint;
    private final String fOwnerType;
    private final String fIdentifier;
    private final String fNamespace;
    private final String fAttributeType;

    public LinkAttributeDescriptor(String ownerType, IEndPointDescriptor endPoint, String identifier, String ns) {
        Assert.isNotNull((Object)endPoint);
        this.fOwnerType = ownerType;
        this.fEndPoint = endPoint;
        this.fIdentifier = identifier;
        this.fNamespace = ns;
        this.fAttributeType = AttributeTypeMapping.getAttributeType(endPoint);
    }

    public IEndPointDescriptor getEndPointDescriptor() {
        return this.fEndPoint;
    }

    public String getOwnerType() {
        return this.fOwnerType;
    }

    public String getAttributeType() {
        return this.fAttributeType;
    }

    public String getDisplayName() {
        return this.fEndPoint.getDisplayName();
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public boolean isReadOnly() {
        return WorkItemLinkTypes.isUserWritable(this.fEndPoint);
    }

    public boolean isCollection() {
        return true;
    }

    public String getNamespace() {
        return this.fNamespace;
    }

    public String getQName() {
        return Namespaces.qualify(this.getNamespace(), this.getIdentifier());
    }
}

