/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.linkdetection;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.linkdetection.WorkItemTextLinkDetector;
import com.ibm.team.workitem.common.model.ItemURI;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttachmentLinkDetector
extends TextLinkDetector
implements TextLinkDetectorManager.IServerSensitiveLinkDetector {
    private static final int ALL_GROUP = 1;
    private static final int ID_GROUP = 3;
    private static final Object fgPatternLock = new Object();
    private boolean fIsServer;
    private static Pattern fgPattern = null;

    public DetectedTextLink createDetectedLink(Matcher matcher) {
        int id = -1;
        try {
            id = Integer.parseInt(matcher.group(3));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (id == -1) {
            return null;
        }
        int referenceOffset = matcher.start(1);
        int referenceLength = matcher.end(1) - referenceOffset;
        return new DetectedAttachmentLink(referenceOffset, referenceLength, this.findAuditableCommon(this.getBaseURI()), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pattern getPattern() {
        Object object = fgPatternLock;
        synchronized (object) {
            if (fgPattern == null) {
                WorkItemTextLinkDetector.ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer);
                if (helper == null || helper.getAttachmentNames().isEmpty()) {
                    return null;
                }
                String attachments = "";
                Iterator<String> iterator = helper.getAttachmentNames().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (attachments.length() > 0) {
                            attachments = attachments.substring(1);
                        }
                        fgPattern = Pattern.compile("((" + attachments + ")\\s?#?(\\d+))", 66);
                        break;
                    }
                    String aName = iterator.next();
                    attachments = String.valueOf(attachments) + "|" + Pattern.quote(aName);
                }
            }
            return fgPattern;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidatePattern() {
        Object object = fgPatternLock;
        synchronized (object) {
            fgPattern = null;
        }
    }

    private IAuditableCommon findAuditableCommon(URI baseUri) {
        WorkItemTextLinkDetector.ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer);
        if (helper == null) {
            return null;
        }
        if (baseUri != null) {
            for (IAuditableCommon aud : helper.getAuditableCommons()) {
                try {
                    if (aud.getRepositoryURI() == null) continue;
                    String auditableRepo = aud.getRepositoryURI();
                    if (auditableRepo.endsWith("/")) {
                        auditableRepo = auditableRepo.substring(0, auditableRepo.length() - 1);
                    }
                    if (!auditableRepo.equals(Location.location((URI)baseUri).getRepoUri())) continue;
                    return aud;
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
        }
        if (helper.getAuditableCommons().size() == 1) {
            return helper.getAuditableCommons().get(0);
        }
        return null;
    }

    public void setIsServer(boolean isServer) {
        this.fIsServer = isServer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DetectedAttachmentLink
    extends DetectedTextLink {
        private IAuditableCommon fAuditableCommon;
        private int fId;

        DetectedAttachmentLink(int offset, int length, IAuditableCommon auditableCommon, int id) {
            super(offset, length);
            this.fAuditableCommon = auditableCommon;
            this.fId = id;
        }

        public List<URI> createURIs() {
            ArrayList<URI> uris = new ArrayList<URI>();
            if (this.fAuditableCommon == null) {
                WorkItemTextLinkDetector.ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(AttachmentLinkDetector.this.fIsServer);
                if (helper != null) {
                    for (IAuditableCommon aud : helper.getAuditableCommons()) {
                        URI uri = ItemURI.createAttachmentURI(aud, this.fId);
                        if (uri == null) continue;
                        uris.add(uri);
                    }
                }
            } else {
                URI uri = ItemURI.createAttachmentURI(this.fAuditableCommon, this.fId);
                if (uri != null) {
                    uris.add(uri);
                }
            }
            return uris;
        }
    }
}

