/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.linkdetection;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.linkdetection.WorkItemTextLinkDetector;
import com.ibm.team.workitem.common.model.ItemURI;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AtUserLinkDetector
extends TextLinkDetector
implements TextLinkDetectorManager.IServerSensitiveLinkDetector {
    private static final int AT_GROUP = 2;
    private static final int USERNAME_GROUP = 3;
    private static final String NOT_ALLOWED_IN_USERID = "\\s,<>():;{}\\[\\]'`*";
    private static final String STOPPERS = ".!&%@\"\\s,<>():;{}\\[\\]'`*";
    private static final String BEFOREAT = "[.!&%@\"\\s,<>():;{}\\[\\]'`*\\-]";
    private static final String NONSTOPPERS = "[^.!&%@\"\\s,<>():;{}\\[\\]'`*]";
    private static final String USERID_START_OR_END = "[^.!&%@\"\\s,<>():;{}\\[\\]'`*]";
    private static final String USERID_MIDDLE = "[^\\s,<>():;{}\\[\\]'`*]";
    private static final String SIMPLE_USERID = "[^.!&%@\"\\s,<>():;{}\\[\\]'`*]+";
    private static final String COMPLEX_USERID = "([^.!&%@\"\\s,<>():;{}\\[\\]'`*][^\\s,<>():;{}\\[\\]'`*]+[^.!&%@\"\\s,<>():;{}\\[\\]'`*])";
    private static final String USERID = "(([^.!&%@\"\\s,<>():;{}\\[\\]'`*][^\\s,<>():;{}\\[\\]'`*]+[^.!&%@\"\\s,<>():;{}\\[\\]'`*])|[^.!&%@\"\\s,<>():;{}\\[\\]'`*]+)";
    private static final Pattern PATTERN = Pattern.compile("(^|[.!&%@\"\\s,<>():;{}\\[\\]'`*\\-])(@)(([^.!&%@\"\\s,<>():;{}\\[\\]'`*][^\\s,<>():;{}\\[\\]'`*]+[^.!&%@\"\\s,<>():;{}\\[\\]'`*])|[^.!&%@\"\\s,<>():;{}\\[\\]'`*]+)", 66);
    private boolean fIsServer;

    public DetectedTextLink createDetectedLink(Matcher matcher) {
        int referenceOffset = matcher.start(2);
        int referenceLength = matcher.end(3) - referenceOffset;
        String username = matcher.group(3);
        return new DetectedAtUserLink(referenceOffset, referenceLength, this.findAuditableCommon(this.getBaseURI()), username);
    }

    public Pattern getPattern() {
        return PATTERN;
    }

    private IAuditableCommon findAuditableCommon(URI baseUri) {
        WorkItemTextLinkDetector.ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer);
        if (helper == null) {
            return null;
        }
        if (baseUri != null) {
            for (IAuditableCommon aud : helper.getAuditableCommons()) {
                try {
                    if (aud.getRepositoryURI() == null) continue;
                    String auditableRepo = aud.getRepositoryURI();
                    if (auditableRepo.endsWith("/")) {
                        auditableRepo = auditableRepo.substring(0, auditableRepo.length() - 1);
                    }
                    if (!auditableRepo.equals(Location.location((URI)baseUri).getRepoUri())) continue;
                    return aud;
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
        }
        if (helper.getAuditableCommons().size() == 1) {
            return helper.getAuditableCommons().get(0);
        }
        return null;
    }

    public void setIsServer(boolean isServer) {
        this.fIsServer = isServer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DetectedAtUserLink
    extends DetectedTextLink {
        private IAuditableCommon fAuditableCommon;
        private String fUsername;

        public DetectedAtUserLink(int offset, int length, IAuditableCommon auditableCommon, String username) {
            super(offset, length);
            this.fUsername = username;
            this.fAuditableCommon = auditableCommon;
        }

        public List<URI> createURIs() {
            ArrayList<URI> uris = new ArrayList<URI>();
            if (this.fAuditableCommon == null) {
                WorkItemTextLinkDetector.ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(AtUserLinkDetector.this.fIsServer);
                if (helper != null) {
                    for (IAuditableCommon aud : helper.getAuditableCommons()) {
                        URI uri = ItemURI.createUserURI(aud, this.fUsername);
                        if (uri == null) continue;
                        uris.add(uri);
                    }
                }
            } else {
                URI uri = ItemURI.createUserURI(this.fAuditableCommon, this.fUsername);
                if (uri != null) {
                    uris.add(uri);
                }
            }
            return uris;
        }
    }
}

