/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.identifiers;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.workitem.common.internal.identifiers.IAttributeType;
import com.ibm.team.workitem.common.internal.identifiers.IIdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IInternalTypeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IPublicAttribute;
import com.ibm.team.workitem.common.internal.identifiers.IPublicItem;
import com.ibm.team.workitem.common.internal.identifiers.IPublicType;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierRegistry;
import com.ibm.team.workitem.common.internal.identifiers.Messages;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierMapping
implements IIdentifierMapping {
    public static final String SEPARATOR_NAMESPACE = ":";
    public static final String SEPARATOR_LINK_TYPE = ".";
    public static final String LABEL_SOURCE_ENDPOINT = "s";
    public static final String LABEL_TARGET_ENDPOINT = "t";
    private final Map<String, String> fNamespaceByPrefix = new HashMap<String, String>();
    private final Map<Identifier<? extends IPublicItem>, String> fNamespaceByIdentifier = new HashMap<Identifier<? extends IPublicItem>, String>();
    private final Map<Identifier<? extends IItem>, Identifier<? extends IPublicItem>> fPubIdByIntId = new HashMap<Identifier<? extends IItem>, Identifier<? extends IPublicItem>>();
    private final Map<Identifier<? extends IPublicItem>, Identifier<? extends IItem>> fIntIdByPubId = new HashMap<Identifier<? extends IPublicItem>, Identifier<? extends IItem>>();
    private final Map<Identifier<?>, Identifier<?>> fTypeIdByAttrId = new HashMap();
    private final Map<Identifier<?>, String> fNameByIntAttrId = new HashMap();
    private static final Map<Class<? extends IdentifierRegistry>, IIdentifierMapping> fgDefinitions = new HashMap<Class<? extends IdentifierRegistry>, IIdentifierMapping>();

    public static IIdentifierMapping create(Class<? extends IdentifierRegistry> regClass) {
        if (!fgDefinitions.containsKey(regClass)) {
            IdentifierMapping def = new IdentifierMapping();
            try {
                regClass.newInstance().writeDefinition(def);
            }
            catch (Exception ex) {
                WorkItemCommonPlugin.log(Messages.IdentifierMapping_ERROR_PROCESS_IDENTIFIER_REGISTRY, ex);
            }
            fgDefinitions.put(regClass, def);
        }
        return fgDefinitions.get(regClass);
    }

    @Override
    public boolean hasIdentifier(Identifier<?> id) {
        if (id == null) {
            return false;
        }
        if (IPublicItem.class.isAssignableFrom(id.getType())) {
            return this.fIntIdByPubId.containsKey(id);
        }
        return this.fPubIdByIntId.containsKey(id);
    }

    @Override
    public <T extends IPublicItem> Identifier<T> getPublicIdentifier(Identifier<? extends IItem> id) {
        return this.fPubIdByIntId.get(id);
    }

    @Override
    public <T extends IItem> Identifier<T> getInternalIdentifier(Identifier<? extends IPublicItem> id) {
        return this.fIntIdByPubId.get(id);
    }

    @Override
    public <T> Identifier<T> getAttributeType(Identifier<?> id) {
        return this.fTypeIdByAttrId.get(id);
    }

    @Override
    public String getDisplayName(Identifier<?> id) {
        return this.fNameByIntAttrId.get(id);
    }

    @Override
    public String getNamespace(String nsPrefix) {
        return this.fNamespaceByPrefix.get(nsPrefix);
    }

    @Override
    public String getNamespace(Identifier<? extends IPublicItem> identifier) {
        return this.fNamespaceByIdentifier.get(identifier);
    }

    @Override
    public String qualify(Identifier<? extends IPublicItem> identifier) {
        String nsUri = this.getNamespace(identifier);
        for (String curPrefix : this.fNamespaceByPrefix.keySet()) {
            if (!nsUri.equals(this.fNamespaceByPrefix.get(curPrefix))) continue;
            return String.valueOf(curPrefix) + SEPARATOR_NAMESPACE + identifier.getStringIdentifier();
        }
        return null;
    }

    public void declareNamespace(String prefix, String uri) {
        Assert.isNotNull((Object)prefix);
        Assert.isNotNull((Object)uri);
        this.fNamespaceByPrefix.put(prefix, uri);
    }

    public void declareInternalIdentifier(Identifier<? extends IPublicItem> publicId, Identifier<? extends IItem> internalId) {
        Assert.isNotNull(publicId);
        Assert.isNotNull(internalId);
        this.fIntIdByPubId.put(publicId, internalId);
    }

    public void declarePublicIdentifier(Identifier<? extends IItem> internalId, Identifier<? extends IPublicItem> publicId, String namespace) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull(publicId);
        Assert.isNotNull(internalId);
        this.fPubIdByIntId.put(internalId, publicId);
        Assert.isTrue((boolean)this.fNamespaceByPrefix.containsValue(namespace));
        this.fNamespaceByIdentifier.put(publicId, namespace);
    }

    public void declareDisplayName(Identifier<?> attrId, String displayName) {
        Assert.isNotNull(attrId);
        Assert.isNotNull((Object)displayName);
        if (!IPublicItem.class.isAssignableFrom(attrId.getType()) && !IItem.class.isAssignableFrom(attrId.getType())) {
            throw new IllegalArgumentException(Messages.IdentifierMapping_ERROR_ILLEGAL_TYPE_IDENTIFIER);
        }
        this.fNameByIntAttrId.put(attrId, displayName);
    }

    public void declareAttributeType(Identifier<?> attrId, Identifier<?> typeId) {
        Assert.isNotNull(attrId);
        Assert.isNotNull(typeId);
        if (!IPublicItem.class.isAssignableFrom(attrId.getType()) && !IItem.class.isAssignableFrom(attrId.getType())) {
            throw new IllegalArgumentException(Messages.IdentifierMapping_ERROR_ILLEGAL_ATTRIBUTE_IDENTIFIER);
        }
        if (!IPublicType.class.isAssignableFrom(typeId.getType()) && !IAttributeType.class.isAssignableFrom(typeId.getType())) {
            throw new IllegalArgumentException(Messages.IdentifierMapping_ERROR_ILLEGAL_TYPE_IDENTIFIER);
        }
        this.fTypeIdByAttrId.put(attrId, typeId);
    }

    public static Identifier<IPublicAttribute> createPublicAttributeIdentifier(Identifier<IPublicType> containerTypeId, String identifier) {
        Assert.isNotNull(containerTypeId);
        Assert.isNotNull((Object)identifier);
        return Identifier.create(IPublicAttribute.class, containerTypeId.getScopedIdentifier(), identifier);
    }

    public static Identifier<IPublicAttribute> createPublicLinkIdentifier(Identifier<IPublicType> containerTypeId, IEndPointDescriptor link) {
        Assert.isNotNull((Object)link);
        return Identifier.create(IPublicAttribute.class, containerTypeId.getScopedIdentifier(), IdentifierMapping.createLinkIdentifier(link)[1]);
    }

    public static Identifier<IPublicType> createPublicTypeIdentifier(String identifier) {
        Assert.isNotNull((Object)identifier);
        return Identifier.create(IPublicType.class, identifier);
    }

    public static Identifier<IPublicType> createPublicTypeIdentifier(ILinkType linkType) {
        Assert.isNotNull((Object)linkType);
        return Identifier.create(IPublicType.class, linkType.getLinkTypeId());
    }

    public static Identifier<IAttribute> createInternalAttributeIdentifier(Identifier<IAttributeType> containerTypeId, String identifier) {
        Assert.isNotNull(containerTypeId);
        Assert.isNotNull((Object)identifier);
        return Identifier.create(IAttribute.class, containerTypeId.getScopedIdentifier(), identifier);
    }

    public static Identifier<IAttribute> createInternalAttributeIdentifier(IAttribute attr) {
        Assert.isNotNull((Object)attr);
        return IdentifierMapping.createWorkItemAttributeIdentifier(attr.getIdentifier());
    }

    public static Identifier<IAttribute> createWorkItemAttributeIdentifier(String identifier) {
        Assert.isNotNull((Object)identifier);
        String[] idPair = IdentifierMapping.createWorkItemIdentifierScope(identifier);
        return Identifier.create(IAttribute.class, idPair[0], idPair[1]);
    }

    public static Identifier<IAttributeType> createInternalTypeIdentifier(String attributeType) {
        Assert.isNotNull((Object)attributeType);
        return Identifier.create(IAttributeType.class, attributeType);
    }

    public static Identifier<IAttributeType> createInternalTypeIdentifier(IAttribute attr) {
        Assert.isNotNull((Object)attr);
        return Identifier.create(IAttributeType.class, attr.getAttributeType());
    }

    public static Identifier<ILink> createInternalLinkIdentifier(IEndPointDescriptor link) {
        Assert.isNotNull((Object)link);
        String[] idPair = IdentifierMapping.createLinkIdentifier(link);
        return Identifier.create(ILink.class, idPair[0], idPair[1]);
    }

    public static Identifier<IAttributeType> createInternalTypeIdentifier(ILinkType linkType) {
        Assert.isNotNull((Object)linkType);
        return Identifier.create(IAttributeType.class, linkType.getLinkTypeId());
    }

    public static String getLinkId(IEndPointDescriptor endPoint) {
        if (endPoint.getId() != null) {
            return endPoint.getId();
        }
        return endPoint.isTarget() ? LABEL_TARGET_ENDPOINT : LABEL_SOURCE_ENDPOINT;
    }

    private static String[] createLinkIdentifier(IEndPointDescriptor link) {
        String typeId = link.getLinkType().getLinkTypeId();
        String linkId = IdentifierMapping.getLinkId(link);
        return IdentifierMapping.createWorkItemIdentifierScope(String.valueOf(typeId) + SEPARATOR_LINK_TYPE + linkId);
    }

    private static String[] createWorkItemIdentifierScope(String identifier) {
        String scope = IInternalTypeIdentifiers.WORK_ITEM.getStringIdentifier();
        Assert.isNotNull((Object)scope);
        Assert.isNotNull((Object)identifier);
        return new String[]{scope, identifier};
    }
}

