/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.SimilarityExpression;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.WorkItemExpression;
import com.ibm.team.workitem.common.internal.expression.DOMElementWrapper;
import com.ibm.team.workitem.common.internal.expression.IExpressionSerializer;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.internal.expression.IXMLElementKeys;
import com.ibm.team.workitem.common.internal.expression.Messages;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLExpressionSerializer
implements IExpressionSerializer,
IXMLElementKeys {
    @Override
    public Expression deserialize(String expression, ISerializationContext context) throws SerializationException {
        return this.deserialize(new StringReader(expression), context);
    }

    @Override
    public String serialize(Expression expression) throws SerializationException {
        StringWriter writer = new StringWriter();
        this.serialize(expression, writer, false, 0, null);
        return writer.toString();
    }

    public String serialize(IQueryDescriptor queryDescriptor) throws SerializationException {
        StringWriter writer = new StringWriter();
        this.serialize(writer, queryDescriptor, false, 0);
        return writer.toString();
    }

    public void serialize(Writer writer, IQueryDescriptor queryDescriptor, boolean omitDeclaration, int indent) throws SerializationException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", queryDescriptor.getName());
        attributes.put("id", queryDescriptor.getId());
        attributes.put("type", queryDescriptor.getQueryType());
        attributes.put("description", queryDescriptor.getDescription());
        this.serialize(queryDescriptor.getExpression(), writer, omitDeclaration, indent, attributes);
    }

    public Expression deserialize(IPersistableElement element, ISerializationContext context) throws SerializationException {
        if ("query".equals(element.getName())) {
            return this.handleQuery(element, context);
        }
        String error = NLS.bind((String)Messages.getString("XMLExpressionSerializer.UNKNOWN_CONFIGURATION_ELEMENT"), (Object)"<query>", (Object[])new Object[]{element.getName()});
        throw new SerializationException(error);
    }

    public Expression deserialize(Reader reader, ISerializationContext context) throws SerializationException {
        Throwable error = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource source = new InputSource(reader);
            Document document = parser.parse(source);
            Element node = document.getDocumentElement();
            if (node instanceof Element) {
                Element query = node;
                if ("query".equals(query.getTagName())) {
                    return this.handleQuery(new DOMElementWrapper(query), context);
                }
                String errorMessage = NLS.bind((String)Messages.getString("XMLExpressionSerializer.UNEXPECTED_START_ELEMENT"), (Object)"<query>", (Object[])new Object[0]);
                throw new SerializationException(errorMessage);
            }
            throw new SerializationException(Messages.getString("XMLExpressionSerializer.MISSING_ROOT_ELEMENT"));
        }
        catch (FactoryConfigurationError e) {
            error = e;
        }
        catch (ParserConfigurationException e) {
            error = e;
        }
        catch (SAXException e) {
            error = e;
        }
        catch (IOException e) {
            error = e;
        }
        throw new SerializationException(Messages.getString("XMLExpressionSerializer.PARSING_ERROR"), error);
    }

    public void serialize(Expression expression, Writer writer, boolean omitDeclaration, int indent, Map<String, String> attributes) throws SerializationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element query = doc.createElement("query");
            doc.appendChild(query);
            if (attributes != null) {
                for (String key : attributes.keySet()) {
                    String value = attributes.get(key);
                    if (value == null || "".equals(value)) continue;
                    query.setAttribute(key, value);
                }
            }
            expression.saveState(new DOMElementWrapper(query));
            this.serialize(doc, writer, omitDeclaration, indent);
        }
        catch (ParserConfigurationException e) {
            throw new SerializationException(Messages.getString("XMLExpressionSerializer.PARSER_CONFIGURATION_ERROR"), e);
        }
    }

    private void serialize(Document document, Writer writer, boolean omitDeclaration, int indent) throws SerializationException {
        Throwable error = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            this.setIndent(factory, (Integer)indent);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", omitDeclaration ? "yes" : "no");
            this.setIndent(transformer, (Integer)indent);
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            return;
        }
        catch (TransformerConfigurationException e) {
            error = e;
        }
        catch (TransformerFactoryConfigurationError e) {
            error = e;
        }
        catch (TransformerException e) {
            error = e;
        }
        throw new SerializationException(Messages.getString("XMLExpressionSerializer.SERIALIZATION_ERROR"), error);
    }

    private void setIndent(TransformerFactory factory, Integer indent) {
        if (indent <= 0) {
            return;
        }
        try {
            factory.setAttribute("indent-number", indent);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void setIndent(Transformer transformer, Integer indent) {
        if (indent <= 0) {
            return;
        }
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", indent.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", indent.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private Expression handleQuery(IPersistableElement query, ISerializationContext context) throws SerializationException {
        Expression expression = null;
        IPersistableElement element = query;
        if (query.hasChild("and")) {
            expression = new Term();
            element = query.getChild("and");
        } else if (query.hasChild("or")) {
            expression = new Term();
            element = query.getChild("or");
        } else if (query.hasChild("condition")) {
            element = query.getChild("condition");
            expression = element.hasChild("variable") ? new VariableAttributeExpression() : new AttributeExpression();
        } else if (query.hasChild("similarContent")) {
            expression = new SimilarityExpression();
            element = query.getChild("similarContent");
        } else if (query.hasChild("similarItem")) {
            expression = new WorkItemExpression();
            element = query.getChild("similarItem");
        } else {
            if (query.hasChild("construction")) {
                throw new SerializationException(Messages.getString("XMLExpressionSerializer.UNSUPPORTED_ELEMENT_CONSTRUCTION"), 1);
            }
            expression = new Statement();
        }
        ((Expression)expression).init(element, context);
        return expression;
    }
}

