/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.ElementWrapper;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.Messages;
import java.util.List;

public class ModelElementWrapper
extends ElementWrapper {
    private static final String SERIALIZATION_NOT_POSSIBLE = Messages.getString("ModelElementWrapper.SERIALIZATION_NOT_POSSIBLE");
    ModelElement fElement;

    public ModelElementWrapper(ModelElement element) {
        this.fElement = element;
    }

    public String getName() {
        return this.fElement.getName();
    }

    public IPersistableElement createChild(String name) {
        throw new UnsupportedOperationException(SERIALIZATION_NOT_POSSIBLE);
    }

    public boolean hasAttribute(String name) {
        return this.fElement.getAttribute(name) != null;
    }

    public String getAttribute(String name) throws SerializationException {
        if (this.hasAttribute(name)) {
            return this.fElement.getAttribute(name);
        }
        String error = NLS.bind((String)Messages.getString("ModelElementWrapper.UNKOWN_ATTRIBUTE"), (Object)name, (Object[])new Object[0]);
        throw new SerializationException(error);
    }

    public void setAttribute(String name, String value) {
        throw new UnsupportedOperationException(SERIALIZATION_NOT_POSSIBLE);
    }

    public IPersistableElement[] getChildren() {
        List children = this.fElement.getChildElements();
        IPersistableElement[] childElements = new IPersistableElement[children.size()];
        int i = 0;
        while (i < children.size()) {
            childElements[i] = new ModelElementWrapper((ModelElement)children.get(i));
            ++i;
        }
        return childElements;
    }
}

