/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    private static final String ID = "id";
    private final IProcessConfigurationElement fDefinition;
    private final List<IConfiguration> fConfigurationEntries = new ArrayList<IConfiguration>();

    public Configuration(IProcessConfigurationElement definition, IProcessConfigurationElement configuration) {
        Assert.isNotNull((Object)definition);
        this.fDefinition = definition;
        this.addChildren(configuration);
        this.addChildren(definition);
    }

    private void addChildren(IProcessConfigurationElement element) {
        if (element != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = element.getChildren();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
                this.fConfigurationEntries.add(new Configuration(child, null));
                ++n2;
            }
        }
    }

    @Override
    public String getIdentifier() {
        return this.getString(ID);
    }

    @Override
    public String getName() {
        return this.fDefinition.getName();
    }

    @Override
    public String getString(String name) {
        return this.fDefinition.getAttribute(name);
    }

    @Override
    public List<String> getAttributeNames() {
        return Arrays.asList(this.fDefinition.getAttributeNames());
    }

    @Override
    public IConfiguration getChild(String name) {
        List<IConfiguration> children = this.getChildren(name);
        return children.size() > 0 ? children.get(0) : null;
    }

    @Override
    public List<IConfiguration> getChildren(String name) {
        ArrayList<IConfiguration> children = new ArrayList<IConfiguration>();
        for (IConfiguration configuration : this.fConfigurationEntries) {
            if (!configuration.getName().equals(name)) continue;
            children.add(configuration);
        }
        return children;
    }

    @Override
    public List<IConfiguration> getChildren() {
        return Collections.unmodifiableList(this.fConfigurationEntries);
    }
}

