/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPropertiesManager {
    public static final Set<String> SUPPORTED_BUILT_IN_ATTRIBUTES = new HashSet<String>(Arrays.asList(IWorkItem.DESCRIPTION_PROPERTY, IWorkItem.DUE_DATE_PROPERTY, IWorkItem.DURATION_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.FOUND_IN_PROPERTY, IWorkItem.OWNER_PROPERTY, IWorkItem.TARGET_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.TAGS_PROPERTY, IWorkItem.PRIORITY_PROPERTY, IWorkItem.SEVERITY_PROPERTY));
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String WORKFLOW_PROPERTIES_ELEMENT = "workflowProperties";
    public static final String TYPE_ATTRIBUTE = "workItemType";
    public static final String CATEGORY_ATTRIBUTE = "workItemTypeCategory";
    public static final String STATE_ID_ATTRIBUTE = "stateId";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String ID_ATTRIBUTE = "id";
    private final IAuditableCommon fAuditableCommon;

    public static boolean isSupportedCustomAttributeType(String attributeType) {
        return AttributeTypes.isSupportedCustomAttributeType(attributeType) && !"boolean".equals(attributeType);
    }

    public RequiredPropertiesManager(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    public List<String> findRequiredWorkflowProperties(IWorkItem workItem, String stateId, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = this.fAuditableCommon.getPeer(IWorkItemCommon.class);
        IWorkItemType workItemType = workItemCommon.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), monitor);
        if (workItemType == null) {
            return Collections.emptyList();
        }
        IProcessAreaHandle processArea = workItemCommon.findProcessArea(workItem, monitor);
        IAuditableCommonProcess process = this.fAuditableCommon.getProcess(processArea, monitor);
        IAdvisorDeclaration advisorDeclaration = process.findAdvisorDeclaration(processArea, "com.ibm.team.workitem.operation.workItemSave", "com.ibm.team.workitem.advisor.requiredProperties", monitor);
        if (advisorDeclaration == null) {
            return Collections.emptyList();
        }
        return RequiredPropertiesManager.readWorkflowAdvisorConfiguration(workItemType, stateId, advisorDeclaration.getConfigurationElement());
    }

    public static List<String> readWorkflowAdvisorConfiguration(IWorkItemType workItemType, String stateId, IProcessConfigurationElement advisorConfiguration) {
        HashSet<String> properties = new HashSet<String>();
        IProcessConfigurationElement[] configurationElements = advisorConfiguration.getChildren();
        int i = 0;
        while (i < configurationElements.length) {
            IProcessConfigurationElement configurationElement = configurationElements[i];
            if (WORKFLOW_PROPERTIES_ELEMENT.equals(configurationElement.getName()) && stateId.equals(configurationElement.getAttribute(STATE_ID_ATTRIBUTE))) {
                if (workItemType.getIdentifier().equals(configurationElement.getAttribute(TYPE_ATTRIBUTE))) {
                    RequiredPropertiesManager.readProperties(properties, configurationElement.getChildren());
                }
                if (workItemType.getCategory().equals(configurationElement.getAttribute(CATEGORY_ATTRIBUTE))) {
                    RequiredPropertiesManager.readProperties(properties, configurationElement.getChildren());
                }
            }
            ++i;
        }
        return new ArrayList<String>(properties);
    }

    public List<String> findRequiredProperties(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = this.fAuditableCommon.getPeer(IWorkItemCommon.class);
        IWorkItemType workItemType = workItemCommon.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), monitor);
        if (workItemType == null) {
            return Collections.emptyList();
        }
        IProcessAreaHandle processArea = workItemCommon.findProcessArea(workItem, monitor);
        IAuditableCommonProcess process = this.fAuditableCommon.getProcess(processArea, monitor);
        IAdvisorDeclaration advisorDeclaration = process.findAdvisorDeclaration(processArea, "com.ibm.team.workitem.operation.workItemSave", "com.ibm.team.workitem.advisor.requiredProperties", monitor);
        if (advisorDeclaration == null) {
            return Collections.emptyList();
        }
        return RequiredPropertiesManager.readAdvisorConfiguration(workItemType, advisorDeclaration.getConfigurationElement());
    }

    public static List<String> readAdvisorConfiguration(IWorkItemType workItemType, IProcessConfigurationElement advisorConfiguration) {
        HashSet<String> properties = new HashSet<String>();
        IProcessConfigurationElement[] configurationElements = advisorConfiguration.getChildren();
        int i = 0;
        while (i < configurationElements.length) {
            IProcessConfigurationElement configurationElement = configurationElements[i];
            if (PROPERTIES_ELEMENT.equals(configurationElement.getName())) {
                if (configurationElement.getAttribute(TYPE_ATTRIBUTE) == null && configurationElement.getAttribute(CATEGORY_ATTRIBUTE) == null) {
                    RequiredPropertiesManager.readProperties(properties, configurationElement.getChildren());
                } else {
                    if (workItemType.getIdentifier().equals(configurationElement.getAttribute(TYPE_ATTRIBUTE))) {
                        RequiredPropertiesManager.readProperties(properties, configurationElement.getChildren());
                    }
                    if (workItemType.getCategory().equals(configurationElement.getAttribute(CATEGORY_ATTRIBUTE))) {
                        RequiredPropertiesManager.readProperties(properties, configurationElement.getChildren());
                    }
                }
            }
            ++i;
        }
        return new ArrayList<String>(properties);
    }

    private static void readProperties(Set<String> properties, IProcessConfigurationElement[] configurationElements) {
        int i = 0;
        while (i < configurationElements.length) {
            String property;
            IProcessConfigurationElement configurationElement = configurationElements[i];
            if (PROPERTY_ELEMENT.equals(configurationElement.getName()) && (property = configurationElement.getAttribute(ID_ATTRIBUTE)) != null && property.length() != 0) {
                if ("version".equals(property)) {
                    property = IWorkItem.FOUND_IN_PROPERTY;
                }
                property = WorkItemAttributes.getAttributeId(Identifier.create(IAttribute.class, property));
                properties.add(property);
            }
            ++i;
        }
    }
}

