/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.ConfigurationItemManager;
import com.ibm.team.workitem.common.internal.Enumeration;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.model.EnumerationAttributeType;
import com.ibm.team.workitem.common.internal.model.Priority;
import com.ibm.team.workitem.common.internal.model.Severity;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationManager
extends CacheHelper {
    public static final String ENUMERATIONS_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.enumerations";
    public static final String ENUMERATION_ELEMENT = "enumeration";
    public static final String ATTRIBUTE_TYPE_ID_ATTRIBUTE = "attributeTypeId";
    private Map<UUID, InternalEnumerations> fCache = new HashMap<UUID, InternalEnumerations>();

    public EnumerationManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public IEnumeration<?> resolve(IAttributeHandle attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attributeItem = this.getAuditableCommon().resolveAuditable(attribute, IAttribute.SMALL_PROFILE, monitor);
        return this.internalResolve(attributeItem.getProjectArea(), attributeItem.getAttributeType(), monitor);
    }

    public IEnumeration<?> internalResolve(IProjectAreaHandle projectArea, String attributeType, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Assert.isTrue((boolean)(AttributeTypes.getAttributeType(attributeType) instanceof EnumerationAttributeType));
        InternalEnumerations enumerations = this.fCache.get(projectArea.getItemId());
        return enumerations.findEnumeration(attributeType, monitor);
    }

    public IEnumeration<? extends ILiteral> findCached(IAttribute attribute) {
        Assert.isTrue((boolean)(AttributeTypes.getAttributeType(attribute.getAttributeType()) instanceof EnumerationAttributeType));
        return this.internalFindChached(attribute.getProjectArea(), attribute.getAttributeType());
    }

    public IEnumeration<? extends ILiteral> internalFindChached(IProjectAreaHandle projectArea, String attributeType) {
        Assert.isTrue((boolean)(AttributeTypes.getAttributeType(attributeType) instanceof EnumerationAttributeType));
        InternalEnumerations enumerations = this.fCache.get(projectArea.getItemId());
        if (enumerations == null) {
            return null;
        }
        return enumerations.findEnumeration(attributeType, null);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        InternalEnumerations enumerations = InternalEnumerations.resolve(auditableCommon, projectAreaHandle, monitor);
        this.fCache.put(projectAreaHandle.getItemId(), enumerations);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumerationReader
    extends ConfigurationItemManager<ConfigurationItem> {
        private String fAttributeTypeIdentifier;
        private static final String LITERAL_ELEMENT = "literal";
        private static final String ID_ATTRIBUTE = "id";
        private static final String NAME_ATTRIBUTE = "name";
        private static final String ICON_ATTRIBUTE = "icon";
        private static final String DEFAULT_ATTRIBUTE = "default";
        private static final String NULL_ATTRIBUTE = "null";

        public EnumerationReader(IAuditableCommon auditableCommon, String attributeTypeIdentifier) {
            super(auditableCommon);
            this.fAttributeTypeIdentifier = attributeTypeIdentifier;
        }

        @Override
        protected String getConfigurationDataPoint() {
            return EnumerationManager.ENUMERATIONS_CONFIGURATION_DATA_POINT;
        }

        @Override
        protected String getGroupElement() {
            return EnumerationManager.ENUMERATION_ELEMENT;
        }

        @Override
        protected String getElement() {
            return LITERAL_ELEMENT;
        }

        @Override
        protected ConfigurationItem readElement(IProjectAreaHandle projectArea, IProcessConfigurationElement configurationElement, int sequenceValue, IProgressMonitor monitor) throws TeamRepositoryException {
            if (configurationElement.getParent() instanceof IProcessConfigurationElement) {
                String attributeTypeIdentifier = ((IProcessConfigurationElement)configurationElement.getParent()).getAttribute(EnumerationManager.ATTRIBUTE_TYPE_ID_ATTRIBUTE);
                if (attributeTypeIdentifier == null || !attributeTypeIdentifier.equals(this.fAttributeTypeIdentifier)) {
                    return null;
                }
            } else {
                return null;
            }
            String identifier = configurationElement.getAttribute(ID_ATTRIBUTE);
            if (identifier == null) {
                return null;
            }
            String displayName = configurationElement.getAttribute(NAME_ATTRIBUTE);
            if (displayName == null) {
                return null;
            }
            String icon = configurationElement.getAttribute(ICON_ATTRIBUTE);
            URL iconURL = this.createResourceURL((IProcessContainerHandle)projectArea, icon, monitor);
            String defaultValue = configurationElement.getAttribute(DEFAULT_ATTRIBUTE);
            boolean isDefault = Boolean.TRUE.toString().equalsIgnoreCase(defaultValue);
            String nullValue = configurationElement.getAttribute(NULL_ATTRIBUTE);
            boolean isNull = Boolean.TRUE.toString().equalsIgnoreCase(nullValue);
            if (this.fAttributeTypeIdentifier.equals("priority")) {
                return new Priority(projectArea, identifier, displayName, iconURL, sequenceValue, isDefault, isNull);
            }
            if (this.fAttributeTypeIdentifier.equals("severity")) {
                return new Severity(projectArea, identifier, displayName, iconURL, sequenceValue, isDefault, isNull);
            }
            return new ConfigurationItem(projectArea, identifier, displayName, iconURL, sequenceValue, isDefault, isNull);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalEnumerations {
        private IAuditableCommon fAuditableCommon;
        private IProjectAreaHandle fProjectArea;
        private IProcessConfigurationData fEnumerationConfiguration;
        private Map<String, EnumerationReader> fEnumerationReaders = new HashMap<String, EnumerationReader>();

        public static InternalEnumerations resolve(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
            IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)projectArea, monitor);
            IProcessConfigurationData enumerationConfiguration = process.findProcessConfiguration(EnumerationManager.ENUMERATIONS_CONFIGURATION_DATA_POINT, monitor);
            return new InternalEnumerations(auditableCommon, projectArea, enumerationConfiguration);
        }

        private InternalEnumerations(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProcessConfigurationData enumerationConfiguration) {
            this.fAuditableCommon = auditableCommon;
            this.fProjectArea = projectArea;
            this.fEnumerationConfiguration = enumerationConfiguration;
        }

        public IEnumeration<?> findEnumeration(String attributeTypeIdentifier, IProgressMonitor monitor) {
            try {
                ArrayList literals = new ArrayList(this.getEnumerationReader(attributeTypeIdentifier).findConfigurationItems(this.fProjectArea, monitor));
                return new Enumeration(literals);
            }
            catch (TeamRepositoryException x) {
                throw new RuntimeException(x);
            }
        }

        private EnumerationReader getEnumerationReader(String attributeTypeIdentifier) {
            EnumerationReader enumerationManager = this.fEnumerationReaders.get(attributeTypeIdentifier);
            if (enumerationManager == null) {
                enumerationManager = new EnumerationReader(this.fAuditableCommon, attributeTypeIdentifier){

                    protected IProcessConfigurationData resolveProcessConfiguration(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
                        return InternalEnumerations.this.fEnumerationConfiguration;
                    }
                };
                this.fEnumerationReaders.put(attributeTypeIdentifier, enumerationManager);
            }
            return enumerationManager;
        }
    }
}

