/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.variables.AbstractAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.Messages;
import com.ibm.team.workitem.common.internal.model.query.BaseCategoryQueryModel;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCategoriesVariable
extends AbstractAttributeVariable<ICategoryHandle> {
    public static final String VARIABLE_ID = "my categories";
    private Collection<ICategoryHandle> fCategories;
    private boolean fIsCaching;

    public MyCategoriesVariable() {
        this(false);
    }

    public MyCategoriesVariable(boolean isCaching) {
        this.fIsCaching = isCaching;
    }

    @Override
    public Collection<ICategoryHandle> evaluate(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fCategories == null || !this.fIsCaching) {
            IAuditableCommon auditableCommon = context.getAuditableCommon();
            IProjectAreaHandle projectArea = context.getProjectArea();
            ItemQueryIterator<ITeamAreaHandle> teamAreasIterator = WorkItemQueries.teamAreasByContributorAndProjectArea(auditableCommon, auditableCommon.getUser(), projectArea);
            List teamAreas = teamAreasIterator.toList(monitor);
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IItemHandleInputArg contributorArg = query.newItemHandleArg();
            IPredicate predicate = model.defaultTeamArea().contributors()._contains(contributorArg);
            for (ITeamAreaHandle teamArea : teamAreas) {
                predicate = predicate._or(model.teamAreas()._contains((IItemHandle)teamArea));
            }
            query.filter(predicate);
            query.distinct();
            ItemQueryIterator iterator = new ItemQueryIterator(auditableCommon, query, new Object[]{auditableCommon.getUser()}, QueryUtils.getContextIds(projectArea));
            ArrayList<ICategoryHandle> categories = new ArrayList<ICategoryHandle>();
            while (iterator.hasNext(monitor)) {
                categories.add((ICategoryHandle)iterator.next(monitor));
            }
            if (categories.isEmpty()) {
                IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
                IAttribute categoryAttribute = workItemCommon.findAttribute(projectArea, IWorkItem.CATEGORY_PROPERTY, monitor);
                this.fCategories = Collections.singleton((ICategoryHandle)categoryAttribute.getNullValue(auditableCommon, monitor));
            } else {
                this.fCategories = categories;
            }
        }
        return this.fCategories;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("MyCategoriesVariable.MY_CATEGORIES");
    }

    @Override
    public String getId() {
        return VARIABLE_ID;
    }

    public boolean equals(Object obj) {
        return obj instanceof MyCategoriesVariable;
    }

    public int hashCode() {
        return VARIABLE_ID.hashCode();
    }
}

