/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.Messages;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableAttributes {
    private static final String EXTENSION_POINT_ID = "com.ibm.team.workitem.common.queryAttributeFactories";
    private static final String EXTENSION_NAME = "queryAttributeFactory";
    private static Map<String, Proxy> fgRegistry;
    private static FoundationLog fgLog;
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String TYPE_ATTRIBUTE = "attributeType";
    private static final String ITEM_TYPE_ELEMENT = "itemType";
    private static final String ITEM_TYPE_NAME_ATTRIBUTE = "name";
    private static final String ITEM_TYPE_URI_ATTRIBUTE = "nsUri";

    public static Comparator<IQueryableAttribute> createComparator() {
        return QueryableAttributes.createComparator(Locale.getDefault());
    }

    public static Comparator<IQueryableAttribute> createComparator(Locale locale) {
        return new Comparator<IQueryableAttribute>(locale){
            private Collator collator;
            {
                this.collator = Collator.getInstance((Locale)locale);
            }

            @Override
            public int compare(IQueryableAttribute a1, IQueryableAttribute a2) {
                return this.collator.compare(a1.getDisplayName(), a2.getDisplayName());
            }
        };
    }

    public static IQueryableAttributeFactory getFactory(IItemType itemType) {
        IQueryableAttributeFactory factory = QueryableAttributes.getFactoryWithDefault(itemType, null);
        return factory == null ? new DefaultFactory(itemType) : factory;
    }

    public static synchronized IQueryableAttributeFactory getFactoryWithDefault(IItemType itemType, IQueryableAttributeFactory defaultFactory) {
        QueryableAttributes.initialize();
        Proxy proxy = fgRegistry.get(QueryableAttributes.getItemTypeKey(itemType));
        if (proxy != null) {
            try {
                return proxy.createFactory();
            }
            catch (CoreException e) {
                QueryableAttributes.getLogger().error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return defaultFactory;
    }

    private static void initialize() {
        if (fgRegistry != null) {
            return;
        }
        fgRegistry = new HashMap<String, Proxy>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(EXTENSION_NAME)) {
                        try {
                            IItemType itemType = QueryableAttributes.readItemTypeElement(element);
                            fgRegistry.put(QueryableAttributes.getItemTypeKey(itemType), new Proxy(element));
                        }
                        catch (IllegalArgumentException e) {
                            String warning = NLS.bind((String)Messages.getString("QueryableAttributes.QUERYTYPEREGISTRY"), (Object)e.getMessage(), (Object[])new Object[0]);
                            QueryableAttributes.getLogger().warn(warning, null);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static String readAttributeType(IConfigurationElement element) {
        String attributeType = element.getAttribute(TYPE_ATTRIBUTE);
        if (attributeType == null) {
            throw new IllegalArgumentException(Messages.getString("QueryableAttributes.MISSING_ATTRIBUTE_TYPE"));
        }
        return attributeType;
    }

    public static IItemType readItemTypeElement(IConfigurationElement element) {
        IConfigurationElement[] itemTypeElement = element.getChildren(ITEM_TYPE_ELEMENT);
        if (itemTypeElement.length != 1) {
            throw new IllegalArgumentException(Messages.getString("QueryableAttributes.TYPE_MISSING"));
        }
        IItemType itemType = QueryableAttributes.readItemType(itemTypeElement[0]);
        if (itemType == null) {
            throw new IllegalArgumentException(Messages.getString("QueryableAttributes.UNKNOWN_TYPE_SPECIFIED"));
        }
        return itemType;
    }

    private static IItemType readItemType(IConfigurationElement element) {
        String itemTypeName = element.getAttribute(ITEM_TYPE_NAME_ATTRIBUTE);
        QueryableAttributes.check(itemTypeName, Messages.getString("QueryableAttributes.ITEM_TYPE_NAME_MISSING"));
        String itemTypeURI = element.getAttribute(ITEM_TYPE_URI_ATTRIBUTE);
        QueryableAttributes.check(itemTypeURI, Messages.getString("QueryableAttributes.ITEM_TYPE_NAMESPACE_URI_IS_MISSING"));
        return IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeURI);
    }

    private static String getItemTypeKey(IItemType itemType) {
        return String.format("%s:%s", itemType.getNamespaceURI(), itemType.getName());
    }

    private static void check(String string, String message) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    private static FoundationLog getLogger() {
        if (fgLog == null) {
            fgLog = FoundationLog.getLog((String)"com.ibm.team.workitem.common");
        }
        return fgLog;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultFactory
    implements IQueryableAttributeFactory {
        private IItemType fItemType;

        private DefaultFactory(IItemType itemType) {
            this.fItemType = itemType;
        }

        @Override
        public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            return new QueryableAttribute(attributeIdentifier, "smallString", attributeIdentifier);
        }

        @Override
        public List<IQueryableAttribute> findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            return Collections.emptyList();
        }

        @Override
        public ItemProfile<? extends IAuditable> computeProfile(List<IQueryableAttribute> attributes) {
            return ItemProfile.createFullProfile(this.fItemType);
        }

        @Override
        public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
            return Collections.emptyList();
        }
    }

    private static class Proxy {
        private IConfigurationElement fElement;
        private IQueryableAttributeFactory fFactory;

        public Proxy(IConfigurationElement element) {
            this.fElement = element;
        }

        public IQueryableAttributeFactory createFactory() throws CoreException {
            if (this.fFactory == null) {
                this.fFactory = (IQueryableAttributeFactory)this.fElement.createExecutableExtension(QueryableAttributes.CLASS_ATTRIBUTE);
            }
            return this.fFactory;
        }
    }
}

