/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.builddefinition.IBuildDefinitionTemplate;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.builddefinition.Messages;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public class BuildDefinitionTemplateExtension
implements IBuildDefinitionTemplate {
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String DEFAULT_VALUE_ATTRIBUTE = "defaultValue";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String BUILD_CONFIGURATION_ELEMENT = "buildConfigurationElement";
    public static final String AVAILABLE_BUILD_CONFIGURATION_ELEMENT = "availableBuildConfigurationElement";
    public static final String GENERIC_PROPERTY_ELEMENT = "genericProperty";
    private String fIdAttribute;
    private String fNameAttribute;
    private String fDescriptionAttribute;
    private List<String> fConfigurationElementIds = new ArrayList<String>();
    private List<String> fAvailableConfigurationElementIds = new ArrayList<String>();
    private List<IBuildProperty> fGenericProperties = new ArrayList<IBuildProperty>();

    public BuildDefinitionTemplateExtension(IConfigurationElement pluginConfigurationElement) {
        ValidationHelper.validateNotNull("pluginConfigurationElement", pluginConfigurationElement);
        this.fIdAttribute = pluginConfigurationElement.getAttribute(ID_ATTRIBUTE);
        ValidationHelper.validateNotNull(ID_ATTRIBUTE, this.fIdAttribute);
        ValidationHelper.validateNotEmpty(ID_ATTRIBUTE, this.fIdAttribute.trim());
        this.fNameAttribute = pluginConfigurationElement.getAttribute(NAME_ATTRIBUTE);
        ValidationHelper.validateNotNull(NAME_ATTRIBUTE, this.fNameAttribute);
        ValidationHelper.validateNotEmpty(NAME_ATTRIBUTE, this.fNameAttribute.trim());
        this.fDescriptionAttribute = pluginConfigurationElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        this.processConfigurationElements(pluginConfigurationElement);
        this.processAvailableConfigurationElements(pluginConfigurationElement);
        this.processGenericProperties(pluginConfigurationElement);
    }

    private void processAvailableConfigurationElements(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren(AVAILABLE_BUILD_CONFIGURATION_ELEMENT);
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String id = pluginElement.getAttribute(ID_ATTRIBUTE);
            ValidationHelper.validateNotNull(ID_ATTRIBUTE, id);
            ValidationHelper.validateNotEmpty(ID_ATTRIBUTE, id.trim());
            if (!this.fAvailableConfigurationElementIds.contains(id) && !this.fConfigurationElementIds.contains(id)) {
                this.fAvailableConfigurationElementIds.add(id);
            }
            ++n2;
        }
    }

    private void processConfigurationElements(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren(BUILD_CONFIGURATION_ELEMENT);
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String id = pluginElement.getAttribute(ID_ATTRIBUTE);
            ValidationHelper.validateNotNull(ID_ATTRIBUTE, id);
            ValidationHelper.validateNotEmpty(ID_ATTRIBUTE, id.trim());
            if (!this.fConfigurationElementIds.contains(id)) {
                this.fConfigurationElementIds.add(id);
            }
            ++n2;
        }
        if (this.fConfigurationElementIds.isEmpty()) {
            throw new IllegalArgumentException(Messages.BuildDefinitionTemplateExtension_MISSING_CONFIG_ELEMENT);
        }
    }

    private void processGenericProperties(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren(GENERIC_PROPERTY_ELEMENT);
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String name = pluginElement.getAttribute(NAME_ATTRIBUTE);
            ValidationHelper.validateNotNull(NAME_ATTRIBUTE, name);
            ValidationHelper.validateNotEmpty(NAME_ATTRIBUTE, name.trim());
            String description = pluginElement.getAttribute(DESCRIPTION_ATTRIBUTE);
            String defaultValue = pluginElement.getAttribute(DEFAULT_VALUE_ATTRIBUTE);
            String required = pluginElement.getAttribute(REQUIRED_ATTRIBUTE);
            IBuildProperty property = BuildItemFactory.createBuildProperty();
            property.setName(name);
            property.setGenericEditAllowed(true);
            if (description != null && description.trim().length() > 0) {
                property.setDescription(description);
            }
            if (defaultValue != null && defaultValue.trim().length() > 0) {
                property.setValue(defaultValue);
            }
            if (required != null) {
                property.setRequired(Boolean.valueOf(required));
            }
            this.fGenericProperties.add(property);
            ++n2;
        }
    }

    public String getNameAttribute() {
        return this.fNameAttribute;
    }

    public String getIdAttribute() {
        return this.fIdAttribute;
    }

    public String getDescriptionAttribute() {
        return this.fDescriptionAttribute;
    }

    public String[] getConfigurationElementIds() {
        return this.fConfigurationElementIds.toArray(new String[this.fConfigurationElementIds.size()]);
    }

    public String[] getAvailableConfigurationElementIds() {
        return this.fAvailableConfigurationElementIds.toArray(new String[this.fAvailableConfigurationElementIds.size()]);
    }

    public IBuildProperty[] getGenericProperties() {
        return this.fGenericProperties.toArray(new IBuildProperty[this.fGenericProperties.size()]);
    }

    public int hashCode() {
        return this.fIdAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildDefinitionTemplateExtension other = (BuildDefinitionTemplateExtension)obj;
        return !(this.fIdAttribute == null ? other.fIdAttribute != null : !this.fIdAttribute.equals(other.fIdAttribute));
    }

    public String getId() {
        return this.getIdAttribute();
    }

    public String getName() {
        return this.getNameAttribute();
    }

    public String getDescription() {
        return this.getDescriptionAttribute();
    }
}

