/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common;

import com.ibm.team.build.internal.common.helper.FileHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.l10n.Messages;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ChangeSetInfo {
    public static final String SERIALIZATION_TOKEN = System.getProperty("line.separator", "\n");
    private IChangeSetHandle[] fChangeSets;
    private IWorkspaceHandle fWorkspace;

    public ChangeSetInfo(IChangeSetHandle[] changeSets, IWorkspaceHandle workspace) throws IllegalArgumentException {
        ValidationHelper.validateNotNull("workspace", workspace);
        ValidationHelper.validateNotNull("changeSets", changeSets);
        this.fChangeSets = changeSets;
        this.fWorkspace = workspace;
    }

    public ChangeSetInfo(File file) throws IOException, TeamRepositoryException {
        this(FileHelper.fileToString(file));
    }

    public ChangeSetInfo(String serializedChangeSetInfo) throws TeamRepositoryException {
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
        IItemType workspaceItemType = IWorkspace.ITEM_TYPE;
        IItemType changeSetItemType = IChangeSet.ITEM_TYPE;
        StringTokenizer tokenizer = new StringTokenizer(serializedChangeSetInfo, SERIALIZATION_TOKEN);
        if (tokenizer.countTokens() < 1) {
            throw new TeamRepositoryException(Messages.getCommonString("ChangeSetInfo.0"));
        }
        String workspaceUuid = tokenizer.nextToken();
        this.fWorkspace = (IWorkspaceHandle)workspaceItemType.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
        while (tokenizer.hasMoreTokens()) {
            String changeSetUuid = tokenizer.nextToken();
            IChangeSetHandle handle = (IChangeSetHandle)changeSetItemType.createItemHandle(UUID.valueOf((String)changeSetUuid), null);
            changeSets.add(handle);
        }
        this.fChangeSets = changeSets.toArray(new IChangeSetHandle[changeSets.size()]);
    }

    public IChangeSetHandle[] getChangeSets() {
        return this.fChangeSets;
    }

    public IWorkspaceHandle getWorkspace() {
        return this.fWorkspace;
    }

    public void serialize(File file) throws IOException {
        FileHelper.stringToFile(this.serialize(), file);
    }

    public String serialize() {
        StringBuffer serialized = new StringBuffer();
        serialized.append(this.fWorkspace.getItemId().getUuidValue());
        serialized.append(SERIALIZATION_TOKEN);
        int i = 0;
        while (i < this.fChangeSets.length) {
            serialized.append(this.fChangeSets[i].getItemId().getUuidValue());
            serialized.append(SERIALIZATION_TOKEN);
            ++i;
        }
        return serialized.toString();
    }
}

