/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.commmon.iterator;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemQueryIterator<T extends IItemHandle> {
    public static Object[] EMPTY_PARAMETERS = IQueryService.EMPTY_PARAMETERS;
    public static int MAX_PAGE_SIZE = 512;
    private IItemQuery fQuery;
    private Object[] fQueryParams;
    private int fQueryPageSize;
    private IItemQueryPage fQueryPage;
    private Iterator fHandleIterator;
    private boolean bUseCommittedQuery = true;

    public AbstractItemQueryIterator() {
        this.fQueryPage = IItemQueryPage.EMPTY_RESULT;
        this.fHandleIterator = new LinkedList().iterator();
    }

    public AbstractItemQueryIterator(IItemQuery query, Object[] queryParams) throws IllegalArgumentException {
        this(query, queryParams, 512);
    }

    public AbstractItemQueryIterator(IItemQuery query, Object[] queryParams, int queryPageSize) throws IllegalArgumentException {
        ValidationHelper.validateNotNull("query", query);
        ValidationHelper.validateNotNull("queryParams", queryParams);
        ValidationHelper.validateNotNullElements("queryParams", queryParams);
        this.fQuery = query;
        this.fQueryParams = queryParams;
        this.fQueryPageSize = queryPageSize;
    }

    public boolean hasNext(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.updatePosition(progressMonitor);
        return this.fHandleIterator.hasNext();
    }

    public T next(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.updatePosition(progressMonitor);
        return (T)((IItemHandle)this.fHandleIterator.next());
    }

    public List<T> next(int numHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        LinkedList<T> handles = new LinkedList<T>();
        int count = 0;
        while (count < numHandles && this.hasNext(progressMonitor)) {
            handles.add(this.next(progressMonitor));
            ++count;
        }
        return handles;
    }

    public int size(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.updatePosition(progressMonitor);
        return this.fQueryPage.getResultSize();
    }

    public void setCommitted(boolean committed) {
        this.bUseCommittedQuery = committed;
    }

    private synchronized void updatePosition(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (!this.hasQueryExecuted()) {
            this.fQueryPage = this.bUseCommittedQuery ? this.queryItems(this.fQuery, this.fQueryParams, this.fQueryPageSize, progressMonitor) : this.uncommittedQueryItems(this.fQuery, this.fQueryParams, this.fQueryPageSize, progressMonitor);
            this.fHandleIterator = this.fQueryPage.getItemHandles().iterator();
        }
        while (!this.fHandleIterator.hasNext() && this.fQueryPage.hasNext()) {
            this.fQueryPage = this.fetchPage(this.fQueryPage, this.fQueryPageSize, progressMonitor);
            this.fHandleIterator = this.fQueryPage.getItemHandles().iterator();
        }
    }

    protected abstract IItemQueryPage queryItems(IItemQuery var1, Object[] var2, int var3, IProgressMonitor var4) throws TeamRepositoryException;

    protected abstract IItemQueryPage uncommittedQueryItems(IItemQuery var1, Object[] var2, int var3, IProgressMonitor var4) throws TeamRepositoryException;

    protected abstract IItemQueryPage fetchPage(IItemQueryPage var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    private boolean hasQueryExecuted() {
        return this.fQueryPage != null;
    }
}

