/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;

public class ParmsCheckInComponentRequest
implements IValidatingParameterWrapper {
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String changeSetItemId;
    public String newChangeSetComment;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        if (this.changeSetItemId != null && this.changeSetItemId.length() > 0 && this.newChangeSetComment != null && this.newChangeSetComment.trim().length() > 0) {
            throw new IllegalArgumentException("Either changeSetItemId or newChangeSetComment should be supplied.  Not both.");
        }
        ParmValidation.requiredValue(this.componentItemId, requestName, parameterName, "componentItemId");
    }

    public IChangeSetHandle getChangeSetHandle() {
        if (this.changeSetItemId != null && this.changeSetItemId.trim().length() > 0) {
            ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
            return (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.changeSetItemId), null);
        }
        return null;
    }

    public IComponentHandle getComponentHandle() {
        if (this.componentItemId == null) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }
}

