/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceLockUtil {
    public static FlowNodeLock acquireWrite(IConnection connection, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        lock.toWriteLock(connection.getContextHandle());
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(IWorkspaceConnection workspace, IComponentHandle componentToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireWrite((IConnection)workspace, componentToLock, (Collection<? extends IAuditable>)Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireWrite(IConnection workspace, IComponentHandle componentToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        lock.toWriteLock(new ConfigurationDescriptor(workspace, componentToLock));
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireWrite(workspace, componentsToLock, (Collection<? extends IAuditable>)Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireWrite(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IComponentHandle componentHandle : componentsToLock) {
            lock.toWriteLock(new ConfigurationDescriptor((IConnection)workspace, componentHandle));
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(Collection<? extends ConfigurationDescriptor> configurationsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireWrite(configurationsToLock, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireWrite(Collection<? extends ConfigurationDescriptor> configurationsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (ConfigurationDescriptor configurationDescriptor : configurationsToLock) {
            lock.toWriteLock(configurationDescriptor);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(Collection<ConfigurationDescriptor> configurationsToLock, Collection<IContextHandle> contexts, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (ConfigurationDescriptor configuration : configurationsToLock) {
            lock.toWriteLock(configuration);
        }
        for (IContextHandle contextHandle : contexts) {
            lock.toWriteLock(contextHandle);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireRead(IConnection connection, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        lock.toReadLock(connection.getContextHandle());
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireRead(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireRead(workspace, componentsToLock, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireRead(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IComponentHandle componentHandle : componentsToLock) {
            lock.toReadLock(new ConfigurationDescriptor((IConnection)workspace, componentHandle));
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireRead(Collection<ConfigurationDescriptor> configurationsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireRead(configurationsToLock, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireRead(Collection<ConfigurationDescriptor> configurationsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (ConfigurationDescriptor configuration : configurationsToLock) {
            lock.toReadLock(configuration);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static void release(FlowNodeLock flowNodeLock) {
        flowNodeLock.release();
    }

    public static FlowNodeLock acquireLocks(Collection<? extends IContextHandle> contextsToRead, Collection<? extends IContextHandle> contextsToWrite, Collection<ConfigurationDescriptor> configurationsToRead, Collection<ConfigurationDescriptor> configurationsToWrite, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireLocks(contextsToRead, contextsToWrite, configurationsToRead, configurationsToWrite, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireLocks(Collection<? extends IContextHandle> contextsToRead, Collection<? extends IContextHandle> contextsToWrite, Collection<ConfigurationDescriptor> configurationsToRead, Collection<ConfigurationDescriptor> configurationsToWrite, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IContextHandle iContextHandle : contextsToRead) {
            lock.toReadLock(iContextHandle);
        }
        for (IContextHandle iContextHandle : contextsToWrite) {
            lock.toWriteLock(iContextHandle);
        }
        for (ConfigurationDescriptor configurationDescriptor : configurationsToRead) {
            lock.toReadLock(configurationDescriptor);
        }
        for (ConfigurationDescriptor configurationDescriptor : configurationsToWrite) {
            lock.toWriteLock(configurationDescriptor);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }
}

