/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesLoader {
    public static final long UNKNOWN_LENGTH = -1L;

    public static void load(Map<String, String> props, InputStream in, String encoding, long fileSize, IProgressMonitor progress) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), encoding);
        if (fileSize == -1L) {
            fileSize = -1L;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)((int)fileSize));
        ParseState state = ParseState.LINE_START;
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        while (true) {
            int read;
            if ((read = ((Reader)reader).read()) == -1) {
                switch (state) {
                    case PROPERTY_VALUE: {
                        props.put(key.toString(), value.toString());
                    }
                }
                break;
            }
            char c = (char)read;
            monitor.worked(1);
            switch (state) {
                case LINE_START: {
                    if (c == '#') {
                        state = ParseState.COMMENT;
                        break;
                    }
                    if (PropertiesLoader.isWS(c) || c == '\r') {
                        state = ParseState.LINE_START;
                        break;
                    }
                    key.append(c);
                    state = ParseState.PROPERTY_KEY;
                    break;
                }
                case PROPERTY_KEY: {
                    if (PropertiesLoader.isWS(c)) {
                        state = ParseState.PROPERTY_KEY_SPACE;
                        break;
                    }
                    if (PropertiesLoader.isKeySeparator(c)) {
                        state = ParseState.PROPERTY_ASSIGNMENT;
                        break;
                    }
                    key.append(c);
                    break;
                }
                case PROPERTY_KEY_SPACE: {
                    if (PropertiesLoader.isWS(c) || c != '=') break;
                    state = ParseState.PROPERTY_ASSIGNMENT;
                    break;
                }
                case PROPERTY_ASSIGNMENT: {
                    if (c == '\n' || c == '\r') {
                        props.put(key.toString(), value.toString());
                        key = new StringBuffer();
                        value = new StringBuffer();
                        state = ParseState.LINE_START;
                        break;
                    }
                    if (PropertiesLoader.isWS(c)) break;
                    if (PropertiesLoader.isEscapeChar(c)) {
                        state = ParseState.PROPERTY_VALUE_ESCAPE;
                        break;
                    }
                    if (!PropertiesLoader.isPropertyValue(c)) break;
                    value.append(c);
                    state = ParseState.PROPERTY_VALUE;
                    break;
                }
                case PROPERTY_VALUE: {
                    if (PropertiesLoader.isEscape(c)) {
                        state = ParseState.PROPERTY_VALUE_ESCAPE;
                        break;
                    }
                    if (PropertiesLoader.isPropertyValue(c)) {
                        value.append(c);
                        break;
                    }
                    if (c != '\n' && c != '\r') break;
                    props.put(key.toString(), value.toString());
                    key = new StringBuffer();
                    value = new StringBuffer();
                    state = ParseState.LINE_START;
                    break;
                }
                case PROPERTY_VALUE_ESCAPE: {
                    if (c == 'n') {
                        value.append('\n');
                        state = ParseState.PROPERTY_VALUE;
                        break;
                    }
                    if (c == 't') {
                        value.append('\t');
                        state = ParseState.PROPERTY_VALUE;
                        break;
                    }
                    if (c == '\n') {
                        state = ParseState.PROPERTY_ASSIGNMENT;
                        break;
                    }
                    if (c == '\r') {
                        state = ParseState.PROPERTY_VALUE_ESCAPE_CRLF;
                        break;
                    }
                    value.append('\\');
                    value.append(c);
                    state = ParseState.PROPERTY_VALUE;
                    break;
                }
                case PROPERTY_VALUE_ESCAPE_CRLF: {
                    if (c != '\n') break;
                    state = ParseState.PROPERTY_ASSIGNMENT;
                    break;
                }
                case COMMENT: {
                    if (c == '\r') {
                        state = ParseState.LINE_START;
                        break;
                    }
                    if (c != '\n') break;
                    state = ParseState.LINE_START;
                }
            }
        }
        monitor.done();
    }

    static boolean isWS(char c) {
        return Character.isWhitespace(c);
    }

    static boolean isEscapeChar(char c) {
        return c == '\\';
    }

    static boolean isPropertyValue(char c) {
        return c != '\r' && c != '\f' && c != '\n';
    }

    static boolean isEscape(char c) {
        return c == '\\';
    }

    static boolean isKeySeparator(char c) {
        return c == '=' || c == ':';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParseState {
        LINE_START,
        COMMENT,
        PROPERTY_KEY,
        PROPERTY_ASSIGNMENT,
        PROPERTY_VALUE,
        COMMENT_NEWLINE,
        PROPERTY_VALUE_NEWLINE,
        PROPERTY_VALUE_ESCAPE,
        PROPERTY_KEY_SPACE,
        PROPERTY_VALUE_ESCAPE_CRLF;

    }
}

