/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.Messages;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class FilesystemLock {
    private final File lockFile;
    protected RandomAccessFile lockRAF;
    protected FileLock lock;
    private static final HashMap<File, FilesystemLock> lockMap = new HashMap();

    public FilesystemLock(File location) {
        this.lockFile = location;
    }

    public FilesystemLock(IPath path) {
        this.lockFile = path.toFile();
    }

    public boolean acquire(IProgressMonitor mon) {
        if (FilesystemLock.acquirePath(this)) {
            boolean acquired = false;
            try {
                boolean bl = acquired = this.acquireInternal(mon);
                return bl;
            }
            finally {
                if (!acquired) {
                    FilesystemLock.releasePath(this);
                }
            }
        }
        return false;
    }

    private boolean acquireInternal(IProgressMonitor mon) {
        if (this.lockFile.exists() && this.lockFile.isDirectory()) {
            throw new IllegalStateException(NLS.bind((String)Messages.FilesystemLock_DIRECTORY_COLLISION, (Object)this.lockFile.getAbsolutePath()));
        }
        if (this.lockFile.exists()) {
            if (!this.lockFile.isFile()) {
                return false;
            }
        } else {
            File lockParent = this.lockFile.getParentFile();
            if (lockParent.exists() ? !lockParent.isDirectory() : !lockParent.mkdirs()) {
                return false;
            }
            try {
                if (!this.lockFile.createNewFile()) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        try {
            this.lockRAF = new RandomAccessFile(this.lockFile, "rw");
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            try {
                this.lock = this.lockRAF.getChannel().tryLock(0L, 1L, false);
            }
            catch (IOException iOException) {
                if (this.lock == null) {
                    try {
                        this.lockRAF.close();
                    }
                    catch (IOException iOException2) {}
                    return false;
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (this.lock == null) {
                try {
                    this.lockRAF.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            throw throwable;
        }
        if (this.lock == null) {
            try {
                this.lockRAF.close();
            }
            catch (IOException iOException) {}
            return false;
        }
        return true;
    }

    public boolean acquire(long timeout, IProgressMonitor progress) {
        long stopTime = System.currentTimeMillis() + timeout;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)((int)(timeout / 50L) + 1));
        while (!this.acquire((IProgressMonitor)monitor.newChild(1))) {
            if (stopTime < System.currentTimeMillis()) {
                monitor.done();
                return false;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void release(IProgressMonitor mon) {
        FilesystemLock.releasePath(this);
        if (this.lock != null) {
            this.lock = null;
        }
        if (this.lockRAF != null) {
            try {
                this.lockRAF.close();
                this.lockRAF = null;
            }
            catch (IOException iOException) {}
        }
        this.lockFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean acquirePath(FilesystemLock fsLock) {
        HashMap<File, FilesystemLock> hashMap = lockMap;
        synchronized (hashMap) {
            FilesystemLock conflictingLock = lockMap.get(fsLock.lockFile);
            if (conflictingLock == null) {
                lockMap.put(fsLock.lockFile, fsLock);
            }
            return conflictingLock == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePath(FilesystemLock fsLock) {
        HashMap<File, FilesystemLock> hashMap = lockMap;
        synchronized (hashMap) {
            lockMap.remove(fsLock.lockFile);
        }
    }

    public File getFile() {
        return this.lockFile;
    }

    public IPath getPath() {
        return new Path(this.lockFile.getAbsolutePath());
    }

    public boolean isAcquired() {
        return FilesystemLock.isAquired(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isAquired(FilesystemLock filesystemLock) {
        HashMap<File, FilesystemLock> hashMap = lockMap;
        synchronized (hashMap) {
            FilesystemLock conflictingLock = lockMap.get(filesystemLock.lockFile);
            return conflictingLock == filesystemLock;
        }
    }
}

