/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeSetRefreshUtils {
    public static void refreshForBaselineChange(IFilesystemRefresher refresher, Collection<ISandbox> sandboxes, IWorkspaceConnection wsConn, List<IBaselineHandle> blHandles, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        if (blHandles.isEmpty()) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        monitor.setWorkRemaining(2 * blHandles.size());
        List baselines = wsConn.teamRepository().itemManager().fetchCompleteItems(blHandles, 0, (IProgressMonitor)monitor.newChild(blHandles.size()));
        for (IBaseline bl : baselines) {
            refresher.addToRefresh(sandboxes, wsConn.getContextHandle(), bl.getComponent(), (IProgressMonitor)monitor.newChild(1));
        }
    }

    public static void refreshLocalForAddition(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshLocalFor(new VersionableExtractor(){

            public IVersionableHandle extract(IChange change) {
                IVersionableHandle refreshState = change.afterState();
                if (refreshState == null) {
                    refreshState = change.beforeState();
                }
                return refreshState;
            }
        }, workspaceConnection, changeSetHandles, refresher, affectedAreas, progress);
    }

    public static void refreshLocalForRemoval(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IWorkspaceConnection workspaceConnection, List<? extends IChangeSetHandle> changeSetHandles, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshLocalFor(new VersionableExtractor(){

            public IVersionableHandle extract(IChange change) {
                IVersionableHandle refreshState = change.beforeState();
                if (refreshState == null) {
                    refreshState = change.afterState();
                }
                return refreshState;
            }
        }, workspaceConnection, changeSetHandles, refresher, affectedAreas, progress);
    }

    private static void refreshLocalFor(VersionableExtractor versionableExtractor, IWorkspaceConnection workspaceConnection, List<? extends IChangeSetHandle> changeSetHandles, IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        List cses = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, (IProgressMonitor)monitor.newChild(1));
        LinkedList<IVersionableHandle> evilTwinCandidates = new LinkedList<IVersionableHandle>();
        ArrayList<IComponentHandle> evilTwinComp = new ArrayList<IComponentHandle>();
        Set<ISandbox> sandboxes = affectedAreas.keySet();
        SubMonitor csMonitor = monitor.newChild(1, 2);
        csMonitor.beginTask(null, cses.size());
        for (IChangeSet cs : cses) {
            SubMonitor changeMonitor = csMonitor.newChild(1);
            changeMonitor.beginTask(null, 2);
            for (IChange change : cs.changes()) {
                IVersionableHandle refreshState = versionableExtractor.extract(change);
                if (refreshState == null) continue;
                evilTwinCandidates.add(refreshState);
                evilTwinComp.add(cs.getComponent());
                Collection<IShareable> shareables = ChangeSetRefreshUtils.getAllShareablesFor(workspaceConnection.getContextHandle(), cs.getComponent(), change.item(), sandboxes, changeMonitor.newChild(1));
                refresher.addToRefresh(shareables);
            }
        }
        SubMonitor compMonitor = monitor.newChild(1);
        Collection<IComponentHandle> comps = ChangeSetRefreshUtils.findComponentsIn(affectedAreas, workspaceConnection);
        compMonitor.setWorkRemaining(comps.size());
        for (IComponentHandle comp : comps) {
            SubMonitor conflictMonitor = compMonitor.newChild(1);
            Collection conflicts = workspaceConnection.conflictReport(comp).conflicts();
            conflictMonitor.setWorkRemaining(conflicts.size());
            for (IItemConflictReport conflict : conflicts) {
                IVersionableHandle after = conflict.getProposedContributorState();
                if (after != null) {
                    evilTwinCandidates.add(after);
                    evilTwinComp.add(conflict.getComponent());
                }
                Collection<IShareable> shareables = ChangeSetRefreshUtils.getAllShareablesFor(workspaceConnection.getContextHandle(), conflict.getComponent(), conflict.item(), sandboxes, conflictMonitor.newChild(1));
                refresher.addToRefresh(shareables);
            }
        }
        List fullEvilTwinCandidates = SCMPlatform.getWorkspaceManager((ITeamRepository)workspaceConnection.teamRepository()).versionableManager().fetchCompleteStates(evilTwinCandidates, (IProgressMonitor)monitor.newChild(1));
        ArrayList<IFolderHandle> evilTwinParents = new ArrayList<IFolderHandle>(fullEvilTwinCandidates.size());
        ArrayList<String> evilTwinNames = new ArrayList<String>(fullEvilTwinCandidates.size());
        for (IVersionable evilTwinCandidate : fullEvilTwinCandidates) {
            evilTwinParents.add(evilTwinCandidate.getParent());
            evilTwinNames.add(evilTwinCandidate.getName());
        }
        SubMonitor evilTwinMonitor = monitor.newChild(1);
        evilTwinMonitor.setWorkRemaining(evilTwinCandidates.size());
        int i = 0;
        while (i < evilTwinCandidates.size()) {
            SubMonitor sandboxMonitor = evilTwinMonitor.newChild(1);
            sandboxMonitor.setWorkRemaining(affectedAreas.size());
            for (ISandbox sb : affectedAreas.keySet()) {
                IShareable parent = sb.findShareable(workspaceConnection.getContextHandle(), (IComponentHandle)evilTwinComp.get(i), (IVersionableHandle)evilTwinParents.get(i), (IProgressMonitor)evilTwinMonitor.newChild(1));
                if (parent == null) continue;
                IShareable evilTwin = sb.findShareable(parent.getLocalPath().append((String)evilTwinNames.get(i)), ResourceType.getResourceType((IVersionableHandle)fullEvilTwinCandidates.get(i)));
                refresher.addToRefresh(evilTwin);
            }
            ++i;
        }
    }

    private static Collection<IComponentHandle> findComponentsIn(Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IWorkspaceConnection workspaceConnection) throws TeamRepositoryException {
        HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>();
        List componentHandles = workspaceConnection.getComponents();
        for (Set<ConfigurationDescriptor> descriptors : affectedAreas.values()) {
            block1: for (ConfigurationDescriptor desc : descriptors) {
                for (IComponentHandle componentHandle : componentHandles) {
                    if (!componentHandle.getItemId().equals((Object)desc.componentHandle.getItemId())) continue;
                    components.put(desc.componentHandle.getItemId(), desc.componentHandle);
                    continue block1;
                }
            }
        }
        return components.values();
    }

    private static Collection<IShareable> getAllShareablesFor(IContextHandle ctx, IComponentHandle comp, IVersionableHandle versionable, Collection<ISandbox> sandboxes, SubMonitor monitor) throws FileSystemClientException {
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(sandboxes.size());
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sandboxes.size());
        for (ISandbox sb : sandboxes) {
            IShareable shareable = sb.findShareable(ctx, comp, versionable, (IProgressMonitor)monitor.newChild(1));
            if (shareable == null) continue;
            shareables.add(shareable);
        }
        return shareables;
    }

    private static interface VersionableExtractor {
        public IVersionableHandle extract(IChange var1);
    }
}

