/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.internal.snapshot.ContextSnapshot;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.WeakValueMap;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceSnapshot
extends ContextSnapshot {
    private ChangeListenerList listeners = new ChangeListenerList();
    private IWorkspaceConnection connection;
    private Set<ItemId<IComponent>> components;
    private String name;
    private boolean allocated = false;
    private IListener connectionListener = new IListener(){

        public void handleEvents(List events) {
            try {
                WorkspaceSnapshot.this.copyValues();
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.error("com.ibm.team.filesystem.client", Messages.WorkspaceSnapshot_0, e);
            }
        }
    };
    private WeakValueMap<ItemId<IComponent>, WorkspaceContext> contexts = new WeakValueMap();

    private WorkspaceSnapshot(IWorkspaceConnection connection) {
        this.connection = connection;
        this.name = connection.getName();
    }

    @Override
    public ITeamRepository getRepository() {
        return this.connection.teamRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        WorkspaceSnapshot workspaceSnapshot = this;
        synchronized (workspaceSnapshot) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyValues() throws TeamRepositoryException {
        Set<ItemId<IComponent>> oldComponents;
        String oldName;
        WorkspaceSnapshot workspaceSnapshot = this;
        synchronized (workspaceSnapshot) {
            oldName = this.name;
            oldComponents = this.components;
            this.name = this.connection.getName();
            this.components = this.fetchComponents();
        }
        if (!this.name.equals(oldName) || oldComponents != null && !this.components.equals(oldComponents)) {
            this.fireChangeEvent();
        }
    }

    private void fireChangeEvent() {
        this.listeners.notifyListeners((Object)this, null);
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.connection.getContextHandle();
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.connection;
    }

    public static WorkspaceSnapshot create(IWorkspaceConnection connection) {
        return new WorkspaceSnapshot(connection);
    }

    public static WorkspaceSnapshot create(ItemLocator<IWorkspace> workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return WorkspaceSnapshot.create(ConnectionUtil.getConnection(workspace, monitor));
    }

    @Override
    public IItemContext getContextFor(ItemId<IComponent> componentId, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceContext result = (WorkspaceContext)this.contexts.get(componentId);
        if (result != null) {
            return result;
        }
        result = WorkspaceContext.create(this.connection, componentId, monitor);
        this.contexts.put(componentId, (Object)result);
        return result;
    }

    @Override
    public Map<ItemId<IComponent>, IItemContext> getContexts(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<ItemId<IComponent>> components = this.getComponents();
        Map fetchedComponents = RepoFetcher.fetchCurrents((ITeamRepository)this.connection.teamRepository(), components, (boolean)false, (IProgressMonitor)progress.newChild(100));
        HashMap<ItemId<IComponent>, IItemContext> result = new HashMap<ItemId<IComponent>, IItemContext>();
        for (ItemId<IComponent> next : components) {
            IComponent cmp = (IComponent)fetchedComponents.get(next);
            WorkspaceContext nextContext = (WorkspaceContext)this.contexts.get(next);
            if (nextContext == null) {
                String contextName = ContextNameUtil.getContextName(this.connection, cmp);
                nextContext = new WorkspaceContext(this.connection, next, contextName);
                this.contexts.put(next, (Object)nextContext);
            }
            result.put(next, nextContext);
        }
        return result;
    }

    @Override
    public Set<ItemNamespace> getNamespaces(IProgressMonitor monitor) throws TeamRepositoryException {
        List<ItemId<IComponent>> components = ConnectionUtil.getComponents((IFlowNodeConnection)this.connection);
        HashSet result = NewCollection.hashSet();
        for (ItemId<IComponent> next : components) {
            result.add(WorkspaceNamespace.create(this.connection.teamRepository(), this.connection.getResolvedWorkspace().getItemId(), next.getItemUUID()));
        }
        return result;
    }

    @Override
    public ItemNamespace getNamespaceFor(ItemId<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        Set<ItemId<IComponent>> components = this.getComponents();
        if (components.contains(component)) {
            return WorkspaceNamespace.create(this.connection.teamRepository(), this.connection.getResolvedWorkspace().getItemId(), component.getItemUUID());
        }
        return EmptyNamespace.create(this.connection.teamRepository(), component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ItemId<IComponent>> getComponents() throws TeamRepositoryException {
        this.copyValues();
        WorkspaceSnapshot workspaceSnapshot = this;
        synchronized (workspaceSnapshot) {
            return this.components;
        }
    }

    private Set<ItemId<IComponent>> fetchComponents() throws TeamRepositoryException {
        HashSet<ItemId<IComponent>> newComponents = new HashSet<ItemId<IComponent>>();
        newComponents.addAll(ConnectionUtil.getComponents((IFlowNodeConnection)this.connection));
        return newComponents;
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        this.connection.refresh(monitor);
        this.copyValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(IChangeListener changeListener) {
        this.listeners.add(changeListener);
        WorkspaceSnapshot workspaceSnapshot = this;
        synchronized (workspaceSnapshot) {
            if (!this.allocated) {
                this.allocated = true;
                this.allocate();
            }
        }
    }

    private void allocate() {
        this.connection.addGenericListener((Object)"components", this.connectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(IChangeListener changeListener) {
        this.listeners.remove(changeListener);
        boolean listenersEmpty = this.listeners.isEmpty();
        WorkspaceSnapshot workspaceSnapshot = this;
        synchronized (workspaceSnapshot) {
            if (this.allocated && listenersEmpty) {
                this.allocated = false;
                this.deallocate();
            }
        }
    }

    private void deallocate() {
        this.connection.removeGenericListener((Object)"components", this.connectionListener);
    }
}

