/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraSyncReport;
import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceSnapshot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotSyncReport {
    private SnapshotSyncReportFragment incoming;
    private SnapshotSyncReportFragment outgoing;

    public SnapshotSyncReport(SnapshotSyncReportFragment incoming, SnapshotSyncReportFragment outgoing) {
        this.incoming = incoming;
        this.outgoing = outgoing;
    }

    public SnapshotSyncReportFragment getIncoming() {
        return this.incoming;
    }

    public SnapshotSyncReportFragment getOutgoing() {
        return this.outgoing;
    }

    public Set<ItemId<IComponent>> getModifiedComponents(FlowType flowType) {
        HashSet result = NewCollection.hashSet();
        if (flowType != FlowType.Outgoing) {
            for (Map.Entry<ItemId<IComponent>, ComponentSyncReportFragment> next : this.incoming.getComponentModifications().entrySet()) {
                if (next.getValue().isEmpty()) continue;
                result.add(next.getKey());
            }
        }
        if (flowType != FlowType.Incoming) {
            for (Map.Entry<ItemId<IComponent>, ComponentSyncReportFragment> next : this.outgoing.getComponentModifications().entrySet()) {
                if (next.getValue().isEmpty()) continue;
                result.add(next.getKey());
            }
        }
        return result;
    }

    public SetDiff<ItemId<IComponent>> getComponentChanges(FlowType flowType) {
        if (flowType == FlowType.Incoming) {
            return this.incoming.getComponentChanges();
        }
        if (flowType == FlowType.Outgoing) {
            return this.outgoing.getComponentChanges();
        }
        HashSet outgoingAdditions = new HashSet();
        HashSet outgoingRemovals = new HashSet();
        SetDiff<ItemId<IComponent>> incomingChanges = this.incoming.getComponentChanges();
        SetDiff<ItemId<IComponent>> outgoingChanges = this.outgoing.getComponentChanges();
        outgoingAdditions.addAll(incomingChanges.getRemovals());
        outgoingRemovals.addAll(incomingChanges.getAdditions());
        outgoingAdditions.addAll(outgoingChanges.getAdditions());
        outgoingRemovals.addAll(outgoingChanges.getRemovals());
        return SetDiff.create(outgoingRemovals, outgoingAdditions);
    }

    public SnapshotSyncReportFragment get(FlowType type) {
        if (type == FlowType.Incoming) {
            return this.getIncoming();
        }
        return this.getOutgoing();
    }

    public Set<ItemId<IComponent>> getAffectedComponents() {
        HashSet result = NewCollection.hashSet();
        result.addAll(this.incoming.getAffectedComponents());
        result.addAll(this.outgoing.getAffectedComponents());
        return result;
    }

    public static SnapshotSyncReport generateSyncReport(ITeamRepository repo, List<ItemId<IChangeSet>> incomingChangeSets, List<ItemId<IChangeSet>> outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List incomingChangeSetIds = ItemLocator.idsToLocators(RepositoryNamespace.create(repo), incomingChangeSets);
        List outgoingChangeSetIds = ItemLocator.idsToLocators(RepositoryNamespace.create(repo), outgoingChangeSets);
        HashSet changeSetsToFetch = NewCollection.hashSet();
        changeSetsToFetch.addAll(incomingChangeSetIds);
        changeSetsToFetch.addAll(outgoingChangeSetIds);
        Map changeSets = ItemFetcher.fetchCurrents(changeSetsToFetch, false, (IProgressMonitor)progress.newChild(10));
        SnapshotSyncReportFragment incomingReport = SnapshotSyncReportFragment.createFromChangeSets(CollectionUtil.reorderValues(changeSets, incomingChangeSetIds));
        SnapshotSyncReportFragment outgoingReport = SnapshotSyncReportFragment.createFromChangeSets(CollectionUtil.reorderValues(changeSets, outgoingChangeSetIds));
        return new SnapshotSyncReport(incomingReport, outgoingReport);
    }

    public static SnapshotSyncReport compare(ISnapshot snapshot1, ISnapshot snapshot2, List<? extends IComponentHandle> componentHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (snapshot1 instanceof WorkspaceSnapshot && snapshot2 instanceof WorkspaceSnapshot) {
            WorkspaceSnapshot ws1 = (WorkspaceSnapshot)snapshot1;
            WorkspaceSnapshot ws2 = (WorkspaceSnapshot)snapshot2;
            ArrayList excludedComponents = null;
            if (componentHandles == null) {
                excludedComponents = Collections.EMPTY_LIST;
            } else {
                List c1 = ws1.getWorkspaceConnection().getComponents();
                List c2 = ws2.getWorkspaceConnection().getComponents();
                HashMap<UUID, IComponentHandle> hashMap = new HashMap<UUID, IComponentHandle>();
                for (IComponentHandle iComponentHandle : c1) {
                    hashMap.put(iComponentHandle.getItemId(), iComponentHandle);
                }
                for (IComponentHandle iComponentHandle : c2) {
                    hashMap.put(iComponentHandle.getItemId(), iComponentHandle);
                }
                for (IComponentHandle iComponentHandle : componentHandles) {
                    hashMap.remove(iComponentHandle.getItemId());
                }
                excludedComponents = new ArrayList(hashMap.values());
            }
            IChangeHistorySyncReport syncReport = ws1.getWorkspaceConnection().compareTo((IFlowNodeConnection)ws2.getWorkspaceConnection(), WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO, (List)excludedComponents, monitor);
            return SnapshotSyncReport.createFrom(syncReport);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<ItemId<IComponent>, IItemContext> otherContexts = snapshot2.getContexts((IProgressMonitor)progress.newChild(20));
        Map<ItemId<IComponent>, IItemContext> localContexts = snapshot1.getContexts((IProgressMonitor)progress.newChild(20));
        HashSet allComponents = NewCollection.hashSet();
        if (componentHandles == null) {
            allComponents.addAll(otherContexts.keySet());
            allComponents.addAll(localContexts.keySet());
        } else {
            HashSet<UUID> set = new HashSet<UUID>();
            for (IComponentHandle iComponentHandle : componentHandles) {
                set.add(iComponentHandle.getItemId());
            }
            for (ItemId<IComponent> itemId : otherContexts.keySet()) {
                if (!set.contains(itemId.getItemUUID())) continue;
                allComponents.add(itemId);
            }
            for (ItemId<IComponent> itemId : localContexts.keySet()) {
                if (!set.contains(itemId.getItemUUID())) continue;
                allComponents.add(itemId);
            }
        }
        HashSet incomingComponents = NewCollection.hashSet();
        HashSet hashSet = NewCollection.hashSet();
        HashMap hashMap = NewCollection.hashMap();
        HashMap outgoingFragments = NewCollection.hashMap();
        SubMonitor loopProgress = progress.newChild(40).setWorkRemaining(allComponents.size());
        for (ItemId next : allComponents) {
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            IItemContext localContext = localContexts.get(next);
            if (localContext == null) {
                incomingComponents.add(next);
                continue;
            }
            IItemContext otherContext = otherContexts.get(next);
            if (otherContext == null) {
                hashSet.add(next);
                continue;
            }
            EraDescriptor localChangeSets = localContext.getChangeSets((IProgressMonitor)iterationProgress.newChild(25));
            EraDescriptor remoteChangeSets = otherContext.getChangeSets((IProgressMonitor)iterationProgress.newChild(25));
            EraSyncReport syncReport = localChangeSets.compare(remoteChangeSets, (IProgressMonitor)iterationProgress.newChild(50));
            hashMap.put(next, ComponentSyncReportFragment.createFrom(syncReport.getIncoming()));
            outgoingFragments.put(next, ComponentSyncReportFragment.createFrom(syncReport.getOutgoing()));
        }
        SnapshotSyncReportFragment incoming = new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)SetDiff.create((Collection)incomingComponents, (Collection)Collections.EMPTY_SET), hashMap, Collections.EMPTY_MAP);
        SnapshotSyncReportFragment outgoing = new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)SetDiff.create((Collection)hashSet, (Collection)Collections.EMPTY_SET), outgoingFragments, Collections.EMPTY_MAP);
        return new SnapshotSyncReport(incoming, outgoing);
    }

    public static SnapshotSyncReport createFrom(IChangeHistorySyncReport syncReport) {
        List localComponents = ItemLists.handlesToIds((Collection)syncReport.localComponents());
        List remoteComponents = ItemLists.handlesToIds((Collection)syncReport.remoteComponents());
        SetDiff componentDiff = SetDiff.computeDiff((Collection)localComponents, (Collection)remoteComponents);
        Map<ItemId<IComponent>, ItemId<IBaseline>> incomingBaselines = SnapshotSyncReport.getBasisMap(syncReport.remoteBases());
        Map<ItemId<IComponent>, ItemId<IBaseline>> outgoingBaselines = SnapshotSyncReport.getBasisMap(syncReport.localBases());
        HashMap incomingReports = NewCollection.hashMap();
        for (ItemId localComponent : localComponents) {
            if (componentDiff.getRemovals().contains(localComponent)) continue;
            IComponentHandle componentHandle = (IComponentHandle)localComponent.toHandle();
            ItemId<IBaseline> commonBaseline = SnapshotSyncReport.getBaselineHandle(syncReport.commonBaseline(componentHandle));
            List differentBaselines = ItemLists.handlesToIds((Collection)syncReport.incomingBaselines(componentHandle));
            List incomingAfterBasis = ItemLists.handlesToIds((Collection)syncReport.incomingChangeSetsAfterBasis(componentHandle));
            List allIncomingChangeSets = ItemLists.handlesToIds((Collection)syncReport.incomingChangeSets(componentHandle));
            incomingReports.put(localComponent, new ComponentSyncReportFragment(differentBaselines, commonBaseline, new EraSyncReportFragment(incomingAfterBasis), allIncomingChangeSets));
        }
        HashMap outgoingReports = NewCollection.hashMap();
        for (ItemId remoteComponent : remoteComponents) {
            if (componentDiff.getAdditions().contains(remoteComponent)) continue;
            IComponentHandle componentHandle = (IComponentHandle)remoteComponent.toHandle();
            ItemId<IBaseline> commonBaseline = SnapshotSyncReport.getBaselineHandle(syncReport.commonBaseline(componentHandle));
            List differentBaselines = ItemLists.handlesToIds((Collection)syncReport.outgoingBaselines(componentHandle));
            List outgoingChangeSets = ItemLists.handlesToIds((Collection)syncReport.outgoingChangeSetsAfterBasis(componentHandle));
            List allOutgoingChangeSets = ItemLists.handlesToIds((Collection)syncReport.outgoingChangeSets(componentHandle));
            outgoingReports.put(remoteComponent, new ComponentSyncReportFragment(differentBaselines, commonBaseline, new EraSyncReportFragment(outgoingChangeSets), allOutgoingChangeSets));
        }
        return new SnapshotSyncReport(new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)SetDiff.create((Collection)Collections.EMPTY_SET, (Collection)componentDiff.getAdditions()), incomingReports, incomingBaselines), new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)SetDiff.create((Collection)Collections.EMPTY_SET, (Collection)componentDiff.getRemovals()), outgoingReports, outgoingBaselines));
    }

    private static ItemId<IBaseline> getBaselineHandle(IBaselineHandle commonBaseline) {
        if (commonBaseline == null) {
            return ItemId.getNullItem((IItemType)IBaseline.ITEM_TYPE);
        }
        return ItemId.create((IItemHandle)commonBaseline);
    }

    private static Map<ItemId<IComponent>, ItemId<IBaseline>> getBasisMap(Map<IComponentHandle, IBaselineHandle> remoteBases) {
        HashMap result = NewCollection.hashMap();
        for (Map.Entry<IComponentHandle, IBaselineHandle> nextEntry : remoteBases.entrySet()) {
            result.put(new ItemId((IItemHandle)nextEntry.getKey()), new ItemId((IItemHandle)nextEntry.getValue()));
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.incoming == null ? 0 : this.incoming.hashCode());
        result = 31 * result + (this.outgoing == null ? 0 : this.outgoing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotSyncReport other = (SnapshotSyncReport)obj;
        if (this.incoming == null ? other.incoming != null : !this.incoming.equals(other.incoming)) {
            return false;
        }
        return !(this.outgoing == null ? other.outgoing != null : !this.outgoing.equals(other.outgoing));
    }
}

