/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.BaselineContext;
import com.ibm.team.filesystem.client.internal.snapshot.AbstractSnapshot;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaselineSetSnapshot
extends AbstractSnapshot {
    private IBaselineSet baselines;
    private ITeamRepository repository;

    private BaselineSetSnapshot(ITeamRepository repo, IBaselineSet baselines) {
        this.baselines = baselines;
        this.repository = repo;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    public static BaselineSetSnapshot create(ItemLocator<IBaselineSet> baselines, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineSet baselineSet = ItemFetcher.fetchCurrent(baselines, monitor);
        return new BaselineSetSnapshot(baselines.getRepository(), baselineSet);
    }

    @Override
    public String getName() {
        return this.baselines.getName();
    }

    @Override
    public Map<ItemId<IComponent>, IItemContext> getContexts(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List baselineList = this.baselines.getBaselines();
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository);
        HashMap result = NewCollection.hashMap();
        progress.setWorkRemaining(baselineList.size());
        for (IBaselineHandle next : baselineList) {
            SubMonitor iterationProgress = progress.newChild(1);
            IBaselineConnection nextConnection = mgr.getBaselineConnection(next, (IProgressMonitor)iterationProgress);
            result.put(ConnectionUtil.getComponent(nextConnection), new BaselineContext(nextConnection));
        }
        return result;
    }

    @Override
    public ItemNamespace getNamespaceFor(ItemId<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        List baselineHandles = ItemLists.handlesToIds((Collection)this.baselines.getBaselines());
        Collection baselines = RepoFetcher.fetchCurrents((ITeamRepository)this.repository, (Collection)baselineHandles, (boolean)false, (IProgressMonitor)monitor).values();
        for (IBaseline next : baselines) {
            ItemId nextComponent = ItemUtil.getComponent((IBaseline)next);
            if (!nextComponent.equals(component)) continue;
            return BaselineNamespace.create(this.repository, (IBaselineHandle)next);
        }
        return EmptyNamespace.create(this.repository, component);
    }

    @Override
    public Set<ItemNamespace> getNamespaces(IProgressMonitor monitor) throws TeamRepositoryException {
        List baselineHandles = this.baselines.getBaselines();
        HashSet result = NewCollection.hashSet();
        for (IBaselineHandle next : baselineHandles) {
            result.add(BaselineNamespace.create(this.repository, next));
        }
        return result;
    }
}

