/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.share.MultipleSandboxShare;
import com.ibm.team.filesystem.client.internal.share.ReshareVersionables;
import com.ibm.team.filesystem.client.internal.share.ShareOverlap;
import com.ibm.team.filesystem.client.internal.share.ShareVersionables;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareOperation
extends FileSystemOperation
implements IShareOperation {
    private ShareDilemmaHandler problemHandler;
    private HashMap<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> shareRequests = new HashMap();
    private HashMap<ConfigurationDescriptor, List<ReshareVersionables>> reshares;
    private HashMap<ConfigurationDescriptor, List<ShareVersionables>> shares;
    private HashMap<UUID, IChangeSetHandle> changeSetsCommitted;
    private HashSet<IShareable> allShares;

    public ShareOperation(ShareDilemmaHandler problemHandler) {
        super(problemHandler);
        this.problemHandler = problemHandler == null ? ShareDilemmaHandler.getDefault() : problemHandler;
        this.changeSetsCommitted = new HashMap();
        this.allShares = new HashSet();
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, List<IPath> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        this.addShareRequest(workspace, changeSet, component, null, new String[0], null, shareRoots, overwrite, progress);
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, List<IPath> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        if (parentFolder == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        this.addShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, null, shareRoots, overwrite, progress);
    }

    @Override
    public void share(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, List<IPath> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        Object descriptor;
        List<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (componentName == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderRoot == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderRoot;
        int n = newFolderUnderRoot.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (shareRoots == null) {
            throw new IllegalArgumentException();
        }
        for (IPath shareRoot : shareRoots) {
            if (shareRoot != null) continue;
            throw new IllegalArgumentException("Share root can not be null");
        }
        HashMap<ConfigurationDescriptor, List<ShareRequest>> requestsByConnection = this.shareRequests.get(workspace);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.shareRequests.put(workspace, requestsByConnection);
        }
        if ((requests = requestsByConnection.get(descriptor = null)) == null) {
            requests = new ArrayList<ShareRequest>();
            requestsByConnection.put((ConfigurationDescriptor)descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, componentName, newFolderUnderRoot, null, shareRoots, overwrite, progress));
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, ISandbox sandbox, List<IPath> relativeSharePaths, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        if (parentFolder == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException("Sandbox must be supplied");
        }
        this.addShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, sandbox, relativeSharePaths, overwrite, progress);
    }

    @Override
    public void share(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, ISandbox sandbox, List<IPath> relativeSharePaths, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        Object descriptor;
        List<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (componentName == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderRoot == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderRoot;
        int n = newFolderUnderRoot.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (relativeSharePaths == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException("Sandbox must be supplied");
        }
        for (IPath shareRoot : relativeSharePaths) {
            if (shareRoot != null) continue;
            throw new IllegalArgumentException("Project can not be null");
        }
        HashMap<ConfigurationDescriptor, List<ShareRequest>> requestsByConnection = this.shareRequests.get(workspace);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.shareRequests.put(workspace, requestsByConnection);
        }
        if ((requests = requestsByConnection.get(descriptor = null)) == null) {
            requests = new ArrayList<ShareRequest>();
            requestsByConnection.put((ConfigurationDescriptor)descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, componentName, newFolderUnderRoot, sandbox, relativeSharePaths, overwrite, progress));
    }

    @Override
    public void reshareAs(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle changeSet, IFolderHandle remoteShare, ISandbox sandbox, IPath relativeSharePath, IProgressMonitor progress) throws TeamRepositoryException {
        ConfigurationDescriptor descriptor;
        List<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (remoteShare == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException();
        }
        if (relativeSharePath == null || relativeSharePath.segmentCount() < 1) {
            throw new IllegalArgumentException("share root must be supplied");
        }
        HashMap<ConfigurationDescriptor, List<ShareRequest>> requestsByConnection = this.shareRequests.get(workspace);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.shareRequests.put(workspace, requestsByConnection);
        }
        if ((requests = requestsByConnection.get(descriptor = new ConfigurationDescriptor((IConnection)workspace, component))) == null) {
            requests = new ArrayList<ShareRequest>();
            requestsByConnection.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, component, changeSet, remoteShare, sandbox, relativeSharePath, progress));
    }

    private void addShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, ISandbox sandbox, List<IPath> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        ConfigurationDescriptor descriptor;
        List<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderParent;
        int n = newFolderUnderParent.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (shareRoots == null) {
            throw new IllegalArgumentException();
        }
        for (IPath shareRoot : shareRoots) {
            if (shareRoot != null) continue;
            throw new IllegalArgumentException("share root can not be null");
        }
        HashMap<ConfigurationDescriptor, List<ShareRequest>> requestsByConnection = this.shareRequests.get(workspace);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.shareRequests.put(workspace, requestsByConnection);
        }
        if ((requests = requestsByConnection.get(descriptor = new ConfigurationDescriptor((IConnection)workspace, component))) == null) {
            requests = new ArrayList<ShareRequest>();
            requestsByConnection.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, sandbox, shareRoots, overwrite, progress));
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress;
        block10: {
            monitor.setTaskName(Messages.ShareProjectsOperation_4);
            if (this.shareRequests.isEmpty()) {
                throw new IllegalStateException();
            }
            final HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
            ArrayList<IContextHandle> contexts = new ArrayList<IContextHandle>();
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)202);
            this.getAffectedConfigurations(configurations, contexts, (IProgressMonitor)progress.newChild(1));
            FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurations, contexts, (Collection<? extends IAuditable>)Collections.EMPTY_LIST, (IProgressMonitor)progress.newChild(1));
            try {
                try {
                    TeamRepositoryException[] repositoryException = new TeamRepositoryException[1];
                    IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ShareOperation.this.doShare(configurations, monitor);
                            }
                            catch (FileSystemClientException e) {
                                throw new InvocationTargetException((Throwable)((Object)e));
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    this.runWithinFileSystemLock(runnableWithProgress, Messages.ShareOperation_5, (IProgressMonitor)progress.newChild(100));
                    if (repositoryException[0] != null) {
                        throw repositoryException[0];
                    }
                }
                catch (CoreException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor(e));
                    WorkspaceLockUtil.release(workspaceLock);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                WorkspaceLockUtil.release(workspaceLock);
                throw throwable;
            }
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.setWorkRemaining(this.shares.size() * 100);
        for (Map.Entry<ConfigurationDescriptor, List<ShareVersionables>> sharesEntry : this.shares.entrySet()) {
            List<ShareVersionables> pendingShareProjects = sharesEntry.getValue();
            SubMonitor iterProgress = progress.newChild(100);
            iterProgress.setWorkRemaining(pendingShareProjects.size() * 10);
            for (ShareVersionables shareProjects : pendingShareProjects) {
                shareProjects.commitNewProjectContents((IProgressMonitor)iterProgress.newChild(10));
                Collection<IChangeSetHandle> csCommitted = shareProjects.getCommittedChangeSets();
                for (IChangeSetHandle changeSet : csCommitted) {
                    this.changeSetsCommitted.put(changeSet.getItemId(), changeSet);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doShare(Set<ConfigurationDescriptor> configurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ShareOperation_SHARE_PROGRESS_MESSAGE, (int)100);
        SubMonitor subProgress = reporter.newChild(5);
        subProgress.setWorkRemaining(this.shareRequests.size() * 100);
        HashSet<ICopyFileAreaLockRequest> cfaLocksNeeded = new HashSet<ICopyFileAreaLockRequest>();
        for (Map.Entry<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> entryByConnection : this.shareRequests.entrySet()) {
            List<ShareRequest> sharesForNewComponents = entryByConnection.getValue().remove(null);
            if (sharesForNewComponents != null) {
                SubMonitor subMonitor = subProgress.newChild(50);
                subMonitor.setWorkRemaining(sharesForNewComponents.size());
                ArrayList componentOps = new ArrayList(sharesForNewComponents.size());
                IWorkspaceConnection iWorkspaceConnection = entryByConnection.getKey();
                IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)iWorkspaceConnection.teamRepository());
                for (ShareRequest shareRequest : sharesForNewComponents) {
                    IContributorHandle owner = RepositoryUtils.getLoggedInContributor(iWorkspaceConnection.teamRepository());
                    shareRequest.component = (IComponentHandle)manager.createComponent(shareRequest.componentName, (IAuditableHandle)owner, (IProgressMonitor)subMonitor.newChild(1));
                    componentOps.add(iWorkspaceConnection.componentOpFactory().addComponent(shareRequest.component, false));
                }
                iWorkspaceConnection.applyComponentOperations((List)componentOps, (IProgressMonitor)subProgress.newChild(20));
                for (ShareRequest shareRequest : sharesForNewComponents) {
                    ArrayList<ShareRequest> requests = new ArrayList<ShareRequest>(1);
                    requests.add(shareRequest);
                    ConfigurationDescriptor configuration = new ConfigurationDescriptor((IConnection)iWorkspaceConnection, shareRequest.component);
                    entryByConnection.getValue().put(configuration, requests);
                    configurations.add(configuration);
                }
            }
            subProgress.setWorkRemaining(10 * entryByConnection.getValue().size());
            for (List list : entryByConnection.getValue().values()) {
                SubMonitor subMonitor = subProgress.newChild(10).setWorkRemaining(list.size());
                for (Object request2 : list) {
                    cfaLocksNeeded.addAll(((ShareRequest)request2).getCopyFileAreaLocksNeeded((IProgressMonitor)subMonitor.newChild(1)));
                }
            }
        }
        ICopyFileAreasLock cfaLock = ICopyFileAreaManager.instance.lock(cfaLocksNeeded, (IProgressMonitor)reporter.newChild(1));
        try {
            void var11_22;
            Map<ConfigurationDescriptor, Set<ISandbox>> configurationSandboxes = this.findMultipleSandboxForConfig(configurations, (IProgressMonitor)reporter.newChild(5));
            HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizedShares = this.organizeShares((IProgressMonitor)reporter.newChild(1));
            this.reshares = new HashMap();
            this.shares = new HashMap();
            HashMap<IShareable, ShareOverlap> hashMap = new HashMap<IShareable, ShareOverlap>();
            HashMap<ConfigurationDescriptor, MultipleSandboxShare> multipleSandboxesForConfiguration = new HashMap<ConfigurationDescriptor, MultipleSandboxShare>();
            subProgress = reporter.newChild(5);
            subProgress.setWorkRemaining(this.shareRequests.size() * 10);
            for (Map.Entry entry : this.shareRequests.entrySet()) {
                IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
                ArrayList<OverlapRequest> arrayList = new ArrayList<OverlapRequest>(((HashMap)entry.getValue()).size());
                SubMonitor subSubProgress = subProgress.newChild(9);
                subSubProgress.setWorkRemaining(((HashMap)entry.getValue()).size());
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    ConfigurationDescriptor descriptor = (ConfigurationDescriptor)entry2.getKey();
                    List requests = (List)entry2.getValue();
                    this.determineReshares((IConnection)iWorkspaceConnection, descriptor.componentHandle, requests, (IProgressMonitor)subSubProgress.newChild(1));
                    arrayList.add(this.buildOverlapRequest((IConnection)iWorkspaceConnection, descriptor, organizedShares, hashMap));
                    Set<ISandbox> sandboxes = configurationSandboxes.get(descriptor);
                    if (sandboxes == null) {
                        sandboxes = new HashSet<ISandbox>();
                        configurationSandboxes.put(descriptor, sandboxes);
                    }
                    for (ShareRequest request : requests) {
                        for (IShareable shareable : request.shareableRoots) {
                            sandboxes.add(shareable.getSandbox());
                        }
                    }
                    if (sandboxes == null || sandboxes.size() <= 1) continue;
                    MultipleSandboxShare multipleSandboxShare = (MultipleSandboxShare)multipleSandboxesForConfiguration.get(descriptor);
                    if (multipleSandboxShare == null) {
                        multipleSandboxShare = new MultipleSandboxShare(descriptor, sandboxes);
                        multipleSandboxesForConfiguration.put(descriptor, multipleSandboxShare);
                    }
                    for (ShareRequest request : requests) {
                        multipleSandboxShare.addShareables(request.shareableRoots);
                    }
                }
                subSubProgress.done();
                FileSystemManager fsm = (FileSystemManager)FileSystemCore.getFileSystemManager(iWorkspaceConnection.teamRepository());
                FileSystemServiceProxy fss = fsm.getFileSystemService();
                List<OverlapResponse> overlapResults = fss.detectOverlap(arrayList, null, (IProgressMonitor)subProgress.newChild(1));
                this.recordOverlaps(iWorkspaceConnection, organizedShares, overlapResults, hashMap);
            }
            subProgress.done();
            if (!multipleSandboxesForConfiguration.isEmpty()) {
                int n = this.problemHandler.multipleSandboxesForConfigurations(multipleSandboxesForConfiguration.values());
                if (n == 1) {
                    throw new OperationCanceledException();
                }
                if (n != 0) {
                    throw new FileSystemClientException(new FileSystemStatus(4, Messages.ShareOperation_6));
                }
            }
            if (!hashMap.isEmpty()) {
                int n = this.problemHandler.overlappingShareRequests(hashMap.values());
                if (n == 1) {
                    throw new OperationCanceledException();
                }
                if (n != 0) {
                    throw new FileSystemClientException(new FileSystemStatus(4, Messages.ShareProjectsOperation_0));
                }
                this.updateSharesToDo(hashMap);
            }
            boolean bl = false;
            int reshareSize = 0;
            for (List<ShareVersionables> list : this.shares.values()) {
                for (ShareVersionables s : list) {
                    var11_22 += s.getShareableCount();
                }
            }
            for (List<ReshareVersionables> list : this.reshares.values()) {
                reshareSize += list.size();
            }
            reporter.setWorkRemaining(reshareSize * 10 + var11_22 * 5 + 1);
            HashMap<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>> hashMap2 = new HashMap<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>>();
            for (Map.Entry<ConfigurationDescriptor, List<ShareVersionables>> entry : this.shares.entrySet()) {
                List<ShareVersionables> pendingShareProjects = entry.getValue();
                ConfigurationDescriptor descriptor = entry.getKey();
                for (ShareVersionables shareProjects : pendingShareProjects) {
                    Map<String, IFolder> foldersCreated = this.getNewFoldersCreatedUnderParent(descriptor, shareProjects, hashMap2);
                    shareProjects.share(foldersCreated, (IProgressMonitor)reporter.newChild(shareProjects.getShareableCount() * 5));
                }
            }
            for (List list : this.reshares.values()) {
                for (ReshareVersionables reshareProject : list) {
                    reshareProject.reShare((IProgressMonitor)reporter.newChild(10));
                }
            }
        }
        finally {
            cfaLock.release((IProgressMonitor)reporter.newChild(1));
        }
    }

    private Map<String, IFolder> getNewFoldersCreatedUnderParent(ConfigurationDescriptor descriptor, ShareVersionables shareProjects, Map<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>> newFolders) {
        Map<String, IFolder> foldersCreated;
        if (shareProjects.newFolderUnderParent.length > 0) {
            Map<UUID, Map<String, IFolder>> newFoldersUnderParents = newFolders.get(descriptor);
            if (newFoldersUnderParents == null) {
                newFoldersUnderParents = new HashMap<UUID, Map<String, IFolder>>();
                newFolders.put(descriptor, newFoldersUnderParents);
            }
            if ((foldersCreated = newFoldersUnderParents.get(shareProjects.parentFolder.getItemId())) == null) {
                foldersCreated = new HashMap<String, IFolder>();
                newFoldersUnderParents.put(shareProjects.parentFolder.getItemId(), foldersCreated);
            }
        } else {
            foldersCreated = Collections.EMPTY_MAP;
        }
        return foldersCreated;
    }

    private void updateSharesToDo(HashMap<IShareable, ShareOverlap> overlaps) {
        for (ShareOverlap shareOverlap : overlaps.values()) {
            List<ShareVersionables> pendingShares;
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor(shareOverlap.getConnection(), shareOverlap.getComponent());
            IShareable project = shareOverlap.getShareRoot();
            List<ReshareVersionables> pendingReshares = this.reshares.get(descriptor);
            if (pendingReshares != null) {
                Iterator<ReshareVersionables> i = pendingReshares.iterator();
                while (i.hasNext()) {
                    ReshareVersionables reshareProject = i.next();
                    if (!reshareProject.shareableRoot.equals(project)) continue;
                    i.remove();
                }
            }
            if ((pendingShares = this.shares.get(descriptor)) == null) continue;
            for (ShareVersionables shareProjects : pendingShares) {
                shareProjects.removeProject(project);
            }
        }
    }

    private OverlapRequest buildOverlapRequest(IConnection connection, ConfigurationDescriptor descriptor, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizedShares, HashMap<IShareable, ShareOverlap> overlaps) {
        List<ReshareVersionables> pendingReshareProject;
        OverlapRequest overlapRequest = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
        overlapRequest.setContext(descriptor.connectionHandle);
        overlapRequest.setComponent(descriptor.componentHandle);
        List toVerfiyForOverlap = overlapRequest.getGroup();
        HashMap<UUID, IShare> existingShares = organizedShares.get(descriptor);
        List<ShareVersionables> pendingShareProjects = this.shares.get(descriptor);
        if (pendingShareProjects != null) {
            for (ShareVersionables shareProjects : pendingShareProjects) {
                ISharingDescriptor sharingDescriptor;
                IShare share;
                toVerfiyForOverlap.add(shareProjects.parentFolder);
                if (existingShares == null || (share = existingShares.get(shareProjects.parentFolder.getItemId())) == null || !(sharingDescriptor = share.getSharingDescriptor()).isAssociatedWithConnection(connection) || !sharingDescriptor.getComponent().sameItemId((IItemHandle)descriptor.componentHandle)) continue;
                for (IShareable project : shareProjects.getShareables()) {
                    ShareOverlap overlap = overlaps.get(project);
                    if (overlap == null) {
                        overlap = new ShareOverlap(connection, descriptor.componentHandle, project);
                        overlaps.put(project, overlap);
                    }
                    overlap.addShareOverlap(share);
                }
            }
        }
        if ((pendingReshareProject = this.reshares.get(descriptor)) != null) {
            for (ReshareVersionables reshareProject : pendingReshareProject) {
                toVerfiyForOverlap.add(reshareProject.remoteShare);
            }
        }
        if (existingShares != null) {
            for (IShare share : existingShares.values()) {
                toVerfiyForOverlap.add(share.getSharingDescriptor().getRootVersionable());
            }
        }
        return overlapRequest;
    }

    private void recordOverlaps(IWorkspaceConnection connection, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizedShares, List<OverlapResponse> overlapResults, HashMap<IShareable, ShareOverlap> overlaps) {
        for (OverlapResponse response : overlapResults) {
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor((IConnection)connection, response.getComponent());
            HashMap<UUID, IShare> existingShares = organizedShares.get(descriptor);
            for (OverlapDescription overlapDescription : response.getOverlapDescriptions()) {
                IShare share;
                ShareOverlap overlap2;
                Collection<ShareVersionables> sharesForParent;
                ShareOverlap overlap22;
                Shareable p;
                Shareable project = this.getResharedProject(descriptor, overlapDescription.getElement());
                if (project != null) {
                    ShareOverlap overlap = overlaps.get(project);
                    if (overlap == null) {
                        overlap = new ShareOverlap((IConnection)connection, response.getComponent(), project);
                        overlaps.put(project, overlap);
                    }
                    for (IVersionableHandle versionableOverlapped : overlapDescription.getOverlappedChildren()) {
                        p = this.getResharedProject(descriptor, versionableOverlapped);
                        if (p != null) {
                            overlap.addShareRootOverlap(p);
                            overlap22 = overlaps.get(p);
                            if (overlap22 == null) {
                                overlap22 = new ShareOverlap((IConnection)connection, response.getComponent(), p);
                                overlaps.put(p, overlap22);
                            }
                            overlap22.addShareRootOverlap(project);
                        }
                        sharesForParent = this.getSharesForParent(descriptor, versionableOverlapped);
                        for (ShareVersionables shareProjects : sharesForParent) {
                            for (IShareable p2 : shareProjects.getShareables()) {
                                overlap.addShareRootOverlap(p2);
                                overlap2 = overlaps.get(p2);
                                if (overlap2 == null) {
                                    overlap2 = new ShareOverlap((IConnection)connection, response.getComponent(), p2);
                                    overlaps.put(p2, overlap2);
                                }
                                overlap2.addShareRootOverlap(project);
                            }
                        }
                        IShare share2 = existingShares.get(versionableOverlapped);
                        if (share2 == null) continue;
                        overlap.addShareOverlap(share2);
                    }
                    continue;
                }
                if (existingShares == null || (share = existingShares.get(overlapDescription.getElement().getItemId())) == null) continue;
                for (IVersionableHandle versionableOverlapped : overlapDescription.getOverlappedChildren()) {
                    p = this.getResharedProject(descriptor, versionableOverlapped);
                    if (p != null) {
                        overlap22 = overlaps.get(p);
                        if (overlap22 == null) {
                            overlap22 = new ShareOverlap((IConnection)connection, response.getComponent(), p);
                            overlaps.put(p, overlap22);
                        }
                        overlap22.addShareOverlap(share);
                    }
                    sharesForParent = this.getSharesForParent(descriptor, versionableOverlapped);
                    for (ShareVersionables shareProjects : sharesForParent) {
                        for (IShareable p2 : shareProjects.getShareables()) {
                            overlap2 = overlaps.get(p2);
                            if (overlap2 == null) {
                                overlap2 = new ShareOverlap((IConnection)connection, response.getComponent(), p2);
                                overlaps.put(p2, overlap2);
                            }
                            overlap2.addShareOverlap(share);
                        }
                    }
                }
            }
        }
    }

    private Collection<ShareVersionables> getSharesForParent(ConfigurationDescriptor descriptor, IVersionableHandle versionableOverlapped) {
        ArrayList<ShareVersionables> result = new ArrayList<ShareVersionables>();
        List<ShareVersionables> currentShares = this.shares.get(descriptor);
        if (currentShares != null) {
            for (ShareVersionables shareProjects : currentShares) {
                if (!shareProjects.parentFolder.sameItemId((IItemHandle)versionableOverlapped)) continue;
                result.add(shareProjects);
            }
        }
        return result;
    }

    private Shareable getResharedProject(ConfigurationDescriptor descriptor, IVersionableHandle versionable) {
        List<ReshareVersionables> currentReshares = this.reshares.get(descriptor);
        if (currentReshares != null) {
            for (ReshareVersionables reshareProject : currentReshares) {
                if (!reshareProject.remoteShare.sameItemId((IItemHandle)versionable)) continue;
                return reshareProject.shareableRoot;
            }
        }
        return null;
    }

    private void determineReshares(IConnection connection, IComponentHandle component, List<ShareRequest> requests, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IComponent fullComponent = (IComponent)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 0, (IProgressMonitor)monitor.newChild(2));
        ArrayList<IFolderHandle> foldersToRetrieve = new ArrayList<IFolderHandle>(requests.size());
        for (ShareRequest request : requests) {
            IFolderHandle parentFolderForShare = request.parentFolder;
            if (parentFolderForShare == null) {
                parentFolderForShare = fullComponent.getRootFolder();
            }
            foldersToRetrieve.add(parentFolderForShare);
        }
        IConfiguration configuration = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component) : ((IBaselineConnection)connection).configuration();
        ConfigurationDescriptor descriptor = new ConfigurationDescriptor(connection, component);
        List folderChildren = configuration.childEntries(foldersToRetrieve, (IProgressMonitor)monitor);
        int i = 0;
        while (i < requests.size()) {
            Map children = (Map)folderChildren.get(i);
            if (children == null) {
                throw new FileSystemClientException(new FileSystemStatus(4, Messages.ShareProjectsOperation_1));
            }
            ShareRequest request = requests.get(i);
            if (request.isKnownReshare()) {
                List<ReshareVersionables> currentReshares = this.reshares.get(descriptor);
                if (currentReshares == null) {
                    currentReshares = new ArrayList<ReshareVersionables>();
                    this.reshares.put(descriptor, currentReshares);
                }
                IVersionable remote = configuration.fetchCompleteItem((IVersionableHandle)request.remoteShare, (IProgressMonitor)monitor.newChild(1));
                currentReshares.add(new ReshareVersionables(connection, fullComponent, remote.getParent(), (IVersionableHandle)request.remoteShare, remote.getName(), (Shareable)request.shareableRoots.get(0), request.overwrite));
                break;
            }
            IFolderHandle parentFolderForShare = request.parentFolder;
            if (parentFolderForShare == null) {
                parentFolderForShare = fullComponent.getRootFolder();
            }
            if (request.newFolderUnderParent.length > 0 && children.get(request.newFolderUnderParent[0]) != null) {
                throw new FileSystemClientException(new FileSystemStatus(4, NLS.bind((String)Messages.ShareProjectsOperation_2, (Object)PathUtils.getString(request.newFolderUnderParent), (Object[])new Object[0])));
            }
            ShareVersionables shareProjects = new ShareVersionables(request.workspace, request.changeSet, fullComponent, parentFolderForShare, request.newFolderUnderParent, request.overwrite, this.problemHandler);
            for (IShareable shareable : request.shareableRoots) {
                if (request.newFolderUnderParent.length > 0) {
                    shareProjects.addShareable(shareable);
                    continue;
                }
                String remoteName = shareable.getLocalPath().lastSegment();
                IVersionableHandle child = (IVersionableHandle)children.get(remoteName);
                if (child == null) {
                    shareProjects.addShareable(shareable);
                    continue;
                }
                if (ResourceType.getResourceType(child) == shareable.getResourceType((IProgressMonitor)monitor.newChild(1))) {
                    List<ReshareVersionables> currentReshares = this.reshares.get(descriptor);
                    if (currentReshares == null) {
                        currentReshares = new ArrayList<ReshareVersionables>();
                        this.reshares.put(descriptor, currentReshares);
                    }
                    currentReshares.add(new ReshareVersionables(connection, fullComponent, parentFolderForShare, child, remoteName, (Shareable)shareable, request.overwrite));
                    continue;
                }
                throw new FileSystemClientException(new FileSystemStatus(4, NLS.bind((String)Messages.ShareProjectsOperation_3, (Object)shareable.getLocalPath(), (Object[])new Object[0])));
            }
            if (shareProjects.getShareableCount() != 0) {
                List<ShareVersionables> currentShares = this.shares.get(descriptor);
                if (currentShares == null) {
                    currentShares = new ArrayList<ShareVersionables>();
                    this.shares.put(descriptor, currentShares);
                }
                currentShares.add(shareProjects);
            }
            ++i;
        }
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations(Set<ConfigurationDescriptor> configurations, Collection<IContextHandle> contexts, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.shareRequests.size());
        for (Map.Entry<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> sharesByConnection : this.shareRequests.entrySet()) {
            IWorkspaceConnection workspace = sharesByConnection.getKey();
            HashMap<ConfigurationDescriptor, List<ShareRequest>> shares = sharesByConnection.getValue();
            SubMonitor iterProgress = progress.newChild(1).setWorkRemaining(shares.size());
            for (Map.Entry<ConfigurationDescriptor, List<ShareRequest>> requestsByConfiguration : shares.entrySet()) {
                List<ShareRequest> requests = requestsByConfiguration.getValue();
                for (ShareRequest request : requests) {
                    configurations.addAll(request.getConfigurationAffected((IProgressMonitor)iterProgress.newChild(1)));
                }
                if (requestsByConfiguration.getKey() != null) continue;
                contexts.add(workspace.getContextHandle());
            }
        }
        return configurations;
    }

    private Map<ConfigurationDescriptor, Set<ISandbox>> findMultipleSandboxForConfig(Set<ConfigurationDescriptor> interestingConfigurations, IProgressMonitor monitor) throws FileSystemClientException {
        HashMap<ConfigurationDescriptor, Set<ISandbox>> sandboxConfigurations = new HashMap<ConfigurationDescriptor, Set<ISandbox>>();
        Collection<ISandbox> sandboxes = SharingManager.getInstance().getRegisteredSandboxes();
        for (ISandbox sandbox : sandboxes) {
            Collection<LoadedConfigurationDescriptor> loadedConfigurations = sandbox.allLoadedConfigurations(monitor);
            for (LoadedConfigurationDescriptor loadedConfigurationDescriptor : loadedConfigurations) {
                ConfigurationDescriptor descriptor = new ConfigurationDescriptor(loadedConfigurationDescriptor.id, loadedConfigurationDescriptor.uri, loadedConfigurationDescriptor.connectionHandle, loadedConfigurationDescriptor.componentHandle);
                if (!interestingConfigurations.contains(descriptor)) continue;
                Set<ISandbox> sandboxesForConfiguration = sandboxConfigurations.get(descriptor);
                if (sandboxesForConfiguration == null) {
                    sandboxesForConfiguration = new HashSet<ISandbox>();
                    sandboxConfigurations.put(descriptor, sandboxesForConfiguration);
                }
                sandboxesForConfiguration.add(sandbox);
            }
        }
        return sandboxConfigurations;
    }

    private HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizeShares(IProgressMonitor monitor) throws FileSystemClientException {
        HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> result = new HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>>();
        HashSet<ISandbox> sandboxesAffected = new HashSet<ISandbox>();
        for (HashMap<ConfigurationDescriptor, List<ShareRequest>> requestsByConnection : this.shareRequests.values()) {
            for (List<ShareRequest> requests : requestsByConnection.values()) {
                for (ShareRequest request : requests) {
                    sandboxesAffected.addAll(request.getSandboxesAffected());
                }
            }
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)sandboxesAffected.size());
        for (ISandbox sandbox : sandboxesAffected) {
            IShare[] iShareArray = sandbox.allShares((IProgressMonitor)progress.newChild(1));
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                if (share.getSharingDescriptor() != null) {
                    ISharingDescriptor shareDesc = share.getSharingDescriptor();
                    ConfigurationDescriptor descriptor = new ConfigurationDescriptor(shareDesc.getRepositoryId(), shareDesc.getRepositoryUri(), shareDesc.getConnectionHandle(), shareDesc.getComponent());
                    HashMap<Object, IShare> shares = result.get(descriptor);
                    if (shares == null) {
                        shares = new HashMap();
                        result.put(descriptor, shares);
                    }
                    shares.put(shareDesc.getRootVersionable().getItemId(), share);
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShareRequest {
        private final IWorkspaceConnection workspace;
        private final IChangeSetHandle changeSet;
        private IComponentHandle component;
        private String componentName;
        private IFolderHandle parentFolder;
        private String[] newFolderUnderParent;
        private final boolean overwrite;
        private final List<IShareable> shareableRoots;
        private IFolderHandle remoteShare;

        ShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, ISandbox sandbox, List<IPath> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
            if (workspace == null) {
                throw new IllegalArgumentException(Messages.ShareOperation_0);
            }
            if (component == null) {
                throw new IllegalArgumentException(Messages.ShareOperation_1);
            }
            this.workspace = workspace;
            this.changeSet = changeSet;
            this.component = component;
            this.parentFolder = parentFolder;
            this.newFolderUnderParent = newFolderUnderParent;
            this.overwrite = overwrite;
            this.shareableRoots = new ArrayList<IShareable>();
            this.init(sandbox, shareRoots, progress);
        }

        public ShareRequest(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, ISandbox sandbox, List<IPath> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
            this.workspace = workspace;
            this.changeSet = null;
            this.componentName = componentName;
            this.parentFolder = null;
            this.newFolderUnderParent = newFolderUnderRoot;
            this.overwrite = overwrite;
            this.shareableRoots = new ArrayList<IShareable>();
            this.init(sandbox, shareRoots, progress);
        }

        public ShareRequest(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle changeSet, IFolderHandle remoteShare, ISandbox sandbox, IPath relativeSharePath, IProgressMonitor progress) throws TeamRepositoryException {
            this.workspace = workspace;
            this.changeSet = changeSet;
            this.component = component;
            this.overwrite = false;
            this.shareableRoots = new ArrayList<IShareable>();
            this.remoteShare = remoteShare;
            this.init(sandbox, Collections.singletonList(relativeSharePath), progress);
        }

        private void init(ISandbox sandbox, List<IPath> roots, IProgressMonitor progress) throws TeamRepositoryException {
            IShareable shareable;
            ResourceType type;
            IFileInfo fileInfo;
            IFileStore fileStore;
            Path realPath;
            String realPathString;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
            SharingManager sharingManager = SharingManager.getInstance();
            if (sandbox == null) {
                for (IPath path : roots) {
                    realPathString = PathUtils.getRealPath(path.removeTrailingSeparator().toOSString());
                    if (realPathString == null) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_7, (Object)path.toOSString(), (Object[])new Object[0]));
                    }
                    realPath = new Path(realPathString);
                    fileStore = EFS.getLocalFileSystem().getStore((IPath)realPath);
                    try {
                        fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (CoreException e) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_9, (Object)realPathString, (Object[])new Object[0]), (Throwable)e);
                    }
                    type = null;
                    if (fileInfo.getAttribute(32)) {
                        type = ResourceType.SYMBOLIC_LINK;
                    } else if (fileInfo.isDirectory()) {
                        type = ResourceType.FOLDER;
                    } else if (fileInfo.exists()) {
                        type = ResourceType.FILE;
                    }
                    if (type == null) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_2, (Object)realPathString, (Object[])new Object[0]));
                    }
                    shareable = sharingManager.findShareable((IPath)realPath, type);
                    if (shareable == null) {
                        IPath cfaPath = realPath.removeLastSegments(1);
                        boolean found = false;
                        while (!found && cfaPath.segmentCount() > 0) {
                            if (cfaMgr.copyFileAreaExists(cfaPath, 1)) {
                                found = true;
                                continue;
                            }
                            cfaPath = cfaPath.removeLastSegments(1);
                        }
                        if (!found) {
                            cfaPath = realPath.removeLastSegments(1);
                        }
                        shareable = sharingManager.findShareable(sharingManager.getSandbox(cfaPath, false), realPath.removeFirstSegments(cfaPath.segmentCount()).setDevice(null), type);
                    }
                    this.shareableRoots.add(shareable);
                }
            } else {
                for (IPath path : roots) {
                    realPathString = PathUtils.getRealPath(sandbox.getRoot().append(path).removeTrailingSeparator().toOSString());
                    if (realPathString == null) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_8, (Object)sandbox.getRoot().append(path).toOSString(), (Object[])new Object[0]));
                    }
                    realPath = new Path(realPathString);
                    fileStore = EFS.getLocalFileSystem().getStore((IPath)realPath);
                    try {
                        fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (CoreException e) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_10, (Object)realPathString, (Object[])new Object[0]), (Throwable)e);
                    }
                    type = null;
                    if (fileInfo.getAttribute(32)) {
                        type = ResourceType.SYMBOLIC_LINK;
                    } else if (fileInfo.isDirectory()) {
                        type = ResourceType.FOLDER;
                    } else if (fileInfo.exists()) {
                        type = ResourceType.FILE;
                    }
                    if (type == null) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_3, (Object)realPathString, (Object[])new Object[0]));
                    }
                    if (realPath.segmentCount() <= sandbox.getRoot().segmentCount()) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_4, (Object)realPathString, (Object[])new Object[]{sandbox.toString()}));
                    }
                    path = realPath.removeFirstSegments(sandbox.getRoot().segmentCount()).setDevice(null);
                    shareable = sharingManager.findShareable(sandbox, path, type);
                    this.shareableRoots.add(shareable);
                }
            }
            for (IShareable shareable2 : this.shareableRoots) {
                if (ShareOperation.this.allShares.add(shareable2)) continue;
                throw new IllegalArgumentException("Share root specified in more than 1 request: " + shareable2.getFullPath().toString());
            }
        }

        Collection<ConfigurationDescriptor> getConfigurationAffected(IProgressMonitor monitor) throws FileSystemClientException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.shareableRoots.size());
            if (!this.overwrite) {
                if (this.component == null) {
                    return Collections.EMPTY_LIST;
                }
                ConfigurationDescriptor configuration = new ConfigurationDescriptor((IConnection)this.workspace, this.component);
                return Collections.singletonList(configuration);
            }
            ArrayList<ConfigurationDescriptor> configurations = new ArrayList<ConfigurationDescriptor>(2);
            if (this.component != null) {
                ConfigurationDescriptor configuration = new ConfigurationDescriptor((IConnection)this.workspace, this.component);
                configurations.add(configuration);
            }
            for (IShareable shareable : this.shareableRoots) {
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                if (share == null) continue;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                configurations.add(new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent()));
            }
            return configurations;
        }

        Collection<ISandbox> getSandboxesAffected() {
            HashSet<ISandbox> result = new HashSet<ISandbox>();
            for (IShareable shareable : this.shareableRoots) {
                result.add(shareable.getSandbox());
            }
            return result;
        }

        String getComponentName() {
            return this.componentName;
        }

        Collection<ICopyFileAreaLockRequest> getCopyFileAreaLocksNeeded(IProgressMonitor monitor) throws FileSystemClientException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.shareableRoots.size());
            ICopyFileAreaManager.ICopyFileAreaLockRequestFactory cfaLockFactory = ICopyFileAreaManager.instance.lockRequestFactory();
            HashSet<ICopyFileAreaLockRequest> locksNeeded = new HashSet<ICopyFileAreaLockRequest>();
            for (IShareable shareable : this.shareableRoots) {
                IShare share;
                locksNeeded.add(cfaLockFactory.getLockRequest(shareable.getSandbox().getRoot(), Collections.singleton(new ConfigurationDescriptor((IConnection)this.workspace, this.component)), false));
                if (!this.overwrite || (share = shareable.getShare((IProgressMonitor)progress.newChild(1))) == null) continue;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                locksNeeded.add(cfaLockFactory.getLockRequest(shareable.getSandbox().getRoot(), Collections.singleton(new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent())), false));
            }
            return locksNeeded;
        }

        boolean isKnownReshare() {
            return this.remoteShare != null;
        }
    }
}

