/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.queries;

import com.ibm.team.filesystem.client.internal.namespace.impl.MruCache;
import com.ibm.team.filesystem.client.internal.queries.IQuery;
import com.ibm.team.filesystem.client.internal.queries.IQueryCache;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class QueryCache
implements IQueryCache {
    private static QueryCache queryCache = new QueryCache();
    private MruCache cache = new MruCache();

    public static List execute(IQuery query, IProgressMonitor mon) throws TeamRepositoryException {
        return QueryCache.getDefault().compute(query, mon);
    }

    public static QueryCache getDefault() {
        return queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List compute(IQuery query, IProgressMonitor mon) throws TeamRepositoryException {
        CacheEntry result;
        MruCache mruCache = this.cache;
        synchronized (mruCache) {
            result = (CacheEntry)this.cache.get(query);
            if (result == null) {
                result = new CacheEntry();
                this.cache.put(query, result);
            }
        }
        return result.getResult(query, mon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(IQuery toFlush) {
        MruCache mruCache = this.cache;
        synchronized (mruCache) {
            this.cache.remove(toFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        MruCache mruCache = this.cache;
        synchronized (mruCache) {
            this.cache.clear();
        }
    }

    private static final class CacheEntry {
        List result;

        private CacheEntry() {
        }

        public synchronized List getResult(IQuery query, IProgressMonitor mon) throws TeamRepositoryException {
            if (this.result != null) {
                return this.result;
            }
            this.result = query.compute(mon);
            return this.result;
        }
    }
}

