/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.queries;

import com.ibm.team.filesystem.client.internal.queries.AbstractQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeSetsForItemQuery
extends AbstractQuery {
    private ITeamRepository repo;
    private ItemId item;

    public ChangeSetsForItemQuery(ITeamRepository repo, ItemId item) {
        this.repo = repo;
        this.item = item;
    }

    public List compute(IProgressMonitor mon) throws TeamRepositoryException {
        IChangeSetSearchCriteria criteria = IChangeSetSearchCriteria.FACTORY.newInstance();
        criteria.setItem((IVersionableHandle)this.item.toHandle());
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo);
        List query = manager.findChangeSets(criteria, Integer.MAX_VALUE, mon);
        return this.repo.itemManager().fetchCompleteItems(query, 0, mon);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeSetsForItemQuery) {
            ChangeSetsForItemQuery other = (ChangeSetsForItemQuery)obj;
            return other.repo == this.repo && other.item.equals((Object)this.item);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.repo.hashCode() + this.item.hashCode();
    }
}

