/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceUpdateRequest {
    private RequestType type;
    private List<IBaselineHandle> baselines;
    private Map<UUID, IComponentHandle> acceptComponents;
    private Map<UUID, IComponentHandle> replaceComponents;
    private List<IChangeSetHandle> changeSets;
    private List<String> newComponentNames;
    private Map<UUID, IComponentHandle> addComponents;
    private Map<UUID, IComponentHandle> removeComponents;
    private IWorkspaceConnection workspace;
    private IBaselineConnection sourceBaselineConnection;
    private IBaselineSetHandle sourceSnapshot;
    private IWorkspaceConnection sourceWorkspace;
    private ITeamRepository sourceRepository = null;
    private IChangeHistorySyncReport syncReport;
    private HashSet<ConfigurationDescriptor> affectedConfigurations;
    private Map<UUID, IFlowNodeConnection.IComponentOp> componentOperations;
    private Map<UUID, IFlowNodeConnection.IComponentReplacementOp> replaceCandidates;
    private List<IBaselineHandle> allBaselines;
    private List<IChangeSetHandle> allChangeSets;

    private WorkspaceUpdateRequest(RequestType requestType, IWorkspaceConnection workspace) {
        this.type = requestType;
        this.workspace = workspace;
        this.sourceWorkspace = null;
        this.syncReport = null;
        this.baselines = new ArrayList<IBaselineHandle>();
        this.acceptComponents = new HashMap<UUID, IComponentHandle>();
        this.replaceComponents = new HashMap<UUID, IComponentHandle>();
        this.changeSets = new ArrayList<IChangeSetHandle>();
        this.newComponentNames = new ArrayList<String>();
        this.addComponents = new HashMap<UUID, IComponentHandle>();
        this.removeComponents = new HashMap<UUID, IComponentHandle>();
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, List<? extends IChangeSetHandle> changeSets) {
        this(RequestType.CHANGE_SET_ONLY, workspace);
        this.changeSets.addAll(changeSets);
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, ITeamRepository teamRepository, List<? extends IChangeSetHandle> changeSets) {
        this(RequestType.CHANGE_SET_ONLY, workspace);
        this.changeSets.addAll(changeSets);
        this.sourceRepository = teamRepository;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IBaselineHandle> baselines, List<? extends IChangeSetHandle> changeSets, List<? extends IComponentHandle> components) {
        this(RequestType.CHOICE, workspace);
        this.sourceWorkspace = sourceWorkspace;
        this.syncReport = syncReport;
        this.changeSets = new ArrayList<IChangeSetHandle>(changeSets);
        this.baselines = new ArrayList<IBaselineHandle>(baselines);
        for (IComponentHandle iComponentHandle : components) {
            this.acceptComponents.put(iComponentHandle.getItemId(), iComponentHandle);
        }
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IComponentHandle> components, boolean replaceComponents) {
        this(RequestType.CHOICE, workspace);
        this.sourceWorkspace = sourceWorkspace;
        this.syncReport = syncReport;
        Map<UUID, IComponentHandle> componentsToSynchronize = replaceComponents ? this.replaceComponents : this.acceptComponents;
        for (IComponentHandle iComponentHandle : components) {
            componentsToSynchronize.put(iComponentHandle.getItemId(), iComponentHandle);
        }
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, boolean replace) {
        this(replace ? RequestType.WORKSPACE_CONTEXT_REPLACE : RequestType.WORKSPACE_CONTEXT_ACCEPT, workspace);
        this.sourceWorkspace = sourceWorkspace;
        this.syncReport = syncReport;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, IBaselineSetHandle sourceSnapshot, List<? extends IComponentHandle> components) {
        this(RequestType.CHOICE, workspace);
        this.sourceSnapshot = sourceSnapshot;
        for (IComponentHandle iComponentHandle : components) {
            this.replaceComponents.put(iComponentHandle.getItemId(), iComponentHandle);
        }
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, IBaselineSetHandle sourceSnapshot) {
        this(RequestType.WORKSPACE_CONTEXT_REPLACE, workspace);
        this.sourceSnapshot = sourceSnapshot;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, IBaselineConnection sourceBaseline) {
        this(RequestType.WORKSPACE_CONTEXT_REPLACE, workspace);
        this.sourceBaselineConnection = sourceBaseline;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, String newComponentName) {
        this(RequestType.CHOICE, workspace);
        this.newComponentNames.add(newComponentName);
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection workspace, IComponentHandle component, boolean add) {
        this(RequestType.CHOICE, workspace);
        if (add) {
            this.addComponents.put(component.getItemId(), component);
        } else {
            this.removeComponents.put(component.getItemId(), component);
        }
    }

    public void addComponents(List<? extends IComponentHandle> components, boolean replaceComponents) throws TeamRepositoryException {
        if (this.type == RequestType.CHOICE) {
            if (!replaceComponents && this.sourceWorkspace == null) {
                throw new TeamRepositoryException(Messages.WorkspaceUpdateRequest_2);
            }
            Map<UUID, IComponentHandle> componentsToSynchronize = replaceComponents ? this.replaceComponents : this.acceptComponents;
            Map<UUID, IComponentHandle> alternative = replaceComponents ? this.acceptComponents : this.replaceComponents;
            for (IComponentHandle iComponentHandle : components) {
                componentsToSynchronize.put(iComponentHandle.getItemId(), iComponentHandle);
                if (!alternative.containsKey(iComponentHandle.getItemId())) continue;
                throw new TeamRepositoryException(Messages.WorkspaceUpdateRequest_0);
            }
            this.resetCachedInfo();
        }
    }

    public void addChangeSets(List<? extends IChangeSetHandle> changeSets) {
        if (this.type == RequestType.CHANGE_SET_ONLY || this.type == RequestType.CHOICE) {
            this.changeSets.addAll(changeSets);
            this.resetCachedInfo();
        }
    }

    public void addBaselines(List<? extends IBaselineHandle> baselines) {
        if (this.type == RequestType.CHOICE) {
            this.baselines.addAll(baselines);
            this.resetCachedInfo();
        }
    }

    public void addNewComponent(String newComponentName) {
        this.newComponentNames.add(newComponentName);
    }

    public void addNewComponent(IComponentHandle component) {
        this.addComponents.put(component.getItemId(), component);
    }

    public void removeComponent(IComponentHandle component) {
        this.removeComponents.put(component.getItemId(), component);
    }

    public void updateSyncReport(IChangeHistorySyncReport compareReport) {
        this.syncReport = compareReport;
        this.resetCachedInfo();
    }

    public void setWorkspaceContext(boolean replace) {
        if (!replace && this.sourceWorkspace == null) {
            throw new IllegalArgumentException("Can only accept from workspaces");
        }
        this.type = replace ? RequestType.WORKSPACE_CONTEXT_REPLACE : RequestType.WORKSPACE_CONTEXT_ACCEPT;
        this.changeSets.clear();
        this.replaceComponents.clear();
        this.acceptComponents.clear();
        this.baselines.clear();
        this.resetCachedInfo();
    }

    public boolean isChangeSetContext() {
        return this.type == RequestType.CHANGE_SET_ONLY;
    }

    public List<IBaselineHandle> getBaselines(IProgressMonitor progress) throws TeamRepositoryException {
        this.decideChanges(progress);
        return Collections.unmodifiableList(this.allBaselines);
    }

    public List<IChangeSetHandle> getChangeSets(IProgressMonitor progress) throws TeamRepositoryException {
        this.decideChanges(progress);
        return Collections.unmodifiableList(this.allChangeSets);
    }

    public List<String> getNewComponentNames() {
        return Collections.unmodifiableList(this.newComponentNames);
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IWorkspaceConnection getSourceWorkspace() {
        return this.sourceWorkspace;
    }

    public ITeamRepository getSourceRepository() {
        return this.sourceRepository;
    }

    public IBaselineSetHandle getSourceSnapshot() {
        return this.sourceSnapshot;
    }

    public IBaselineConnection getSourceBaseline() {
        return this.sourceBaselineConnection;
    }

    public IChangeHistorySyncReport getSyncReport(IProgressMonitor progress) throws TeamRepositoryException {
        if (this.syncReport == null && this.sourceWorkspace != null) {
            this.recomputeSyncReport(progress);
        }
        return this.syncReport;
    }

    public Collection<IFlowNodeConnection.IComponentOp> getComponentOperations(IProgressMonitor progress) throws TeamRepositoryException {
        this.decideChanges(progress);
        return Collections.unmodifiableCollection(this.componentOperations.values());
    }

    public Collection<IFlowNodeConnection.IComponentReplacementOp> getReplaceCandidates(IProgressMonitor progress) throws TeamRepositoryException {
        this.decideChanges(progress);
        return Collections.unmodifiableCollection(this.replaceCandidates.values());
    }

    private Collection<IComponentHandle> getAffectedComponents(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>();
        if (this.type == RequestType.WORKSPACE_CONTEXT_ACCEPT || this.type == RequestType.WORKSPACE_CONTEXT_REPLACE) {
            if (this.sourceBaselineConnection == null) {
                for (IComponentHandle componentHandle : this.workspace.getComponents()) {
                    components.put(componentHandle.getItemId(), componentHandle);
                }
            } else {
                components.put(this.sourceBaselineConnection.getComponent().getItemId(), this.sourceBaselineConnection.getComponent());
            }
        }
        if (!this.changeSets.isEmpty()) {
            List fullChangeSets = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)monitor.newChild(50));
            for (IChangeSet changeSet : fullChangeSets) {
                components.put(changeSet.getComponent().getItemId(), changeSet.getComponent());
            }
        }
        if (!this.baselines.isEmpty()) {
            List fullBaselines = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)monitor.newChild(50));
            for (IBaseline baseline : fullBaselines) {
                components.put(baseline.getComponent().getItemId(), baseline.getComponent());
            }
        }
        for (IComponentHandle componentHandle : this.acceptComponents.values()) {
            components.put(componentHandle.getItemId(), componentHandle);
        }
        for (IComponentHandle componentHandle : this.replaceComponents.values()) {
            components.put(componentHandle.getItemId(), componentHandle);
        }
        return components.values();
    }

    public Collection<ConfigurationDescriptor> getAffectedConfigurations(IProgressMonitor progress) throws TeamRepositoryException {
        if (this.affectedConfigurations == null) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            this.decideChanges((IProgressMonitor)monitor.newChild(80));
            this.affectedConfigurations = new HashSet();
            if (!this.replaceCandidates.isEmpty()) {
                for (IFlowNodeConnection.IComponentReplacementOp iComponentReplacementOp : this.replaceCandidates.values()) {
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, iComponentReplacementOp.getComponent()));
                }
            }
            if (!this.componentOperations.isEmpty()) {
                for (IFlowNodeConnection.IComponentOp iComponentOp : this.componentOperations.values()) {
                    if (iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp) continue;
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, iComponentOp.getComponent()));
                }
            }
            if (!this.allChangeSets.isEmpty()) {
                List list = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.allChangeSets, 0, (IProgressMonitor)monitor.newChild(50));
                for (IChangeSet changeSet : list) {
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, changeSet.getComponent()));
                }
            }
            if (!this.allBaselines.isEmpty()) {
                List list = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.allBaselines, 0, (IProgressMonitor)monitor.newChild(50));
                for (IBaseline baseline : list) {
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, baseline.getComponent()));
                }
            }
        }
        return Collections.unmodifiableCollection(this.affectedConfigurations);
    }

    public void excludeComponentOps(List<IComponentHandle> componentsToExclude, IProgressMonitor progress) throws TeamRepositoryException {
        this.decideChanges(progress);
        for (IComponentHandle componentToExclude : componentsToExclude) {
            if (this.componentOperations.containsKey(componentToExclude.getItemId())) {
                this.componentOperations.remove(componentToExclude.getItemId());
            }
            if (!this.replaceCandidates.containsKey(componentToExclude.getItemId())) continue;
            this.replaceCandidates.remove(componentToExclude.getItemId());
            this.decideComponentChanges(componentToExclude);
        }
    }

    private void decideComponentChanges(IComponentHandle component) {
        if (this.allChangeSets == null) {
            this.allChangeSets = new ArrayList<IChangeSetHandle>();
        }
        if (this.allBaselines == null) {
            this.allBaselines = new ArrayList<IBaselineHandle>();
        }
        if (this.syncReport != null) {
            if ((this.syncReport.getFlags() & WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO) == WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO) {
                IBaselineHandle baseline = (IBaselineHandle)this.syncReport.remoteBases().get(component);
                for (IBaselineHandle incomingBaseline : this.syncReport.incomingBaselines(component)) {
                    if (!incomingBaseline.sameItemId((IItemHandle)baseline)) continue;
                    this.allBaselines.add(baseline);
                    break;
                }
                this.allChangeSets.addAll(this.syncReport.incomingChangeSetsAfterBasis(component));
            } else {
                this.allChangeSets.addAll(this.syncReport.incomingChangeSets(component));
            }
        }
    }

    public void decideChanges(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (this.componentOperations == null) {
            this.componentOperations = new HashMap<UUID, IFlowNodeConnection.IComponentOp>();
            this.replaceCandidates = new HashMap<UUID, IFlowNodeConnection.IComponentReplacementOp>();
            this.allBaselines = new ArrayList<IBaselineHandle>();
            this.allChangeSets = new ArrayList<IChangeSetHandle>();
            switch (this.type) {
                case CHOICE: {
                    IBaselineConnection baseline;
                    if (this.sourceWorkspace != null) {
                        List componentOps = FlowUtils.getAcceptComponentSynchronizationOps((boolean)false, this.getAffectedComponents((IProgressMonitor)monitor.newChild(10)), (IWorkspaceConnection)this.sourceWorkspace, (IWorkspaceConnection)this.workspace, (IChangeHistorySyncReport)this.getSyncReport((IProgressMonitor)monitor.newChild(90)));
                        for (IFlowNodeConnection.IComponentOp op : componentOps) {
                            this.componentOperations.put(op.getComponent().getItemId(), op);
                        }
                        componentOps = null;
                        for (IComponentHandle componentHandle : this.replaceComponents.values()) {
                            if (this.componentOperations.containsKey(componentHandle.getItemId())) continue;
                            this.componentOperations.put(componentHandle.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().replaceComponent(componentHandle, (IConnection)this.sourceWorkspace, true));
                        }
                        this.decideComponentChanges(this.acceptComponents.values());
                        this.decideIndividualChanges((IProgressMonitor)monitor.newChild(1));
                        break;
                    }
                    if (this.sourceSnapshot == null) break;
                    IBaselineSet snapShot = (IBaselineSet)this.workspace.teamRepository().itemManager().fetchCompleteItem((IItemHandle)this.sourceSnapshot, 0, (IProgressMonitor)monitor.newChild(10));
                    IWorkspaceManager wsm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspace.teamRepository());
                    List baselines = this.workspace.teamRepository().itemManager().fetchCompleteItems(snapShot.getBaselines(), 0, (IProgressMonitor)monitor.newChild(10));
                    HashMap remoteBaselines = new HashMap();
                    monitor.setWorkRemaining(10 * this.replaceComponents.size());
                    for (IComponentHandle componentHandle : this.replaceComponents.values()) {
                        baseline = null;
                        Iterator iterator = baselines.iterator();
                        while (iterator.hasNext()) {
                            IBaseline baselineInSnapshot = (IBaseline)iterator.next();
                            if (baselineInSnapshot == null || !componentHandle.sameItemId((IItemHandle)baselineInSnapshot.getComponent())) continue;
                            baseline = wsm.getBaselineConnection(baselineInSnapshot, (IProgressMonitor)monitor.newChild(10));
                            break;
                        }
                        if (baseline == null) {
                            throw new TeamRepositoryException(Messages.WorkspaceUpdateRequest_1);
                        }
                        remoteBaselines.put(componentHandle.getItemId(), baseline);
                    }
                    for (IComponentHandle componentHandle : this.workspace.getComponents()) {
                        baseline = (IBaselineConnection)remoteBaselines.remove(componentHandle.getItemId());
                        if (baseline == null) continue;
                        this.componentOperations.put(componentHandle.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().replaceComponent(componentHandle, (IConnection)baseline, true));
                    }
                    for (IBaselineHandle baseline2 : remoteBaselines.values()) {
                        this.componentOperations.put(baseline2.getComponent().getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().addComponent(baseline2.getComponent(), (IConnection)baseline2, false));
                    }
                    break;
                }
                case WORKSPACE_CONTEXT_ACCEPT: {
                    List componentOps = FlowUtils.getAcceptComponentSynchronizationOps((boolean)true, (Collection)this.workspace.getComponents(), (IWorkspaceConnection)this.sourceWorkspace, (IWorkspaceConnection)this.workspace, (IChangeHistorySyncReport)this.getSyncReport((IProgressMonitor)monitor.newChild(90)));
                    for (IFlowNodeConnection.IComponentOp op : componentOps) {
                        this.componentOperations.put(op.getComponent().getItemId(), op);
                    }
                    componentOps = null;
                    this.decideComponentChanges(this.workspace.getComponents());
                    break;
                }
                case WORKSPACE_CONTEXT_REPLACE: {
                    if (this.sourceWorkspace != null) {
                        IChangeHistorySyncReport synchronizationReport = this.getSyncReport((IProgressMonitor)monitor.newChild(10));
                        HashMap<UUID, IComponentHandle> remoteComponents = new HashMap<UUID, IComponentHandle>();
                        for (IComponentHandle component : synchronizationReport.remoteComponents()) {
                            remoteComponents.put(component.getItemId(), component);
                        }
                        for (IComponentHandle component : synchronizationReport.localComponents()) {
                            if (remoteComponents.remove(component.getItemId()) != null) {
                                if (synchronizationReport.incomingChangeSets(component).isEmpty() && synchronizationReport.outgoingChangeSets(component).isEmpty() && synchronizationReport.incomingBaselines(component).isEmpty() && synchronizationReport.outgoingBaselines(component).isEmpty()) continue;
                                this.componentOperations.put(component.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().replaceComponent(component, (IConnection)this.sourceWorkspace, true));
                                continue;
                            }
                            this.componentOperations.put(component.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().removeComponent(component, false));
                        }
                        for (IComponentHandle component : remoteComponents.values()) {
                            this.componentOperations.put(component.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().addComponent(component, (IConnection)this.sourceWorkspace, false));
                        }
                        break;
                    }
                    if (this.sourceSnapshot != null) {
                        IBaselineSet baselineSet = (IBaselineSet)this.workspace.teamRepository().itemManager().fetchCompleteItem((IItemHandle)this.sourceSnapshot, 0, (IProgressMonitor)monitor.newChild(10));
                        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspace.teamRepository());
                        SubMonitor iterMonitor = monitor.newChild(10).setWorkRemaining(baselineSet.getBaselines().size());
                        HashMap<UUID, IBaselineConnection> remoteComponents = new HashMap<UUID, IBaselineConnection>();
                        for (IBaselineHandle baseline2 : baselineSet.getBaselines()) {
                            IBaselineConnection baselineConnection = workspaceManager.getBaselineConnection(baseline2, (IProgressMonitor)iterMonitor.newChild(1));
                            remoteComponents.put(baselineConnection.getComponent().getItemId(), baselineConnection);
                        }
                        for (IComponentHandle component : this.workspace.getComponents()) {
                            IBaselineConnection connection = (IBaselineConnection)remoteComponents.remove(component.getItemId());
                            if (connection != null) {
                                this.componentOperations.put(component.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().replaceComponent(component, (IConnection)connection, true));
                                continue;
                            }
                            this.componentOperations.put(component.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().removeComponent(component, false));
                        }
                        for (IBaselineConnection connection : remoteComponents.values()) {
                            this.componentOperations.put(connection.getComponent().getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().addComponent(connection.getComponent(), (IConnection)connection, false));
                        }
                        break;
                    }
                    if (this.sourceBaselineConnection == null) break;
                    boolean found = false;
                    for (IComponentHandle component : this.workspace.getComponents()) {
                        if (!component.sameItemId((IItemHandle)this.sourceBaselineConnection.getComponent())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.componentOperations.put(this.sourceBaselineConnection.getComponent().getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().addComponent(this.sourceBaselineConnection.getComponent(), (IConnection)this.sourceBaselineConnection, false));
                        break;
                    }
                    this.componentOperations.put(this.sourceBaselineConnection.getComponent().getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().replaceComponent(this.sourceBaselineConnection.getComponent(), (IConnection)this.sourceBaselineConnection, true));
                    break;
                }
                case CHANGE_SET_ONLY: {
                    this.allChangeSets = new ArrayList<IChangeSetHandle>();
                    this.allChangeSets.addAll(this.changeSets);
                }
            }
            for (IComponentHandle componentHandle : this.addComponents.values()) {
                this.componentOperations.put(componentHandle.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().addComponent(componentHandle, false));
            }
            for (IComponentHandle componentHandle : this.removeComponents.values()) {
                this.componentOperations.put(componentHandle.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().removeComponent(componentHandle, false));
            }
        }
    }

    private void decideIndividualChanges(IProgressMonitor progress) throws TeamRepositoryException {
        UUID key;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (this.allChangeSets == null) {
            this.allChangeSets = new ArrayList<IChangeSetHandle>();
        }
        if (this.allBaselines == null) {
            this.allBaselines = new ArrayList<IBaselineHandle>();
        }
        if (!this.baselines.isEmpty()) {
            List completeBaselines = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)monitor.newChild(10));
            for (IBaseline baseline : completeBaselines) {
                key = baseline.getComponent().getItemId();
                if (this.componentOperations.containsKey(key) || this.replaceCandidates.containsKey(key) || this.acceptComponents.containsKey(key)) continue;
                this.allBaselines.add((IBaselineHandle)baseline);
            }
        }
        if (!this.changeSets.isEmpty()) {
            List completeChangeSets = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)monitor.newChild(10));
            for (IChangeSet changeSet : completeChangeSets) {
                key = changeSet.getComponent().getItemId();
                if (this.componentOperations.containsKey(key) || this.replaceCandidates.containsKey(key) || this.acceptComponents.containsKey(key)) continue;
                this.allChangeSets.add((IChangeSetHandle)changeSet);
            }
        }
    }

    private void decideComponentChanges(Collection<IComponentHandle> componentsToConsider) {
        HashSet<UUID> replacedComponents = new HashSet<UUID>();
        if (this.syncReport != null && !this.syncReport.getReplacedComponents().isEmpty() && this.sourceWorkspace != null) {
            for (IComponentHandle componentHandle : this.syncReport.getReplacedComponents()) {
                if (this.syncReport.outgoingChangeSets(componentHandle).isEmpty()) continue;
                replacedComponents.add(componentHandle.getItemId());
            }
        }
        this.replaceCandidates = new HashMap<UUID, IFlowNodeConnection.IComponentReplacementOp>();
        for (IComponentHandle componentHandle : componentsToConsider) {
            if (replacedComponents.contains(componentHandle.getItemId())) {
                this.replaceCandidates.put(componentHandle.getItemId(), this.workspace.componentOpFactory().replaceComponent(componentHandle, (IConnection)this.sourceWorkspace, true));
                continue;
            }
            if (this.componentOperations.containsKey(componentHandle.getItemId())) continue;
            this.decideComponentChanges(componentHandle);
        }
    }

    public void recomputeSyncReport(IProgressMonitor progress) throws TeamRepositoryException {
        if (this.sourceWorkspace == null) {
            throw new IllegalStateException("Can only obtain sync reports for workspaces");
        }
        int flags = WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY;
        if (this.syncReport != null) {
            flags = this.syncReport.getFlags();
        }
        this.syncReport = this.workspace.compareTo((IFlowNodeConnection)this.sourceWorkspace, flags, Collections.EMPTY_LIST, progress);
    }

    private void resetCachedInfo() {
        this.componentOperations = null;
        this.replaceCandidates = null;
        this.affectedConfigurations = null;
        this.allBaselines = null;
        this.allChangeSets = null;
    }

    public void createNewComponents(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor iterMonitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.newComponentNames.size());
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspace.teamRepository());
        Object owner = this.workspace.isStream() ? this.workspace.getOwner() : RepositoryUtils.getLoggedInContributor(this.workspace.teamRepository());
        Iterator<String> iNames = this.newComponentNames.iterator();
        while (iNames.hasNext()) {
            String name = iNames.next();
            IComponent component = wm.createComponent(name, owner, (IProgressMonitor)iterMonitor);
            this.addComponents.put(component.getItemId(), (IComponentHandle)component);
            this.componentOperations.put(component.getItemId(), (IFlowNodeConnection.IComponentOp)this.workspace.componentOpFactory().addComponent((IComponentHandle)component, false));
            iNames.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestType {
        CHANGE_SET_ONLY,
        WORKSPACE_CONTEXT_ACCEPT,
        WORKSPACE_CONTEXT_REPLACE,
        CHOICE;

    }
}

