/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumeOperation
extends ChangeHistoryChangeSetsOperation
implements IResumeOperation {
    private final Map<IWorkspaceConnection, List<IChangeSetHandle>> resumeRequests;
    private final ResumeDilemmaHandler problemHandler;

    public ResumeOperation(ResumeDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? ResumeDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? ResumeDilemmaHandler.getDefault() : dilemmaHandler;
        this.resumeRequests = new HashMap<IWorkspaceConnection, List<IChangeSetHandle>>();
    }

    @Override
    public void resume(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changesToResume) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changesToResume == null) {
            throw new IllegalArgumentException();
        }
        List<IChangeSetHandle> toResume = this.resumeRequests.get(workspace);
        if (toResume == null) {
            toResume = new ArrayList<IChangeSetHandle>();
            this.resumeRequests.put(workspace, toResume);
        }
        toResume.addAll(changesToResume);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ResumeOperation_ProgressMessage, (int)100);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        final Set<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(4));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResumeOperation.this.resume(affectedConfigurations, monitor);
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.ResumeOperation_0, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private void resume(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(43 + 100 * this.resumeRequests.size()));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            SubMonitor iterProgress = progress.newChild(1);
            iterProgress.setWorkRemaining(affectedConfigurations.size());
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify(configurationDescriptor.getConnection((IProgressMonitor)iterProgress.newChild(1)), configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(20));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
        try {
            this.checkinPendingChanges(affectedConfigurations, this.problemHandler, true, (IProgressMonitor)progress.newChild(20));
            for (Map.Entry entry : this.resumeRequests.entrySet()) {
                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)entry.getKey();
                List changeSetHandles = (List)entry.getValue();
                Map<IComponentHandle, IChangeSetHandle> changeSetsToMakeCurrent = ResumeOperation.shouldMakeResumedCurrent(workspaceConnection, changeSetHandles, (IProgressMonitor)progress.newChild(5));
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IUpdateReport report = workspaceConnection.resume(0, changeSetHandles, (IProgressMonitor)progress.newChild(45));
                UpdateOperation updateOp = new UpdateOperation(workspaceConnection, Collections.singletonList(report), 3, this.problemHandler, null);
                this.disableVerifyInSync(updateOp);
                updateOp.run((IProgressMonitor)progress.newChild(45));
                SubMonitor iterMonitor = progress.newChild(5);
                iterMonitor.setWorkRemaining(changeSetsToMakeCurrent.size());
                for (IChangeSetHandle toMakeCurrent : changeSetsToMakeCurrent.values()) {
                    workspaceConnection.setCurrentChangeSet(toMakeCurrent, (IProgressMonitor)iterMonitor.newChild(1));
                }
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
        }
    }

    public static Map<IComponentHandle, IChangeSetHandle> shouldMakeResumedCurrent(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, ArrayList<IChangeSet>> groupedByComponent = new HashMap<UUID, ArrayList<IChangeSet>>();
        HashMap<IComponentHandle, IChangeSetHandle> changeSetsToMakeCurrent = new HashMap<IComponentHandle, IChangeSetHandle>();
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
        for (IChangeSet changeSet : changeSets) {
            if (!changeSet.isActive()) continue;
            IComponentHandle component = changeSet.getComponent();
            ArrayList<IChangeSet> gCsets = (ArrayList<IChangeSet>)groupedByComponent.get(component.getItemId());
            if (gCsets == null) {
                gCsets = new ArrayList<IChangeSet>();
                groupedByComponent.put(component.getItemId(), gCsets);
            }
            gCsets.add(changeSet);
        }
        for (UUID componentUUID : groupedByComponent.keySet()) {
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null);
            IChangeSetHandle currentChangeSetHandle = workspaceConnection.getCurrentChangeSet(componentHandle);
            List changeSetsInComponent = (List)groupedByComponent.get(componentUUID);
            if (currentChangeSetHandle != null || changeSetsInComponent.size() != 1) continue;
            changeSetsToMakeCurrent.put(componentHandle, (IChangeSetHandle)changeSetsInComponent.get(0));
        }
        return changeSetsToMakeCurrent;
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry<IWorkspaceConnection, List<IChangeSetHandle>> entry : this.resumeRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IChangeSetHandle> changeSetHandles = entry.getValue();
            List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
            determinants.addAll(changeSets);
            for (IChangeSet changeSet : changeSets) {
                affectedConfigurations.add(new ConfigurationDescriptor((IConnection)workspaceConnection, changeSet.getComponent()));
            }
        }
        return affectedConfigurations;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        for (Map.Entry<IWorkspaceConnection, List<IChangeSetHandle>> entry : this.resumeRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IChangeSetHandle> changeSetHandles = entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForAddition(refresher, affectedAreas, workspaceConnection, changeSetHandles, progress);
        }
    }
}

