/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkAsMergedOperation
extends ResolveConflictsOperation
implements ICheckinOptions {
    private final MarkAsMergedDilemmaHandler problemHandler;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    public MarkAsMergedOperation(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, Collection<? extends ILogicalChange> changes, MarkAsMergedDilemmaHandler dilemmaHandler) throws FileSystemClientException {
        super(connection, conflictReport, changes, dilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (this.changes.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ILogicalChange> missingChanges = this.getRequiredChanges();
        if (missingChanges.size() > 0) {
            switch (this.problemHandler.missingRequiredChanges(missingChanges)) {
                case 2: {
                    throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.MarkAsMergedOperation_0, (Object)missingChanges.size())));
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 0: {
                    this.changes.addAll(missingChanges);
                }
            }
        }
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        final HashSet<ConfigurationDescriptor> configurationsToLock = new HashSet<ConfigurationDescriptor>();
        for (ILogicalChange change : this.changes) {
            verifyOp.addToVerify((IConnection)this.connection, change.component());
            configurationsToLock.add(new ConfigurationDescriptor((IConnection)this.connection, change.component()));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurationsToLock, (IProgressMonitor)progress.newChild(1));
        try {
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                verifyOp.run((IProgressMonitor)progress.newChild(5));
            }
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(configurationsToLock, true);
                    try {
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            MarkAsMergedOperation.this.doMarkAsMerged(configurationsToLock, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.MarkAsMergedOperation_3, (IProgressMonitor)progress);
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void doMarkAsMerged(HashSet<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        List updateReports;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> organizedChanges = this.organizeChanges();
        Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas = this.getCopyFileAreasAffected(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        this.checkinPendingChanges(organizedChanges, affectedAreas, this.problemHandler, (IProgressMonitor)progress.newChild(24));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.verifyChangesMerged(organizedChanges, affectedAreas, this.problemHandler, (IProgressMonitor)progress.newChild(5));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.confirmMarkAsMerged(this.problemHandler);
        FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
        try {
            updateReports = fileSystemService.markAsMerged(this.connection, this.changes, (IProgressMonitor)progress.newChild(25));
        }
        catch (TeamRepositoryException e) {
            if (e.getData() instanceof ConflictResolutionReport) {
                this.collectStatus(new FileSystemStatus(4, e.getMessage()));
                if (e.getCause() != null) {
                    this.collectStatus(new FileSystemStatus(4, e.getCause().getMessage()));
                }
                this.updateCopyFileArea((ConflictResolutionReport)e.getData(), (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)progress.newChild(45));
            }
            throw e;
        }
        if (!updateReports.isEmpty()) {
            this.updateCopyFileArea(updateReports, (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)progress.newChild(45));
        }
    }

    private void confirmMarkAsMerged(MarkAsMergedDilemmaHandler ignoreSyncs) throws FileSystemClientException {
        int result = ignoreSyncs.confirmMarkAsMerged(this.changes);
        if (result == 1) {
            throw new OperationCanceledException();
        }
    }

    private Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> organizeChanges() {
        HashMap<ConfigurationDescriptor, Map<UUID, ILogicalChange>> result = new HashMap<ConfigurationDescriptor, Map<UUID, ILogicalChange>>();
        for (ILogicalChange change : this.changes) {
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor((IConnection)this.connection, change.component());
            HashMap<UUID, ILogicalChange> logicalChangesByVersionable = (HashMap<UUID, ILogicalChange>)result.get(descriptor);
            if (logicalChangesByVersionable == null) {
                logicalChangesByVersionable = new HashMap<UUID, ILogicalChange>();
                result.put(descriptor, logicalChangesByVersionable);
            }
            logicalChangesByVersionable.put(change.item().getItemId(), change);
        }
        return result;
    }

    protected void verifyChangesMerged(Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> organizedChanges, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, MarkAsMergedDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        int result;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<ILogicalChange> unmergedChanges = new ArrayList<ILogicalChange>();
        IUpdateReport conflictReport = this.connection.conflictReport();
        for (IItemConflictReport conflict : conflictReport.conflicts()) {
            ILogicalChange change;
            ConfigurationDescriptor descriptor;
            Map<UUID, ILogicalChange> changesToMarkAsMerged;
            boolean wasMerged = false;
            IVersionableHandle selectedContributorState = conflict.getSelectedContributorState();
            IVersionableHandle proposedContributorState = conflict.getProposedContributorState();
            IVersionableHandle originalSelectedContributorState = conflict.getOriginalSelectedContributorState();
            if (selectedContributorState == null && originalSelectedContributorState != null) {
                wasMerged = true;
            } else if (selectedContributorState != null && originalSelectedContributorState == null) {
                wasMerged = true;
            } else if (selectedContributorState == null && originalSelectedContributorState == null) {
                if (proposedContributorState == null) {
                    wasMerged = true;
                }
            } else if (!selectedContributorState.sameStateId((IItemHandle)originalSelectedContributorState)) {
                wasMerged = true;
            }
            if (wasMerged || (changesToMarkAsMerged = organizedChanges.get(descriptor = new ConfigurationDescriptor((IConnection)this.connection, conflict.getComponent()))) == null || !changesToMarkAsMerged.containsKey(conflict.item().getItemId()) || this.isEvilTwin(conflict, change = changesToMarkAsMerged.get(conflict.item().getItemId()), descriptor, affectedAreas, (IProgressMonitor)monitor)) continue;
            unmergedChanges.add(change);
        }
        if (!unmergedChanges.isEmpty() && (result = problemHandler.unmergedChanges(unmergedChanges)) != 0) {
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemClientException(new FileSystemStatus(4, Messages.MarkAsMergedOperation_2));
        }
    }

    private boolean isEvilTwin(IItemConflictReport conflict, ILogicalChange change, ConfigurationDescriptor descriptor, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IProgressMonitor monitor) throws FileSystemClientException {
        boolean evilTwin = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationDescriptor>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<ConfigurationDescriptor> configurationsLoaded = entry.getValue();
            if (!configurationsLoaded.contains(descriptor) || !(evilTwin |= this.isEvilTwin(sandbox, conflict, change, (IProgressMonitor)progress.newChild(1)))) continue;
            return evilTwin;
        }
        return false;
    }

    private boolean isEvilTwin(ISandbox sandbox, IItemConflictReport conflict, ILogicalChange change, IProgressMonitor progress) throws FileSystemClientException {
        Shareable shareable;
        ResourceType type;
        IPath fullName;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        IVersionableHandle selectedContributorState = conflict.getSelectedContributorState();
        IVersionableHandle proposedContributorState = conflict.getProposedContributorState();
        IVersionableHandle originalSelectedContributorState = conflict.getOriginalSelectedContributorState();
        return selectedContributorState == null && originalSelectedContributorState == null && proposedContributorState != null && (fullName = sandbox.getPathRelativeToShares(this.connection.getContextHandle(), conflict.getComponent(), Collections.singletonList(change.getAncestorPathHint()), (IProgressMonitor)monitor.newChild(1)).get(0)) != null && (type = (shareable = (Shareable)sandbox.findShareable(fullName, ResourceType.getResourceType(conflict.item()))).getResourceType((IProgressMonitor)monitor.newChild(1))) != null && type == ResourceType.getResourceType(conflict.item());
    }

    private void checkinPendingChanges(Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> changes, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, MarkAsMergedDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        ArrayList<ILocalChange> pendingChanges = new ArrayList<ILocalChange>();
        HashMap<UUID, ArrayList<ILocalChange>> checkin = new HashMap<UUID, ArrayList<ILocalChange>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        SubMonitor iterMon = monitor.newChild(2).setWorkRemaining(affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationDescriptor>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<ConfigurationDescriptor> configurationsForCFA = entry.getValue();
            SubMonitor subIterMon = iterMon.newChild(1).setWorkRemaining(configurationsForCFA.size());
            for (ConfigurationDescriptor descriptor : configurationsForCFA) {
                ILocalChange[] localChanges;
                Map<UUID, ILogicalChange> toMarkAsMerged = changes.get(descriptor);
                ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                lcm.syncPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox, (IProgressMonitor)subIterMon.newChild(1));
                ILocalChange[] iLocalChangeArray = localChanges = lcm.getPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox);
                int n = localChanges.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalChange localChange = iLocalChangeArray[n2];
                    if (toMarkAsMerged.containsKey(localChange.getTarget().getItemId())) {
                        pendingChanges.add(localChange);
                        ArrayList<ILocalChange> changesToCheckin = (ArrayList<ILocalChange>)checkin.get(localChange.getComponent().getItemId());
                        if (changesToCheckin == null) {
                            changesToCheckin = new ArrayList<ILocalChange>();
                            checkin.put(localChange.getComponent().getItemId(), changesToCheckin);
                        }
                        changesToCheckin.add(localChange);
                    }
                    ++n2;
                }
            }
        }
        if (!pendingChanges.isEmpty()) {
            int result = problemHandler.uncheckedInChanges(pendingChanges);
            if (result == 0) {
                ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(problemHandler);
                if (this.nonAtomicCommitIsAnOption) {
                    op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    op.disableNonAtomicCommit();
                }
                iterMon = monitor.newChild(8);
                iterMon.setWorkRemaining(checkin.size());
                for (Map.Entry entry : checkin.entrySet()) {
                    Collection changesToCheckin = (Collection)entry.getValue();
                    if (changesToCheckin.isEmpty()) continue;
                    IComponentHandle component = ((ILocalChange)changesToCheckin.iterator().next()).getComponent();
                    op.requestCheckin(this.connection, component, changesToCheckin.toArray(new ILocalChange[changesToCheckin.size()]), null, Messages.MarkAsMergedOperation_ChangeSetDefaultComment, (IProgressMonitor)iterMon.newChild(1));
                }
                this.disableVerifyInSync(op);
                op.run((IProgressMonitor)monitor.newChild(90));
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                throw new FileSystemClientException(new FileSystemStatus(4, Messages.MarkAsMergedOperation_1));
            }
        }
        monitor.done();
    }

    protected final Map<ISandbox, Set<ConfigurationDescriptor>> getCopyFileAreasAffected(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws FileSystemClientException {
        HashMap<ISandbox, Set<ConfigurationDescriptor>> result = new HashMap<ISandbox, Set<ConfigurationDescriptor>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationDescriptor configuration : affectedConfigurations) {
            Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
            for (ICopyFileArea cfa : copyFileAreas) {
                Sandbox sandbox = new Sandbox(cfa);
                HashSet<ConfigurationDescriptor> configurations = (HashSet<ConfigurationDescriptor>)result.get(sandbox);
                if (configurations == null) {
                    configurations = new HashSet<ConfigurationDescriptor>();
                    result.put(sandbox, configurations);
                }
                configurations.add(configuration);
            }
        }
        return result;
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }
}

