/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Collision;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.InvalidLoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadOverlap;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.load.RemovedShare;
import com.ibm.team.filesystem.client.internal.load.ShareableToLoad;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.InvalidLoadRequest;
import com.ibm.team.filesystem.client.internal.operations.LoadRequest;
import com.ibm.team.filesystem.client.internal.operations.MultipleSandboxLoad;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadOperation
extends FileSystemOperation
implements ILoadOperation {
    private final LoadDilemmaHandler dilemmaHandler;
    private HashMap<ISandbox, HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>>> requestsByCFA;
    private HashSet<ISandbox> copyFileAreasAffected;
    private ISynchronizationInfo synchronizationInfo;
    private HashSet<IRemovedShare> sharesToRemove = new HashSet();
    private HashMap<ILoadRequest, IInvalidLoadLocation> invalidLoadLocations = new HashMap();
    private HashMap<IPath, LoadLocation> treesToLoad;
    private HashMap<IPath, ICollision> collisions;
    private HashMap<IPath, IShareableToLoad> newItems;
    private ArrayList<ILoadOverlap> loadOverLaps;
    private ArrayList<IShareOutOfSync> sharesOutOfSync;
    private ArrayList<IInvalidLoadRequest> invalidLoadRequests;
    private int options;
    private IDownloadListener downloadMonitor;

    public LoadOperation(LoadDilemmaHandler problemHandler) {
        super(problemHandler == null ? LoadDilemmaHandler.getDefault() : problemHandler);
        this.dilemmaHandler = problemHandler == null ? LoadDilemmaHandler.getDefault() : problemHandler;
        this.requestsByCFA = new HashMap();
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashSet();
        this.invalidLoadLocations = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.copyFileAreasAffected = new HashSet();
        this.options = 0;
    }

    @Override
    public void requestLoad(ISandbox sandbox, IPath relativeLoadPath, IWorkspaceConnection workspaceConnection, IComponentHandle component, Collection<? extends IVersionableHandle> itemsToLoad) {
        this.validateRequestToLoad(sandbox, relativeLoadPath, (IConnection)workspaceConnection, component, itemsToLoad);
        this.recordRequestToLoad(sandbox, relativeLoadPath, (IConnection)workspaceConnection, component, itemsToLoad);
    }

    @Override
    public void requestLoad(ISandbox sandbox, IPath relativeLoadPath, IBaselineConnection baselineConnection, Collection<? extends IVersionableHandle> itemsToLoad) {
        if (baselineConnection == null) {
            throw new IllegalArgumentException();
        }
        this.validateRequestToLoad(sandbox, relativeLoadPath, (IConnection)baselineConnection, baselineConnection.getComponent(), itemsToLoad);
        this.recordRequestToLoad(sandbox, relativeLoadPath, (IConnection)baselineConnection, baselineConnection.getComponent(), itemsToLoad);
    }

    @Override
    public void requestLoad(ISandbox sandbox, IPath relativeLoadPath, Collection<ILoadRule> loadRules, IProgressMonitor progress) throws TeamRepositoryException {
        if (loadRules == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)loadRules.size());
        for (ILoadRule loadRule : loadRules) {
            this.recordRequestToLoad(sandbox, relativeLoadPath, (IConnection)loadRule.getWorkspaceConnection(), loadRule.getComponent(), loadRule.getItemsToLoad((IProgressMonitor)monitor.newChild(1)));
        }
    }

    private void validateRequestToLoad(ISandbox sandbox, IPath relativeLoadPath, IConnection connection, IComponentHandle component, Collection<? extends IVersionableHandle> itemsToLoad) {
        if (sandbox == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (itemsToLoad == null) {
            throw new IllegalArgumentException();
        }
        for (IVersionableHandle iVersionableHandle : itemsToLoad) {
            if (iVersionableHandle != null) continue;
            throw new IllegalArgumentException();
        }
    }

    private void recordRequestToLoad(ISandbox sandbox, IPath relativeLoadPath, IConnection connection, IComponentHandle component, Collection<? extends IVersionableHandle> itemsToLoad) {
        ConfigurationDescriptor descriptor = new ConfigurationDescriptor(connection, component);
        if (!itemsToLoad.isEmpty()) {
            Set<LoadRequest> requests;
            HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig;
            HashMap<Object, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(sandbox);
            if (requestsByConnection == null) {
                requestsByConnection = new HashMap();
                this.requestsByCFA.put(sandbox, requestsByConnection);
            }
            if ((requestsByConfig = requestsByConnection.get(connection)) == null) {
                requestsByConfig = new HashMap();
                requestsByConnection.put(connection, requestsByConfig);
            }
            if ((requests = requestsByConfig.get(descriptor)) == null) {
                requests = new HashSet<LoadRequest>();
                requestsByConfig.put(descriptor, requests);
            }
            for (IVersionableHandle iVersionableHandle : itemsToLoad) {
                LoadRequest request = new LoadRequest(sandbox, relativeLoadPath, "", connection, component, iVersionableHandle, false);
                requests.add(request);
            }
        }
    }

    @Override
    public void requestReLoad(Collection<IShare> sharesToReload, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)sharesToReload.size());
        if (sharesToReload == null || sharesToReload.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (IShare share : sharesToReload) {
            if (share != null) continue;
            throw new IllegalArgumentException();
        }
        for (IShare share : sharesToReload) {
            Set<LoadRequest> requests;
            HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig;
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
            IConnection connection = configurationDescriptor.getConnection((IProgressMonitor)monitor.newChild(1));
            HashMap<Object, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(share.getSandbox());
            if (requestsByConnection == null) {
                requestsByConnection = new HashMap();
                this.requestsByCFA.put(share.getSandbox(), requestsByConnection);
            }
            if ((requestsByConfig = requestsByConnection.get(connection)) == null) {
                requestsByConfig = new HashMap();
                requestsByConnection.put(connection, requestsByConfig);
            }
            if ((requests = requestsByConfig.get(configurationDescriptor)) == null) {
                requests = new HashSet<LoadRequest>();
                requestsByConfig.put(configurationDescriptor, requests);
            }
            IPath localCopyFileAreaPath = share.getPath().removeLastSegments(1);
            String alternativeName = share.getPath().lastSegment();
            requests.add(new LoadRequest(share.getSandbox(), localCopyFileAreaPath, alternativeName, connection, sharingDescriptor.getComponent(), sharingDescriptor.getRootVersionable(), true));
        }
    }

    @Override
    public void requestLoadAs(ISandbox sandbox, IPath relativeLoadPath, String alternativeName, IBaselineConnection baselineConnection, IVersionableHandle itemToLoad) {
        ConfigurationDescriptor descriptor;
        Set<LoadRequest> requests;
        HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig;
        if (baselineConnection == null) {
            throw new IllegalArgumentException();
        }
        this.validateRequestToLoad(sandbox, relativeLoadPath, (IConnection)baselineConnection, baselineConnection.getComponent(), Collections.singletonList(itemToLoad));
        HashMap<Object, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(sandbox);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.requestsByCFA.put(sandbox, requestsByConnection);
        }
        if ((requestsByConfig = requestsByConnection.get(baselineConnection)) == null) {
            requestsByConfig = new HashMap();
            requestsByConnection.put((IConnection)baselineConnection, requestsByConfig);
        }
        if ((requests = requestsByConfig.get(descriptor = new ConfigurationDescriptor(baselineConnection))) == null) {
            requests = new HashSet<LoadRequest>();
            requestsByConfig.put(descriptor, requests);
        }
        LoadRequest request = new LoadRequest(sandbox, relativeLoadPath, alternativeName, (IConnection)baselineConnection, baselineConnection.getComponent(), itemToLoad, false);
        requests.add(request);
    }

    @Override
    public void requestLoadAs(ISandbox sandbox, IPath relativeLoadPath, String alternativeName, IWorkspaceConnection workspaceConnection, IComponentHandle component, IVersionableHandle itemToLoad) {
        ConfigurationDescriptor descriptor;
        Set<LoadRequest> requests;
        HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig;
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        this.validateRequestToLoad(sandbox, relativeLoadPath, (IConnection)workspaceConnection, component, Collections.singletonList(itemToLoad));
        HashMap<Object, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(sandbox);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.requestsByCFA.put(sandbox, requestsByConnection);
        }
        if ((requestsByConfig = requestsByConnection.get(workspaceConnection)) == null) {
            requestsByConfig = new HashMap();
            requestsByConnection.put((IConnection)workspaceConnection, requestsByConfig);
        }
        if ((requests = requestsByConfig.get(descriptor = new ConfigurationDescriptor((IConnection)workspaceConnection, component))) == null) {
            requests = new HashSet<LoadRequest>();
            requestsByConfig.put(descriptor, requests);
        }
        LoadRequest request = new LoadRequest(sandbox, relativeLoadPath, alternativeName, (IConnection)workspaceConnection, component, itemToLoad, false);
        requests.add(request);
    }

    @Override
    public Collection<ILoadRequest> getLoadRequests() {
        ArrayList<LoadRequest> allRequests = new ArrayList<LoadRequest>();
        for (HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection : this.requestsByCFA.values()) {
            for (HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig : requestsByConnection.values()) {
                for (Set<LoadRequest> requests : requestsByConfig.values()) {
                    allRequests.addAll(requests);
                }
            }
        }
        return Collections.unmodifiableCollection(allRequests);
    }

    @Override
    public Collection<ILoadOverlap> getLoadOverlaps() {
        return Collections.unmodifiableCollection(this.loadOverLaps);
    }

    @Override
    public Collection<IInvalidLoadRequest> getInvalidLoadRequests() {
        return Collections.unmodifiableCollection(this.invalidLoadRequests);
    }

    @Override
    public Collection<IMultipleSandboxLoad> getMultipleSandboxLoads(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Set<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations();
        Map<ConfigurationDescriptor, Set<ISandbox>> configurationSandboxes = this.getConfigurationSandboxes(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
        return this.validateMultipleCopyFileAreas(configurationSandboxes, true, (IProgressMonitor)monitor.newChild(90));
    }

    @Override
    public void evaluateLoadRequests(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * this.requestsByCFA.size()));
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashSet();
        this.invalidLoadLocations = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        HashMap<IShare, IConnection> sharesToVerifyInSync = new HashMap<IShare, IConnection>();
        HashSet<ISandbox> allCopyFileAreas = new HashSet<ISandbox>();
        allCopyFileAreas.addAll(SharingManager.getInstance().getRegisteredSandboxes());
        for (Map.Entry<ISandbox, HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>>> entry : this.requestsByCFA.entrySet()) {
            if (!this.validateCopyFileAreas(entry.getKey(), entry.getValue(), allCopyFileAreas)) continue;
            this.getElementsToLoad(entry.getKey(), entry.getValue(), sharesToVerifyInSync, (IProgressMonitor)monitor.newChild(90));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!sharesToVerifyInSync.isEmpty()) {
            OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = new OutOfSyncDilemmaHandler(){

                @Override
                public int outOfSync(Collection<IShareOutOfSync> shares) {
                    LoadOperation.this.sharesOutOfSync.addAll(shares);
                    return 0;
                }
            };
            VerifySharesOperation verifyInSyncOp = new VerifySharesOperation(outOfSyncDilemmaHandler);
            for (Map.Entry entry : sharesToVerifyInSync.entrySet()) {
                verifyInSyncOp.addToVerify((IConnection)entry.getValue(), (IShare)entry.getKey());
            }
            verifyInSyncOp.run((IProgressMonitor)monitor.newChild(10));
        }
        monitor.done();
    }

    private Collection<IMultipleSandboxLoad> validateMultipleCopyFileAreas(Map<ConfigurationDescriptor, Set<ISandbox>> configurationSandboxes, boolean includeCollisions, IProgressMonitor monitor) throws FileSystemClientException {
        HashMap<ConfigurationDescriptor, Set<ISandbox>> multipleCFA = new HashMap<ConfigurationDescriptor, Set<ISandbox>>();
        HashMap<ConfigurationDescriptor, Set<ILoadLocation>> loadLocations = new HashMap<ConfigurationDescriptor, Set<ILoadLocation>>();
        this.recordSandbox(this.treesToLoad.values(), multipleCFA, loadLocations);
        if (includeCollisions) {
            for (ICollision collision : this.collisions.values()) {
                this.recordSandbox(collision.getLocations(), multipleCFA, loadLocations);
            }
        }
        ArrayList<IMultipleSandboxLoad> result = new ArrayList<IMultipleSandboxLoad>();
        for (Map.Entry entry : multipleCFA.entrySet()) {
            ConfigurationDescriptor configuration = (ConfigurationDescriptor)entry.getKey();
            Set<ISandbox> loadedSandboxes = configurationSandboxes.get(configuration);
            Set sandboxes = (Set)entry.getValue();
            if (loadedSandboxes != null) {
                sandboxes.addAll(loadedSandboxes);
            }
            if (sandboxes.size() <= 1) continue;
            MultipleSandboxLoad multipleSandboxLoad = new MultipleSandboxLoad(configuration, sandboxes, (Set)loadLocations.get(configuration));
            result.add(multipleSandboxLoad);
        }
        return result;
    }

    private void recordSandbox(Collection<? extends ILoadLocation> toLoad, Map<ConfigurationDescriptor, Set<ISandbox>> multipleCFA, Map<ConfigurationDescriptor, Set<ILoadLocation>> loadLocations) {
        for (ILoadLocation iLoadLocation : toLoad) {
            ConfigurationDescriptor configuration = new ConfigurationDescriptor(iLoadLocation.getConnection(), (IComponentHandle)iLoadLocation.getComponent());
            Set<ISandbox> sandboxes = multipleCFA.get(configuration);
            if (sandboxes == null) {
                sandboxes = new HashSet<ISandbox>();
                multipleCFA.put(configuration, sandboxes);
            }
            sandboxes.add(iLoadLocation.getSandbox());
            Set<ILoadLocation> locations = loadLocations.get(configuration);
            if (locations == null) {
                locations = new HashSet<ILoadLocation>();
                loadLocations.put(configuration, locations);
            }
            locations.add(iLoadLocation);
        }
    }

    private boolean validateCopyFileAreas(ISandbox sandbox, HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection, HashSet<ISandbox> allCopyFileAreas) {
        boolean validCFA = true;
        if (!allCopyFileAreas.contains(sandbox)) {
            HashSet<ISandbox> copyFileAreasOverlapped = new HashSet<ISandbox>();
            for (ISandbox iSandbox : allCopyFileAreas) {
                if (!sandbox.getRoot().isPrefixOf(iSandbox.getRoot()) && !iSandbox.getRoot().isPrefixOf(sandbox.getRoot())) continue;
                copyFileAreasOverlapped.add(iSandbox);
            }
            for (ISandbox iSandbox : this.requestsByCFA.keySet()) {
                if (sandbox.equals(iSandbox) || !sandbox.getRoot().isPrefixOf(iSandbox.getRoot()) && !iSandbox.getRoot().isPrefixOf(sandbox.getRoot())) continue;
                copyFileAreasOverlapped.add(iSandbox);
            }
            if (!copyFileAreasOverlapped.isEmpty()) {
                validCFA = false;
                for (HashMap hashMap : requestsByConnection.values()) {
                    for (Set loadRequests : hashMap.values()) {
                        for (ILoadRequest loadRequest : loadRequests) {
                            InvalidLoadLocation invalidLoadLocation = new InvalidLoadLocation(loadRequest);
                            invalidLoadLocation.addCopyFileAreaPaths(copyFileAreasOverlapped);
                            this.invalidLoadLocations.put(loadRequest, invalidLoadLocation);
                        }
                    }
                }
            }
        }
        return validCFA;
    }

    @Override
    public void removeLoadRequests(Collection<ILoadRequest> requestsToRemove) {
        if (requestsToRemove == null) {
            throw new IllegalArgumentException();
        }
        for (ILoadRequest request : requestsToRemove) {
            Set<LoadRequest> requests;
            HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(request.getSandbox());
            if (requestsByConnection == null) continue;
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor(request.getConnection(), request.getComponent());
            HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig = requestsByConnection.get(request.getConnection());
            if (requestsByConfig == null || (requests = requestsByConfig.get(descriptor)) == null) continue;
            requests.remove(request);
            if (!requests.isEmpty()) continue;
            requestsByConfig.remove(descriptor);
            if (!requestsByConfig.isEmpty()) continue;
            requestsByConnection.remove(request.getConnection());
            if (!requestsByConnection.isEmpty()) continue;
            this.requestsByCFA.remove(request.getSandbox());
        }
    }

    @Override
    public Collection<IInvalidLoadLocation> getInvalidLoadLocations() {
        return Collections.unmodifiableCollection(this.invalidLoadLocations.values());
    }

    @Override
    public Collection<IRemovedShare> getSharesToBeRemoved() {
        return Collections.unmodifiableCollection(this.sharesToRemove);
    }

    @Override
    public Collection<ICollision> getCollisions() {
        return Collections.unmodifiableCollection(this.collisions.values());
    }

    @Override
    public Collection<IShareableToLoad> getNewSharesToLoad() {
        return Collections.unmodifiableCollection(this.newItems.values());
    }

    @Override
    public Collection<IShareOutOfSync> getSharesOutOfSync() {
        return Collections.unmodifiableCollection(this.sharesOutOfSync);
    }

    @Override
    public void setSychronizationInfo(ISynchronizationInfo synchronizationInfo) {
        this.synchronizationInfo = synchronizationInfo;
    }

    @Override
    public void setDownloadListener(IDownloadListener downloadListener) {
        this.downloadMonitor = downloadListener;
    }

    @Override
    protected final void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final Set<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    configurationSandboxes = LoadOperation.this.getConfigurationSandboxes(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
                    lockRequests = LoadOperation.access$1(LoadOperation.this);
                    copyFileAreaLock = ICopyFileAreaManager.instance.lock(lockRequests, (IProgressMonitor)progress.newChild(1));
                    try {
                        try {
                            LoadOperation.this.evaluateLoadRequests((IProgressMonitor)progress.newChild(2));
                            LoadOperation.this.notifyDilemmaHandler(configurationSandboxes, (IProgressMonitor)progress.newChild(1));
                            LoadOperation.access$4(LoadOperation.this, (IProgressMonitor)progress.newChild(10));
                            LoadOperation.this.load(LoadOperation.access$5(LoadOperation.this), (IProgressMonitor)progress.newChild(84));
                        }
                        finally {
                            LoadOperation.access$2(LoadOperation.this).addAll(LoadOperation.access$3(LoadOperation.this).keySet());
                            ** for (sandbox : LoadOperation.access$2((LoadOperation)LoadOperation.this))
                        }
lbl-1000:
                        // 1 sources

                        {
                            cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(sandbox.getRoot());
                            if (cfa == null) continue;
                            cfa.syncMetaData();
                            continue;
lbl21:
                            // 1 sources

                        }
                    }
                    finally {
                        copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        progress.done();
                    }
                }
                catch (FileSystemClientException e) {
                    throw new InvocationTargetException((Throwable)e);
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException v0) {
                    throw new InterruptedException();
                }
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FlowNodeLock jazzWorkspaceLock = WorkspaceLockUtil.acquireRead(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            this.runWithinFileSystemLock(runnableWithProgress, Messages.LoadOperation_18, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(jazzWorkspaceLock);
        }
        progress.done();
    }

    protected Map<ConfigurationDescriptor, Set<ISandbox>> getConfigurationSandboxes(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        HashMap<ConfigurationDescriptor, Set<ISandbox>> result = new HashMap<ConfigurationDescriptor, Set<ISandbox>>();
        for (ConfigurationDescriptor configuration : affectedConfigurations) {
            Collection<ISandbox> sandboxes = SharingManager.getInstance().getSandboxes(configuration, (IProgressMonitor)monitor.newChild(1));
            result.put(configuration, new HashSet<ISandbox>(sandboxes));
        }
        return result;
    }

    private List<ICopyFileAreaLockRequest> cfaLockRequests() {
        ICopyFileAreaManager.ICopyFileAreaLockRequestFactory lockFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        ArrayList<ICopyFileAreaLockRequest> requests = new ArrayList<ICopyFileAreaLockRequest>();
        for (Map.Entry<ISandbox, HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>>> requestsByConnection : this.requestsByCFA.entrySet()) {
            HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
            IPath copyFileAreaRoot = requestsByConnection.getKey().getRoot();
            for (HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfigurations : requestsByConnection.getValue().values()) {
                configurations.addAll(requestsByConfigurations.keySet());
            }
            requests.add(lockFactory.getLockRequest(copyFileAreaRoot, configurations, true));
        }
        return requests;
    }

    protected final Set<ConfigurationDescriptor> getAffectedConfigurations() {
        HashSet<ConfigurationDescriptor> configurationsAffected = new HashSet<ConfigurationDescriptor>();
        for (HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection : this.requestsByCFA.values()) {
            for (HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig : requestsByConnection.values()) {
                configurationsAffected.addAll(requestsByConfig.keySet());
            }
        }
        return configurationsAffected;
    }

    protected void notifyDilemmaHandler(Map<ConfigurationDescriptor, Set<ISandbox>> configurationSandboxes, IProgressMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        int reaction;
        Collection<IMultipleSandboxLoad> multipleSandboxes;
        int reaction2;
        MultiStatus status;
        int i;
        int result;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)(100 + this.requestsByCFA.size()));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.loadOverLaps.isEmpty()) {
            result = this.dilemmaHandler.overlappingLoadRequests(Collections.unmodifiableCollection(this.loadOverLaps));
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result != 0) {
                IStatus[] reportedOverlaps = new IStatus[this.loadOverLaps.size()];
                i = 0;
                for (ILoadOverlap overlap : this.loadOverLaps) {
                    String msg = "";
                    if (!overlap.getOverlappingShares().isEmpty()) {
                        msg = NLS.bind((String)Messages.LoadOperation_1, (Object)PathUtils.getString(overlap.getPath()), (Object)overlap.getOverlappingShares().size());
                    }
                    if (!overlap.getOverlappingItems().isEmpty()) {
                        msg = NLS.bind((String)Messages.LoadOperation_2, (Object)PathUtils.getString(overlap.getPath()), (Object)overlap.getOverlappingItems().size());
                    }
                    reportedOverlaps[i] = new FileSystemStatus(4, msg);
                    ++i;
                }
                status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedOverlaps, Messages.LoadOperation_3, null);
                this.handleErrors(new IStatus[]{status});
            }
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.newItems.isEmpty()) {
            result = this.dilemmaHandler.newItemsToLoad(Collections.unmodifiableCollection(this.newItems.values()));
            if (result == 0) {
                for (IShareableToLoad newItem : this.newItems.values()) {
                    if (newItem.willLoad()) continue;
                    this.treesToLoad.remove(((LoadLocation)newItem.getLoadLocation()).getFullPath());
                }
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                IStatus[] reportedNewItems = new IStatus[this.newItems.size()];
                i = 0;
                for (IShareableToLoad shareableToLoad : this.newItems.values()) {
                    reportedNewItems[i] = new FileSystemStatus(2, shareableToLoad.getShareable().getLocalPath() + Messages.LoadOperation_4);
                    ++i;
                }
                status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedNewItems, Messages.LoadOperation_5, null);
                this.handleErrors(new IStatus[]{status});
            }
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.invalidLoadLocations.size() > 0 && (reaction2 = this.dilemmaHandler.invalidLoadLocations(this.getInvalidLoadLocations())) != 0) {
            if (reaction2 == 1) {
                throw new OperationCanceledException();
            }
            IStatus[] reasons = new IStatus[this.invalidLoadLocations.size()];
            int i2 = 0;
            for (IInvalidLoadLocation invalidLocation : this.invalidLoadLocations.values()) {
                reasons[i2] = ((InvalidLoadLocation)invalidLocation).getStatus();
                ++i2;
            }
            status = new MultiStatus("com.ibm.team.filesystem.client", 4, reasons, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadLocations.size()), null);
            this.handleErrors(new IStatus[]{status});
        }
        if (this.collisions.size() > 0 || this.sharesToRemove.size() > 0) {
            result = this.dilemmaHandler.collision(Collections.unmodifiableCollection(this.collisions.values()), Collections.unmodifiableCollection(this.sharesToRemove), Collections.unmodifiableCollection(this.sharesOutOfSync));
            if (result == 0) {
                ICollision[] collisionDecisions = this.collisions.values().toArray(new ICollision[this.collisions.size()]);
                int i3 = 0;
                while (i3 < collisionDecisions.length) {
                    LoadLocation loadLocation = (LoadLocation)collisionDecisions[i3].getLoadLocation();
                    if (loadLocation != null) {
                        this.treesToLoad.put(loadLocation.getFullPath(), loadLocation);
                    }
                    ++i3;
                }
            } else if (result != 1) {
                IStatus[] reportedCollisions = new IStatus[this.collisions.size() + this.sharesToRemove.size()];
                int i4 = 0;
                Iterator<ICollision> iCollisions = this.collisions.values().iterator();
                while (iCollisions.hasNext()) {
                    reportedCollisions[i4] = iCollisions.next().getStatus();
                    ++i4;
                }
                for (IRemovedShare removedShare : this.sharesToRemove) {
                    reportedCollisions[i4] = new FileSystemStatus(2, NLS.bind((String)Messages.LoadOperation_0, (Object)removedShare.getLocalPath()));
                    ++i4;
                }
                status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedCollisions, Messages.LoadOperation_7, null);
                this.handleErrors(new IStatus[]{status});
            } else {
                throw new OperationCanceledException();
            }
        }
        if ((multipleSandboxes = this.validateMultipleCopyFileAreas(configurationSandboxes, false, (IProgressMonitor)progress.newChild(10))).size() > 0 && (reaction = this.dilemmaHandler.multipleSandboxLoad(multipleSandboxes)) != 0) {
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            IStatus status2 = FileSystemStatus.getStatusFor(4, Messages.LoadOperation_19, null);
            this.handleErrors(new IStatus[]{status2});
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.invalidLoadRequests.size() > 0 && (reaction = this.dilemmaHandler.invalidLoadRequest(Collections.unmodifiableCollection(this.invalidLoadRequests))) != 0) {
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            IStatus[] reasons = new IStatus[this.invalidLoadRequests.size()];
            int i5 = 0;
            for (IInvalidLoadRequest request : this.invalidLoadRequests) {
                reasons[i5] = ((InvalidLoadRequest)request).getStatus();
                ++i5;
            }
            MultiStatus status3 = new MultiStatus("com.ibm.team.filesystem.client", 4, reasons, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadRequests.size()), null);
            this.handleErrors(new IStatus[]{status3});
        }
        progress.done();
    }

    protected boolean maintainShareInfo() {
        return true;
    }

    private void removeShares(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.sharesToRemove.size());
        Shed shed = new Shed(this.dilemmaHandler.getBackupDilemmaHandler());
        for (IRemovedShare shareToRemove : this.sharesToRemove) {
            IShare share = shareToRemove.getShare();
            mon.setTaskName(NLS.bind((String)Messages.LoadOperation_8, (Object)share.getPath().toString()));
            if (shareToRemove.isToBeDeleted()) {
                MergeLoadMutator.deleteShare(share, shed, (IProgressMonitor)mon.newChild(1));
            } else {
                ResourceType type = ResourceType.FOLDER;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                if (descriptor != null) {
                    type = ResourceType.getResourceType(descriptor.getRootVersionable());
                }
                Shareable shareable = (Shareable)share.getSandbox().findShareable(share.getPath(), type);
                shareable.unshare((IProgressMonitor)mon.newChild(1));
            }
            this.copyFileAreasAffected.add(share.getSandbox());
            if (!mon.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        mon.done();
    }

    protected void load(IDownloadListener downloadMonitor, IProgressMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)reporter, (int)(this.treesToLoad.size() * 3));
        subProgress.setTaskName(Messages.LoadOperation_9);
        subProgress.beginTask(Messages.LoadOperation_10, this.treesToLoad.size() * 3);
        int configCount = 0;
        HashMap toLoad = new HashMap();
        for (LoadLocation loadLocation : this.treesToLoad.values()) {
            ConfigurationDescriptor descriptor;
            ArrayList<LoadLocation> itemsToLoad;
            HashMap<ConfigurationDescriptor, ArrayList<LoadLocation>> componentsToLoad = (HashMap<ConfigurationDescriptor, ArrayList<LoadLocation>>)toLoad.get(loadLocation.getSandbox());
            if (componentsToLoad == null) {
                componentsToLoad = new HashMap<ConfigurationDescriptor, ArrayList<LoadLocation>>();
                toLoad.put(loadLocation.getSandbox(), componentsToLoad);
            }
            if ((itemsToLoad = (ArrayList<LoadLocation>)componentsToLoad.get(descriptor = new ConfigurationDescriptor(loadLocation.getConnection(), (IComponentHandle)loadLocation.getComponent()))) == null) {
                ++configCount;
                itemsToLoad = new ArrayList<LoadLocation>();
                componentsToLoad.put(descriptor, itemsToLoad);
            }
            itemsToLoad.add(loadLocation);
        }
        int i = 1;
        for (Map.Entry toLoadEntry : toLoad.entrySet()) {
            ISandbox sandbox = (ISandbox)toLoadEntry.getKey();
            HashMap componentsToLoad = (HashMap)toLoadEntry.getValue();
            for (ArrayList itemsToLoad : componentsToLoad.values()) {
                LoadLocation location = (LoadLocation)itemsToLoad.get(0);
                SubProgressMonitor dlMonitor = new SubProgressMonitor((IProgressMonitor)subProgress, itemsToLoad.size() * 2);
                IFileSystemManager fsm = (IFileSystemManager)location.getConnection().teamRepository().getClientLibrary(IFileSystemManager.class);
                IConnection connection = location.getConnection();
                FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
                dlMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_11, (Object[])new Object[]{connection.getName(), location.getComponent().getName(), i, configCount}));
                subProgress.subTask(NLS.bind((String)Messages.LoadOperation_12, (Object)location.getComponent().getName()));
                IVersionableHandle[] versionableHandles = new IVersionableHandle[itemsToLoad.size()];
                int j = 0;
                for (ILoadLocation loadLocation : itemsToLoad) {
                    versionableHandles[j] = ((LoadLocation)loadLocation).getRootToLoad();
                    ++j;
                }
                LoadTree loadTree = fss.getFileTreeByVersionable(connection, (IComponentHandle)location.getComponent(), versionableHandles, -1, true, this.synchronizationInfo, (IProgressMonitor)subProgress.newChild(itemsToLoad.size()));
                FileSystemOperation mutator = this.getLoadMutator(connection, location.getComponent(), sandbox, itemsToLoad, loadTree, this.dilemmaHandler, downloadMonitor);
                try {
                    mutator.run((IProgressMonitor)dlMonitor);
                }
                finally {
                    dlMonitor.done();
                }
                if (subProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
        }
        subProgress.setTaskName(Messages.LoadOperation_13);
        subProgress.done();
    }

    private void getElementsToLoad(ISandbox sandbox, HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection, HashMap<IShare, IConnection> sharesToVerifyInSync, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        monitor.setTaskName(Messages.LoadOperation_14);
        HashMap<IPath, IShare> allShares = new HashMap<IPath, IShare>();
        HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> existingShares = new HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>>();
        this.organizeShares(sandbox, allShares, existingShares, (IProgressMonitor)monitor.newChild(1));
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        HashMap<LoadRequest, LoadLocation> locationsInSandbox = new HashMap<LoadRequest, LoadLocation>();
        monitor.setWorkRemaining(requestsByConnection.size());
        for (Map.Entry<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> entryByConnection : requestsByConnection.entrySet()) {
            SubMonitor iterProgress = monitor.newChild(1);
            iterProgress.setWorkRemaining(100);
            IConnection connection = entryByConnection.getKey();
            HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsForConnection = entryByConnection.getValue();
            ArrayList<OverlapRequest> overlapRequests = new ArrayList<OverlapRequest>(entryByConnection.getValue().size());
            HashMap<ConfigurationDescriptor, HashMap<UUID, LoadRequest>> toLoad = new HashMap<ConfigurationDescriptor, HashMap<UUID, LoadRequest>>();
            HashMap<ConfigurationDescriptor, HashMap<UUID, IVersionable>> configurationVersionables = new HashMap<ConfigurationDescriptor, HashMap<UUID, IVersionable>>();
            Map<UUID, Map<UUID, ? extends IVersionable>> fullVersionables = this.fetchInfoForLoadEvaluation(connection, requestsForConnection, toLoad, components, existingShares, (IProgressMonitor)iterProgress.newChild(50));
            this.buildOverlapRequestCheckExistance(connection, requestsForConnection, overlapRequests, toLoad, existingShares, configurationVersionables, fullVersionables, (IProgressMonitor)iterProgress.newChild(10));
            if (!overlapRequests.isEmpty()) {
                this.checkItemOverlaps(connection, overlapRequests, toLoad, existingShares, (IProgressMonitor)iterProgress.newChild(30));
            }
            for (Map.Entry<ConfigurationDescriptor, HashMap<UUID, LoadRequest>> entry : toLoad.entrySet()) {
                ConfigurationDescriptor descriptor = entry.getKey();
                for (LoadRequest request : entry.getValue().values()) {
                    IVersionable versionable = configurationVersionables.get(descriptor).get(request.getVersionableToLoad().getItemId());
                    if (versionable == null) {
                        throw new IllegalStateException();
                    }
                    boolean isLoadWithAnotherName = false;
                    String loadName = versionable.getName();
                    if (request.getAlternativeName().length() > 0) {
                        loadName = request.getAlternativeName();
                        isLoadWithAnotherName = true;
                    }
                    LoadLocation location = new LoadLocation(request.getSandbox(), request.getRelativeLoadPath(), loadName, request.getConnection(), components.get(request.getComponent().getItemId()), request.getVersionableToLoad(), isLoadWithAnotherName);
                    locationsInSandbox.put(request, location);
                }
            }
            iterProgress.setWorkRemaining(locationsInSandbox.size());
            for (Map.Entry<ConfigurationDescriptor, HashMap<Object, LoadRequest>> entry : locationsInSandbox.entrySet()) {
                InvalidLoadLocation invalidLoadLocation = null;
                LoadLocation loadLocation = (LoadLocation)((Object)entry.getValue());
                for (Map.Entry otherEntry : locationsInSandbox.entrySet()) {
                    LoadLocation otherLocation = (LoadLocation)otherEntry.getValue();
                    if (!PathUtils.overlapsButNotEqual(loadLocation.getLoadPath(), loadLocation.getSandbox().isCaseSensitive(), otherLocation.getLoadPath(), otherLocation.getSandbox().isCaseSensitive())) continue;
                    if (invalidLoadLocation == null) {
                        invalidLoadLocation = new InvalidLoadLocation((ILoadRequest)((Object)entry.getKey()));
                    }
                    invalidLoadLocation.addOverlappingLoadRequests((ILoadRequest)otherEntry.getKey());
                }
                if (invalidLoadLocation == null) {
                    this.checkForCollision((LoadRequest)((Object)entry.getKey()), loadLocation, sharesToVerifyInSync, allShares, existingShares, (IProgressMonitor)iterProgress.newChild(1));
                    continue;
                }
                this.invalidLoadLocations.put((ILoadRequest)((Object)entry.getKey()), invalidLoadLocation);
            }
        }
    }

    private void checkItemOverlaps(IConnection connection, ArrayList<OverlapRequest> overlapRequests, HashMap<ConfigurationDescriptor, HashMap<UUID, LoadRequest>> toLoad, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> existingShares, IProgressMonitor progress) throws TeamRepositoryException {
        FileSystemManager fsm = (FileSystemManager)FileSystemCore.getFileSystemManager(connection.teamRepository());
        FileSystemServiceProxy fileSystemService = fsm.getFileSystemService();
        List<OverlapResponse> overlapResult = fileSystemService.detectOverlap(overlapRequests, null, progress);
        for (OverlapResponse response : overlapResult) {
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor(connection, response.getComponent());
            HashMap<UUID, LoadRequest> uuidsToLoad = toLoad.get(descriptor);
            if (uuidsToLoad == null) continue;
            HashMap<UUID, IAncestorReport> ancestorReports = new HashMap<UUID, IAncestorReport>();
            for (IAncestorReport ancestorReport : response.getAncestorReports()) {
                List pairs = ancestorReport.getNameItemPairs();
                ancestorReports.put(((INameItemPair)pairs.get(pairs.size() - 1)).getItem().getItemId(), ancestorReport);
            }
            HashMap<UUID, Collection<IVersionableHandle>> overlapSituations = new HashMap<UUID, Collection<IVersionableHandle>>();
            for (OverlapDescription overlapDescription : response.getOverlapDescriptions()) {
                IVersionableHandle element = overlapDescription.getElement();
                for (IVersionableHandle itemOverlapped : overlapDescription.getOverlappedChildren()) {
                    this.recordOverlap(overlapSituations, element, itemOverlapped);
                    this.recordOverlap(overlapSituations, itemOverlapped, element);
                }
            }
            for (Map.Entry entry : overlapSituations.entrySet()) {
                LoadRequest request = uuidsToLoad.get(entry.getKey());
                if (request == null) continue;
                uuidsToLoad.remove(entry.getKey());
                LoadOverlap loadOverlap = new LoadOverlap(request.getSandbox(), connection, response.getComponent(), (IAncestorReport)ancestorReports.get(entry.getKey()));
                this.loadOverLaps.add(loadOverlap);
                for (IVersionableHandle versionable : (Collection)entry.getValue()) {
                    HashMap<UUID, IShare> shares = existingShares.get(descriptor);
                    if (shares != null && shares.get(versionable.getItemId()) != null) {
                        loadOverlap.addOverlappingShare(shares.get(versionable.getItemId()));
                    }
                    loadOverlap.addOverlappingItem((IAncestorReport)ancestorReports.get(versionable.getItemId()));
                }
            }
        }
    }

    private void buildOverlapRequestCheckExistance(IConnection connection, HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsForConnection, ArrayList<OverlapRequest> overlapRequests, HashMap<ConfigurationDescriptor, HashMap<UUID, LoadRequest>> toLoad, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> existingShares, HashMap<ConfigurationDescriptor, HashMap<UUID, IVersionable>> configurationVersionables, Map<UUID, Map<UUID, ? extends IVersionable>> fullVersionables, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)requestsForConnection.size());
        for (Map.Entry<ConfigurationDescriptor, Set<LoadRequest>> entryByConfig : requestsForConnection.entrySet()) {
            SubMonitor iterMonitor = monitor.newChild(1);
            ConfigurationDescriptor descriptor = entryByConfig.getKey();
            HashMap<UUID, LoadRequest> uuidsToLoad = toLoad.get(descriptor);
            HashMap<UUID, IShare> shares = existingShares.get(descriptor);
            Map<UUID, ? extends IVersionable> fullVersionablesForComponent = fullVersionables.get(descriptor.componentHandle.getItemId());
            if (fullVersionablesForComponent == null) continue;
            HashMap<UUID, IVersionable> versionablesRetrieved = new HashMap<UUID, IVersionable>();
            for (IVersionable iVersionable : fullVersionablesForComponent.values()) {
                if (iVersionable == null) continue;
                versionablesRetrieved.put(iVersionable.getItemId(), iVersionable);
            }
            configurationVersionables.put(descriptor, versionablesRetrieved);
            OverlapRequest overlapRequest = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
            overlapRequest.setContext(connection.getContextHandle());
            overlapRequest.setComponent(descriptor.componentHandle);
            int i = 0;
            iterMonitor.setWorkRemaining(fullVersionablesForComponent.size());
            for (Map.Entry<UUID, ? extends IVersionable> entry : fullVersionablesForComponent.entrySet()) {
                UUID itemId = entry.getKey();
                if (entry.getValue() == null) {
                    IShare share;
                    LoadRequest request = uuidsToLoad.get(itemId);
                    if (request != null) {
                        uuidsToLoad.remove(itemId);
                        if (request.isReloadRequest()) {
                            share = shares.get(itemId);
                            this.sharesToRemove.add(new RemovedShare(share, (IProgressMonitor)iterMonitor.newChild(1)));
                        } else {
                            FileSystemStatus msg = new FileSystemStatus(2, Messages.LoadOperation_16);
                            InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.NonExistantFolder, msg);
                            this.invalidLoadRequests.add(invalidLoadRequest);
                        }
                    } else {
                        share = shares.get(itemId);
                        this.sharesToRemove.add(new RemovedShare(share, (IProgressMonitor)iterMonitor.newChild(1)));
                    }
                } else {
                    IVersionable versionable = entry.getValue();
                    LoadRequest request = uuidsToLoad.get(itemId);
                    if (request == null) {
                        overlapRequest.getGroup().add(versionable);
                    } else {
                        String loadName = request.getAlternativeName().length() == 0 ? versionable.getName() : request.getAlternativeName();
                        Path path = new Path(loadName);
                        if (path.segmentCount() != 1) {
                            uuidsToLoad.remove(itemId);
                            FileSystemStatus msg = new FileSystemStatus(4, NLS.bind((String)Messages.LoadOperation_17, (Object)loadName));
                            InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.InvalidProjectName, msg);
                            this.invalidLoadRequests.add(invalidLoadRequest);
                        } else {
                            overlapRequest.getGroup().add(versionable);
                        }
                    }
                }
                ++i;
            }
            if (overlapRequest.getGroup().size() <= 1) continue;
            overlapRequests.add(overlapRequest);
        }
    }

    private Map<UUID, Map<UUID, ? extends IVersionable>> fetchInfoForLoadEvaluation(IConnection connection, HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsForConnection, HashMap<ConfigurationDescriptor, HashMap<UUID, LoadRequest>> toLoad, HashMap<UUID, IComponent> components, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> existingShares, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IComponentHandle> componentsToRetrieve = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> interestingComponents = new ArrayList<IComponentHandle>();
        ArrayList<List<? extends IVersionableHandle>> interestingVersionables = new ArrayList<List<? extends IVersionableHandle>>();
        for (Map.Entry<ConfigurationDescriptor, Set<LoadRequest>> entryByConfig : requestsForConnection.entrySet()) {
            ConfigurationDescriptor descriptor = entryByConfig.getKey();
            interestingComponents.add(descriptor.componentHandle);
            ArrayList<IVersionableHandle> versionables = new ArrayList<IVersionableHandle>();
            interestingVersionables.add(versionables);
            HashMap<UUID, LoadRequest> uuidsToLoad = new HashMap<UUID, LoadRequest>();
            toLoad.put(descriptor, uuidsToLoad);
            for (LoadRequest request : entryByConfig.getValue()) {
                if (!components.containsKey(request.getComponent().getItemId())) {
                    componentsToRetrieve.add(request.getComponent());
                }
                versionables.add(request.getVersionableToLoad());
                uuidsToLoad.put(request.getVersionableToLoad().getItemId(), request);
            }
            HashMap<UUID, IShare> shares = existingShares.get(descriptor);
            if (shares == null) continue;
            for (IShare share : shares.values()) {
                ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                LoadRequest request = (LoadRequest)uuidsToLoad.get(sharingDescriptor.getRootVersionable().getItemId());
                if (request != null) {
                    request.setReloadRequest(true);
                    continue;
                }
                versionables.add(sharingDescriptor.getRootVersionable());
            }
        }
        if (!componentsToRetrieve.isEmpty()) {
            List fullComponents = connection.teamRepository().itemManager().fetchCompleteItems(componentsToRetrieve, 0, (IProgressMonitor)monitor.newChild(20));
            for (IComponent component : fullComponents) {
                components.put(component.getItemId(), component);
            }
        }
        return this.fetchCompleteItems(connection, interestingComponents, interestingVersionables, monitor.newChild(80));
    }

    private Map<UUID, Map<UUID, ? extends IVersionable>> fetchCompleteItems(IConnection connection, ArrayList<IComponentHandle> interestingComponents, ArrayList<List<? extends IVersionableHandle>> interestingVersionables, SubMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, HashMap<UUID, IFolder>> fullFolders;
        if (connection instanceof IWorkspaceConnection) {
            fullFolders = ((IWorkspaceConnection)connection).configuration().fetchCompleteItems(interestingComponents, interestingVersionables, (IProgressMonitor)progress.newChild(10));
        } else {
            IConfiguration configuration = ((IBaselineConnection)connection).configuration();
            if (interestingComponents.size() != 1) {
                throw new IllegalStateException("There should be just 1 component in a baseline connection");
            }
            List<? extends IVersionableHandle> versionablesToGet = interestingVersionables.get(0);
            List fullFoldersRetrieved = configuration.fetchCompleteItems(versionablesToGet, (IProgressMonitor)progress.newChild(10));
            Iterator iFullFoldersRetrieved = fullFoldersRetrieved.iterator();
            HashMap<UUID, IFolder> fullFoldersForComponent = new HashMap<UUID, IFolder>();
            fullFolders = new HashMap<UUID, HashMap<UUID, IFolder>>(1);
            fullFolders.put(configuration.component().getItemId(), fullFoldersForComponent);
            for (IVersionableHandle iVersionableHandle : versionablesToGet) {
                IFolder folder = (IFolder)iFullFoldersRetrieved.next();
                fullFoldersForComponent.put(iVersionableHandle.getItemId(), folder);
            }
        }
        return fullFolders;
    }

    private void recordOverlap(HashMap<UUID, Collection<IVersionableHandle>> overlapSituations, IVersionableHandle element, IVersionableHandle itemOverlapped) {
        Collection<IVersionableHandle> overlap = overlapSituations.get(element.getItemId());
        if (overlap == null) {
            overlap = new ArrayList<IVersionableHandle>();
            overlapSituations.put(element.getItemId(), overlap);
        }
        overlap.add(itemOverlapped);
    }

    private void organizeShares(ISandbox sandbox, HashMap<IPath, IShare> allShares, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> existingShares, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
        if (cfaManager.copyFileAreaExists(sandbox.getRoot(), 1)) {
            IShare[] iShareArray = sandbox.allShares(monitor);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                if (share.getSharingDescriptor() != null) {
                    ISharingDescriptor shareDesc = share.getSharingDescriptor();
                    ConfigurationDescriptor descriptor = new ConfigurationDescriptor(shareDesc.getRepositoryId(), shareDesc.getRepositoryUri(), shareDesc.getConnectionHandle(), shareDesc.getComponent());
                    HashMap<Object, IShare> shares = existingShares.get(descriptor);
                    if (shares == null) {
                        shares = new HashMap();
                        existingShares.put(descriptor, shares);
                    }
                    shares.put(shareDesc.getRootVersionable().getItemId(), share);
                }
                IPath path = LoadRequest.getPath(sandbox.getRoot().append(share.getPath()));
                allShares.put(path, share);
                ++n2;
            }
        }
    }

    private void checkForCollision(LoadRequest request, LoadLocation location, HashMap<IShare, IConnection> sharesToVerifyInSync, HashMap<IPath, IShare> sharesInCopyFileArea, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> existingShares, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Collision overWriteCollision = null;
        InvalidLoadLocation invalidLoadLocation = null;
        ISandbox sandbox = location.getSandbox();
        try {
            IShareable existingShareableInCFA = sandbox.findShareable(request.getConnection().getContextHandle(), request.getComponent(), request.getVersionableToLoad(), (IProgressMonitor)monitor.newChild(10));
            if (existingShareableInCFA != null && !PathUtils.sameRelativePath(existingShareableInCFA.getLocalPath(), existingShareableInCFA.getSandbox().isCaseSensitive(), location.getLoadPath(), location.getSandbox().isCaseSensitive())) {
                IShare existingShareableShare = existingShareableInCFA.getShare((IProgressMonitor)monitor.newChild(1));
                if (!existingShareableInCFA.isShare((IProgressMonitor)monitor.newChild(1)) || existingShareableShare.isLoadedWithAnotherName((IProgressMonitor)monitor.newChild(1)) || location.isLoadWithAnotherName()) {
                    if (invalidLoadLocation == null) {
                        invalidLoadLocation = new InvalidLoadLocation(request);
                    }
                    invalidLoadLocation.setPresentLoadLocation(existingShareableInCFA);
                }
            }
        }
        catch (FileSystemClientException e) {
            this.collectStatus(e.getStatus());
        }
        IPath fullLoadPath = location.getFullPath();
        for (Map.Entry<IPath, IShare> entry : sharesInCopyFileArea.entrySet()) {
            IPath sharePath = entry.getKey();
            if (!PathUtils.overlapsButNotEqual(sharePath, entry.getValue().getSandbox().isCaseSensitive(), fullLoadPath, location.getSandbox().isCaseSensitive())) continue;
            if (invalidLoadLocation == null) {
                invalidLoadLocation = new InvalidLoadLocation(request);
            }
            invalidLoadLocation.addOverlappingShare(entry.getValue());
        }
        if (invalidLoadLocation == null) {
            IShare share;
            IShareable shareable = location.getSandbox().findShareable(location.getLoadPath(), ResourceType.getResourceType(location.getRootToLoad()));
            if (shareable.exists((IProgressMonitor)monitor.newChild(1))) {
                ISharingDescriptor descriptor;
                share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                overWriteCollision = new Collision(shareable, share, location, true);
                if (share != null && (descriptor = share.getSharingDescriptor()).getConnectionHandle().sameItemId((IItemHandle)location.getConnection().getContextHandle()) && descriptor.getComponent().sameItemId((IItemHandle)location.getComponent()) && descriptor.getRootVersionable().sameItemId((IItemHandle)overWriteCollision.getShareable().getVersionable((IProgressMonitor)monitor.newChild(1)))) {
                    sharesToVerifyInSync.put(share, location.getConnection());
                }
            }
            if (this.collisions.containsKey(location.getFullPath())) {
                ICollision collision = this.collisions.get(location.getFullPath());
                collision.getLocations().add(location);
            } else if (this.treesToLoad.containsKey(location.getFullPath())) {
                share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                Collision collision = new Collision(shareable, share, location, false);
                ILoadLocation otherLocation = this.treesToLoad.remove(location.getFullPath());
                this.newItems.remove(location.getFullPath());
                collision.getLocations().add(otherLocation);
                this.collisions.put(location.getFullPath(), collision);
            } else if (overWriteCollision != null) {
                this.collisions.put(location.getFullPath(), overWriteCollision);
            } else {
                this.treesToLoad.put(location.getFullPath(), location);
                this.newItems.put(location.getFullPath(), new ShareableToLoad(shareable, location));
            }
        } else {
            this.invalidLoadLocations.put(request, invalidLoadLocation);
        }
    }

    private FileSystemOperation getLoadMutator(IConnection connection, IComponent component, ISandbox sandbox, ArrayList<LoadLocation> itemsToLoad, LoadTree loadTree, LoadDilemmaHandler loadProblemHandler, IDownloadListener downloadMonitor) throws TeamRepositoryException {
        return SharingManager.getInstance().getLoadMutator(this.options, connection, component, sandbox, itemsToLoad, loadTree, loadProblemHandler, downloadMonitor);
    }

    @Override
    public int getEclipseSpecificLoadOptions() {
        return this.options;
    }

    @Override
    public void setEclipseSpecificLoadOptions(int options) {
        if ((options & 3) == 3) {
            throw new IllegalArgumentException("Only one of CREATE_PROJECTS_FOR_NEW_SHARE_ROOTS or IMPORT_PROJECTS can be specified");
        }
        if (options > 7) {
            throw new IllegalArgumentException("Invalid option " + options);
        }
        this.options = options;
    }

    static /* synthetic */ List access$1(LoadOperation loadOperation) {
        return loadOperation.cfaLockRequests();
    }

    static /* synthetic */ HashSet access$2(LoadOperation loadOperation) {
        return loadOperation.copyFileAreasAffected;
    }

    static /* synthetic */ HashMap access$3(LoadOperation loadOperation) {
        return loadOperation.requestsByCFA;
    }

    static /* synthetic */ void access$4(LoadOperation loadOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        loadOperation.removeShares(iProgressMonitor);
    }

    static /* synthetic */ IDownloadListener access$5(LoadOperation loadOperation) {
        return loadOperation.downloadMonitor;
    }
}

