/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadHandler;
import com.ibm.team.filesystem.client.internal.operations.UploadFailure;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.repository.common.util.NLS;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EncodingUploadFailure
extends UploadFailure
implements IEncodingUploadFailure {
    private boolean unknownEncoding;
    private boolean malformed;
    private String encodingUsed;
    private String predecessorEncoding;
    private String alternativeEncoding;
    private IStatus status;
    private boolean ignoreEncoding;

    public EncodingUploadFailure(IShareable shareable, String encoding, String predecessorEncoding, boolean unknownEncoding, boolean malformed, CheckinUploadHandler checkinUploadHandler, Throwable e) {
        super(shareable, checkinUploadHandler, e);
        this.unknownEncoding = unknownEncoding;
        this.malformed = malformed;
        this.encodingUsed = encoding;
        this.predecessorEncoding = predecessorEncoding;
        this.alternativeEncoding = encoding;
        this.ignoreEncoding = false;
    }

    public String getEncoding() {
        return this.encodingUsed;
    }

    public String getOriginalEncoding() {
        return this.predecessorEncoding;
    }

    public boolean isUnknownEncoding() {
        return this.unknownEncoding;
    }

    public boolean isMalformedContent() {
        return this.malformed;
    }

    public void setAlternativeEncoding(String alternativeEncoding) {
        if (alternativeEncoding == null) {
            throw new IllegalArgumentException("alternativeEncoding cannot be null");
        }
        if (!Charset.isSupported(alternativeEncoding)) {
            throw new UnsupportedCharsetException(alternativeEncoding);
        }
        this.alternativeEncoding = alternativeEncoding;
    }

    public String getAlternativeEncoding() {
        return this.alternativeEncoding;
    }

    public boolean isIgnoreEncoding() {
        return this.ignoreEncoding;
    }

    public void setIgnoreEncoding(boolean ignoreEncoding) {
        this.ignoreEncoding = ignoreEncoding;
    }

    public IStatus getStatus() {
        if (this.status == null) {
            this.status = this.unknownEncoding ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.NewCheckInOperation_12, (Object)this.getShareable().getLocalPath().toString(), (Object[])new Object[]{this.encodingUsed}), this.getRootCause()) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.NewCheckInOperation_13, (Object)this.getShareable().getLocalPath().toString(), (Object[])new Object[]{this.encodingUsed}), this.getRootCause());
        }
        return this.status;
    }

    public boolean hasDirection() {
        return this.ignoreEncoding || !this.encodingUsed.equals(this.alternativeEncoding) && this.alternativeEncoding != null || super.isSkipFailure();
    }
}

