/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadHandler;
import com.ibm.team.filesystem.client.internal.operations.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.UploadFailure;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckinUploadData {
    private Map<UUID, Map<UUID, Long>> uploadContentSize = new HashMap<UUID, Map<UUID, Long>>();
    private Map<UUID, Map<UUID, ContentHash>> uploadHashCode = new HashMap<UUID, Map<UUID, ContentHash>>();
    private Map<UUID, Map<UUID, FileContent>> uploadContent = new HashMap<UUID, Map<UUID, FileContent>>();
    private Map<UUID, Map<UUID, String>> uploadContentType = new HashMap<UUID, Map<UUID, String>>();
    private Map<UUID, Map<UUID, IShareable>> uploadShareables = new HashMap<UUID, Map<UUID, IShareable>>();
    private List<CheckinUploadHandler> filesNeedingConversion = new ArrayList<CheckinUploadHandler>();
    private Map<UUID, Map<UUID, Long>> modTimes = new HashMap<UUID, Map<UUID, Long>>();
    private Map<UUID, List<LineDelimiterUploadFailure>> lineDelimiterFailures = new HashMap<UUID, List<LineDelimiterUploadFailure>>();
    private Map<UUID, List<EncodingUploadFailure>> encodingFailures = new HashMap<UUID, List<EncodingUploadFailure>>();
    private Map<UUID, Map<UUID, UploadFailure>> uploadFailures = new HashMap<UUID, Map<UUID, UploadFailure>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUploadInfo(CheckinUploadHandler uploadHandler, Long uploadedSize, ContentHash uploadedHashCode, FileContent uploadedContent, String uploadedContentType, IShareable shareable, boolean needsConversion) {
        UUID componentId = uploadHandler.getComponent().getItemId();
        UUID itemId = uploadHandler.getVersionable().getItemId();
        Map<UUID, Map<UUID, Long>> map = this.uploadContentSize;
        synchronized (map) {
            Map<UUID, Long> uploadContentSizeByComponent = this.uploadContentSize.get(componentId);
            if (uploadContentSizeByComponent == null) {
                uploadContentSizeByComponent = new HashMap<UUID, Long>();
                this.uploadContentSize.put(componentId, uploadContentSizeByComponent);
            }
            uploadContentSizeByComponent.put(itemId, uploadedSize);
            Map<UUID, ContentHash> uploadHashCodeByComponent = this.uploadHashCode.get(componentId);
            if (uploadHashCodeByComponent == null) {
                uploadHashCodeByComponent = new HashMap<UUID, ContentHash>();
                this.uploadHashCode.put(componentId, uploadHashCodeByComponent);
            }
            uploadHashCodeByComponent.put(itemId, uploadedHashCode);
            Map<UUID, FileContent> uploadContentByComponent = this.uploadContent.get(componentId);
            if (uploadContentByComponent == null) {
                uploadContentByComponent = new HashMap<UUID, FileContent>();
                this.uploadContent.put(componentId, uploadContentByComponent);
            }
            uploadContentByComponent.put(itemId, uploadedContent);
            Map<UUID, String> uploadDeterminedContentTypeByComponent = this.uploadContentType.get(componentId);
            if (uploadDeterminedContentTypeByComponent == null) {
                uploadDeterminedContentTypeByComponent = new HashMap<UUID, String>();
                this.uploadContentType.put(componentId, uploadDeterminedContentTypeByComponent);
            }
            uploadDeterminedContentTypeByComponent.put(itemId, uploadedContentType);
            Map<UUID, IShareable> uploadShareableByComponent = this.uploadShareables.get(componentId);
            if (uploadShareableByComponent == null) {
                uploadShareableByComponent = new HashMap<UUID, IShareable>();
                this.uploadShareables.put(componentId, uploadShareableByComponent);
            }
            uploadShareableByComponent.put(itemId, shareable);
            if (needsConversion) {
                this.filesNeedingConversion.add(uploadHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModTime(IComponentHandle component, UUID itemId, Long modStamp) {
        Map<UUID, Map<UUID, Long>> map = this.modTimes;
        synchronized (map) {
            Map<UUID, Long> modTimesByComponent = this.modTimes.get(component.getItemId());
            if (modTimesByComponent == null) {
                modTimesByComponent = new HashMap<UUID, Long>();
                this.modTimes.put(component.getItemId(), modTimesByComponent);
            }
            modTimesByComponent.put(itemId, modStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConvertInfo(IComponentHandle component, UUID itemId, long size, ContentHash hashcode, long modificationStamp) {
        UUID componentId = component.getItemId();
        Map<UUID, Map<UUID, Long>> map = this.uploadContentSize;
        synchronized (map) {
            Map<UUID, Long> uploadContentSizeByComponent = this.uploadContentSize.get(componentId);
            if (uploadContentSizeByComponent == null) {
                uploadContentSizeByComponent = new HashMap<UUID, Long>();
                this.uploadContentSize.put(componentId, uploadContentSizeByComponent);
            }
            uploadContentSizeByComponent.put(itemId, size);
            Map<UUID, ContentHash> uploadHashCodeByComponent = this.uploadHashCode.get(componentId);
            if (uploadHashCodeByComponent == null) {
                uploadHashCodeByComponent = new HashMap<UUID, ContentHash>();
                this.uploadHashCode.put(componentId, uploadHashCodeByComponent);
            }
            uploadHashCodeByComponent.put(itemId, hashcode);
        }
        map = this.modTimes;
        synchronized (map) {
            Map<UUID, Long> modTimesByComponent = this.modTimes.get(componentId);
            if (modTimesByComponent == null) {
                modTimesByComponent = new HashMap<UUID, Long>();
                this.modTimes.put(componentId, modTimesByComponent);
            }
            modTimesByComponent.put(itemId, modificationStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineDelimiterFailure(LineDelimiterUploadFailure failedUpload) {
        UUID componentId = failedUpload.getUploadHandler().getComponent().getItemId();
        Map<UUID, List<LineDelimiterUploadFailure>> map = this.lineDelimiterFailures;
        synchronized (map) {
            List<LineDelimiterUploadFailure> lineDelimiterFailuresByComponent = this.lineDelimiterFailures.get(componentId);
            if (lineDelimiterFailuresByComponent == null) {
                lineDelimiterFailuresByComponent = new ArrayList<LineDelimiterUploadFailure>();
                this.lineDelimiterFailures.put(componentId, lineDelimiterFailuresByComponent);
            }
            lineDelimiterFailuresByComponent.add(failedUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodingUploadFailure(EncodingUploadFailure failedUpload) {
        UUID componentId = failedUpload.getUploadHandler().getComponent().getItemId();
        Map<UUID, List<EncodingUploadFailure>> map = this.encodingFailures;
        synchronized (map) {
            List<EncodingUploadFailure> encodingFailuresByComponent = this.encodingFailures.get(componentId);
            if (encodingFailuresByComponent == null) {
                encodingFailuresByComponent = new ArrayList<EncodingUploadFailure>();
                this.encodingFailures.put(componentId, encodingFailuresByComponent);
            }
            encodingFailuresByComponent.add(failedUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFailure(UploadFailure failedUpload) {
        UUID componentId = failedUpload.getUploadHandler().getComponent().getItemId();
        UUID itemId = failedUpload.getUploadHandler().getVersionable().getItemId();
        Map<UUID, Map<UUID, UploadFailure>> map = this.uploadFailures;
        synchronized (map) {
            Map<UUID, UploadFailure> failuresByComponent = this.uploadFailures.get(componentId);
            if (failuresByComponent == null) {
                failuresByComponent = new HashMap<UUID, UploadFailure>();
                this.uploadFailures.put(componentId, failuresByComponent);
            }
            failuresByComponent.put(itemId, failedUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LineDelimiterUploadFailure> clearLineDelimiterFailures() {
        Map<UUID, List<LineDelimiterUploadFailure>> map = this.lineDelimiterFailures;
        synchronized (map) {
            ArrayList<LineDelimiterUploadFailure> allLineDelimiterFailures = new ArrayList<LineDelimiterUploadFailure>();
            for (List<LineDelimiterUploadFailure> failures : this.lineDelimiterFailures.values()) {
                allLineDelimiterFailures.addAll(failures);
            }
            this.lineDelimiterFailures.clear();
            return allLineDelimiterFailures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EncodingUploadFailure> clearEncodingFailures() {
        Map<UUID, List<EncodingUploadFailure>> map = this.encodingFailures;
        synchronized (map) {
            ArrayList<EncodingUploadFailure> allEncodingFailures = new ArrayList<EncodingUploadFailure>();
            for (List<EncodingUploadFailure> failures : this.encodingFailures.values()) {
                allEncodingFailures.addAll(failures);
            }
            this.encodingFailures.clear();
            return allEncodingFailures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus[] getUploadFailureStatuses() {
        Map<UUID, Map<UUID, UploadFailure>> map = this.uploadFailures;
        synchronized (map) {
            ArrayList<IStatus> allFailureStatuses = new ArrayList<IStatus>();
            for (Map<UUID, UploadFailure> failedFileUploads : this.uploadFailures.values()) {
                for (UploadFailure failure : failedFileUploads.values()) {
                    allFailureStatuses.add(failure.getStatus());
                }
            }
            return allFailureStatuses.toArray(new IStatus[allFailureStatuses.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CheckinUploadHandler> clearFilesNeedingConversion() {
        List<CheckinUploadHandler> list = this.filesNeedingConversion;
        synchronized (list) {
            ArrayList<CheckinUploadHandler> result = new ArrayList<CheckinUploadHandler>(this.filesNeedingConversion);
            this.filesNeedingConversion.clear();
            return result;
        }
    }

    public boolean isUploadFailed(IComponentHandle component, IVersionableHandle target) {
        if (this.uploadFailures.isEmpty()) {
            return false;
        }
        Map<UUID, UploadFailure> uploadFailuresByComponent = this.uploadFailures.get(component.getItemId());
        return uploadFailuresByComponent != null && uploadFailuresByComponent.containsKey(target.getItemId());
    }

    public FileContent getContent(IComponentHandle component, IVersionableHandle versionable) {
        FileContent content = null;
        Map<UUID, FileContent> contentbyComponent = this.uploadContent.get(component.getItemId());
        if (contentbyComponent != null) {
            content = contentbyComponent.get(versionable.getItemId());
        }
        return content;
    }

    public String getContentType(IComponentHandle component, IVersionableHandle versionable) {
        String contentType = null;
        Map<UUID, String> contentTypeByComponent = this.uploadContentType.get(component.getItemId());
        if (contentTypeByComponent != null) {
            contentType = contentTypeByComponent.get(versionable.getItemId());
        }
        return contentType;
    }

    public IShareable getShareable(IComponentHandle component, IVersionableHandle versionable) {
        IShareable shareable = null;
        Map<UUID, IShareable> shareables = this.uploadShareables.get(component.getItemId());
        if (shareables != null) {
            shareable = shareables.get(versionable.getItemId());
        }
        return shareable;
    }

    public Long getContentSize(IComponentHandle component, IVersionableHandle versionable) {
        Long contentSize = null;
        Map<UUID, Long> contentSizeByComponent = this.uploadContentSize.get(component.getItemId());
        if (contentSizeByComponent != null) {
            contentSize = contentSizeByComponent.get(versionable.getItemId());
        }
        return contentSize;
    }

    public ContentHash getHashCode(IComponentHandle component, IVersionableHandle versionable) {
        ContentHash hash = null;
        Map<UUID, ContentHash> hashCodeByComponent = this.uploadHashCode.get(component.getItemId());
        if (hashCodeByComponent != null) {
            hash = hashCodeByComponent.get(versionable.getItemId());
        }
        return hash;
    }

    public Long getModTime(IComponentHandle component, IVersionableHandle versionable) {
        Long modTime = null;
        Map<UUID, Long> modTimeByComponent = this.modTimes.get(component.getItemId());
        if (modTimeByComponent != null) {
            modTime = modTimeByComponent.get(versionable.getItemId());
        }
        return modTime;
    }

    public void clearUploadInfo() {
        this.uploadContentSize.clear();
        this.uploadHashCode.clear();
        this.uploadContent.clear();
        this.uploadContentType.clear();
        this.uploadShareables.clear();
        this.modTimes.clear();
    }
}

