/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ApplyAcceptedOperation;
import com.ibm.team.filesystem.client.internal.operations.FailedAutoResolveRequest;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoResolveOperation
extends FileSystemOperation
implements IAutoResolveConflictsOperation {
    private final AutoResolveConflictsDilemmaHandler problemHandler;
    private ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler;
    private MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler;
    private ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler;
    private OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
    private int conflictsResolvedCount;
    private Shed shed;
    private final HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> contentConflicts;
    private final HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> autoMergeableConflicts;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    public AutoResolveOperation(AutoResolveConflictsDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler;
        this.applyAcceptedDilemmaHandler = this.problemHandler.getApplyAcceptedDilemmaHandler();
        if (this.problemHandler.getApplyAcceptedDilemmaHandler() == null) {
            this.applyAcceptedDilemmaHandler = ApplyAcceptedDilemmaHandler.getDefault();
        }
        this.markAsMergedDilemmaHandler = this.problemHandler.getMarkAsMergedDilemmaHandler();
        if (this.markAsMergedDilemmaHandler == null) {
            this.markAsMergedDilemmaHandler = MarkAsMergedDilemmaHandler.getDefault();
        }
        this.changePropertiesDilemmaHandler = this.problemHandler.getChangePropertiesDilemmaHandler();
        if (this.changePropertiesDilemmaHandler == null) {
            this.changePropertiesDilemmaHandler = ChangePropertiesDilemmaHandler.getDefault();
        }
        this.outOfSyncDilemmaHandler = this.problemHandler.getOutOfSyncDilemmaHandler();
        if (this.outOfSyncDilemmaHandler == null) {
            this.outOfSyncDilemmaHandler = OutOfSyncDilemmaHandler.getDefault();
        }
        this.contentConflicts = new HashMap();
        this.autoMergeableConflicts = new HashMap();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.conflictsResolvedCount = 0;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final Set<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        if (AutoResolveOperation.this.verifyInSyncEnabled() && !AutoResolveOperation.this.outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync()) {
                            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(AutoResolveOperation.this.outOfSyncDilemmaHandler);
                            for (ConfigurationDescriptor configuration : affectedConfigurations) {
                                verifyOp.addToVerify(configuration.getConnection(null), configuration.componentHandle);
                            }
                            verifyOp.run((IProgressMonitor)progress.newChild(7));
                        }
                        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
                        ICopyFileAreaLockRequest lockRequest = cfaManager.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                        ICopyFileAreasLock lock = cfaManager.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            Map sandboxes = AutoResolveOperation.this.getAffectedCFA(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
                            AutoResolveOperation autoResolveOperation = AutoResolveOperation.this;
                            autoResolveOperation.conflictsResolvedCount = autoResolveOperation.conflictsResolvedCount + AutoResolveOperation.this.performAutoMerge(sandboxes, (IProgressMonitor)progress.newChild(90));
                        }
                        finally {
                            lock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                }
            };
            this.runWithinFileSystemLock(op, Messages.AutoResolveOperation_2, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations() throws FileSystemClientException {
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        this.getAffectedConfigurations(this.contentConflicts, configurations);
        this.getAffectedConfigurations(this.autoMergeableConflicts, configurations);
        return configurations;
    }

    private Map<ConfigurationDescriptor, List<ISandbox>> getAffectedCFA(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affectedConfigurations.size());
        HashMap<ConfigurationDescriptor, List<ISandbox>> result = new HashMap<ConfigurationDescriptor, List<ISandbox>>();
        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
        for (ConfigurationDescriptor descriptor : affectedConfigurations) {
            ArrayList<Sandbox> sandboxes = new ArrayList<Sandbox>(2);
            result.put(descriptor, sandboxes);
            Collection<ICopyFileArea> cfas = cfaManager.getCopyFileAreasForConfiguration(descriptor, (IProgressMonitor)progress.newChild(1));
            for (ICopyFileArea cfa : cfas) {
                sandboxes.add(new Sandbox(cfa));
            }
        }
        return result;
    }

    private void getAffectedConfigurations(HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> requests, HashSet<ConfigurationDescriptor> configurations) {
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestByContext : requests.values()) {
            for (List<AutoResolveRequest> requestByReport : requestByContext.values()) {
                for (AutoResolveRequest request : requestByReport) {
                    configurations.add(request.getAffectedConfiguation());
                }
            }
        }
    }

    @Override
    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }

    private int performAutoMerge(Map<ConfigurationDescriptor, List<ISandbox>> affectedCFA, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.contentConflicts.size() + this.autoMergeableConflicts.size()));
        int mergeCount = 0;
        mergeCount += this.performStructuralAutoMerge((IProgressMonitor)progress.newChild(this.autoMergeableConflicts.size()));
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestsByContext : this.contentConflicts.values()) {
            SubMonitor contextProgress = progress.newChild(1);
            ArrayList<IFileItemHandle> filesToFetch = new ArrayList<IFileItemHandle>();
            ArrayList<ISymbolicLinkHandle> symbolicLinksToFetch = new ArrayList<ISymbolicLinkHandle>();
            ArrayList<IFolderHandle> foldersToFetch = new ArrayList<IFolderHandle>();
            IWorkspaceConnection wc = null;
            int workRemaining = 0;
            for (List<AutoResolveRequest> requests : requestsByContext.values()) {
                for (AutoResolveRequest request : requests) {
                    if (wc == null) {
                        wc = request.connection;
                    }
                    if (request.getCommonAncestorState() instanceof IFileItemHandle) {
                        filesToFetch.add((IFileItemHandle)request.getCommonAncestorState());
                    }
                    if (request.getCommonAncestorState() instanceof ISymbolicLinkHandle) {
                        symbolicLinksToFetch.add((ISymbolicLinkHandle)request.getCommonAncestorState());
                    }
                    if (request.getProposedContributorState() instanceof IFileItemHandle) {
                        filesToFetch.add((IFileItemHandle)request.getProposedContributorState());
                    }
                    if (request.getProposedContributorState() instanceof ISymbolicLinkHandle) {
                        symbolicLinksToFetch.add((ISymbolicLinkHandle)request.getProposedContributorState());
                    }
                    if (this.isQualifyingFolderAddAddConflict(request.logicalChange)) {
                        IFolderHandle handle = (IFolderHandle)request.getCommonAncestorState();
                        if (handle != null) {
                            foldersToFetch.add(handle);
                        }
                        if ((handle = (IFolderHandle)request.getProposedContributorState()) != null) {
                            foldersToFetch.add(handle);
                        }
                        if ((handle = (IFolderHandle)request.getSelectedContributorState()) != null) {
                            foldersToFetch.add(handle);
                        }
                    }
                    ++workRemaining;
                }
            }
            contextProgress.setWorkRemaining(100);
            Map<UUID, IVersionable> fetched = this.fetchItems(wc, filesToFetch, foldersToFetch, symbolicLinksToFetch, (IProgressMonitor)contextProgress.newChild(25));
            ArrayList<FailedAutoResolveRequest> unknownTypes = new ArrayList<FailedAutoResolveRequest>();
            ArrayList<FailedAutoResolveRequest> itemsWithNoHandlers = new ArrayList<FailedAutoResolveRequest>();
            HashMap<ILogicalConflictReport, List<ILogicalChange>> resolvedConflicts = new HashMap<ILogicalConflictReport, List<ILogicalChange>>();
            SubMonitor subProgress = contextProgress.newChild(25).setWorkRemaining(workRemaining);
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> entry : requestsByContext.entrySet()) {
                ArrayList<ILogicalChange> resolvedItems = new ArrayList<ILogicalChange>();
                resolvedConflicts.put(entry.getKey(), resolvedItems);
                for (AutoResolveRequest autoResolveRequest : entry.getValue()) {
                    IVersionable proposedItem;
                    IVersionableHandle commonAncestor = autoResolveRequest.getCommonAncestorState();
                    IVersionableHandle proposed = autoResolveRequest.getProposedContributorState();
                    if (proposed == null) continue;
                    IVersionable commonAncestorItem = null;
                    if (commonAncestor != null) {
                        commonAncestorItem = fetched.get(commonAncestor.getStateId());
                    }
                    if ((proposedItem = fetched.get(proposed.getStateId())) == null) continue;
                    try {
                        List<ISandbox> sandboxes = affectedCFA.get(autoResolveRequest.configurationDescriptor);
                        SubMonitor itemProgress = subProgress.newChild(1).setWorkRemaining(sandboxes.size());
                        for (ISandbox sandbox : sandboxes) {
                            SubMonitor sandboxItemProgress = itemProgress.newChild(1).setWorkRemaining(100);
                            Shareable shareable = (Shareable)sandbox.findShareable(autoResolveRequest.connection.getContextHandle(), ((AutoResolveRequest)autoResolveRequest).configurationDescriptor.componentHandle, autoResolveRequest.logicalChange.item(), (IProgressMonitor)sandboxItemProgress.newChild(2));
                            if (shareable == null) continue;
                            ResourceType type = shareable.getResourceType((IProgressMonitor)sandboxItemProgress.newChild(1));
                            IVersionableHandle shareableVersionable = shareable.getVersionable((IProgressMonitor)sandboxItemProgress.newChild(1));
                            if (type == ResourceType.FOLDER && ResourceType.getResourceType(shareableVersionable) == ResourceType.FOLDER) {
                                if (!this.isQualifyingFolderAddAddConflict(autoResolveRequest.logicalChange)) continue;
                                boolean success = false;
                                IVersionable selectedItem = fetched.get(autoResolveRequest.getSelectedContributorState().getStateId());
                                if (selectedItem != null && selectedItem.getName().equals(proposedItem.getName()) && shareable.getLocalPath().lastSegment().equals(proposedItem.getName()) && selectedItem.getParent().sameItemId((IItemHandle)proposedItem.getParent())) {
                                    if (!shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(49))) {
                                        if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(48)))) {
                                            success = true;
                                        }
                                    } else {
                                        success = true;
                                    }
                                }
                                if (!success) continue;
                                resolvedItems.add(autoResolveRequest.logicalChange);
                                continue;
                            }
                            if (type == ResourceType.FILE && ResourceType.getResourceType(shareableVersionable) == ResourceType.FILE) {
                                AutoResolveState resolveState = new AutoResolveState(type);
                                resolveState.executableMerged = this.performExecutablePropertyMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(1));
                                resolveState.propertiesMerged = this.performFilePropertyAutoMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, sandboxItemProgress.newChild(3));
                                if (autoResolveRequest.logicalChange.isChangeType(4) && !autoResolveRequest.logicalChange.isModificationChange(4)) {
                                    resolveState.contentMerged = true;
                                }
                                if (!autoResolveRequest.logicalChange.isChangeType(1)) {
                                    resolveState.addMerged = true;
                                }
                                if (!(!resolveState.propertiesMerged || resolveState.contentMerged && resolveState.addMerged)) {
                                    IFileContentMerger fileContentMerger = SharingManager.getInstance().getFileContentMerger();
                                    IStatus status = fileContentMerger.performAutoMerge(wc.teamRepository(), (IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, null, this.shed, (IProgressMonitor)sandboxItemProgress.newChild(89));
                                    if (status.isOK()) {
                                        resolveState.contentMerged = true;
                                    } else if (status.getCode() == 1002) {
                                        unknownTypes.add(new FailedAutoResolveRequest(autoResolveRequest, shareable, true, resolveState));
                                    } else if (status.getCode() == 1001) {
                                        itemsWithNoHandlers.add(new FailedAutoResolveRequest(autoResolveRequest, shareable, true, resolveState));
                                    }
                                }
                                if (this.isQualifyingAddAddChange(autoResolveRequest.logicalChange) && proposedItem.getName().equals(shareable.getLocalPath().lastSegment())) {
                                    if (shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(2))) {
                                        if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(1)))) {
                                            resolveState.addMerged = true;
                                        }
                                    } else {
                                        resolveState.addMerged = true;
                                    }
                                }
                                if (!resolveState.isMerged()) continue;
                                resolvedItems.add(autoResolveRequest.logicalChange);
                                continue;
                            }
                            if (type != ResourceType.SYMBOLIC_LINK || ResourceType.getResourceType(shareableVersionable) != ResourceType.SYMBOLIC_LINK) continue;
                            AutoResolveState resolveState = new AutoResolveState(type);
                            resolveState.propertiesMerged = this.performPropertyAutoMerge(commonAncestorItem, proposedItem, shareable, sandboxItemProgress.newChild(3));
                            if (autoResolveRequest.logicalChange.isChangeType(4) && !autoResolveRequest.logicalChange.isModificationChange(4)) {
                                resolveState.contentMerged = true;
                            }
                            if (!autoResolveRequest.logicalChange.isChangeType(1)) {
                                resolveState.addMerged = true;
                            }
                            if (resolveState.propertiesMerged && (!resolveState.contentMerged || !resolveState.addMerged) && shareable.getFileStorage().getTarget((IProgressMonitor)sandboxItemProgress.newChild(1)).equals(((ISymbolicLink)proposedItem).getTarget())) {
                                resolveState.contentMerged = true;
                            }
                            if (this.isQualifyingAddAddChange(autoResolveRequest.logicalChange) && proposedItem.getName().equals(shareable.getLocalPath().lastSegment())) {
                                if (shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(2))) {
                                    if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(1)))) {
                                        resolveState.addMerged = true;
                                    }
                                } else {
                                    resolveState.addMerged = true;
                                }
                            }
                            if (!resolveState.isMerged()) continue;
                            resolvedItems.add(autoResolveRequest.logicalChange);
                        }
                    }
                    catch (Exception e) {
                        this.collectStatus(FileSystemStatus.getStatusFor(e));
                    }
                }
            }
            if (!itemsWithNoHandlers.isEmpty() || !unknownTypes.isEmpty()) {
                FailedAutoResolveRequest failedRequest;
                SubMonitor itemProgress;
                subProgress = contextProgress.newChild(25).setWorkRemaining(100);
                int n = this.problemHandler.missingStorageMerger(Collections.unmodifiableCollection(unknownTypes), Collections.unmodifiableCollection(itemsWithNoHandlers), (IProgressMonitor)subProgress.newChild(5));
                if (n == 2) {
                    throw new FileSystemClientException(new FileSystemStatus(4, Messages.AutoResolveOperation_0));
                }
                if (n == 1) {
                    throw new OperationCanceledException();
                }
                ITeamRepository teamRepository = wc.teamRepository();
                subProgress.setWorkRemaining(unknownTypes.size() + itemsWithNoHandlers.size());
                for (IFailedAutoResolveRequest iFailedAutoResolveRequest : unknownTypes) {
                    itemProgress = subProgress.newChild(1).setWorkRemaining(100);
                    failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                    if (!failedRequest.isRetryMerge()) continue;
                    this.retryFileContentMerge(teamRepository, failedRequest, fetched, resolvedConflicts, (IProgressMonitor)itemProgress);
                }
                for (IFailedAutoResolveRequest iFailedAutoResolveRequest : itemsWithNoHandlers) {
                    itemProgress = subProgress.newChild(1).setWorkRemaining(100);
                    failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                    if (!failedRequest.isRetryMerge()) continue;
                    this.retryFileContentMerge(teamRepository, failedRequest, fetched, resolvedConflicts, (IProgressMonitor)itemProgress);
                }
            }
            contextProgress.setWorkRemaining(resolvedConflicts.size());
            for (Map.Entry<Object, List<AutoResolveRequest>> entry : resolvedConflicts.entrySet()) {
                try {
                    MarkAsMergedOperation markAsMergedOperation = new MarkAsMergedOperation(wc, (ILogicalConflictReport)entry.getKey(), (Collection<? extends ILogicalChange>)entry.getValue(), this.markAsMergedDilemmaHandler);
                    this.disableVerifyInSync(markAsMergedOperation);
                    if (this.nonAtomicCommitIsAnOption) {
                        markAsMergedOperation.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                    } else {
                        markAsMergedOperation.disableNonAtomicCommit();
                    }
                    markAsMergedOperation.run((IProgressMonitor)contextProgress.newChild(1));
                    mergeCount += entry.getValue().size();
                }
                catch (Exception exception) {
                    this.collectStatus(FileSystemStatus.getStatusFor(exception));
                }
            }
        }
        return mergeCount;
    }

    private boolean performPropertyAutoMerge(IVersionable commonAncestorItem, IVersionable proposedItem, Shareable shareable, SubMonitor newChild) {
        return true;
    }

    private boolean isQualifyingFolderAddAddConflict(ILogicalChange change) {
        return change.item() instanceof IFolderHandle && this.isQualifyingAddAddChange(change);
    }

    private boolean isQualifyingAddAddChange(ILogicalChange change) {
        IVersionableHandle versionableConflictedWith;
        ILogicalConflict conflict;
        return change.kind() == 1 && ((ILogicalConflict)change).conflictType() == 1 && (conflict = (ILogicalConflict)change).conflictingItems().size() == 1 && (versionableConflictedWith = (IVersionableHandle)conflict.conflictingItems().iterator().next()).sameItemId((IItemHandle)conflict.item());
    }

    private boolean performExecutablePropertyMerge(IFileItem commonAncestorItem, IFileItem proposedItem, IShareable selectedItem, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (proposedItem.isExecutable() == ((Shareable)selectedItem).getFileStorage().isExecutable((IProgressMonitor)monitor.newChild(30))) {
            return true;
        }
        if (commonAncestorItem == null) {
            return false;
        }
        if (proposedItem.isExecutable() == commonAncestorItem.isExecutable()) {
            return true;
        }
        boolean merged = ((Shareable)selectedItem).getFileStorage().setExecutable(proposedItem.isExecutable(), (IProgressMonitor)monitor.newChild(65));
        if (merged) {
            LocalChangeManager.getInstance().computeChanges(selectedItem, (IProgressMonitor)monitor.newChild(5));
        }
        return merged;
    }

    private void retryFileContentMerge(ITeamRepository teamRepository, FailedAutoResolveRequest request, Map<UUID, IVersionable> fetched, HashMap<ILogicalConflictReport, List<ILogicalChange>> resolvedConflicts, IProgressMonitor progress) {
        SubMonitor itemProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        AutoResolveRequest modModConflict = request.getRequest();
        IVersionableHandle commonAncestor = modModConflict.getCommonAncestorState();
        IVersionableHandle proposed = modModConflict.getProposedContributorState();
        if (!(modModConflict.logicalChange.item() instanceof IFileItemHandle)) {
            return;
        }
        IFileItem commonAncestorItem = (IFileItem)fetched.get(commonAncestor.getStateId());
        IFileItem proposedItem = (IFileItem)fetched.get(proposed.getStateId());
        if (proposedItem == null) {
            return;
        }
        try {
            IFileContentMerger fileContentMerger;
            IStatus status;
            IShareable shareable = request.getConflictedShareable();
            ResourceType type = shareable.getResourceType((IProgressMonitor)itemProgress.newChild(1));
            if (type == ResourceType.FILE && (status = (fileContentMerger = SharingManager.getInstance().getFileContentMerger()).performAutoMerge(teamRepository, commonAncestorItem, proposedItem, shareable, request.getDefaultContentTypeMerger(), this.shed, (IProgressMonitor)itemProgress.newChild(94))).isOK()) {
                request.getResolveState().contentMerged = true;
                LocalChangeManager.getInstance().computeChanges(shareable, (IProgressMonitor)itemProgress.newChild(5));
                if (request.getResolveState().isMerged()) {
                    List<ILogicalChange> resolvedItems = resolvedConflicts.get(modModConflict.conflictReport);
                    resolvedItems.add(modModConflict.logicalChange);
                }
            }
        }
        catch (Exception e) {
            this.collectStatus(FileSystemStatus.getStatusFor(e));
        }
    }

    private int performStructuralAutoMerge(IProgressMonitor progress) {
        int mergeCount = 0;
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestByContext : this.autoMergeableConflicts.values()) {
            IWorkspaceConnection wc = null;
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> autoMergeable : requestByContext.entrySet()) {
                ILogicalConflictReport conflictReport = autoMergeable.getKey();
                ArrayList<ILogicalChange> conflictsToAutoResolve = new ArrayList<ILogicalChange>();
                for (AutoResolveRequest request : autoMergeable.getValue()) {
                    if (wc == null) {
                        wc = request.connection;
                    }
                    conflictsToAutoResolve.add(request.logicalChange);
                }
                try {
                    ApplyAcceptedOperation op = new ApplyAcceptedOperation(wc, conflictReport, conflictsToAutoResolve, this.applyAcceptedDilemmaHandler);
                    this.disableVerifyInSync(op);
                    op.run(progress);
                    mergeCount += conflictsToAutoResolve.size();
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatus.getStatusFor(4, Messages.AutoResolveOperation_1, (Throwable)e));
                }
            }
        }
        return mergeCount;
    }

    private Map<UUID, IVersionable> fetchItems(IWorkspaceConnection wc, List<IFileItemHandle> toFetch, ArrayList<IFolderHandle> foldersToFetch, ArrayList<ISymbolicLinkHandle> symbolicLinksToFetch, IProgressMonitor progress) throws TeamRepositoryException {
        List fetched;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(toFetch.size() + foldersToFetch.size()));
        HashMap<UUID, IVersionable> result = new HashMap<UUID, IVersionable>();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository());
        if (!toFetch.isEmpty()) {
            fetched = manager.versionableManager().fetchCompleteStates(toFetch, (IProgressMonitor)monitor.newChild(toFetch.size()));
            for (IVersionable item : fetched) {
                result.put(item.getStateId(), item);
            }
        }
        if (!foldersToFetch.isEmpty()) {
            fetched = manager.versionableManager().fetchCompleteStates(foldersToFetch, (IProgressMonitor)monitor.newChild(foldersToFetch.size()));
            for (IVersionable item : fetched) {
                result.put(item.getStateId(), item);
            }
        }
        if (!symbolicLinksToFetch.isEmpty()) {
            fetched = manager.versionableManager().fetchCompleteStates(symbolicLinksToFetch, (IProgressMonitor)monitor.newChild(foldersToFetch.size()));
            for (IVersionable item : fetched) {
                result.put(item.getStateId(), item);
            }
        }
        return result;
    }

    private boolean performFilePropertyAutoMerge(IFileItem commonAncestorItem, IFileItem proposedItem, Shareable shareable, SubMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        final boolean[] success = new boolean[]{true};
        ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler = new ChangePropertiesDilemmaHandler(){

            @Override
            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }

            @Override
            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 0;
            }

            @Override
            public int inconsistentLineDelimiters(List<IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemClientException {
                success[0] = false;
                return AutoResolveOperation.this.problemHandler.getChangePropertiesDilemmaHandler().inconsistentLineDelimiters(inconsistentDelimiters, monitor);
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return AutoResolveOperation.this.problemHandler.getBackupDilemmaHandler();
            }
        };
        IChangeFilePropertiesOperation op = null;
        IFileContent proposedContent = proposedItem.getContent();
        IFileContent commonAncestorContent = null;
        if (commonAncestorItem != null) {
            commonAncestorContent = commonAncestorItem.getContent();
        }
        progress.setWorkRemaining(100);
        String currentContentType = shareable.getContentType((IProgressMonitor)progress.newChild(10));
        String proposedContentType = proposedItem.getContentType();
        String commonAncestorContentType = "";
        if (commonAncestorItem != null) {
            commonAncestorContentType = commonAncestorItem.getContentType();
        }
        if (!commonAncestorContentType.equals(proposedContentType)) {
            if (currentContentType == null || currentContentType.equals(commonAncestorContentType)) {
                op = IOperationFactory.instance.getChangeFilePropertiesOperation(changePropertiesDilemmaHandler);
                op.setContentType(shareable, proposedContentType);
            } else if (!currentContentType.equals(proposedContentType)) {
                success[0] = false;
            }
        }
        FileLineDelimiter currentLineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(10));
        FileLineDelimiter proposedLineDelimiter = proposedContent.getLineDelimiter();
        FileLineDelimiter commonAncestorLineDelimiter = null;
        if (commonAncestorContent != null) {
            commonAncestorLineDelimiter = commonAncestorContent.getLineDelimiter();
        }
        if (success[0] && commonAncestorLineDelimiter != proposedLineDelimiter) {
            if (currentLineDelimiter == null || currentLineDelimiter == commonAncestorLineDelimiter) {
                if (op == null) {
                    op = IOperationFactory.instance.getChangeFilePropertiesOperation(changePropertiesDilemmaHandler);
                }
                op.setLineDelimiter(shareable, proposedLineDelimiter);
            } else if (currentLineDelimiter != proposedLineDelimiter) {
                success[0] = false;
            }
        }
        if (success[0] && op != null) {
            this.disableVerifyInSync(op);
            op.run((IProgressMonitor)progress.newChild(80));
        }
        return success[0];
    }

    @Override
    public void autoResolveConflict(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange) {
        if (conflictReport == null) {
            throw new IllegalArgumentException();
        }
        if (logicalChange == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        IUpdateReport report = conflictReport.conflictReport();
        IItemConflictReport conflictFound = null;
        for (IItemConflictReport conflictedItem : report.conflicts()) {
            if (!conflictedItem.item().sameItemId((IItemHandle)logicalChange.item())) continue;
            conflictFound = conflictedItem;
            break;
        }
        if (conflictFound == null) {
            ++this.conflictsResolvedCount;
        } else {
            AutoResolveRequest request = new AutoResolveRequest(connection, conflictReport, logicalChange, conflictFound);
            if (request.isContentConflict()) {
                this.addRequest(this.contentConflicts, request);
            } else if (request.isAutoMergeable()) {
                this.addRequest(this.autoMergeableConflicts, request);
            }
        }
    }

    private void addRequest(HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> requests, AutoResolveRequest request) {
        List<AutoResolveRequest> requestsForReport;
        IContextHandle context = request.getAffectedConfiguation().connectionHandle;
        HashMap<Object, List<AutoResolveRequest>> requestsForContext = requests.get(context.getItemId());
        if (requestsForContext == null) {
            requestsForContext = new HashMap();
            requests.put(context.getItemId(), requestsForContext);
            requestsForReport = new ArrayList<AutoResolveRequest>();
            requestsForContext.put(request.conflictReport, requestsForReport);
        } else {
            requestsForReport = requestsForContext.get(request.conflictReport);
            if (requestsForReport == null) {
                requestsForReport = new ArrayList<AutoResolveRequest>();
                requestsForContext.put(request.conflictReport, requestsForReport);
            }
        }
        requestsForReport.add(request);
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    public final class AutoResolveRequest {
        private final IItemConflictReport conflict;
        private final ILogicalChange logicalChange;
        private final ILogicalConflictReport conflictReport;
        private IWorkspaceConnection connection;
        private final ConfigurationDescriptor configurationDescriptor;

        public AutoResolveRequest(IWorkspaceConnection workspaceConnection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange, IItemConflictReport conflict) {
            this.conflict = conflict;
            this.logicalChange = logicalChange;
            this.conflictReport = conflictReport;
            this.connection = workspaceConnection;
            this.configurationDescriptor = new ConfigurationDescriptor((IConnection)workspaceConnection, logicalChange.component());
        }

        public ConfigurationDescriptor getAffectedConfiguation() {
            return this.configurationDescriptor;
        }

        public IVersionableHandle getProposedContributorState() {
            return this.conflict.getProposedContributorState();
        }

        public IVersionableHandle getCommonAncestorState() {
            return this.conflict.getCommonAncestorState();
        }

        public IVersionableHandle getSelectedContributorState() {
            return this.conflict.getSelectedContributorState();
        }

        public boolean isContentConflict() {
            ILogicalConflict logicalConflict;
            int conflictType;
            return this.logicalChange != null && this.logicalChange.kind() == 1 && ((conflictType = (logicalConflict = (ILogicalConflict)this.logicalChange).conflictType()) == 1 || conflictType == 9);
        }

        public boolean isAutoMergeable() {
            return this.logicalChange != null && this.logicalChange.kind() == 2;
        }
    }

    public final class AutoResolveState {
        boolean executableMerged = false;
        boolean propertiesMerged = false;
        boolean contentMerged = false;
        boolean addMerged = false;
        ResourceType mergeType;

        public AutoResolveState(ResourceType type) {
            this.mergeType = type;
        }

        boolean isMerged() {
            if (this.mergeType == ResourceType.FILE) {
                return this.executableMerged && this.propertiesMerged && this.contentMerged && this.addMerged;
            }
            if (this.mergeType == ResourceType.SYMBOLIC_LINK) {
                return this.propertiesMerged && this.contentMerged && this.addMerged;
            }
            return false;
        }
    }
}

