/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.magic;

import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.common.FileLineDelimiter;

public class ContentProperties
implements IContentProperties {
    private final String contentTypeForMerge;
    private final boolean isContentTypeText;
    private final String encoding;
    private final String mimeType;
    private final FileLineDelimiter lineDelimiter;
    public static final IContentProperties UNKNOWN = new ContentProperties(IContentProperties.CHARACTER_ENCODING_UNKNOWN, "application/unknown", FileLineDelimiter.LINE_DELIMITER_NONE);

    public ContentProperties(String encoding, String mimeType, FileLineDelimiter lineDelimiter, String contentTypeForMerge, boolean isContentTypeText) {
        this.contentTypeForMerge = contentTypeForMerge;
        this.encoding = encoding == null ? IContentProperties.CHARACTER_ENCODING_UNKNOWN : encoding;
        this.mimeType = mimeType;
        this.isContentTypeText = isContentTypeText;
        this.lineDelimiter = lineDelimiter;
    }

    public ContentProperties(String encoding, String mimeType, FileLineDelimiter lineDelimiter) {
        this.contentTypeForMerge = null;
        this.encoding = encoding == null ? IContentProperties.CHARACTER_ENCODING_UNKNOWN : encoding;
        this.mimeType = mimeType;
        this.isContentTypeText = false;
        this.lineDelimiter = lineDelimiter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public FileLineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getContentTypeForMerge() {
        return this.contentTypeForMerge;
    }

    public boolean isText() {
        return this.isContentTypeText || this.mimeType.startsWith("text");
    }

    public boolean isContentTypeText() {
        return this.isContentTypeText;
    }
}

