/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.localchanges.LocalDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalModification;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SynchronizationTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalChangeManager
implements ILocalChangeManager {
    public static final IRepositoryResolver DEFAULT_RESOLVER = new DefaultRepoResolver();
    private Object avoidNotification = new Object();
    private int avoidNotificationCount = 0;
    public static final ILocalChange[] NO_CHANGES = new ILocalChange[0];
    private static volatile LocalChangeManager instance;
    public static String RECOMPUTE_PENDING_CHANGES_FAMILY;
    private Set<RefreshRequest> toRefresh = new HashSet<RefreshRequest>();
    private Object refreshLock = new Object();
    private Map<LocalChangeContext, LocalChangeTracker> trackers = new HashMap<LocalChangeContext, LocalChangeTracker>();
    private LocalChangeNotifier notifier = new LocalChangeNotifier();
    private RecomputePendingChangesJob recomputeJob = new RecomputePendingChangesJob();
    private static final String BACKUP_NAME = "#apo";

    static {
        RECOMPUTE_PENDING_CHANGES_FAMILY = RecomputePendingChangesJob.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalChangeManager getInstance() {
        LocalChangeManager i = instance;
        if (i != null) return i;
        Class<LocalChangeManager> clazz = LocalChangeManager.class;
        synchronized (LocalChangeManager.class) {
            i = instance;
            if (i != null) return i;
            instance = i = new LocalChangeManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return i;
        }
    }

    private LocalChangeManager() {
    }

    @Override
    public void addLocalChangeListener(ILocalChangeListener listener) {
        this.notifier.addListener(listener);
    }

    public String getProgressDescription(ILocalChange change) {
        if ((change instanceof LocalModification || change instanceof LocalAddition) && change.getTarget() instanceof IFileItemHandle) {
            return NLS.bind((String)Messages.LocalChangeManager_3, (Object)change.getPath());
        }
        if (change instanceof LocalDeletion) {
            return NLS.bind((String)Messages.LocalChangeManager_4, (Object)change.getPath());
        }
        if (change instanceof LocalAddition) {
            return NLS.bind((String)Messages.LocalChangeManager_5, (Object)change.getPath());
        }
        if (change instanceof LocalMoveFrom) {
            return NLS.bind((String)Messages.LocalChangeManager_7, (Object)change.getPath());
        }
        if (change instanceof LocalMoveTo) {
            return NLS.bind((String)Messages.LocalChangeManager_8, (Object)change.getResultingPath());
        }
        LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LocalChangeManager_9, (Object)this.getClass().getName())));
        return Messages.LocalChangeManager_10;
    }

    public void cancelChanges(IShare share) {
        LocalChangeTracker tracker = this.findTracker(share);
        if (tracker != null) {
            tracker.cancelChanges(tracker.getPendingChanges(share.getPath(), false));
        }
    }

    private LocalChangeTracker findTracker(IShare share) {
        ISharingDescriptor desc = share.getSharingDescriptor();
        return this.findTracker(desc.getConnectionHandle(), desc.getComponent(), share.getSandbox().getRoot());
    }

    private Map<LocalChangeContext, List<ILocalChange>> getChangesMap(ILocalChange[] changes) {
        HashMap<LocalChangeContext, List<ILocalChange>> changesMap = new HashMap<LocalChangeContext, List<ILocalChange>>();
        ILocalChange[] iLocalChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            LocalChangeContext ctx = ((LocalChange)c).context;
            if (ctx != null) {
                ArrayList<ILocalChange> changesList = (ArrayList<ILocalChange>)changesMap.get(ctx);
                if (changesList == null) {
                    changesList = new ArrayList<ILocalChange>();
                    changesMap.put(ctx, changesList);
                }
                changesList.add(c);
            }
            ++n2;
        }
        return changesMap;
    }

    public void cancelChanges(ILocalChange[] canceled) {
        for (Map.Entry<LocalChangeContext, List<ILocalChange>> entry : this.getChangesMap(canceled).entrySet()) {
            LocalChangeTracker tracker = this.findTracker(entry.getKey());
            tracker.cancelChanges(entry.getValue().toArray(new ILocalChange[entry.getValue().size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(IContextHandle connection, IComponentHandle component, IPath cfaRoot) {
        LocalChangeTracker tracker = null;
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            tracker = this.trackers.remove(new LocalChangeContext(component, connection, cfaRoot));
        }
        if (tracker != null) {
            tracker.cancelAllChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(IPath cfaRoot) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            Iterator<LocalChangeContext> i = this.trackers.keySet().iterator();
            while (i.hasNext()) {
                LocalChangeContext c = i.next();
                if (!c.getRoot().equals((Object)cfaRoot)) continue;
                i.remove();
            }
        }
    }

    public void commitChanges(ILocalChange[] committed) {
        for (Map.Entry<LocalChangeContext, List<ILocalChange>> entry : this.getChangesMap(committed).entrySet()) {
            LocalChangeTracker tracker = this.findTracker(entry.getKey());
            tracker.confirmChanges(entry.getValue().toArray(new ILocalChange[entry.getValue().size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshSynchronously(IShare givenShare, IShareable refreshRoot, ILocalChangeManager.RefreshType traversalType, IProgressMonitor progress) throws FileSystemClientException {
        ILocalChange[] newChanges;
        ILocalChange[] existingChanges;
        Share share = (Share)givenShare;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        LocalChangeTracker tracker = share.getTracker();
        LocalChangeNotifier.disableChangeNotification();
        try {
            ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(share.getCopyFileAreaPath());
            try {
                Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)monitor.newChild(1));
                AbstractLock rule = CFALockUtil.createAndLockForUpdate(share.getCopyFileAreaPath(), share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), (IProgressMonitor)monitor.newChild(1));
                try {
                    LocalChangeTracker localChangeTracker = tracker;
                    synchronized (localChangeTracker) {
                        existingChanges = tracker.getPendingChanges(true);
                        LocalChangeTracker.computePendingChanges(refreshRoot, traversalType, (IProgressMonitor)monitor.newChild(93));
                        tracker.syncChanges((IProgressMonitor)monitor.newChild(5));
                        newChanges = tracker.getPendingChanges();
                    }
                }
                finally {
                    CFALockUtil.endBatching(rule, (IProgressMonitor)monitor.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule(trackingRule);
            }
        }
        finally {
            LocalChangeNotifier.enableChangeNotification();
        }
        this.notifier.changesCanceled(tracker.getContext(), existingChanges);
        this.notifier.changesOccurred(tracker.getContext(), newChanges);
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh(IProgressMonitor monitor) throws FileSystemClientException {
        Set<RefreshRequest> snapshot;
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.toRefresh.isEmpty()) {
                return;
            }
            snapshot = this.toRefresh;
            this.toRefresh = new HashSet<RefreshRequest>();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LocalChangeManager_11, (int)snapshot.size());
        try {
            for (RefreshRequest current : snapshot) {
                this.refreshSynchronously(current.getShare(), current.getRootShareable(), current.getTraversalType(), (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeTracker findTracker(LocalChangeContext ctx) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            block5: {
                LocalChangeTracker tracker = this.trackers.get(ctx);
                if (tracker != null) {
                    return tracker;
                }
                if (ICopyFileAreaManager.instance.copyFileAreaExists(ctx.getRoot(), 0)) break block5;
                return null;
            }
            return this.getTracker(ctx.getConnection(), ctx.getComponent(), ctx.getRoot(), SharingManager.getInstance().getTrackingRule(ctx.getRoot()));
        }
    }

    public LocalChangeTracker findTracker(IContextHandle connection, IComponentHandle component, IPath cfaRoot) {
        return this.findTracker(new LocalChangeContext(component, connection, cfaRoot));
    }

    @Override
    public ILocalChange getPendingChange(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
        if (share == null) {
            return NoOpChange.NO_OP;
        }
        return this.getPendingChange(share, shareable.getVersionable((IProgressMonitor)progress.newChild(50)));
    }

    @Override
    public ILocalChange getPendingChange(IShare share, IVersionableHandle versionable) {
        LocalChangeTracker tracker = this.findTracker(share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), share.getSandbox().getRoot());
        return tracker == null ? NoOpChange.NO_OP : tracker.getPendingChange(versionable);
    }

    @Override
    public void syncPendingChanges(IContextHandle connection, IComponentHandle component, ISandbox sandbox, IProgressMonitor monitor) {
        LocalChangeTracker tracker = this.findTracker(connection, component, sandbox.getRoot());
        if (tracker != null) {
            tracker.syncChanges(monitor);
        }
    }

    @Override
    public ILocalChange[] getPendingChanges(IContextHandle connection, IComponentHandle component, ISandbox sandbox) {
        LocalChangeTracker tracker = this.findTracker(connection, component, sandbox.getRoot());
        if (tracker == null) {
            return NO_CHANGES;
        }
        return tracker.getPendingChanges();
    }

    @Override
    public ILocalChange[] getPendingChanges(IShareable[] startingPoints, IProgressMonitor monitor) throws FileSystemClientException {
        HashMap<LocalChangeContext, ArrayList<IShareable>> shareableMap = new HashMap<LocalChangeContext, ArrayList<IShareable>>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)startingPoints.length);
        IShareable[] iShareableArray = startingPoints;
        int n = startingPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable s = iShareableArray[n2];
            IShare share = s.getShare((IProgressMonitor)progress.newChild(1));
            if (share != null) {
                ISharingDescriptor desc = share.getSharingDescriptor();
                LocalChangeContext ctx = new LocalChangeContext(desc.getComponent(), desc.getConnectionHandle(), s.getSandbox().getRoot());
                ArrayList<IShareable> shareables = (ArrayList<IShareable>)shareableMap.get(ctx);
                if (shareables == null) {
                    shareables = new ArrayList<IShareable>();
                    shareableMap.put(ctx, shareables);
                }
                shareables.add(s);
            }
            ++n2;
        }
        ArrayList<ILocalChange> result = new ArrayList<ILocalChange>();
        for (Map.Entry entry : shareableMap.entrySet()) {
            LocalChangeTracker tracker = this.findTracker((LocalChangeContext)entry.getKey());
            if (tracker == null) continue;
            for (IShareable s : (List)entry.getValue()) {
                result.addAll(Arrays.asList(tracker.getPendingChanges(s.getLocalPath(), false)));
            }
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    public IShareable getShareable(LocalChange change) {
        Assert.isNotNull((Object)change.path);
        Assert.isNotNull((Object)change.target);
        Assert.isNotNull((Object)change.context);
        IPath path = change.isType(16) ? change.getResultingPath() : change.getPath();
        SharingManager sm = SharingManager.getInstance();
        ISandbox sandbox = sm.getSandbox(change.context.getRoot(), false);
        return sandbox.findShareable(path, ResourceType.getResourceType(change.getTarget()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeTracker getTracker(IContextHandle connection, IComponentHandle component, IPath cfaRoot, ISchedulingRule schedulingRule) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            LocalChangeContext context = new LocalChangeContext(component, connection, cfaRoot);
            LocalChangeTracker tracker = this.trackers.get(context);
            if (tracker == null) {
                tracker = new LocalChangeTracker(this.notifier, context, schedulingRule);
                this.trackers.put(context, tracker);
            }
            return tracker;
        }
    }

    public void loadChanges(IShare share, IProgressMonitor monitor) throws FileSystemClientException {
        IShareable rootShareable = share.getSandbox().findShareable(share.getPath(), ResourceType.getResourceType(share.getSharingDescriptor().getRootVersionable()));
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(share.getSandbox().getRoot());
        try {
            Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)progress.newChild(5));
            LocalChangeTracker.computePendingChanges(rootShareable, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            Job.getJobManager().endRule(trackingRule);
            progress.done();
        }
    }

    public void refreshAllChanges(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare[] shares = SharingManager.getInstance().allShares((IProgressMonitor)progress.newChild(1));
        this.refreshChanges(shares, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
        progress.done();
    }

    public void computeChanges(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        LocalChangeTracker.computePendingChanges(shareable, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
    }

    public void refreshChanges(Collection<IShareable> shareables, IProgressMonitor progress) throws FileSystemClientException {
        this.refreshChanges(shareables, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, progress);
    }

    public void refreshChanges(Collection<IShareable> shareables, ILocalChangeManager.RefreshType type, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(shareables.size() * 2));
        for (IShareable shareable : shareables) {
            IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            if (share == null) {
                throw new IllegalArgumentException("Refresh root must be shared: " + shareable.getLocalPath().toPortableString());
            }
            this.addToRefresh(share, shareable, type);
        }
        monitor.setWorkRemaining(1);
        this.doRefresh((IProgressMonitor)monitor.newChild(1));
    }

    public void refreshChanges(IShare share, IShareable startingPoint, IProgressMonitor monitor) throws FileSystemClientException {
        this.addToRefresh(share, startingPoint, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN);
        this.doRefresh(monitor);
    }

    public void refreshChanges(IShareable shareable, ILocalChangeManager.RefreshType refreshType, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
        if (share == null) {
            throw new IllegalArgumentException("Refresh root not shared.");
        }
        this.refreshSynchronously(share, shareable, refreshType, (IProgressMonitor)monitor.newChild(9));
    }

    public void refreshChanges(IShare[] shares, ILocalChangeManager.RefreshType traversalType, IProgressMonitor monitor) throws FileSystemClientException {
        int i = 0;
        while (i < shares.length) {
            this.addToRefresh(shares[i], null, traversalType);
            ++i;
        }
        this.doRefresh(monitor);
    }

    public void refreshChanges(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare[] allShares = SharingManager.getInstance().allShares((IProgressMonitor)progress.newChild(1));
        int i = 0;
        while (i < allShares.length) {
            ISharingDescriptor sharingDescriptor = allShares[i].getSharingDescriptor();
            if (sharingDescriptor.getComponent().sameItemId((IItemHandle)component) && sharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)connection)) {
                this.addToRefresh(allShares[i], null, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN);
            }
            ++i;
        }
        this.doRefresh((IProgressMonitor)progress.newChild(99));
        progress.done();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void undoChanges(final ILocalChange[] toUndo, IRepositoryResolver repositoryResolver, UndoDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        v0 = undoDilemmaHandler = problemHandler == null ? UndoDilemmaHandler.getDefault() : problemHandler;
        if (toUndo.length == 0) {
            return;
        }
        mgr = SharingManager.getInstance();
        resolver = repositoryResolver == null ? LocalChangeManager.DEFAULT_RESOLVER : repositoryResolver;
        changesMap = new HashMap<LocalChangeContext, Set<LocalChange>[]>();
        repoMap = new HashMap<LocalChangeContext, ITeamRepository>();
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subProgress = progress.newChild(1);
        subProgress.setWorkRemaining(toUndo.length);
        sharelessChanges = new HashMap<IPath, ArrayList<LocalChange>>();
        var16_13 = toUndo;
        var15_14 = toUndo.length;
        var14_17 = 0;
        while (var14_17 < var15_14) {
            c = var16_13[var14_17];
            ch = (LocalChange)c;
            repo = (ITeamRepository)repoMap.get(ch.context);
            if (repo != null) ** GOTO lbl34
            share = (Share)mgr.getShare(ch.context.getRoot(), ch.getPath(), (IProgressMonitor)subProgress.newChild(1));
            if (share == null) {
                changes = (ArrayList<LocalChange>)sharelessChanges.get(ch.context.getRoot());
                if (changes == null) {
                    changes = new ArrayList<LocalChange>();
                    sharelessChanges.put(ch.context.getRoot(), changes);
                }
                changes.add(ch);
            } else {
                repo = resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
                repoMap.put(ch.context, repo);
lbl34:
                // 2 sources

                if ((changes = (Set[])changesMap.get(ch.context)) == null) {
                    changes = new Set[]{new HashSet<E>(), new HashSet<E>(), new HashSet<E>()};
                    changesMap.put(ch.context, changes);
                }
                if (ch.isType(4)) {
                    changes[0].add(ch);
                } else if (ch.isType(2)) {
                    changes[2].add(ch);
                } else if (ch.isType(16)) {
                    changes[1].add((LocalChange)ch.getCounterpart());
                } else {
                    changes[1].add(ch);
                }
            }
            ++var14_17;
        }
        subProgress.done();
        affectedConfigurations = this.getConfigurationsAffected(changesMap, repoMap, progress.newChild(1));
        workspaceLock = WorkspaceLockUtil.acquireRead(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            try {
                mgr.runWithinFileSystemLock(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(toUndo.length + 20));
                        Shed backupShed = new Shed(undoDilemmaHandler.getBackupDilemmaHandler());
                        try {
                            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(undoDilemmaHandler.getOutOfSyncDilemmaHandler());
                            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                                verifyOp.addToVerify(configurationDescriptor.getConnection((IProgressMonitor)progress.newChild(1)), configurationDescriptor.componentHandle);
                            }
                            verifyOp.run((IProgressMonitor)progress.newChild(4));
                            for (Map.Entry entry : changesMap.entrySet()) {
                                LocalChangeTracker tracker = LocalChangeManager.this.findTracker((LocalChangeContext)entry.getKey());
                                Set[] undoPerTracker = (Set[])entry.getValue();
                                ITeamRepository repo = (ITeamRepository)repoMap.get(entry.getKey());
                                LocalChangeManager.this.undoChanges(tracker, repo, (Set[])entry.getValue(), resolver, undoDilemmaHandler, backupShed, (IProgressMonitor)progress.newChild(undoPerTracker[0].size() + undoPerTracker[1].size() + undoPerTracker[2].size()));
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (FileSystemClientException e) {
                            throw new InvocationTargetException((Throwable)((Object)e));
                        }
                    }
                }, null, (IProgressMonitor)progress.newChild(95));
            }
            catch (InvocationTargetException e) {
                cause = e.getCause();
                if (cause instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)cause;
                }
                if (cause instanceof FileSystemClientException) {
                    throw (FileSystemClientException)cause;
                }
                throw new TeamRepositoryException(Messages.LocalChangeManager_12, cause);
            }
            catch (InterruptedException v1) {
                throw new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        if (!sharelessChanges.isEmpty()) {
            progress.setWorkRemaining(sharelessChanges.size() * 10);
            for (Map.Entry entry : sharelessChanges.entrySet()) {
                lock = CFALockUtil.lockExistingForGlobalUpdate((IPath)entry.getKey(), (IProgressMonitor)progress.newChild(1));
                inner = progress.newChild(8);
                inner.setWorkRemaining(((Collection)entry.getValue()).size());
                try {
                    for (LocalChange ch : (Collection)entry.getValue()) {
                        shareable = ch.getShareable();
                        if (shareable == null) continue;
                        try {
                            this.forget(shareable, (IProgressMonitor)inner.newChild(1));
                        }
                        catch (FileSystemClientException v2) {}
                    }
                }
                finally {
                    if (lock != null) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
        }
        progress.done();
    }

    private HashSet<ConfigurationDescriptor> getConfigurationsAffected(Map<LocalChangeContext, Set<LocalChange>[]> changesMap, Map<LocalChangeContext, ITeamRepository> repoMap, SubMonitor progress) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> configurationsAffected = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry<LocalChangeContext, Set<LocalChange>[]> e : changesMap.entrySet()) {
            LocalChangeContext context = e.getKey();
            ITeamRepository repo = repoMap.get(context);
            if (repo == null) continue;
            configurationsAffected.add(new ConfigurationDescriptor(repo.getId(), repo.getRepositoryURI(), context.getConnection(), context.getComponent()));
        }
        return configurationsAffected;
    }

    private void undoChanges(LocalChangeTracker tracker, ITeamRepository repo, Set<LocalChange>[] toUndo, IRepositoryResolver resolver, UpdateDilemmaHandler problemHandler, Shed backupShed, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        if (repo == null) {
            return;
        }
        if (tracker == null) {
            return;
        }
        ISchedulingRule rule = SharingManager.getInstance().getTrackingRule(tracker.getContext().getRoot());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)progress.newChild(1));
            AbstractLock cfaRule = CFALockUtil.lockExistingForUpdate(tracker.getContext().getRoot(), tracker.getContext().getConnection(), tracker.getContext().getComponent(), (IProgressMonitor)progress.newChild(1));
            if (cfaRule == null) {
                return;
            }
            try {
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(tracker.getContext().getRoot());
                tracker.syncChanges((IProgressMonitor)progress.newChild(1));
                Set<LocalChange>[] setArray = toUndo;
                int n = toUndo.length;
                int n2 = 0;
                while (n2 < n) {
                    Set<LocalChange> changeList = setArray[n2];
                    Iterator<LocalChange> i = changeList.iterator();
                    while (i.hasNext()) {
                        LocalChange change = i.next();
                        if (!change.isCanceled()) continue;
                        i.remove();
                    }
                    ++n2;
                }
                this.validateUndoPrereq(tracker, cfa, toUndo[0], toUndo[1], toUndo[2], (IProgressMonitor)progress.newChild(1));
                Object connection = tracker.getContext().getConnection() instanceof IBaselineHandle ? SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection((IBaselineHandle)tracker.getContext().getConnection(), (IProgressMonitor)progress.newChild(1)) : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)tracker.getContext().getConnection(), (IProgressMonitor)progress.newChild(1));
                FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(repo)).getFileSystemService();
                SubMonitor subProgress = progress.newChild(93);
                subProgress.setWorkRemaining(toUndo[0].size() + toUndo[1].size() + toUndo[2].size());
                for (LocalChange c : toUndo[0]) {
                    this.undoDeletion(c, tracker, cfa, (IConnection)connection, fileSystemService, problemHandler, (IProgressMonitor)subProgress.newChild(1));
                }
                int remaining = toUndo[1].size() + toUndo[2].size();
                while (true) {
                    HashSet<LocalChange> changesToUndo = new HashSet<LocalChange>();
                    for (LocalChange c : toUndo[1]) {
                        if (!this.undoChange(c, tracker, cfa, (IConnection)connection, backupShed, (IProgressMonitor)subProgress.newChild(1))) {
                            changesToUndo.add(c);
                            subProgress.setWorkRemaining(remaining);
                            continue;
                        }
                        --remaining;
                    }
                    if (changesToUndo.isEmpty()) break;
                    if (toUndo[1].size() == changesToUndo.size()) {
                        StringBuilder str = new StringBuilder(Messages.LocalChangeManager_13);
                        boolean first = true;
                        for (LocalChange c : changesToUndo) {
                            if (!first) {
                                str.append(", ");
                            } else {
                                first = false;
                            }
                            str.append(c.toString());
                            if (!c.isType(8)) continue;
                            str.append(" - ").append(c.getCounterpart().toString());
                        }
                        throw new IllegalStateException(str.toString());
                    }
                    toUndo[1] = changesToUndo;
                }
                for (LocalChange c : toUndo[2]) {
                    this.undoAddition(c, tracker, cfa, (IConnection)connection, backupShed, (IProgressMonitor)subProgress.newChild(1));
                }
                subProgress.done();
            }
            finally {
                CFALockUtil.endBatching(cfaRule, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUndoPrereq(LocalChangeTracker tracker, CopyFileAreaStore cfa, Set<LocalChange> deletions, final Set<LocalChange> changes, final Set<LocalChange> additions, IProgressMonitor monitor) throws FileSystemClientException {
        for (LocalChange c : deletions) {
            ILocalChange[] chg = tracker.getPendingChangesAt(c.getPath());
            ILocalChange[] iLocalChangeArray = chg;
            int n = chg.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange ch = iLocalChangeArray[n2];
                if (ch.isType(2)) {
                    if (!additions.contains(ch)) {
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_16, (Object)c.getPath(), (Object)ch.getResultingPath())));
                    }
                } else if (ch.isType(8)) {
                    if (!changes.contains(ch)) {
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_17, (Object)c.getPath(), (Object)ch.getResultingPath())));
                    }
                } else if (!ch.equals(c)) {
                    throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_18, (Object)ch, (Object)c));
                }
                ++n2;
            }
        }
        IComponentHandle component = tracker.getContext().getComponent();
        IContextHandle connection = tracker.getContext().getConnection();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.size());
        block5: for (LocalChange c : changes) {
            if (!c.isType(8)) {
                progress.worked(1);
                continue;
            }
            IFolderHandle parent = c.getCounterpart().getTargetParent();
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(2);
            IPath localPath = cfa.getLocalPathFor((IVersionableHandle)parent, component, connection, (IProgressMonitor)subProgress.newChild(1));
            String name = c.getCounterpart().getPath().lastSegment();
            if (localPath != null) {
                ILocalChange[] chg;
                ILocalChange[] iLocalChangeArray = chg = tracker.getPendingChangesAt(localPath.append(name));
                int n = chg.length;
                int n3 = 0;
                while (n3 < n) {
                    ILocalChange ch = iLocalChangeArray[n3];
                    if (ch.isType(2)) {
                        if (!additions.contains(ch)) {
                            throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_19, (Object)c.getResultingPath(), (Object)ch.getResultingPath())));
                        }
                    } else if (ch.isType(8)) {
                        if (!changes.contains(ch)) {
                            throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_20, (Object)c.getResultingPath(), (Object)ch.getResultingPath())));
                        }
                    } else {
                        throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_21, (Object)ch, (Object)c));
                    }
                    ++n3;
                }
            }
            ArrayList<IFolderHandle> parents = new ArrayList<IFolderHandle>();
            HashSet<UUID> seenItems = new HashSet<UUID>();
            seenItems.add(c.getTarget().getItemId());
            ILocalChange lastUndoMove = c;
            while (!cfa.isShareRoot((IVersionableHandle)parent, c.getComponent(), c.getConnection())) {
                parents.add(parent);
                InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)parent, c.getComponent(), c.getConnection());
                if (info == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_InverseMetadataMissing, (Object)c.getShareable().getLocalPath()));
                }
                ILocalChange parentChange = tracker.getPendingChange((IVersionableHandle)parent);
                if (parentChange.isType(4)) {
                    if (!deletions.contains(parentChange)) {
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_22, (Object)lastUndoMove.getResultingPath(), (Object)parentChange.getPath())));
                    }
                    parent = info.getParent();
                } else if (parentChange.isType(2)) {
                    if (additions.contains(parentChange)) continue block5;
                    parent = info.getLocalParent();
                } else if (parentChange.isType(8)) {
                    if (changes.contains(parentChange)) {
                        parent = info.getParent();
                        lastUndoMove = parentChange;
                    } else {
                        parent = info.getLocalParent();
                    }
                } else {
                    parent = info.getLocalParent();
                    if (parent == null) {
                        parent = info.getParent();
                    }
                }
                if (seenItems.contains(parent.getItemId())) {
                    parents.add(parent);
                    subProgress.setWorkRemaining(parents.size());
                    HashMap<UUID, IFolderHandle> parentSet = new HashMap<UUID, IFolderHandle>((int)((double)parents.size() / 0.75));
                    HashSet<UUID> seenParents = new HashSet<UUID>((int)((double)parents.size() / 0.75));
                    int i = 0;
                    while (i < parents.size()) {
                        IFolderHandle ancestor = (IFolderHandle)parents.get(i);
                        ILocalChange ancestorChange = tracker.getPendingChange((IVersionableHandle)ancestor);
                        seenParents.add(ancestor.getItemId());
                        if (ancestorChange.isType(8)) {
                            if (changes.contains(ancestorChange)) {
                                UUID ancestorId;
                                HashSet<UUID> toSearch = new HashSet<UUID>(parentSet.keySet());
                                while ((ancestorId = cfa.getRemoteAncestor(toSearch, (IVersionableHandle)ancestor, c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(1))) != null) {
                                    ILocalChange depChange = tracker.getPendingChange((IVersionableHandle)parentSet.get(ancestorId));
                                    if (!seenParents.contains(depChange.getCounterpart().getTargetParent().getItemId())) {
                                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_23, (Object)ancestorChange.getResultingPath(), (Object)depChange.getResultingPath())));
                                    }
                                    toSearch.remove(ancestorId);
                                }
                            } else {
                                parentSet.put(ancestor.getItemId(), ancestor);
                            }
                        }
                        ++i;
                    }
                    throw new IllegalStateException(Messages.LocalChangeManager_24);
                }
                seenItems.add(parent.getItemId());
            }
            subProgress.done();
        }
        final FileSystemClientException[] ex = new FileSystemClientException[1];
        LocalChangeTracker localChangeTracker = tracker;
        synchronized (localChangeTracker) {
            for (final LocalChange c : additions) {
                c.getNode().basicAccept(new LocalChangeNode.IVisitor(){

                    public boolean visit(LocalChange toVisit) {
                        if (toVisit == c) {
                            return true;
                        }
                        if (toVisit.isType(2)) {
                            if (!additions.contains(toVisit)) {
                                ex[0] = new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_25, (Object)c.getResultingPath(), (Object)toVisit.getResultingPath())));
                            }
                        } else if (toVisit.isType(8)) {
                            if (!changes.contains(toVisit)) {
                                ex[0] = new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_26, (Object)c.getResultingPath(), (Object)toVisit.getResultingPath())));
                            }
                        } else if (!toVisit.isType(4)) {
                            throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_27, (Object)toVisit, (Object)c));
                        }
                        return false;
                    }
                });
                if (ex[0] == null) continue;
                throw ex[0];
            }
        }
        progress.done();
    }

    private void undoDeletion(LocalChange c, LocalChangeTracker tracker, CopyFileArea cfa, IConnection connection, FileSystemServiceProxy fileSystemService, UpdateDilemmaHandler updateDilemmaHandler, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        LoadTree loadTree = fileSystemService.getFileTreeByVersionable(connection, c.getComponent(), new IVersionableHandle[]{c.getTarget()}, -1, true, null, (IProgressMonitor)progress);
        FileAreaUpdateReport updates = this.getUpdatesForDeletion(c, tracker, loadTree.getFileAreaUpdates());
        ComponentStateSummary stateSummary = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
        stateSummary.setComponent(c.getComponent());
        stateSummary.setConfigurationState(((SynchronizationTime)loadTree.getConfigurationState()).getTime());
        List<ComponentStateSummary> stateSummaries = Collections.singletonList(stateSummary);
        SharingManager mgr = SharingManager.getInstance();
        progress.worked(50);
        IPath parentPath = cfa.getLocalPathFor((IVersionableHandle)c.getTargetParent(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1));
        if (parentPath == null) {
            this.forget(c.getShareable(), (IProgressMonitor)progress.newChild(1));
        } else {
            progress.setWorkRemaining(100);
            mgr.getUpdateMutator(connection, stateSummaries, stateSummaries, updates, Collections.singletonList(cfa), updateDilemmaHandler, null).run((IProgressMonitor)progress.newChild(100));
        }
        progress.done();
    }

    private FileAreaUpdateReport getUpdatesForDeletion(LocalChange c, LocalChangeTracker tracker, List<FileAreaUpdate> updates) throws TeamRepositoryException {
        FileAreaUpdateReport result = FilesystemDTOFactory.eINSTANCE.createFileAreaUpdateReport();
        HashSet<UUID> excludedParents = new HashSet<UUID>();
        for (FileAreaUpdate update : updates) {
            if (c.getTarget().sameItemId((IItemHandle)update.getItem()) || !excludedParents.contains(update.getDestinationParent().getItemId()) && tracker.getPendingChange(update.getItem()).getType() == 0) {
                result.getAdds().add(update);
                continue;
            }
            excludedParents.add(update.getItem().getItemId());
        }
        return result;
    }

    private void preserve(IFileStorage storage, IProgressMonitor monitor) throws FileSystemClientException {
        IFileStorage parent = ((Shareable)storage.getShareable().getParent()).getFileStorage();
        String baseName = String.valueOf(storage.getName()) + BACKUP_NAME;
        int i = 2;
        String name = baseName;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        while (parent.getChild(name, (IProgressMonitor)progress.newChild(1)) != null) {
            name = String.valueOf(baseName) + Integer.toString(i++);
            progress.setWorkRemaining(100);
        }
        Share share = (Share)storage.getShareable().getShare((IProgressMonitor)progress.newChild(18));
        ResourceType hint = storage.getResourceType((IProgressMonitor)progress.newChild(1));
        if (hint == null) {
            hint = ResourceType.getResourceType(storage.getShareable().getVersionable((IProgressMonitor)progress.newChild(1)));
        }
        Shareable target = share.getShareable(parent.getShareable().getLocalPath().append(name), hint);
        storage.move(target.getSandbox(), target.getLocalPath(), (IProgressMonitor)progress.newChild(80));
        progress.done();
    }

    private boolean undoChange(LocalChange c, LocalChangeTracker tracker, CopyFileAreaStore cfa, IConnection connection, Shed backupShed, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        IFileStorage storage;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IPath localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1));
        SharingManager sm = SharingManager.getInstance();
        ISandbox sandbox = sm.getSandbox(c.context.getRoot(), false);
        Shareable shareable = sm.findShareable(sandbox, localPath, ResourceType.getResourceType(c.getTarget()));
        if (c.isType(8)) {
            SubMonitor subProgress = progress.newChild(c.isType(1) ? 19 : 99);
            subProgress.setWorkRemaining(100);
            IPath oldPath = cfa.getLocalPathFor((IVersionableHandle)c.getCounterpart().getTargetParent(), c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(20)).append(c.getCounterpart().getPath().lastSegment());
            if (localPath.isPrefixOf(oldPath)) {
                subProgress.done();
                progress.done();
                return false;
            }
            Shareable targetShareable = sm.findShareable(sandbox, oldPath, ResourceType.getResourceType(c.getTarget()));
            IFileStorage target = targetShareable.getFileStorage();
            IFileStorage existingChild = ((Shareable)targetShareable.getParent()).getFileStorage().getChild(target.getName(), (IProgressMonitor)subProgress.newChild(1));
            if (existingChild != null && (sandbox.isCaseSensitive() || !this.isSamePathWithCaseChangeInName(oldPath, localPath))) {
                this.preserve(existingChild, (IProgressMonitor)subProgress.newChild(19));
            }
            if (oldPath.isPrefixOf(localPath)) {
                localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(20));
                shareable = sm.findShareable(sandbox, localPath, ResourceType.getResourceType(c.getTarget()));
            }
            subProgress.setWorkRemaining(40);
            shareable.getFileStorage().move(targetShareable.getSandbox(), targetShareable.getLocalPath(), (IProgressMonitor)subProgress.newChild(40));
            localPath = oldPath;
            shareable = targetShareable;
            subProgress.done();
        }
        FileItemInfo oldInfo = null;
        if (c.isType(1)) {
            progress.setWorkRemaining(100);
            oldInfo = cfa.getItemInfo(localPath);
            if (oldInfo == null) {
                return true;
            }
            if (oldInfo.getVersionableHandle() instanceof IFileItemHandle) {
                storage = shareable.getFileStorage();
                FileContent content = FilesystemFactory.eINSTANCE.createFileContent();
                ContentHash prev = oldInfo.getStoredPredecessorHintHash();
                content.setPredecessorHint(prev);
                content.setLineDelimiter(oldInfo.getOriginalLineDelimiter());
                content.setSize(oldInfo.getStoredSize());
                content.setCharacterEncoding(oldInfo.getStoredEncoding());
                content.setHash(oldInfo.getStoredHash());
                content.setLineDelimiterCount(oldInfo.getStoredNumLineDelimiters());
                boolean isExecutable = oldInfo.isExecutable();
                boolean isOriginalExecutable = oldInfo.isOriginalExecutable();
                String contentType = oldInfo.getContentType();
                String originalContentType = oldInfo.getOriginalContentType();
                IFileContentManager contentManager = FileSystemCore.getContentManager(connection.teamRepository());
                DigestComputingInputStream is = ContentHash.getDigestComputingStream((InputStream)contentManager.retrieveContentStream((IFileItemHandle)c.getTarget(), (IFileContent)content, (IProgressMonitor)progress.newChild(68)));
                storage.setContents((InputStream)is, backupShed, (IProgressMonitor)new CancellationMonitor((IProgressMonitor)progress));
                FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), false, storage.getModificationStamp(), oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), ContentHash.valueOf((byte[])is.getFinalDigest()), is.getContentSize(), content.getLineDelimiter(), content.getLineDelimiter(), originalContentType, contentType, content.getPredecessorHintHash(), content.getSize(), content.getCharacterEncoding(), content.getHash(), content.getLineDelimiterCount(), isExecutable, isOriginalExecutable);
                cfa.setItemInfo(shareable.getLocalPath(), newInfo, (IProgressMonitor)progress.newChild(1));
                oldInfo = newInfo;
            } else if (oldInfo.getVersionableHandle() instanceof ISymbolicLinkHandle) {
                ISymbolicLink item = (ISymbolicLink)SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).versionableManager().fetchCompleteState(oldInfo.getVersionableHandle(), (IProgressMonitor)progress.newChild(1));
                String target = item.getTarget();
                IFileStorage storage2 = shareable.getFileStorage();
                storage2.setTarget(backupShed, target, (IProgressMonitor)progress.newChild(1));
                String targetOnDisk = storage2.getTarget((IProgressMonitor)progress.newChild(1));
                try {
                    FileItemInfo newInfo = new FileItemInfo((ISymbolicLinkHandle)oldInfo.getVersionableHandle(), false, oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), LocalChangeTracker.getLinkHash(targetOnDisk), oldInfo.getStoredHash());
                    cfa.setItemInfo(shareable.getLocalPath(), newInfo, (IProgressMonitor)progress.newChild(1));
                    oldInfo = newInfo;
                }
                catch (ContentHashAlgorithmException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        }
        if (c.isType(32)) {
            progress.setWorkRemaining(1);
            if (oldInfo == null) {
                oldInfo = cfa.getItemInfo(localPath);
            }
            if (oldInfo == null) {
                return true;
            }
            storage = shareable.getFileStorage();
            storage.setExecutable(oldInfo.isOriginalExecutable(), (IProgressMonitor)progress.newChild(1));
            FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), false, storage.getModificationStamp(), oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getOriginalLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getOriginalContentType(), oldInfo.getStoredPredecessorHintHash(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredHash(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isOriginalExecutable(), oldInfo.isOriginalExecutable());
            cfa.setItemInfo(shareable.getLocalPath(), newInfo, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return true;
    }

    private boolean isSamePathWithCaseChangeInName(IPath oldPath, IPath localPath) {
        return oldPath.segmentCount() == localPath.segmentCount() && oldPath.removeLastSegments(1).equals((Object)localPath.removeLastSegments(1)) && oldPath.lastSegment().toUpperCase().equals(localPath.lastSegment().toUpperCase());
    }

    private void undoAddition(LocalChange c, LocalChangeTracker tracker, CopyFileAreaStore cfa, IConnection connection, Shed backupShed, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IPath localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1));
        if (localPath != null) {
            SharingManager sm = SharingManager.getInstance();
            ISandbox sandbox = sm.getSandbox(c.context.getRoot(), false);
            Shareable shareable = sm.findShareable(sandbox, localPath, ResourceType.getResourceType(c.getTarget()));
            shareable.getFileStorage().delete(backupShed, (IProgressMonitor)progress.newChild(99));
        }
        progress.done();
    }

    @Override
    public void removeLocalChangeListener(ILocalChangeListener listener) {
        this.notifier.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(IShare share, IShareable root, ILocalChangeManager.RefreshType traversalType) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.toRefresh.add(new RefreshRequest(share, root, traversalType));
            this.recomputeJob.schedule(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(IShare share, IShareable root) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.toRefresh.add(new RefreshRequest(share, root, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN));
            this.recomputeJob.schedule(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAvoidNotify() {
        Object object = this.avoidNotification;
        synchronized (object) {
            ++this.avoidNotificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAvoidNotify() throws FileSystemClientException {
        Object object = this.avoidNotification;
        synchronized (object) {
            --this.avoidNotificationCount;
            Assert.isTrue((this.avoidNotificationCount >= 0 ? 1 : 0) != 0, (String)"Unmatched start/end notification");
            if (this.avoidNotificationCount < 0) {
                this.avoidNotificationCount = 0;
            }
            if (this.avoidNotificationCount == 0) {
                this.notifier.scheduleNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled() {
        Object object = this.avoidNotification;
        synchronized (object) {
            return this.avoidNotificationCount == 0;
        }
    }

    @Override
    public ILocalChange[] getPendingChanges(IShare[] startingPoints) {
        HashMap<LocalChangeContext, ArrayList<IPath>> pathMap = new HashMap<LocalChangeContext, ArrayList<IPath>>();
        IShare[] iShareArray = startingPoints;
        int n = startingPoints.length;
        int n2 = 0;
        while (n2 < n) {
            ISharingDescriptor desc;
            IShare share = iShareArray[n2];
            if (share != null && (desc = share.getSharingDescriptor()) != null) {
                LocalChangeContext ctx = new LocalChangeContext(desc.getComponent(), desc.getConnectionHandle(), share.getSandbox().getRoot());
                ArrayList<IPath> paths = (ArrayList<IPath>)pathMap.get(ctx);
                if (paths == null) {
                    paths = new ArrayList<IPath>();
                    pathMap.put(ctx, paths);
                }
                paths.add(share.getPath());
            }
            ++n2;
        }
        ArrayList<ILocalChange> result = new ArrayList<ILocalChange>();
        for (Map.Entry entry : pathMap.entrySet()) {
            LocalChangeTracker tracker = this.findTracker((LocalChangeContext)entry.getKey());
            if (tracker == null) continue;
            for (IPath path : (List)entry.getValue()) {
                result.addAll(Arrays.asList(tracker.getPendingChanges(path, false)));
            }
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    @Override
    public void undoChanges(ILocalChange[] toUndo, UndoDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.undoChanges(toUndo, null, problemHandler, monitor);
    }

    @Override
    public boolean isContentDirty(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(shareable.getSandbox().getRoot(), (IProgressMonitor)progress.newChild(10));
        if (lock == null) {
            throw new IllegalArgumentException("The cfa must exist");
        }
        try {
            FileItemInfo itemInfo = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot()).getItemInfo(shareable.getLocalPath());
            if (itemInfo != null && !itemInfo.isFolder()) {
                if (shareable.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER) {
                    return true;
                }
                boolean bl = itemInfo.isContentChanged();
                return bl;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(10));
        }
    }

    @Override
    public void combineDeleteAdd(ILocalChange deletion, ILocalChange addition, IProgressMonitor monitor) throws FileSystemClientException {
        this.combineDeleteAdd(DEFAULT_RESOLVER, deletion, addition, monitor);
    }

    public void combineDeleteAdd(IRepositoryResolver resolver, final ILocalChange deletion, final ILocalChange addition, IProgressMonitor monitor) throws FileSystemClientException {
        if (deletion == null || !deletion.isType(4)) {
            throw new IllegalArgumentException();
        }
        if (addition == null || !addition.isType(2)) {
            throw new IllegalArgumentException();
        }
        if (!deletion.getConnection().sameItemId((IItemHandle)addition.getConnection())) {
            throw new IllegalArgumentException("Changes must be in the same workspace");
        }
        if (!deletion.getComponent().sameItemId((IItemHandle)addition.getComponent())) {
            throw new IllegalArgumentException("Changes must be in the same component");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SharingManager mgr = SharingManager.getInstance();
        IShareable del = deletion.getShareable();
        if (del == null) {
            throw new IllegalArgumentException();
        }
        IShareable add = addition.getShareable();
        if (add == null) {
            throw new IllegalArgumentException();
        }
        if (!del.getSandbox().getRoot().equals((Object)add.getSandbox().getRoot())) {
            throw new IllegalArgumentException("Changes have different roots");
        }
        final IVersionableHandle item = deletion.getTarget();
        if (item == null) {
            throw new IllegalArgumentException("No versionable");
        }
        IShare share = del.getShare((IProgressMonitor)progress.newChild(1));
        if (share == null) {
            throw new IllegalArgumentException();
        }
        ITeamRepository repo = resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
        final ISandbox sandbox = ((Share)share).getSandbox();
        ConfigurationDescriptor desc = new ConfigurationDescriptor(repo.getId(), repo.getRepositoryURI(), addition.getConnection(), addition.getComponent());
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireRead(Collections.singleton(desc), (IProgressMonitor)progress.newChild(1));
        try {
            try {
                final FileSystemClientException[] ex = new FileSystemClientException[1];
                mgr.runWithinFileSystemLock(new IRunnableWithProgress(){

                    public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                        try {
                            LocalChangeTracker tracker = LocalChangeManager.this.findTracker(((LocalChange)addition).context);
                            if (tracker == null) {
                                throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "The tracker has been unregistered"));
                            }
                            ISchedulingRule rule = SharingManager.getInstance().getTrackingRule(tracker.getContext().getRoot());
                            try {
                                Job.getJobManager().beginRule(rule, (IProgressMonitor)mon.newChild(1));
                                AbstractLock lock = CFALockUtil.lockExistingForUpdate(tracker.getContext().getRoot(), tracker.getContext().getConnection(), tracker.getContext().getComponent(), (IProgressMonitor)mon.newChild(1));
                                if (lock == null) {
                                    throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "The CFA has been unregistered"));
                                }
                                try {
                                    LocalChangeManager.this.syncPendingChanges(addition.getConnection(), addition.getComponent(), sandbox, (IProgressMonitor)mon.newChild(1));
                                    if (addition.isCanceled()) {
                                        throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "addition cancelled"));
                                    }
                                    if (deletion.isCanceled()) {
                                        throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "deletion cancelled"));
                                    }
                                    LocalChangeManager.this.combineDeleteAddInternal(CopyFileAreaManager.instance.getExistingCopyFileArea(tracker.getContext().getRoot()), item, deletion, addition, (IProgressMonitor)mon.newChild(96));
                                    LocalChangeManager.this.syncPendingChanges(addition.getConnection(), addition.getComponent(), sandbox, (IProgressMonitor)mon.newChild(1));
                                }
                                finally {
                                    CFALockUtil.endBatching(lock, (IProgressMonitor)mon.newChild(1));
                                }
                            }
                            finally {
                                Job.getJobManager().endRule(rule);
                            }
                        }
                        catch (FileSystemClientException e) {
                            ex[0] = e;
                        }
                        mon.done();
                    }
                }, null, (IProgressMonitor)progress.newChild(98));
                if (ex[0] != null) {
                    throw ex[0];
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                WorkspaceLockUtil.release(workspaceLock);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                WorkspaceLockUtil.release(workspaceLock);
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void combineDeleteAddInternal(CopyFileAreaStore cfa, IVersionableHandle oldItem, ILocalChange deletion, ILocalChange addition, IProgressMonitor monitor) throws FileSystemClientException {
        IComponentHandle comp = deletion.getComponent();
        IContextHandle conn = deletion.getConnection();
        Shareable newRoot = (Shareable)((LocalChange)addition).getShareable();
        LinkedList<Shareable> resources = new LinkedList<Shareable>();
        LinkedList<IVersionableHandle> oldItems = new LinkedList<IVersionableHandle>();
        resources.add(newRoot);
        oldItems.add(oldItem);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        while (!resources.isEmpty()) {
            assert (!oldItems.isEmpty());
            progress.setWorkRemaining(resources.size() + 4);
            Shareable resource = (Shareable)resources.removeFirst();
            IVersionableHandle item = (IVersionableHandle)oldItems.removeFirst();
            InverseFileItemInfo itemInfo = cfa.getItemInfo(item, comp, conn);
            cfa.setItemInfo(resource.getLocalPath(), itemInfo, (IProgressMonitor)progress.newChild(1));
            Map<String, IVersionableHandle> remoteChildren = itemInfo.getRemoteChildren();
            IFileStorage storage = resource.getFileStorage();
            Collection<IFileStorage> localChildren = storage.getChildren((IProgressMonitor)progress.newChild(1));
            if (localChildren != null) {
                SubMonitor subProgress = progress.newChild(1);
                subProgress.setWorkRemaining(localChildren.size());
                for (IFileStorage childStorage : localChildren) {
                    Shareable childShareable = childStorage.getShareable();
                    assert (childShareable.exists((IProgressMonitor)subProgress.newChild(1)));
                    IVersionableHandle childItem = remoteChildren.get(childStorage.getName());
                    if (childItem == null) continue;
                    resources.addFirst(childShareable);
                    oldItems.addFirst(childItem);
                }
            }
            if (resource.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER) continue;
            this.refreshChanges(resource.getShare((IProgressMonitor)progress.newChild(10)), resource, (IProgressMonitor)progress.newChild(10));
        }
        assert (oldItems.isEmpty());
        progress.done();
    }

    @Override
    public void refreshChanges(ISandbox[] sandboxes, ILocalChangeManager.RefreshType traversalType, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + sandboxes.length));
        ArrayList<IShare> allShares = new ArrayList<IShare>();
        ISandbox[] iSandboxArray = sandboxes;
        int n = sandboxes.length;
        int n2 = 0;
        while (n2 < n) {
            ISandbox sandbox = iSandboxArray[n2];
            IShare[] shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
            allShares.addAll(Arrays.asList(shares));
            ++n2;
        }
        if (!allShares.isEmpty()) {
            this.refreshChanges(allShares.toArray(new IShare[allShares.size()]), traversalType, (IProgressMonitor)progress.newChild(100));
        }
    }

    private void forget(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath copyFileAreaRoot = ((Shareable)shareable).getCopyFileAreaRoot();
        AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            cfa.deleteTreeInfo(shareable.getLocalPath(), true, (IProgressMonitor)progress.newChild(74));
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    private static class DefaultRepoResolver
    implements IRepositoryResolver {
        private DefaultRepoResolver() {
        }

        public ITeamRepository getRepoFor(String uri, UUID id) {
            return RepositoryUtils.getTeamRepository(uri, id);
        }
    }

    class RecomputePendingChangesJob
    extends Job {
        public RecomputePendingChangesJob() {
            super(Messages.LocalChangeManager_0);
        }

        public boolean belongsTo(Object family) {
            return RECOMPUTE_PENDING_CHANGES_FAMILY.equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            long start;
            long l = start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                try {
                    LocalChangeManager.this.doRefresh(monitor);
                }
                catch (FileSystemClientException e) {
                    IStatus iStatus = FileSystemStatus.getStatusFor((Throwable)((Object)e));
                    if (Trace.LOG_ELAPSED_TIME) {
                        Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                    }
                    return iStatus;
                }
            }
            finally {
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                }
            }
            return Status.OK_STATUS;
        }
    }

    public static class RefreshRequest {
        private final IShare share;
        private final IShareable startingPoint;
        private final ILocalChangeManager.RefreshType traversalType;

        public RefreshRequest(IShare share, IShareable startingPoint, ILocalChangeManager.RefreshType traversalType) {
            this.share = share;
            this.startingPoint = startingPoint;
            this.traversalType = traversalType;
        }

        public IShareable getRootShareable() {
            if (this.startingPoint != null) {
                return this.startingPoint;
            }
            return this.share.getShareable();
        }

        public IShare getShare() {
            return this.share;
        }

        public IShareable getStartingPoint() {
            return this.startingPoint;
        }

        public ILocalChangeManager.RefreshType getTraversalType() {
            return this.traversalType;
        }
    }
}

