/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.internal.load.IUpdateInfo;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateOrder
implements IUpdateInfo {
    private List<FileAreaUpdate> folderAdds;
    private List<FileAreaUpdate> linkAdds;
    private List<FileAreaUpdate> fileAdds;
    private List<FileAreaUpdate> orderedDeletes;
    private Map<UUID, Set<UUID>> movedOrDeletedItemIds = new HashMap<UUID, Set<UUID>>();
    private List<FileAreaUpdate> folderMoves;
    private List<FileAreaUpdate> linkMoves;
    private List<FileAreaUpdate> fileMoves;
    private List<FileAreaUpdate> groupedModifies;

    public UpdateOrder(Collection<FileAreaUpdate> adds, Collection<FileAreaUpdate> deletes, Collection<FileAreaUpdate> moves, Collection<FileAreaUpdate> modifies) {
        this.orderAdds(adds);
        this.orderModifies(modifies);
        this.orderDeletes(deletes);
        this.orderMoves(moves);
    }

    @Override
    public List<FileAreaUpdate> getOrderedDeletes() {
        return this.orderedDeletes;
    }

    private void orderDeletes(Collection<FileAreaUpdate> deletes) {
        this.orderedDeletes = new ArrayList<FileAreaUpdate>(deletes.size());
        HashMap<UUID, List<FileAreaUpdate>> groupedDeletes = this.group(deletes);
        for (Map.Entry<UUID, List<FileAreaUpdate>> entry : groupedDeletes.entrySet()) {
            UUID componentItemId = entry.getKey();
            List<FileAreaUpdate> deleteGrouping = entry.getValue();
            HashMap<UUID, List<FileAreaUpdate>> deleteParentage = new HashMap<UUID, List<FileAreaUpdate>>();
            for (FileAreaUpdate delete : deleteGrouping) {
                UUID parentId = delete.getSourceParent().getItemId();
                List<FileAreaUpdate> children = deleteParentage.get(parentId);
                if (children == null) {
                    children = new ArrayList<FileAreaUpdate>();
                    deleteParentage.put(parentId, children);
                }
                children.add(delete);
                Set<UUID> movedOrDeletedItems = this.movedOrDeletedItemIds.get(componentItemId);
                if (movedOrDeletedItems == null) {
                    movedOrDeletedItems = new HashSet<UUID>();
                    this.movedOrDeletedItemIds.put(componentItemId, movedOrDeletedItems);
                }
                movedOrDeletedItems.add(delete.getItem().getItemId());
            }
            this.orderedDeletes.addAll(this.calculateOrdering(deleteParentage));
        }
    }

    @Override
    public List<FileAreaUpdate> getFolderAdds() {
        return this.folderAdds;
    }

    @Override
    public List<FileAreaUpdate> getLinkAdds() {
        return this.linkAdds;
    }

    @Override
    public List<FileAreaUpdate> getFileAdds() {
        return this.fileAdds;
    }

    private void orderAdds(Collection<FileAreaUpdate> adds) {
        this.folderAdds = new ArrayList<FileAreaUpdate>(adds.size() / 2 + 1);
        this.fileAdds = new ArrayList<FileAreaUpdate>(adds.size() / 2 + 1);
        this.linkAdds = new ArrayList<FileAreaUpdate>();
        HashMap<UUID, List<FileAreaUpdate>> orderedAdds = this.calculateOrderedAdds(adds);
        for (List<FileAreaUpdate> grouping : orderedAdds.values()) {
            for (FileAreaUpdate add : grouping) {
                if (add.getItem() instanceof IFolderHandle) {
                    this.folderAdds.add(add);
                    continue;
                }
                if (add.getItem() instanceof IFileItemHandle) {
                    this.fileAdds.add(add);
                    continue;
                }
                if (!(add.getItem() instanceof ISymbolicLinkHandle)) continue;
                this.linkAdds.add(add);
            }
        }
    }

    @Override
    public List<FileAreaUpdate> getFolderMoves() {
        return this.folderMoves;
    }

    @Override
    public List<FileAreaUpdate> getLinkMoves() {
        return this.linkMoves;
    }

    @Override
    public List<FileAreaUpdate> getFileMoves() {
        return this.fileMoves;
    }

    private void orderMoves(Collection<FileAreaUpdate> moves) {
        this.folderMoves = new ArrayList<FileAreaUpdate>();
        this.linkMoves = new ArrayList<FileAreaUpdate>();
        this.fileMoves = new ArrayList<FileAreaUpdate>();
        for (FileAreaUpdate move : moves) {
            if (move.getItem() instanceof IFolderHandle) {
                this.folderMoves.add(move);
            } else if (move.getItem() instanceof IFileItemHandle) {
                this.fileMoves.add(move);
            } else if (move.getItem() instanceof ISymbolicLinkHandle) {
                this.linkMoves.add(move);
            }
            Set<UUID> movedItems = this.movedOrDeletedItemIds.get(move.getPreviousComponent().getItemId());
            if (movedItems == null) {
                movedItems = new HashSet<UUID>();
                this.movedOrDeletedItemIds.put(move.getPreviousComponent().getItemId(), movedItems);
            }
            movedItems.add(move.getItem().getItemId());
        }
    }

    @Override
    public List<FileAreaUpdate> getGroupedModifies() {
        return this.groupedModifies;
    }

    private void orderModifies(Collection<FileAreaUpdate> modifies) {
        this.groupedModifies = new ArrayList<FileAreaUpdate>(modifies.size());
        HashMap<UUID, List<FileAreaUpdate>> modifiesByComponent = this.group(modifies);
        for (List<FileAreaUpdate> group : modifiesByComponent.values()) {
            this.groupedModifies.addAll(group);
        }
    }

    @Override
    public boolean isMovedOrDeleted(IComponentHandle componentHandle, IVersionableHandle versionableHandle) {
        Set<UUID> movedOrDeleted = this.movedOrDeletedItemIds.get(componentHandle.getItemId());
        return movedOrDeleted != null && movedOrDeleted.contains(versionableHandle.getItemId());
    }

    private HashMap<UUID, List<FileAreaUpdate>> group(Collection<FileAreaUpdate> updates) {
        HashMap<UUID, List<FileAreaUpdate>> groupedUpdates = new HashMap<UUID, List<FileAreaUpdate>>();
        for (FileAreaUpdate update : updates) {
            List<FileAreaUpdate> grouping = groupedUpdates.get(update.component().getItemId());
            if (grouping == null) {
                grouping = new ArrayList<FileAreaUpdate>();
                groupedUpdates.put(update.component().getItemId(), grouping);
            }
            grouping.add(update);
        }
        return groupedUpdates;
    }

    private HashMap<UUID, List<FileAreaUpdate>> calculateOrderedAdds(Collection<FileAreaUpdate> adds) {
        HashMap<UUID, List<FileAreaUpdate>> groupedAdds = this.group(adds);
        HashMap<UUID, List<FileAreaUpdate>> orderedAdds = new HashMap<UUID, List<FileAreaUpdate>>();
        for (Map.Entry<UUID, List<FileAreaUpdate>> entry : groupedAdds.entrySet()) {
            HashMap<UUID, List<FileAreaUpdate>> addParentage = new HashMap<UUID, List<FileAreaUpdate>>();
            for (FileAreaUpdate add : entry.getValue()) {
                List<FileAreaUpdate> children = addParentage.get(add.getDestinationParent().getItemId());
                if (children == null) {
                    children = new ArrayList<FileAreaUpdate>();
                    addParentage.put(add.getDestinationParent().getItemId(), children);
                }
                children.add(add);
            }
            ArrayList<FileAreaUpdate> orderedGrouping = this.calculateOrdering(addParentage);
            Collections.reverse(orderedGrouping);
            orderedAdds.put(entry.getKey(), orderedGrouping);
        }
        return orderedAdds;
    }

    private ArrayList<FileAreaUpdate> calculateOrdering(HashMap<UUID, List<FileAreaUpdate>> parentage) {
        ArrayList<FileAreaUpdate> orderedUpdates = new ArrayList<FileAreaUpdate>();
        while (!parentage.isEmpty()) {
            UUID parent = parentage.keySet().iterator().next();
            List<FileAreaUpdate> children = parentage.get(parent);
            this.orderChildrenFirst(children, parentage, orderedUpdates);
            parentage.remove(parent);
        }
        return orderedUpdates;
    }

    private void orderChildrenFirst(List children, HashMap disjointParents, List orderedChanges) {
        for (FileAreaUpdate child : children) {
            List grandChildren = (List)disjointParents.get(child.getItem().getItemId());
            if (grandChildren != null) {
                this.orderChildrenFirst(grandChildren, disjointParents, orderedChanges);
            }
            orderedChanges.add(child);
            disjointParents.remove(child.getItem().getItemId());
        }
    }

    public void processed(FileAreaUpdate update) {
        Set<UUID> itemIds = this.movedOrDeletedItemIds.get(update.component().getItemId());
        if (itemIds != null) {
            itemIds.remove(update.getItem().getItemId());
        }
    }
}

