/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.DeferredInformation;
import com.ibm.team.filesystem.client.internal.load.IUpdateInfo;
import com.ibm.team.filesystem.client.internal.load.UpdateOrder;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.EncodingDownloadFailure;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.SilentProgressMonitor;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateMutator
extends FileSystemOperation {
    private static final String COLLISION_RENAME = "#jazz";
    private final FileAreaUpdateReport updates;
    protected final ITeamRepository repository;
    protected final IConnection connection;
    protected final IContextHandle connectionHandle;
    private final HashSet<ICopyFileArea> copyFileAreasToUpdate;
    protected final IDownloadListener downloadMonitor;
    protected IFileContentManagerSession contentSession;
    private boolean lastComponentSharedResult;
    private IComponentHandle lastComponentShareTested;
    private Map<IPath, Map<ConfigurationDescriptor, Set<UUID>>> toSkip = new HashMap<IPath, Map<ConfigurationDescriptor, Set<UUID>>>();
    private HashSet<ShareReference> inconsistentShares = new HashSet();
    private HashSet<ShareReference> newShares = new HashSet();
    private HashMap<UUID, IComponentStateSummary> componentStatesBefore;
    private HashMap<UUID, IComponentStateSummary> componentStatesAfter;
    private HashSet<UUID> componentNotShared;
    private Map<IPath, Map<UUID, Map<UUID, SharePoint>>> shareParents;
    private final HashMap<ICopyFileArea, Map<UUID, List<FileAreaUpdate>>> failedUpdates;
    private HashMap<UUID, List<ICopyFileArea>> copyFileAreasByComponent;
    private Shed shed;
    private UpdateOrder updateInfo;

    public UpdateMutator(IConnection session, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler problemHandler, IDownloadListener downloadMonitor) {
        super(problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler);
        problemHandler = problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler;
        this.repository = session.teamRepository();
        if (session instanceof IWorkspaceConnection) {
            this.connectionHandle = ((IWorkspaceConnection)session).getResolvedWorkspace();
        } else if (session instanceof IBaselineConnection) {
            this.connectionHandle = ((IBaselineConnection)session).getBaseline();
        } else {
            throw new IllegalArgumentException();
        }
        this.connection = session;
        if (componentStatesBefore == null) {
            throw new IllegalArgumentException();
        }
        if (componentStatesAfter == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreasToUpdate == null) {
            throw new IllegalArgumentException();
        }
        this.componentStatesBefore = new HashMap();
        for (IComponentStateSummary componentState : componentStatesBefore) {
            this.componentStatesBefore.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentStatesAfter = new HashMap();
        for (IComponentStateSummary componentState : componentStatesAfter) {
            this.componentStatesAfter.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentNotShared = new HashSet();
        this.shareParents = new HashMap<IPath, Map<UUID, Map<UUID, SharePoint>>>();
        for (SharePoint sharePoint : updates.getShareParents()) {
            IVersionableHandle parent;
            Map<UUID, SharePoint> shareParentsForComponent;
            Path cfaPath = new Path(sharePoint.getCopyFileArea());
            Map<UUID, Map<UUID, SharePoint>> shareParentsForCFA = this.shareParents.get(cfaPath);
            if (shareParentsForCFA == null) {
                shareParentsForCFA = new HashMap<UUID, Map<UUID, SharePoint>>();
                this.shareParents.put((IPath)cfaPath, shareParentsForCFA);
            }
            if ((shareParentsForComponent = shareParentsForCFA.get(sharePoint.getComponent().getItemId())) == null) {
                shareParentsForComponent = new HashMap<UUID, SharePoint>();
                shareParentsForCFA.put(sharePoint.getComponent().getItemId(), shareParentsForComponent);
            }
            if ((parent = sharePoint.getVersionable()) == null) {
                shareParentsForComponent.put(null, sharePoint);
                continue;
            }
            shareParentsForComponent.put(parent.getItemId(), sharePoint);
        }
        this.updates = updates;
        this.failedUpdates = new HashMap();
        this.downloadMonitor = downloadMonitor;
        this.copyFileAreasToUpdate = new HashSet<ICopyFileArea>(copyFileAreasToUpdate);
        for (String overlapCopyFileAreas : updates.getCopyFileAreasWithOverlaps()) {
            Path path = new Path(overlapCopyFileAreas);
            Iterator<ICopyFileArea> iCFA = copyFileAreasToUpdate.iterator();
            while (iCFA.hasNext()) {
                ICopyFileArea cfa = iCFA.next();
                if (!PathUtils.samePath(cfa.getRoot(), cfa.isCaseSensitive(), (IPath)path, cfa.isCaseSensitive())) continue;
                iCFA.remove();
                this.collectStatus(new FileSystemStatus(2, NLS.bind((String)Messages.UpdateMutator_45, (Object)overlapCopyFileAreas, (Object[])new Object[0])));
            }
        }
        this.copyFileAreasByComponent = new HashMap();
        this.shed = new Shed(problemHandler.getBackupDilemmaHandler());
    }

    private final void createFile(IComponent component, FileAreaUpdate update, ArrayList<DeferredDownloadInformation> deferredDownloadInfo, Date date, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = update.getName();
            SharingDescriptor descriptor = null;
            IFolderHandle parent = update.getDestinationParent();
            IPath parentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)parent, (IProgressMonitor)progress.newChild(1));
            if (parentPath == null) {
                SharePoint sharePoint = this.getSharePoint(cfa, component, parent);
                if (sharePoint != null) {
                    descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)component, component.getName(), (IVersionableHandle)fileItemState);
                    parentPath = PathUtils.getPath(sharePoint.getRelativePath());
                } else {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)parent, (IComponentHandle)component, this.connectionHandle);
                    if (info != null) {
                        IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)parent, (IProgressMonitor)progress.newChild(1));
                        if (share != null) {
                            this.recordInconsistentShare((IComponentHandle)component, share);
                        } else {
                            this.recordInconsistentComponent(cfa, component, (IProgressMonitor)progress.newChild(1));
                        }
                        this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_2, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
            }
            IPath path = parentPath.append(update.getName());
            errorMsgFileName = path.toString();
            Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.FILE);
            Shareable existingNewFileShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
            if (potentialCollision.exists((IProgressMonitor)progress.newChild(1))) {
                if (descriptor != null) {
                    this.failedUpdate(cfa, update);
                    if (existingNewFileShareable == null) continue;
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_1, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                if (existingNewFileShareable != null) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                if (!this.handleCollision(cfa, component, potentialCollision, (IProgressMonitor)progress.newChild(1))) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, potentialCollision.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
            }
            if (existingNewFileShareable != null) {
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_29, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                continue;
            }
            progress.setWorkRemaining(100);
            Shareable fileToCreate = new Shareable(cfa.getRoot(), path, ResourceType.FILE);
            DeferredDownloadInformation deferredDownload = new DeferredDownloadInformation(cfa, update, descriptor);
            deferredDownloadInfo.add(deferredDownload);
            boolean skipWrite = this.skipUpdate(cfa.getRoot(), (IComponentHandle)component, (IVersionableHandle)fileItemState);
            this.storeFileContent(deferredDownload, fileToCreate, skipWrite, (IProgressMonitor)progress);
        }
    }

    private void createLink(IComponent component, final FileAreaUpdate update, final Set<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        ISymbolicLinkHandle linkItemState = (ISymbolicLinkHandle)update.afterState();
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            FileItemInfoProxy proxy;
            final SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = update.getName();
            SharingDescriptor descriptor = null;
            IFolderHandle parent = update.getDestinationParent();
            IPath parentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)parent, (IProgressMonitor)progress.newChild(1));
            boolean isShare = false;
            if (parentPath == null) {
                SharePoint sharePoint = this.getSharePoint(cfa, component, parent);
                if (sharePoint != null) {
                    descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)component, component.getName(), (IVersionableHandle)linkItemState);
                    parentPath = PathUtils.getPath(sharePoint.getRelativePath());
                    isShare = true;
                } else {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)parent, (IComponentHandle)component, this.connectionHandle);
                    if (info != null) {
                        IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)parent, (IProgressMonitor)progress.newChild(1));
                        if (share != null) {
                            this.recordInconsistentShare((IComponentHandle)component, share);
                        } else {
                            this.recordInconsistentComponent(cfa, component, (IProgressMonitor)progress.newChild(1));
                        }
                        this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_2, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
            }
            IPath path = parentPath.append(update.getName());
            errorMsgFileName = path.toString();
            Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.SYMBOLIC_LINK);
            Shareable existingNewLinkShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)linkItemState, (IProgressMonitor)progress.newChild(1));
            if (potentialCollision.exists((IProgressMonitor)progress.newChild(1))) {
                if (descriptor != null) {
                    this.failedUpdate(cfa, update);
                    if (existingNewLinkShareable == null) continue;
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_1, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, existingNewLinkShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                if (existingNewLinkShareable != null) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, existingNewLinkShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                if (!this.handleCollision(cfa, component, potentialCollision, (IProgressMonitor)progress.newChild(1))) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, potentialCollision.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
            }
            if (existingNewLinkShareable != null) {
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_29, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                this.recordInconsistentShare((IComponentHandle)component, existingNewLinkShareable.getShare((IProgressMonitor)progress.newChild(1)));
                continue;
            }
            progress.setWorkRemaining(100);
            final Shareable linkToCreate = new Shareable(cfa.getRoot(), path, ResourceType.SYMBOLIC_LINK);
            if (!this.skipUpdate(cfa.getRoot(), (IComponentHandle)component, (IVersionableHandle)linkItemState)) {
                if (ManagedFileStore.supportsSymLinks()) {
                    try {
                        SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                            public void run() throws CoreException {
                                linkToCreate.getFileStorage().create(update.getLinkTarget(), (IProgressMonitor)progress.newChild(50));
                                linksToRefresh.add(linkToCreate);
                            }
                        });
                    }
                    catch (CoreException e) {
                        this.recordInconsistentShare((IComponentHandle)component, linkToCreate.getShare((IProgressMonitor)progress.newChild(1)));
                        this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_31, (Object)path.toString(), (Object[])new Object[]{component.getName()}), (Throwable)e));
                    }
                } else {
                    this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.UpdateMutator_50, (Object)path.toOSString(), (Object[])new Object[]{update.getLinkTarget()}), null));
                    linksToRecompute.add(linkToCreate);
                }
            }
            if (isShare) {
                proxy = new FileItemInfoProxy((IVersionableHandle)linkItemState, parent, update.getName(), false);
                proxy.setTarget(linkToCreate.getFileStorage().getModificationStamp(), update.getLinkTarget());
                IShare share = SharingManager.getInstance().share(linkToCreate, descriptor, proxy.getFileItemInfo(), 2, (IProgressMonitor)progress.newChild(1));
                this.newShares.add(new ShareReference((IComponentHandle)component, share));
                continue;
            }
            proxy = new FileItemInfoProxy((IVersionableHandle)linkItemState, parent, update.getName());
            proxy.setTarget(linkToCreate.getFileStorage().getModificationStamp(), update.getLinkTarget());
            cfa.setItemMetaData(linkToCreate.getLocalPath(), proxy.getFileItemInfo(), (IProgressMonitor)progress.newChild(1));
        }
    }

    private final void createFolder(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IFolderHandle parent = update.getDestinationParent();
        if (parent == null) {
            return;
        }
        String name = update.getName();
        IFolderHandle folderItemState = (IFolderHandle)update.afterState();
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            FileItemInfo proxy;
            final SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = name;
            boolean isShare = false;
            IPath parentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)parent, (IProgressMonitor)progress.newChild(1));
            if (parentPath == null) {
                SharePoint sharePoint = this.getSharePoint(cfa, component, parent);
                if (sharePoint != null) {
                    isShare = true;
                    parentPath = PathUtils.getPath(sharePoint.getRelativePath());
                } else {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)parent, (IComponentHandle)component, this.connectionHandle);
                    if (info != null) {
                        IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)parent, (IProgressMonitor)progress.newChild(1));
                        if (share != null) {
                            this.recordInconsistentShare((IComponentHandle)component, share);
                        } else {
                            this.recordInconsistentComponent(cfa, component, (IProgressMonitor)progress.newChild(1));
                        }
                        this.collectStatus(new FileSystemStatus(4, 368, NLS.bind((String)Messages.UpdateMutator_2, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
            }
            IPath path = parentPath.append(name);
            errorMsgFileName = path.toString();
            Shareable newFolderShareable = new Shareable(cfa.getRoot(), path, ResourceType.FOLDER);
            Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.FOLDER);
            Shareable existingNewFolderShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)folderItemState, null);
            if (potentialCollision.exists((IProgressMonitor)progress.newChild(1)) || !potentialCollision.getSandbox().isCaseSensitive() && (potentialCollision.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) || !update.getName().equals(potentialCollision.getFileStorage().getActualName()))) {
                IShare share;
                if (potentialCollision.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER && potentialCollision.getRemote((IProgressMonitor)progress.newChild(1)) == null && existingNewFolderShareable == null) {
                    if (!name.equals((potentialCollision = this.getShareableForExistingStorage(potentialCollision, (IProgressMonitor)progress.newChild(1))).getFileStorage().getActualName())) {
                        this.move(cfa, component, (IComponentHandle)component, potentialCollision, newFolderShareable, parent, name, null, false, false, (IProgressMonitor)progress.newChild(25));
                    }
                    if (isShare) {
                        SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)component, component.getName(), (IVersionableHandle)folderItemState);
                        proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name, PathUtils.isLoadedWithAnotherName(newFolderShareable.getSandbox(), path, name)).getFileItemInfo();
                        share = SharingManager.getInstance().share(newFolderShareable, descriptor, proxy, 2, monitor);
                        this.newShares.add(new ShareReference((IComponentHandle)component, share));
                        continue;
                    }
                    FileItemInfo proxy2 = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name).getFileItemInfo();
                    cfa.setItemMetaData(path, proxy2, (IProgressMonitor)progress.newChild(50));
                    continue;
                }
                IComponentHandle collisionComponent = null;
                IContextHandle collisionConnection = null;
                share = potentialCollision.getShare((IProgressMonitor)progress.newChild(1));
                if (share != null) {
                    collisionComponent = share.getSharingDescriptor().getComponent();
                    collisionConnection = share.getSharingDescriptor().getConnectionHandle();
                }
                if (folderItemState.sameItemId((IItemHandle)potentialCollision.getRemote((IProgressMonitor)progress.newChild(1))) && component.sameItemId((IItemHandle)collisionComponent) && this.connectionHandle.sameItemId((IItemHandle)collisionConnection)) {
                    if (name.equals(potentialCollision.getFileStorage().getActualName())) {
                        FileItemInfo proxy3 = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name, false).getFileItemInfo();
                        cfa.setItemMetaData(potentialCollision.getLocalPath(), proxy3, (IProgressMonitor)progress.newChild(50));
                        continue;
                    }
                    this.move(cfa, component, (IComponentHandle)component, potentialCollision, newFolderShareable, parent, name, (IVersionableHandle)folderItemState, true, false, (IProgressMonitor)progress.newChild(25));
                    continue;
                }
                if (!(!isShare || folderItemState.sameItemId((IItemHandle)potentialCollision.getRemote((IProgressMonitor)progress.newChild(1))) && this.connectionHandle.sameItemId((IItemHandle)collisionConnection))) {
                    this.collectStatus(new FileSystemStatus(2, NLS.bind((String)Messages.UpdateMutator_46, (Object)path.toString(), (Object[])new Object[0])));
                    this.failedUpdate(cfa, update);
                    continue;
                }
                if (!this.handleCollision(cfa, component, potentialCollision, (IProgressMonitor)progress.newChild(25))) {
                    this.collectStatus(new FileSystemStatus(4, 368, NLS.bind((String)Messages.UpdateMutator_12, (Object)errorMsgFileName, (Object[])new Object[]{potentialCollision.getFileStorage().getActualName()})));
                    this.recordInconsistentShare((IComponentHandle)component, potentialCollision.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
            }
            if (existingNewFolderShareable != null && existingNewFolderShareable.exists((IProgressMonitor)progress.newChild(1))) {
                this.move(cfa, component, (IComponentHandle)component, existingNewFolderShareable, newFolderShareable, parent, name, (IVersionableHandle)folderItemState, true, false, (IProgressMonitor)progress.newChild(25));
                continue;
            }
            try {
                final IFileStorage fileStorage = newFolderShareable.getFileStorage();
                if (!this.skipUpdate(newFolderShareable.getCopyFileAreaRoot(), (IComponentHandle)component, (IVersionableHandle)folderItemState)) {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            fileStorage.create(false, (IProgressMonitor)progress.newChild(50));
                        }
                    });
                }
                if (isShare) {
                    proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name, false).getFileItemInfo();
                    SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)component, component.getName(), (IVersionableHandle)folderItemState);
                    IShare share = SharingManager.getInstance().share(newFolderShareable, descriptor, proxy, 2, (IProgressMonitor)progress.newChild(1));
                    this.newShares.add(new ShareReference((IComponentHandle)component, share));
                } else {
                    proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name).getFileItemInfo();
                    cfa.setItemMetaData(newFolderShareable.getLocalPath(), proxy, (IProgressMonitor)progress.newChild(1));
                }
            }
            catch (CoreException e) {
                this.recordInconsistentShare((IComponentHandle)component, newFolderShareable.getShare((IProgressMonitor)progress.newChild(1)));
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_31, (Object)path.toString(), (Object[])new Object[]{component.getName()}), (Throwable)e));
            }
            this.folderCreated(newFolderShareable, isShare, (IProgressMonitor)progress.newChild(1));
        }
    }

    private SharePoint getSharePoint(ICopyFileArea cfa, IComponent component, IFolderHandle parent) {
        Map<UUID, SharePoint> parentsForComponent;
        Map<UUID, Map<UUID, SharePoint>> parentsForCFA = this.shareParents.get(cfa.getRoot());
        if (parentsForCFA != null && (parentsForComponent = parentsForCFA.get(component.getItemId())) != null) {
            return parentsForComponent.get(parent.getItemId());
        }
        return null;
    }

    private final void deleteSubtree(IComponent component, IFolderHandle parent, String name, IVersionableHandle itemState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            if (parent == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, Messages.UpdateMutator_32, null));
                this.recordInconsistentComponent(cfa, component, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            progress.subTask(NLS.bind((String)Messages.UpdateMutator_4, (Object)name, (Object[])new Object[0]));
            IPath toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
            if (toDeletePath == null) {
                cfa.forget(this.connectionHandle, (IComponentHandle)component, itemState, null);
                continue;
            }
            Shareable toDeleteShareable = new Shareable(cfa.getRoot(), toDeletePath, ResourceType.getResourceType(itemState));
            if (!toDeleteShareable.exists((IProgressMonitor)progress.newChild(1))) {
                if (toDeleteShareable.isShare((IProgressMonitor)progress.newChild(1))) {
                    toDeleteShareable.unshare((IProgressMonitor)progress.newChild(98));
                    continue;
                }
                toDeleteShareable.forget((IProgressMonitor)progress.newChild(98));
                continue;
            }
            this.deleteSubtree(component, toDeleteShareable, (IProgressMonitor)progress.newChild(98));
        }
    }

    private void deleteSubtree(IComponent component, Shareable toDeleteShareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle remote = toDeleteShareable.getRemote((IProgressMonitor)progress.newChild(1));
        if (remote == null || !this.skipUpdate(toDeleteShareable.getCopyFileAreaRoot(), (IComponentHandle)component, remote)) {
            final IFileStorage storage = toDeleteShareable.getFileStorage();
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        try {
                            storage.delete(UpdateMutator.this.shed, (IProgressMonitor)progress.newChild(50));
                        }
                        catch (TeamRepositoryException e) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                        }
                    }
                });
            }
            catch (CoreException e) {
                this.recordInconsistentShare((IComponentHandle)component, toDeleteShareable.getShare((IProgressMonitor)progress.newChild(1)));
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_34, (Object)toDeleteShareable.getLocalPath(), (Object[])new Object[]{component.getName()}), (Throwable)e));
            }
        }
        if (toDeleteShareable.isShare((IProgressMonitor)progress.newChild(1))) {
            toDeleteShareable.unshare((IProgressMonitor)progress.newChild(49));
        } else {
            toDeleteShareable.forget((IProgressMonitor)progress.newChild(49));
        }
        progress.done();
    }

    protected final void modifyFile(IComponent component, FileAreaUpdate update, ArrayList<DeferredDownloadInformation> deferredDownloadInfo, Date timestamp, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = update.getName();
            try {
                IPath toModifyPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                if (toModifyPath == null) {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle);
                    if (info != null) {
                        IPath remotePath = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                        if (remotePath != null) {
                            errorMsgFileName = remotePath.toString();
                        }
                        this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_8, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)progress.newChild(1));
                    if (share != null) {
                        this.recordInconsistentShare((IComponentHandle)component, share);
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
                errorMsgFileName = toModifyPath.toString();
                Shareable toModifyShareable = new Shareable(cfa.getRoot(), toModifyPath, ResourceType.FILE);
                if (toModifyShareable.getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.FILE) {
                    this.collectStatus(new FileSystemStatus(4, 369, NLS.bind((String)Messages.UpdateMutator_35, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, toModifyShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                if (toModifyShareable.exists((IProgressMonitor)progress.newChild(1)) && (toModifyShareable.getSandbox().isCaseSensitive() || toModifyShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) && toModifyShareable.getFileStorage().getActualName().equals(toModifyPath.lastSegment()))) {
                    DeferredDownloadInformation deferredDownload = new DeferredDownloadInformation(cfa, update, null);
                    deferredDownloadInfo.add(deferredDownload);
                    boolean skipWrite = this.skipUpdate(toModifyShareable.getCopyFileAreaRoot(), deferredDownload.getComponent(), toModifyShareable.getRemote((IProgressMonitor)progress));
                    this.storeFileContent(deferredDownload, toModifyShareable, skipWrite, (IProgressMonitor)progress);
                    continue;
                }
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_8, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
            }
            finally {
                progress.done();
            }
        }
    }

    private void modifyLink(IComponent component, FileAreaUpdate update, HashSet<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        ISymbolicLinkHandle linkItemState = (ISymbolicLinkHandle)update.afterState();
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = update.getName();
            try {
                IPath toModifyPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)linkItemState, (IProgressMonitor)progress.newChild(1));
                if (toModifyPath == null) {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)linkItemState, (IComponentHandle)component, this.connectionHandle);
                    if (info != null) {
                        IPath remotePath = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)linkItemState, (IProgressMonitor)progress.newChild(1));
                        if (remotePath != null) {
                            errorMsgFileName = remotePath.toString();
                        }
                        this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_30, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)progress.newChild(1));
                    if (share != null) {
                        this.recordInconsistentShare((IComponentHandle)component, share);
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
                errorMsgFileName = toModifyPath.toString();
                Shareable toModifyShareable = new Shareable(cfa.getRoot(), toModifyPath, ResourceType.SYMBOLIC_LINK);
                if (toModifyShareable.getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.SYMBOLIC_LINK) {
                    this.collectStatus(new FileSystemStatus(4, 369, NLS.bind((String)Messages.UpdateMutator_33, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    this.recordInconsistentShare((IComponentHandle)component, toModifyShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                if (toModifyShareable.exists((IProgressMonitor)progress.newChild(1)) && (toModifyShareable.getSandbox().isCaseSensitive() || toModifyShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) && toModifyShareable.getFileStorage().getActualName().equals(toModifyPath.lastSegment()))) {
                    this.modifyLink(cfa, toModifyShareable, component, update, linksToRefresh, linksToRecompute, progress);
                    continue;
                }
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_42, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
            }
            finally {
                progress.done();
            }
        }
    }

    private void modifyLink(ICopyFileArea copyFileArea, Shareable shareable, IComponent component, FileAreaUpdate updateInfo, HashSet<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, SubMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        InverseFileItemInfo oldInfo;
        IVersionableHandle symbolicLinkHandle;
        String linkTarget;
        SubMonitor monitor;
        block10: {
            monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            linkTarget = updateInfo.getLinkTarget();
            symbolicLinkHandle = updateInfo.afterState();
            if (ManagedFileStore.supportsSymLinks()) {
                if (!this.skipUpdate(copyFileArea.getRoot(), (IComponentHandle)component, shareable.getRemote((IProgressMonitor)progress))) {
                    SharingManager.getInstance().disableChangeMonitoring();
                    try {
                        try {
                            shareable.getFileStorage().setTarget(this.shed, linkTarget == null ? "" : linkTarget, (IProgressMonitor)monitor.newChild(50));
                            linksToRefresh.add(shareable);
                        }
                        catch (FileSystemClientException e) {
                            this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                            this.recordInconsistentShare((IComponentHandle)component, shareable.getShare(null));
                            SharingManager.getInstance().enableChangeMonitoring();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        SharingManager.getInstance().enableChangeMonitoring();
                        throw throwable;
                    }
                    SharingManager.getInstance().enableChangeMonitoring();
                }
            } else {
                this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.UpdateMutator_47, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{linkTarget}), null));
                linksToRecompute.add(shareable);
            }
        }
        if ((oldInfo = copyFileArea.getItemInfo(symbolicLinkHandle, (IComponentHandle)component, this.connectionHandle)) == null) {
            this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_48, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{component.getName()}), null));
            this.recordInconsistentShare((IComponentHandle)component, shareable.getShare(null));
        } else {
            FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(oldInfo);
            newInfoProxy.setItemState(symbolicLinkHandle);
            newInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), linkTarget);
            FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
            copyFileArea.setItemMetaData(shareable.getLocalPath(), newInfo, (IProgressMonitor)monitor.newChild(10));
        }
    }

    private void storeFileContent(DeferredDownloadInformation downloadInfo, Shareable shareable, boolean skipWrite, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (skipWrite && shareable.getRemote((IProgressMonitor)monitor.newChild(1)) != null && !FileSystemCore.getContentManager(this.repository).convertDelimitersDuringRetrieval(downloadInfo.getContent())) {
            IFileContent content = downloadInfo.getContent();
            downloadInfo.setContentUpdated(shareable, content.getHash(), content.getRawLength());
            return;
        }
        if (shareable.exists((IProgressMonitor)monitor.newChild(1))) {
            try {
                this.shed.forceBackup(shareable, (IProgressMonitor)monitor.newChild(10));
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_36, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
            }
            catch (FileSystemClientException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_36, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)((Object)e)));
            }
        }
        DownloadHandler downloader = new DownloadHandler(shareable, downloadInfo, skipWrite);
        this.contentSession.retrieveContent((IFileItemHandle)downloadInfo.getFileItemState(), downloadInfo.getContent(), downloader);
    }

    private static void read(InputStream in) throws IOException {
        byte[] b = new byte[16000];
        try {
            while (in.read(b) != -1) {
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    protected final void moveSubtree(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        IComponent previousComponent = update.getComponent().sameItemId((IItemHandle)update.getPreviousComponent()) ? component : (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)update.getPreviousComponent(), 0, (IProgressMonitor)totalProgress.newChild(1));
        IFolderHandle destinationParent = update.getDestinationParent();
        String newName = update.getName();
        IVersionableHandle itemMovedState = update.afterState();
        boolean alsoModified = update.isChangeType(4);
        if (!this.isComponentShared((IComponentHandle)previousComponent, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(previousComponent.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            FileItemInfo info;
            SubMonitor progress = totalProgress.newChild(100);
            boolean itemToMoveExists = false;
            boolean itemToMoveIsShare = false;
            boolean targetFolderExistsLocally = false;
            boolean targetFolderIsShareParent = false;
            IShare targetShare = null;
            IShare sourceShare = null;
            IPath targetPath = null;
            String sourceErrorMsgName = update.getOldName();
            String targetErrorMsgName = update.getName();
            IPath toMovePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)previousComponent, itemMovedState, (IProgressMonitor)progress.newChild(1));
            if (toMovePath != null) {
                Shareable sourceShareable = new Shareable(cfa.getRoot(), toMovePath, ResourceType.getResourceType(itemMovedState));
                sourceShare = sourceShareable.getShare((IProgressMonitor)progress.newChild(1));
                itemToMoveExists = sourceShareable.exists((IProgressMonitor)progress.newChild(1));
                if (!(!itemToMoveExists || sourceShareable.getSandbox().isCaseSensitive() || sourceShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) && toMovePath.lastSegment().equals(sourceShareable.getFileStorage().getActualName()))) {
                    itemToMoveExists = false;
                }
                itemToMoveIsShare = sourceShareable.isShare((IProgressMonitor)progress.newChild(1));
                sourceErrorMsgName = toMovePath.toString();
            } else {
                itemToMoveExists = false;
                sourceShare = cfa.getShare(this.connectionHandle, (IComponentHandle)previousComponent, itemMovedState, (IProgressMonitor)progress.newChild(1));
                IPath bestGuess = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)previousComponent, itemMovedState, (IProgressMonitor)progress.newChild(1));
                if (bestGuess != null) {
                    sourceErrorMsgName = bestGuess.toString();
                }
            }
            Shareable destinationParentShareable = null;
            SharePoint sharePoint = this.getSharePoint(cfa, component, destinationParent);
            if (sharePoint != null) {
                targetPath = PathUtils.getPath(sharePoint.getRelativePath()).append(newName);
                targetFolderIsShareParent = true;
                targetErrorMsgName = targetPath.toString();
            } else {
                IPath destinationParentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)destinationParent, (IProgressMonitor)progress.newChild(1));
                destinationParentShareable = null;
                if (destinationParentPath != null) {
                    destinationParentShareable = new Shareable(cfa.getRoot(), destinationParentPath, ResourceType.FOLDER);
                    targetPath = destinationParentShareable.getLocalPath().append(newName);
                    targetErrorMsgName = targetPath.toString();
                    targetShare = destinationParentShareable.getShare((IProgressMonitor)progress.newChild(1));
                    targetFolderExistsLocally = true;
                } else {
                    IPath bestGuess;
                    targetFolderExistsLocally = false;
                    targetShare = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)destinationParent, (IProgressMonitor)progress.newChild(1));
                    if (targetShare == null && itemToMoveIsShare) {
                        targetFolderIsShareParent = true;
                        targetPath = sourceShare.getPath().removeLastSegments(1).append(newName);
                    } else if (targetShare != null && (bestGuess = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)destinationParent, (IProgressMonitor)progress.newChild(1))) != null) {
                        targetErrorMsgName = bestGuess.toString();
                    }
                }
            }
            if (!itemToMoveExists) {
                this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                this.recordInconsistentShare((IComponentHandle)component, targetShare);
                if (sourceShare == null) {
                    this.failedUpdate(cfa, update, update.getPreviousComponent());
                }
                if (targetShare != null || sourceShare != null) {
                    this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_9, (Object)sourceErrorMsgName, (Object[])new Object[]{targetErrorMsgName, component.getName()})));
                    continue;
                }
                if (targetFolderIsShareParent) continue;
                this.failedUpdate(cfa, update);
                continue;
            }
            if (!(targetFolderExistsLocally || targetFolderIsShareParent || itemToMoveIsShare && targetShare == null)) {
                this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                this.recordInconsistentShare((IComponentHandle)component, targetShare);
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_10, (Object)sourceErrorMsgName, (Object[])new Object[]{targetErrorMsgName, component.getName()})));
                continue;
            }
            Shareable toMoveShareable = new Shareable(cfa.getRoot(), toMovePath, ResourceType.getResourceType(itemMovedState));
            Shareable potentialCollision = new Shareable(cfa.getRoot(), targetPath, ResourceType.getResourceType(itemMovedState));
            if (itemToMoveIsShare && targetFolderIsShareParent && (info = cfa.getItemInfo(toMoveShareable.getLocalPath())).isLoadedWithAnotherName()) {
                if (!targetFolderIsShareParent) {
                    this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                    this.recordInconsistentShare((IComponentHandle)component, targetShare);
                    this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_43, (Object)sourceErrorMsgName, (Object[])new Object[]{targetErrorMsgName, component.getName()})));
                }
                this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, potentialCollision, itemToMoveIsShare, true, alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(75));
                continue;
            }
            if (itemMovedState.sameItemId((IItemHandle)potentialCollision.getRemote((IProgressMonitor)progress.newChild(1))) && component.sameItemId((IItemHandle)previousComponent)) {
                if (update.getOldName().equals(update.getName())) {
                    this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, potentialCollision, itemToMoveIsShare, true, alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(75));
                    continue;
                }
            } else if (potentialCollision.exists((IProgressMonitor)progress.newChild(1)) || !potentialCollision.getSandbox().isCaseSensitive() && (potentialCollision.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) || !potentialCollision.getFileStorage().getActualName().equals(update.getName()))) {
                if (PathUtils.sameRelativePath(potentialCollision.getLocalPath(), true, toMoveShareable.getLocalPath(), true)) {
                    this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, potentialCollision, itemToMoveIsShare, true, alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(75));
                    continue;
                }
                if (!this.handleCollision(cfa, component, potentialCollision, (IProgressMonitor)progress.newChild(25))) {
                    this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_13, (Object)toMovePath.toString(), (Object[])new Object[]{targetPath.toString()})));
                    this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                    this.recordInconsistentShare((IComponentHandle)component, targetShare);
                    continue;
                }
            }
            Shareable targetShareable = new Shareable(cfa.getRoot(), targetPath, ResourceType.getResourceType(itemMovedState));
            this.move(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, targetShareable, destinationParent, newName, itemMovedState, true, alsoModified, (IProgressMonitor)progress.newChild(75));
        }
    }

    private void move(ICopyFileArea cfa, IComponent component, IComponentHandle previousComponent, Shareable toMoveShareable, final Shareable destinationShareable, IFolderHandle destinationParent, String newName, IVersionableHandle itemMovedState, boolean moveUpdate, boolean alsoModified, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean isShare = toMoveShareable.isShare((IProgressMonitor)progress.newChild(1));
        final IFileStorage storage = toMoveShareable.getFileStorage();
        final IPath targetPath = destinationShareable.getLocalPath();
        if (!this.skipUpdate(cfa.getRoot(), previousComponent, toMoveShareable.getRemote((IProgressMonitor)progress.newChild(1)))) {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        storage.move(destinationShareable.getSandbox(), targetPath, (IProgressMonitor)progress.newChild(75));
                    }
                });
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
            }
        }
        this.updateMetaDataAfterMove(cfa, component, previousComponent, toMoveShareable, destinationShareable, isShare, moveUpdate, alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(24));
    }

    private boolean handleCollision(ICopyFileArea cfa, IComponent component, Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle remoteItem = shareable.getRemote((IProgressMonitor)progress.newChild(1));
        boolean shouldPreserve = false;
        shareable = this.getShareableForExistingStorage(shareable, (IProgressMonitor)progress.newChild(1));
        if (remoteItem != null) {
            boolean movedOrDeleted = this.updateInfo.isMovedOrDeleted((IComponentHandle)component, remoteItem);
            if (shareable.isShare((IProgressMonitor)progress.newChild(1))) {
                if (!movedOrDeleted) {
                    this.collectStatus(new FileSystemStatus(2, 333, NLS.bind((String)Messages.UpdateMutator_17, (Object)shareable.getLocalPath(), (Object[])new Object[0])));
                } else {
                    shouldPreserve = true;
                }
            } else if (movedOrDeleted) {
                shouldPreserve = true;
            } else {
                return false;
            }
        }
        if (shouldPreserve) {
            this.preserve(cfa, component, shareable, (IProgressMonitor)progress.newChild(98));
        } else {
            this.deleteSubtree(component, shareable, (IProgressMonitor)progress.newChild(98));
        }
        return true;
    }

    private Shareable getShareableForExistingStorage(Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!shareable.getSandbox().isCaseSensitive() && !shareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1))) {
            Shareable realShareable = null;
            ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(4));
            IFileStorage parentStorage = shareable.getFileStorage().getParent();
            if (parentStorage != null) {
                IFileStorage child = parentStorage.getChild(shareable.getLocalPath().lastSegment(), (IProgressMonitor)progress.newChild(10));
                if (child != null) {
                    realShareable = child.getShareable();
                }
            } else {
                File parent = shareable.getFullPath().toFile().getParentFile();
                if (parent != null) {
                    File[] children;
                    String name = shareable.getLocalPath().lastSegment().toUpperCase().toLowerCase();
                    File[] fileArray = children = parent.listFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        if (child.getName().length() == name.length() && child.getName().toUpperCase().toLowerCase().equals(name)) {
                            Path path = new Path(child.getAbsolutePath());
                            realShareable = (Shareable)SharingManager.getInstance().findShareable((IPath)path, type == null ? ResourceType.FILE : type);
                            if (realShareable == null || realShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1))) break;
                            realShareable = null;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (realShareable == null) {
                IFileStorage storage = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), shareable.getLocalPath(), type == null ? ResourceType.FILE : type);
                realShareable = storage.getShareable();
            }
            shareable = realShareable;
        }
        return shareable;
    }

    private void preserve(ICopyFileArea cfa, IComponent component, final Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        String destination;
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean isShareRoot = shareable.isShare((IProgressMonitor)progress.newChild(1));
        IPath path = shareable.getFullPath();
        ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
        IPath parent = path.removeLastSegments(1);
        String name = path.lastSegment();
        String extension = shareable.getLocalPath().lastSegment();
        int posn = extension.lastIndexOf(".");
        if (posn < 0) {
            extension = "";
        } else {
            extension = extension.substring(posn);
            name = name.substring(0, name.length() - extension.length());
        }
        name = String.valueOf(name) + COLLISION_RENAME;
        int count = 0;
        IPath destinationPath = null;
        do {
            destination = String.valueOf(name) + count + extension;
            ++count;
        } while (PathUtils.exists(destinationPath = parent.append(destination), (IProgressMonitor)progress.newChild(1)));
        final IFileStorage storage = shareable.getFileStorage();
        final IPath targetPath = shareable.getLocalPath().removeLastSegments(1).append(destination);
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    storage.move(shareable.getSandbox(), targetPath, (IProgressMonitor)progress.newChild(74));
                }
            });
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
        }
        Shareable targetShareable = new Shareable(shareable.getSandbox(), targetPath, type);
        this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)component, shareable, targetShareable, isShareRoot, false, false, null, null, null, (IProgressMonitor)progress.newChild(25));
        progress.done();
    }

    protected final boolean isComponentShared(IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        if (component.sameItemId((IItemHandle)this.lastComponentShareTested)) {
            return this.lastComponentSharedResult;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.copyFileAreasToUpdate.size());
        this.lastComponentShareTested = component;
        List<ICopyFileArea> cfas = this.copyFileAreasByComponent.get(component.getItemId());
        if (cfas != null) {
            this.lastComponentSharedResult = true;
            return this.lastComponentSharedResult;
        }
        if (this.componentNotShared.contains(component.getItemId())) {
            this.lastComponentSharedResult = false;
            return this.lastComponentSharedResult;
        }
        cfas = new ArrayList<ICopyFileArea>(2);
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            if (!cfa.isConfigurationShared(this.connectionHandle, component, (IProgressMonitor)progress.newChild(1))) continue;
            cfas.add(cfa);
        }
        boolean bl = this.lastComponentSharedResult = !cfas.isEmpty();
        if (this.lastComponentSharedResult) {
            this.copyFileAreasByComponent.put(component.getItemId(), cfas);
        } else {
            String message;
            this.componentNotShared.add(component.getItemId());
            try {
                IComponent fullComponent = this.getFullComponent(component, null, (IProgressMonitor)progress.newChild(1));
                message = NLS.bind((String)Messages.UpdateMutator_18, (Object)fullComponent.getName(), (Object[])new Object[0]);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                message = Messages.UpdateMutator_7;
            }
            this.collectStatus(new FileSystemStatus(2, 367, message));
        }
        return this.lastComponentSharedResult;
    }

    private void recordInconsistentShare(IComponentHandle component, IShare share) {
        if (share != null) {
            this.inconsistentShares.add(new ShareReference(component, share));
        }
    }

    private void recordInconsistentComponent(ICopyFileArea cfa, IComponent component, IProgressMonitor monitor) throws FileSystemClientException {
        Collection<IShare> sharesNowInconsistent = cfa.allShares(this.connectionHandle, (IComponentHandle)component, monitor);
        for (IShare share : sharesNowInconsistent) {
            this.recordInconsistentShare((IComponentHandle)component, share);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.updateInfo = orderer = new UpdateOrder(this.updates.getAdds(), this.updates.getDeletes(), this.updates.getMoves(), this.updates.getModifies());
        maxContentToDownLoad = orderer.getFileMoves().size() + orderer.getFileAdds().size() + orderer.getGroupedModifies().size();
        deferredDownloadInfo = new ArrayList<DeferredDownloadInformation>(maxContentToDownLoad);
        linksToRefresh = new HashSet<Shareable>();
        linksToRecompute = new HashSet<Shareable>();
        this.contentSession = FileSystemCore.getContentManager(this.repository).createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName(), (Object[])new Object[0]), true, maxContentToDownLoad, (IProgressMonitor)subMonitor.newChild(80));
        progress = new CancellationMonitor((IProgressMonitor)subMonitor);
        component = null;
        try {
            this.startingUpdates(orderer, (IProgressMonitor)progress);
            for (FileAreaUpdate update : orderer.getFolderAdds()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.createFolder(component, update, (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getFolderMoves()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.moveSubtree(component, update, (IProgressMonitor)progress);
                orderer.processed(update);
                this.checkCancelled((IProgressMonitor)progress);
            }
            this.folderAddsAndMovesCompleted((IProgressMonitor)progress);
            for (FileAreaUpdate update : orderer.getLinkMoves()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.moveSubtree(component, update, (IProgressMonitor)progress);
                orderer.processed(update);
                if (update.isChangeType(4)) {
                    this.modifyLink(component, update, linksToRefresh, linksToRecompute, (IProgressMonitor)progress);
                }
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getFileMoves()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.moveSubtree(component, update, (IProgressMonitor)progress);
                orderer.processed(update);
                if (update.isChangeType(4)) {
                    this.modifyFile(component, update, deferredDownloadInfo, update.getFileTimestamp(), (IProgressMonitor)progress);
                } else {
                    this.contentSession.decrementTransferCount(1L);
                }
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getOrderedDeletes()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.deleteSubtree(component, update.getSourceParent(), update.getName(), update.beforeState(), (IProgressMonitor)progress);
                orderer.processed(update);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getGroupedModifies()) {
                if (update.getItem() instanceof IFileItemHandle) {
                    component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                    this.modifyFile(component, update, deferredDownloadInfo, update.getFileTimestamp(), (IProgressMonitor)progress);
                } else if (update.getItem() instanceof ISymbolicLinkHandle) {
                    component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                    this.modifyLink(component, update, linksToRefresh, linksToRecompute, (IProgressMonitor)progress);
                    this.contentSession.decrementTransferCount(1L);
                }
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getLinkAdds()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.createLink(component, update, linksToRefresh, linksToRecompute, (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getFileAdds()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.createFile(component, update, deferredDownloadInfo, update.getFileTimestamp(), (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            this.verifyUpdatesOutsideShares((IProgressMonitor)progress);
        }
        finally {
            this.contentSession.join();
            try {
                if (!progress.isCanceled()) {
                    this.doDilemmaHandling(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(10));
                }
            }
            finally {
                nonCancellableMonitor = new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(5));
                metaDataMonitor = SubMonitor.convert((IProgressMonitor)nonCancellableMonitor, (int)(deferredDownloadInfo.size() * 4 + linksToRefresh.size() + linksToRecompute.size()));
                downloadInfo = deferredDownloadInfo.iterator();
                if (true) ** GOTO lbl89
            }
            {
            }
        }
        do {
            if (!(downloadInfo = downloadInfo.next()).contentUpdated()) continue;
            this.refresh(downloadInfo, (IProgressMonitor)metaDataMonitor.newChild(1));
lbl89:
            // 3 sources

        } while (downloadInfo.hasNext());
        if (!linksToRefresh.isEmpty() || !linksToRecompute.isEmpty()) {
            this.refreshLinks(linksToRefresh, linksToRecompute, (IProgressMonitor)metaDataMonitor.newChild(linksToRefresh.size()));
        }
        for (DeferredDownloadInformation downloadInfo : deferredDownloadInfo) {
            if (!downloadInfo.contentUpdated()) continue;
            skipUpdate = this.skipUpdate(downloadInfo.getCopyFileArea().getRoot(), downloadInfo.getComponent(), downloadInfo.getShareable().getRemote((IProgressMonitor)metaDataMonitor.newChild(1)));
            this.updateMetaData(downloadInfo, skipUpdate, (IProgressMonitor)metaDataMonitor.newChild(1));
            if (skipUpdate) continue;
            downloadInfo.getShareable().getFileStorage().setExecutable(downloadInfo.isExecutable(), (IProgressMonitor)metaDataMonitor.newChild(1));
        }
        metaDataMonitor.done();
        iterProgress = subMonitor.newChild(5);
        iterProgress.setWorkRemaining(deferredDownloadInfo.size());
        for (Object downloadInfo : deferredDownloadInfo) {
            if (!downloadInfo.contentUpdated()) continue;
            this.fileLoaded(downloadInfo.getShareable(), (IProgressMonitor)iterProgress.newChild(1));
        }
        iterProgress.done();
        this.updatesComplete((IProgressMonitor)subMonitor.newChild(5));
        failures = this.getDownloadFailures(deferredDownloadInfo);
        if (failures.length > 0) {
            seriousFailure = false;
            var15_26 = failures;
            var14_22 = failures.length;
            var13_17 = 0;
            while (var13_17 < var14_22) {
                failure = var15_26[var13_17];
                if (failure.getSeverity() == 4 || failure.getSeverity() == 8) {
                    seriousFailure = true;
                }
                this.collectStatus(failure);
                ++var13_17;
            }
            if (seriousFailure) {
                failures = this.getErrors();
                RepositoryUtils.throwAppropriateException(Messages.UpdateMutator_20, failures);
            }
        } else if (this.contentSession.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateConfigStates((IProgressMonitor)subMonitor.newChild(5));
        this.updateCompleted((IProgressMonitor)subMonitor.newChild(5));
    }

    private void refreshLinks(Set<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(linksToRefresh.size() + linksToRecompute.size()));
        for (Shareable shareable : linksToRefresh) {
            try {
                new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.SYMBOLIC_LINK).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        for (Shareable shareable : linksToRecompute) {
            try {
                lcm.computeChanges(shareable, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
    }

    protected void startingUpdates(IUpdateInfo orderer, IProgressMonitor progress) {
    }

    protected void folderAddsAndMovesCompleted(IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
    }

    protected void updateCompleted(IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
    }

    private void verifyUpdatesOutsideShares(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.failedUpdates.size());
        if (this.failedUpdates.isEmpty()) {
            return;
        }
        HashMap shares = new HashMap();
        for (ICopyFileArea iCopyFileArea : this.copyFileAreasToUpdate) {
            Map<UUID, List<FileAreaUpdate>> failedUpdatesForCFA = this.failedUpdates.get(iCopyFileArea);
            if (failedUpdatesForCFA == null) continue;
            Collection<IShare> allShares = iCopyFileArea.allShares();
            for (IShare iShare : allShares) {
                HashMap<UUID, IShare> sharesForComponent;
                ISharingDescriptor descriptor = iShare.getSharingDescriptor();
                if (!failedUpdatesForCFA.containsKey(descriptor.getComponent().getItemId()) || !descriptor.getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle)) continue;
                HashMap<UUID, HashMap<UUID, IShare>> sharesForCFA = (HashMap<UUID, HashMap<UUID, IShare>>)shares.get(iCopyFileArea);
                if (sharesForCFA == null) {
                    sharesForCFA = new HashMap<UUID, HashMap<UUID, IShare>>();
                    shares.put(iCopyFileArea, sharesForCFA);
                }
                if ((sharesForComponent = (HashMap<UUID, IShare>)sharesForCFA.get(descriptor.getComponent().getItemId())) == null) {
                    sharesForComponent = new HashMap<UUID, IShare>();
                    sharesForCFA.put(descriptor.getComponent().getItemId(), sharesForComponent);
                }
                sharesForComponent.put(descriptor.getRootVersionable().getItemId(), iShare);
            }
        }
        for (Map.Entry entry : this.failedUpdates.entrySet()) {
            ICopyFileArea cfa = (ICopyFileArea)entry.getKey();
            Map failedUpdatesForCFA = (Map)entry.getValue();
            for (Map.Entry entry2 : failedUpdatesForCFA.entrySet()) {
                HashMap sharesForComponent;
                IConfiguration configuration = null;
                HashMap<UUID, UUID> itemsSeen = new HashMap<UUID, UUID>();
                HashMap<UUID, IVersionableHandle> itemsToLocate = new HashMap<UUID, IVersionableHandle>();
                HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates = new HashMap<UUID, HashSet<FileAreaUpdate>>();
                for (FileAreaUpdate update : (List)entry2.getValue()) {
                    if (configuration == null) {
                        configuration = this.connection instanceof IWorkspaceConnection ? (((UUID)entry2.getKey()).equals((Object)update.getComponent().getItemId()) ? ((IWorkspaceConnection)this.connection).configuration(update.component()) : ((IWorkspaceConnection)this.connection).configuration(update.getPreviousComponent())) : ((IBaselineConnection)this.connection).configuration();
                    }
                    if (update.isChangeType(8)) {
                        if (((UUID)entry2.getKey()).equals((Object)update.getComponent().getItemId())) {
                            this.determineWhatToLocate(itemsSeen, itemsToLocate, locateUpdates, update);
                        }
                        if (!((UUID)entry2.getKey()).equals((Object)update.getPreviousComponent().getItemId())) continue;
                        UUID parentId = update.getSourceParent().getItemId();
                        HashSet<FileAreaUpdate> toRecord = new HashSet<FileAreaUpdate>();
                        toRecord.add(update);
                        if (!itemsSeen.containsKey(parentId)) {
                            itemsToLocate.put(parentId, (IVersionableHandle)update.getSourceParent());
                            locateUpdates.put(parentId, toRecord);
                            itemsSeen.put(parentId, null);
                            continue;
                        }
                        this.recordUpdateAgainstLocate(parentId, toRecord, itemsSeen, locateUpdates);
                        continue;
                    }
                    if (!update.isChangeType(1) && !update.isChangeType(4)) continue;
                    this.determineWhatToLocate(itemsSeen, itemsToLocate, locateUpdates, update);
                }
                Map sharesForCFA = (Map)shares.get(cfa);
                if (sharesForCFA == null || (sharesForComponent = (HashMap)sharesForCFA.get(configuration.component().getItemId())) == null || sharesForComponent.isEmpty() || itemsToLocate.isEmpty()) continue;
                IComponent component = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)configuration.component(), 0, null);
                ArrayList<IVersionableHandle> toLocate = new ArrayList<IVersionableHandle>(itemsToLocate.values());
                List report = configuration.locateAncestors(toLocate, (IProgressMonitor)progress.newChild(1));
                int i = 0;
                for (IAncestorReport parentage : report) {
                    for (INameItemPair pair : parentage.getNameItemPairs()) {
                        IShare share = (IShare)sharesForComponent.get(pair.getItem().getItemId());
                        if (share == null) continue;
                        this.recordInconsistentShare(configuration.component(), share);
                        this.reportFailedUpdates(component, toLocate.get(i), locateUpdates);
                    }
                    ++i;
                }
            }
        }
    }

    private void determineWhatToLocate(HashMap<UUID, UUID> itemsSeen, HashMap<UUID, IVersionableHandle> itemsToLocate, HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates, FileAreaUpdate update) {
        HashSet<FileAreaUpdate> toRecord;
        UUID itemId = update.item().getItemId();
        UUID parentId = update.getDestinationParent().getItemId();
        itemsSeen.put(itemId, parentId);
        if (itemsToLocate.containsKey(itemId)) {
            itemsToLocate.remove(itemId);
            toRecord = locateUpdates.remove(itemId);
        } else {
            toRecord = new HashSet<FileAreaUpdate>();
        }
        toRecord.add(update);
        if (!itemsSeen.containsKey(parentId)) {
            itemsToLocate.put(parentId, (IVersionableHandle)update.getDestinationParent());
            locateUpdates.put(parentId, toRecord);
            itemsSeen.put(parentId, null);
        } else {
            this.recordUpdateAgainstLocate(parentId, toRecord, itemsSeen, locateUpdates);
        }
    }

    private void recordUpdateAgainstLocate(UUID itemId, HashSet<FileAreaUpdate> toRecord, HashMap<UUID, UUID> itemsSeen, HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates) {
        int paranoiaCount = 0;
        while (paranoiaCount < 2000) {
            UUID parent = itemsSeen.get(itemId);
            if (parent == null) {
                HashSet<FileAreaUpdate> updatesRecorded = locateUpdates.get(itemId);
                if (updatesRecorded == null) {
                    locateUpdates.put(itemId, toRecord);
                    break;
                }
                updatesRecorded.addAll(toRecord);
                break;
            }
            itemId = parent;
            ++paranoiaCount;
        }
    }

    private void reportFailedUpdates(IComponent component, IVersionableHandle versionableHandle, HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates) {
        HashSet<FileAreaUpdate> updatesToReport = locateUpdates.get(versionableHandle.getItemId());
        if (updatesToReport != null) {
            for (FileAreaUpdate update : updatesToReport) {
                if (update.isChangeType(4)) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_25, (Object)update.getName(), (Object[])new Object[]{component.getName()})));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof IFileItemHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_26, (Object)update.getName(), (Object[])new Object[]{component.getName()})));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof IFolderHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_27, (Object)update.getName(), (Object[])new Object[]{component.getName()})));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof ISymbolicLinkHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_49, (Object)update.getName(), (Object[])new Object[]{component.getName()})));
                    continue;
                }
                if (!update.isChangeType(8)) continue;
                this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_28, (Object)update.getOldName(), (Object[])new Object[]{component.getName()})));
            }
        }
    }

    private void doDilemmaHandling(ArrayList<DeferredDownloadInformation> deferredDownloadInfo, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(100);
        ArrayList<EncodingDownloadFailure> encodingFailures = new ArrayList<EncodingDownloadFailure>();
        for (DeferredInformation deferredInformation : deferredDownloadInfo) {
            if (deferredInformation == null || deferredInformation.getFailure() == null) continue;
            Object rootCause = deferredInformation.getFailure().getCause();
            int digParanoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)((Object)rootCause)).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++digParanoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                encodingFailures.add(new EncodingDownloadFailure(deferredInformation));
                continue;
            }
            if (rootCause instanceof CharacterCodingException) {
                encodingFailures.add(new EncodingDownloadFailure(deferredInformation));
                continue;
            }
            if (!(rootCause instanceof OperationCanceledException)) continue;
            throw new OperationCanceledException();
        }
        if (encodingFailures.size() > 0) {
            boolean bl;
            for (EncodingDownloadFailure encodingDownloadFailure : encodingFailures) {
                encodingDownloadFailure.setIgnoreEncoding(true);
            }
            boolean bl2 = false;
            this.contentSession = FileSystemCore.getContentManager(this.repository).createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName(), (Object[])new Object[0]), true, encodingFailures.size(), (IProgressMonitor)progress.newChild(75));
            try {
                for (EncodingDownloadFailure failure : encodingFailures) {
                    if (!failure.hasDirection()) continue;
                    DeferredDownloadInformation info = (DeferredDownloadInformation)failure.getDeferredUpdateInformation();
                    IVersionableHandle fileItemState = info.getFileItemState();
                    this.contentSession.retrieveContent((IFileItemHandle)fileItemState, info.getContent(), info.getEncoding(), info.getLineDelimiter(), new DownloadHandler(info.getShareable(), info, false));
                    bl = true;
                }
            }
            finally {
                if (bl) {
                    this.contentSession.join();
                }
            }
            SubMonitor iterProgress = progress.newChild(25);
            iterProgress.setWorkRemaining(encodingFailures.size());
            for (EncodingDownloadFailure failure : encodingFailures) {
                if (!failure.getDeferredUpdateInformation().isLineDelimiterIgnored() || failure.getDeferredUpdateInformation().getFailure() != null) continue;
                failure.getDeferredUpdateInformation().convert((IProgressMonitor)iterProgress.newChild(1));
            }
        }
    }

    private IStatus[] getDownloadFailures(ArrayList<DeferredDownloadInformation> deferredDownloadInfo) {
        ArrayList<Status> errors = new ArrayList<Status>();
        boolean reportedSupportedCharSets = false;
        for (DeferredDownloadInformation deferredUpdateInformation : deferredDownloadInfo) {
            Status status;
            if (deferredUpdateInformation == null) continue;
            if (deferredUpdateInformation.getFailure() != null) {
                Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
                if (rootCause == null) {
                    rootCause = deferredUpdateInformation.getFailure();
                }
                int paranoiaCount = 0;
                while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                    Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                    if (cause == null) break;
                    rootCause = cause;
                    ++paranoiaCount;
                }
                if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                    if (!reportedSupportedCharSets) {
                        StringBuffer charSetsAvailable = new StringBuffer();
                        for (String charsetName : Charset.availableCharsets().keySet()) {
                            charSetsAvailable.append(charsetName).append(' ');
                        }
                        Status infoStatus = new Status(1, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_11, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                        errors.add(infoStatus);
                        reportedSupportedCharSets = true;
                    }
                    status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_21, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
                } else if (rootCause instanceof CharacterCodingException) {
                    status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_23, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
                } else {
                    if (rootCause instanceof OperationCanceledException) continue;
                    status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_22, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[0]), (Throwable)deferredUpdateInformation.getFailure());
                }
                errors.add(status);
                continue;
            }
            if (!deferredUpdateInformation.isLineDelimiterIgnored()) continue;
            IFileContent contentInfo = deferredUpdateInformation.getFileAreaUpdate().getOptionalContent();
            status = new Status(2, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_51, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[]{contentInfo.getCharacterEncoding(), contentInfo.getLineDelimiter().toString()}));
            errors.add(status);
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    protected void refresh(DeferredDownloadInformation downloadInfo, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        Shareable shareable = downloadInfo.getShareable();
        final IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        file.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)new SilentProgressMonitor((IProgressMonitor)progress.newChild(100)));
                    }
                });
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.UpdateMutator_44, (Throwable)e));
            }
        }
    }

    protected void updateMetaData(DeferredDownloadInformation downloadInfo, boolean skipUpdate, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        Shareable shareable = downloadInfo.getShareable();
        IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            ISharingDescriptor sharingDescriptor;
            boolean isLoadedWithAnotherName;
            String name;
            IFolderHandle parent;
            long modificationStamp = file.getModificationStamp();
            FileContent content = (FileContent)downloadInfo.getContent();
            FileItemInfo oldInfo = downloadInfo.getCopyFileArea().getItemInfo(shareable.getLocalPath());
            if (oldInfo == null) {
                parent = downloadInfo.getRemoteParent();
                name = downloadInfo.getRemoteName();
                isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), name);
            } else {
                parent = oldInfo.getParent();
                name = oldInfo.getName();
                isLoadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
            }
            FileItemInfoProxy infoProxy = new FileItemInfoProxy(downloadInfo.getFileItemState(), parent, name, isLoadedWithAnotherName);
            infoProxy.setContentInfo(modificationStamp, downloadInfo.getHash(), downloadInfo.getContentSize(), content);
            infoProxy.setExecutable(downloadInfo.isExecutable(), downloadInfo.isExecutable());
            infoProxy.setProperties(downloadInfo.getProperties());
            if (skipUpdate) {
                infoProxy.setContentChanged(true, modificationStamp);
            }
            if ((sharingDescriptor = downloadInfo.getSharingDescriptor()) != null) {
                IShare share = SharingManager.getInstance().share(shareable, sharingDescriptor, infoProxy.getFileItemInfo(), 2, (IProgressMonitor)progress);
                this.newShares.add(new ShareReference(sharingDescriptor.getComponent(), share));
            } else {
                downloadInfo.getCopyFileArea().setItemMetaData(shareable.getLocalPath(), infoProxy.getFileItemInfo(), (IProgressMonitor)progress);
            }
            if (skipUpdate && !shareable.exists((IProgressMonitor)progress.newChild(1))) {
                downloadInfo.getCopyFileArea().makePendingDeletion(downloadInfo.getShareable().getLocalPath(), (IProgressMonitor)progress);
            }
        }
        progress.done();
    }

    private IComponent getFullComponent(FileAreaUpdate update, IComponent currentComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle component = update.component();
        return this.getFullComponent(component, currentComponent, monitor);
    }

    private IComponent getFullComponent(IComponentHandle component, IComponent currentComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component instanceof IComponent) {
            return (IComponent)component;
        }
        if (!component.sameItemId((IItemHandle)currentComponent)) {
            currentComponent = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)component, 0, monitor);
        }
        return currentComponent;
    }

    private void updateConfigStates(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.newShares.removeAll(this.inconsistentShares);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.newShares.size() + this.inconsistentShares.size() + this.componentStatesAfter.size()));
        for (ShareReference newShare : this.newShares) {
            IComponentStateSummary summary = this.componentStatesAfter.get(newShare.component.getItemId());
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(newShare.share.getSandbox().getRoot());
            cfa.setConfigurationState(this.connectionHandle, newShare.component, newShare.share.getShareable().getLocalPath(), summary.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
        }
        for (IComponentStateSummary stateAfter : this.componentStatesAfter.values()) {
            IComponentStateSummary stateBefore = this.componentStatesBefore.get(stateAfter.getComponent().getItemId());
            if (stateBefore == null) continue;
            for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
                cfa.setConfigurationState(this.connectionHandle, stateAfter.getComponent(), stateBefore.getConfigurationTime(), stateAfter.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        for (ShareReference inconsistentShare : this.inconsistentShares) {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(inconsistentShare.share.getSandbox().getRoot());
            cfa.setUnknownConfigurationState(this.connectionHandle, inconsistentShare.component, inconsistentShare.share.getShareable().getLocalPath(), (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    protected ISyncTime getBeforeConfigState(IComponentHandle component) {
        return this.componentStatesBefore.get(component.getItemId()).getConfigurationTime();
    }

    protected void updateMetaDataAfterMove(ICopyFileArea cfa, IComponent component, IComponentHandle previousComponent, Shareable sourceShareable, Shareable targetShareable, boolean isShareRoot, boolean moveUpdate, boolean alsoModified, IFolderHandle parent, IVersionableHandle itemState, String remoteName, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FileItemInfo itemInfo = cfa.getItemInfo(sourceShareable.getLocalPath());
        if (isShareRoot) {
            if (!PathUtils.sameRelativePath(sourceShareable.getLocalPath(), sourceShareable.getSandbox().isCaseSensitive(), targetShareable.getLocalPath(), targetShareable.getSandbox().isCaseSensitive())) {
                cfa.moveInfo(sourceShareable.getLocalPath(), targetShareable.getLocalPath(), false, (IProgressMonitor)progress.newChild(74));
            }
            if (!component.sameItemId((IItemHandle)previousComponent)) {
                SharingDescriptor sharingDescriptor;
                SharingDescriptor descriptor = (SharingDescriptor)targetShareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor();
                ISyncTime previousSyncState = this.getBeforeConfigState(previousComponent);
                ISyncTime componentSyncState = this.getBeforeConfigState((IComponentHandle)component);
                FileItemInfo info = null;
                if (moveUpdate) {
                    InverseFileItemInfo oldInfo = cfa.getItemInfo(itemState, previousComponent, this.connectionHandle);
                    FileItemInfoProxy infoProxy = new FileItemInfoProxy(oldInfo);
                    if (!alsoModified) {
                        infoProxy.setItemState(itemState);
                    }
                    infoProxy.changeIdentity(parent, remoteName);
                    info = infoProxy.getFileItemInfo();
                }
                if (!descriptor.getConfigurationState().equals(previousSyncState)) {
                    this.recordInconsistentShare((IComponentHandle)component, targetShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    sharingDescriptor = new SharingDescriptor(descriptor.getRepositoryUri(), descriptor.getRepositoryId(), this.connection, (IComponentHandle)component, component.getName(), descriptor.getRootVersionable());
                    cfa.share(targetShareable.getLocalPath(), sharingDescriptor, info, 2, (IProgressMonitor)progress.newChild(24));
                } else if (componentSyncState == null) {
                    this.newShares.add(new ShareReference((IComponentHandle)component, targetShareable.getShare((IProgressMonitor)progress.newChild(1))));
                    sharingDescriptor = new SharingDescriptor(descriptor.getRepositoryUri(), descriptor.getRepositoryId(), this.connection, (IComponentHandle)component, component.getName(), descriptor.getRootVersionable());
                    cfa.share(targetShareable.getLocalPath(), sharingDescriptor, info, 2, (IProgressMonitor)progress.newChild(24));
                } else {
                    sharingDescriptor = new SharingDescriptor(descriptor.getRepositoryUri(), descriptor.getRepositoryId(), this.connection, (IComponentHandle)component, component.getName(), descriptor.getRootVersionable(), componentSyncState);
                    cfa.share(targetShareable.getLocalPath(), sharingDescriptor, info, 2, (IProgressMonitor)progress.newChild(25));
                }
            } else if (moveUpdate) {
                InverseFileItemInfo oldInfo = cfa.getItemInfo(itemState, (IComponentHandle)component, this.connectionHandle);
                FileItemInfoProxy info = new FileItemInfoProxy(oldInfo);
                if (!alsoModified) {
                    info.setItemState(itemState);
                }
                info.changeIdentity(parent, remoteName);
                cfa.setItemMetaData(targetShareable.getLocalPath(), info.getFileItemInfo(), null);
            }
        } else if (itemInfo != null) {
            SharingDescriptor sourceDescriptor;
            cfa.moveInfo(sourceShareable.getLocalPath(), targetShareable.getLocalPath(), moveUpdate, (IProgressMonitor)progress.newChild(90));
            if (moveUpdate && !alsoModified && (itemState instanceof IFileItemHandle || itemState instanceof ISymbolicLinkHandle)) {
                InverseFileItemInfo oldInfo = cfa.getItemInfo(itemState, (IComponentHandle)component, this.connectionHandle);
                FileItemInfoProxy info = new FileItemInfoProxy(oldInfo);
                info.setItemState(itemState);
                cfa.setItemMetaData(targetShareable.getLocalPath(), info.getFileItemInfo(), null);
            }
            if (!(sourceDescriptor = (SharingDescriptor)sourceShareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor()).getConfigurationState().equals(this.getBeforeConfigState(sourceDescriptor.getComponent()))) {
                this.recordInconsistentShare((IComponentHandle)component, targetShareable.getShare((IProgressMonitor)progress.newChild(1)));
            }
        }
    }

    public final void setSkipStoreContent(Map<IPath, Map<ConfigurationDescriptor, Set<UUID>>> skipList) {
        this.toSkip = skipList;
    }

    protected final void addUpdateToSkip(IPath cfa, IComponentHandle component, IVersionableHandle remote) {
        ConfigurationDescriptor desc;
        Set<UUID> uuids;
        Map<ConfigurationDescriptor, Set<UUID>> configMap = this.toSkip.get(cfa);
        if (configMap == null) {
            configMap = new HashMap<ConfigurationDescriptor, Set<UUID>>();
            this.toSkip.put(cfa, configMap);
        }
        if ((uuids = configMap.get(desc = new ConfigurationDescriptor(this.connection, component))) == null) {
            uuids = new HashSet<UUID>();
            configMap.put(desc, uuids);
        }
        uuids.add(remote.getItemId());
    }

    protected final boolean isSkipping() {
        return this.toSkip.size() > 0;
    }

    protected final boolean skipUpdate(IPath cfa, IComponentHandle comp, IVersionableHandle remote) {
        if (remote == null) {
            return false;
        }
        Map<ConfigurationDescriptor, Set<UUID>> configMap = this.toSkip.get(cfa);
        if (configMap == null) {
            return false;
        }
        ConfigurationDescriptor desc = new ConfigurationDescriptor(this.connection, comp);
        Set<UUID> uuids = configMap.get(desc);
        if (uuids == null) {
            return false;
        }
        return uuids.contains(remote.getItemId());
    }

    private void failedUpdate(ICopyFileArea cfa, FileAreaUpdate update) {
        this.failedUpdate(cfa, update, update.component());
    }

    protected final void failedUpdate(ICopyFileArea cfa, FileAreaUpdate update, IComponentHandle component) {
        List<FileAreaUpdate> failedUpdatesForComponent;
        Map<UUID, List<FileAreaUpdate>> failedUpdatesForCFA = this.failedUpdates.get(cfa);
        if (failedUpdatesForCFA == null) {
            failedUpdatesForCFA = new HashMap<UUID, List<FileAreaUpdate>>();
            this.failedUpdates.put(cfa, failedUpdatesForCFA);
        }
        if ((failedUpdatesForComponent = failedUpdatesForCFA.get(component.getItemId())) == null) {
            failedUpdatesForComponent = new ArrayList<FileAreaUpdate>();
            failedUpdatesForCFA.put(component.getItemId(), failedUpdatesForComponent);
        }
        failedUpdatesForComponent.add(update);
    }

    @Override
    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemClientException {
        if (errors.length == 0) {
            return;
        }
        if (this.inconsistentShares.size() > 0) {
            MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.UpdateMutator_24, (Object)errors.length, (Object[])new Object[0]), null);
            throw new FileSystemClientException((IStatus)result);
        }
        super.reportErrorsAsException(errors);
    }

    protected void folderCreated(Shareable newFolder, boolean isShare, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    protected void fileLoaded(Shareable fileLoaded, IProgressMonitor monitor) throws FileSystemClientException {
    }

    protected void updatesComplete(IProgressMonitor monitor) throws FileSystemClientException {
    }

    private class DownloadHandler
    extends FileDownloadHandler {
        private Shareable shareable;
        private DeferredDownloadInformation downloadInfo;
        private boolean skipWrite;

        public DownloadHandler(Shareable shareable, DeferredDownloadInformation downloadInfo, boolean skipWrite) {
            this.shareable = shareable;
            this.downloadInfo = downloadInfo;
            this.skipWrite = skipWrite;
        }

        public void downloadStreamAcquired(IFileItemHandle item, IFileContent content, InputStream in) throws TeamRepositoryException {
            final InputStream contentStream = in;
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        try {
                            File victim;
                            DownloadHandler.this.downloadInfo.reset();
                            if (((DownloadHandler)DownloadHandler.this).UpdateMutator.this.downloadMonitor != null) {
                                ((DownloadHandler)DownloadHandler.this).UpdateMutator.this.downloadMonitor.downloadStarted(DownloadHandler.this.shareable.getFullPath(), DownloadHandler.this.downloadInfo.getContent().getEstimatedConvertedLength());
                            }
                            FileOutputStream out = null;
                            if (!DownloadHandler.this.skipWrite) {
                                out = new FileOutputStream(DownloadHandler.this.shareable.getFullPath().toFile());
                            }
                            boolean completed = false;
                            try {
                                DigestComputingInputStream inStream = ContentHash.getDigestComputingStream((InputStream)contentStream);
                                if (out == null) {
                                    if (!$assertionsDisabled && !DownloadHandler.this.skipWrite) {
                                        throw new AssertionError();
                                    }
                                    UpdateMutator.read((InputStream)inStream);
                                } else {
                                    ContentManager.read((InputStream)inStream, (OutputStream)out);
                                }
                                Shareable shareableUpdated = new Shareable(DownloadHandler.this.shareable.getSandbox().getRoot(), DownloadHandler.this.shareable.getLocalPath(), ResourceType.FILE);
                                DownloadHandler.this.downloadInfo.setContentUpdated(shareableUpdated, ContentHash.valueOf((byte[])inStream.getFinalDigest()), inStream.getContentSize());
                                completed = true;
                            }
                            catch (Throwable throwable) {
                                File victim2;
                                try {
                                    if (out != null) {
                                        ((OutputStream)out).close();
                                    }
                                }
                                catch (IOException iOException) {}
                                if (!completed && !DownloadHandler.this.skipWrite && (victim2 = DownloadHandler.this.shareable.getFullPath().toFile()).exists()) {
                                    victim2.delete();
                                }
                                throw throwable;
                            }
                            try {
                                if (out != null) {
                                    ((OutputStream)out).close();
                                }
                            }
                            catch (IOException iOException) {}
                            if (!completed && !DownloadHandler.this.skipWrite && (victim = DownloadHandler.this.shareable.getFullPath().toFile()).exists()) {
                                victim.delete();
                            }
                        }
                        catch (ContentHashAlgorithmException e) {
                            IStatus status = FileSystemStatus.getStatusFor(4, 203, NLS.bind((String)Messages.UpdateMutator_37, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                            throw new CoreException(status);
                        }
                        catch (SocketException e) {
                            IStatus status = FileSystemStatus.getStatusFor(4, 203, NLS.bind((String)Messages.UpdateMutator_37, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                            throw new CoreException(status);
                        }
                        catch (IOException e) {
                            IStatus status = FileSystemStatus.getStatusFor(4, 203, NLS.bind((String)Messages.UpdateMutator_38, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                            throw new CoreException(status);
                        }
                    }
                });
            }
            catch (CoreException e) {
                LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_39, (Object)this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                throw new TeamRepositoryException(NLS.bind((String)Messages.UpdateMutator_40, (Object)this.shareable.getFullPath().toString(), (Object[])new Object[0]), (Throwable)e);
            }
        }

        public void downloadFailed(IFileItemHandle item, IFileContent content, Exception e) {
            this.downloadInfo.setFailure(this.shareable, e);
        }
    }

    private static class ShareReference {
        protected IComponentHandle component;
        protected IShare share;

        public ShareReference(IComponentHandle component, IShare share) {
            this.component = component;
            this.share = share;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
            result = 31 * result + (this.share.getShareable().getFullPath() == null ? 0 : this.share.getShareable().getFullPath().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ShareReference other = (ShareReference)obj;
            if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
                return false;
            }
            return !(this.share.getShareable().getFullPath() == null ? other.share.getShareable().getFullPath() != null : !this.share.getShareable().getFullPath().equals((Object)other.share.getShareable().getFullPath()));
        }
    }
}

