/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemovedShare
implements IRemovedShare {
    private final int uncommittedChangeCount;
    private final IShare share;
    private boolean toDelete;

    public RemovedShare(IShare share, IProgressMonitor monitor) throws FileSystemClientException {
        this.share = share;
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        LocalChangeManager.getInstance().refreshChanges(new IShare[]{share}, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
        this.uncommittedChangeCount = lcm.getPendingChanges(new IShare[]{share}).length;
        this.toDelete = false;
    }

    public boolean isToBeDeleted() {
        return this.toDelete;
    }

    public void isToBeDeleted(boolean toDelete) {
        this.toDelete = toDelete;
    }

    public int getUncommittedChangeCount() {
        return this.uncommittedChangeCount;
    }

    public IPath getLocalPath() {
        return this.share.getPath();
    }

    public IPath getFullPath() {
        return this.share.getSandbox().getRoot().append(this.share.getPath());
    }

    public int hashCode() {
        int result = 1;
        result *= 31;
        result = 31 * result + (this.share != null && this.share.getSandbox() != null ? 0 : this.share.getSandbox().hashCode());
        result = 31 * result + (this.share != null && this.share.getPath() != null ? 0 : this.share.getPath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemovedShare other = (RemovedShare)obj;
        if (this.share == null ? other.share != null : other.share == null) {
            return false;
        }
        if (this.share.getSandbox() == null ? other.share.getSandbox() != null : !this.share.getSandbox().equals(other.share.getSandbox())) {
            return false;
        }
        return !(this.share.getPath() == null ? other.share.getPath() != null : !this.share.getPath().equals((Object)other.share.getPath()));
    }

    public IShare getShare() {
        return this.share;
    }
}

