/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LoadLocation
implements ILoadLocation {
    private ISandbox sandbox;
    private IPath relativeLoadPath;
    private String name;
    private IPath fullPath;
    private IConnection connection;
    private IComponent component;
    private IVersionableHandle itemToLoad;
    private boolean loadWithAnotherName;

    public LoadLocation(ISandbox sandbox, IPath relativeLoadPath, String name, IConnection connection, IComponent component, IVersionableHandle itemToLoad, boolean isLoadWithAnotherName) throws TeamRepositoryException {
        this.sandbox = sandbox;
        this.relativeLoadPath = relativeLoadPath;
        this.name = name;
        this.fullPath = new Path(sandbox.getRoot().append(relativeLoadPath).append(name).toFile().getAbsolutePath()).removeTrailingSeparator();
        this.connection = connection;
        this.component = component;
        this.itemToLoad = itemToLoad;
        this.loadWithAnotherName = isLoadWithAnotherName;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
        result = 31 * result + (this.fullPath == null ? 0 : this.fullPath.hashCode());
        result = 31 * result + (this.itemToLoad == null ? 0 : this.itemToLoad.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadLocation other = (LoadLocation)obj;
        if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
            return false;
        }
        if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
            return false;
        }
        if (this.fullPath == null ? other.fullPath != null : !this.fullPath.equals((Object)other.fullPath)) {
            return false;
        }
        return !(this.itemToLoad == null ? other.itemToLoad != null : !this.itemToLoad.sameItemId((IItemHandle)other.itemToLoad));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getComponent().getName());
        sb.append('/');
        sb.append(this.fullPath.toString());
        return sb.toString();
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public ISandbox getSandbox() {
        return this.sandbox;
    }

    public IPath getLoadPath() {
        return this.relativeLoadPath.append(this.name);
    }

    public IVersionableHandle getRootToLoad() {
        return this.itemToLoad;
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public boolean isLoadWithAnotherName() {
        return this.loadWithAnotherName;
    }
}

