/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class RandomAccessFileInputStream
extends InputStream {
    protected ByteBuffer ONE_BYTE_BUF;
    protected long readOffset;
    protected long startOffset;
    protected long limit;
    protected RAFWrapper raf;
    protected StringBuilder log;

    public RandomAccessFileInputStream(long offset, long size, RAFWrapper raf, StringBuilder log) throws IOException {
        this.startOffset = this.readOffset = offset;
        this.raf = raf;
        this.log = log;
        this.limit = size < 0L ? raf.getFile().length() : offset + size;
    }

    public int read() throws IOException {
        int bytesRead;
        if (this.readOffset == this.limit) {
            this.log.append("Attempting to read beyond specified limit of " + (this.limit - this.readOffset) + ", initial location: " + this.startOffset + "\n");
        }
        if (this.ONE_BYTE_BUF == null) {
            this.ONE_BYTE_BUF = ByteBuffer.allocate(1);
        } else {
            this.ONE_BYTE_BUF.rewind();
        }
        try {
            while ((bytesRead = this.raf.getFile().getChannel().read(this.ONE_BYTE_BUF, this.readOffset)) == 0) {
            }
        }
        finally {
            this.readOffset += (long)this.ONE_BYTE_BUF.position();
        }
        if (bytesRead == -1) {
            return -1;
        }
        return this.ONE_BYTE_BUF.get(0) & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.readOffset == this.limit && len > 0) {
            this.log.append("Attempting to read " + len + " bytes beyond specified limit of " + (this.limit - this.readOffset) + ", initial location: " + this.startOffset + "\n");
        } else if (this.readOffset < this.limit) {
            len = (int)Math.min((long)len, this.limit - this.readOffset);
        }
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        try {
            int n = this.raf.getFile().getChannel().read(buf, this.readOffset);
            return n;
        }
        finally {
            this.readOffset += (long)(buf.position() - off);
        }
    }

    public long skip(long n) throws IOException {
        if (this.readOffset == this.limit) {
            this.log.append("Attempting to skip " + n + " bytes beyond specified limit of " + (this.limit - this.readOffset) + ", initial location: " + this.startOffset + "\n");
            n = Math.min(n, this.raf.getFile().length() - this.readOffset);
        } else {
            n = this.readOffset < this.limit ? Math.min(n, this.limit - this.readOffset) : Math.min(n, this.raf.getFile().length() - this.readOffset);
        }
        this.readOffset += n;
        return n;
    }
}

