/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathLockRequest
extends CopyFileAreaLockRequest {
    private final Collection<IShareable> shareables;

    public PathLockRequest(Collection<IShareable> shareables) {
        this.shareables = shareables;
    }

    @Override
    public void addLocks(Set<? super AbstractLock> rules, IProgressMonitor monitor) throws FileSystemClientException {
        for (IShareable s : this.shareables) {
            IPath root = s.getSandbox().getRoot();
            AbstractLock lock = PathLockRequest.lockCFA(root, monitor);
            try {
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(root);
                ISharingDescriptor desc = cfa.findSharingDescriptor(s.getLocalPath());
                if (desc != null) {
                    rules.add(new ComponentLock(cfa.getRoot(), desc.getConnectionHandle(), desc.getComponent()));
                    continue;
                }
                rules.add(new CFAReadLock(cfa.getRoot()));
            }
            finally {
                CopyFileAreaManager.instance.batchingLock.release(lock, monitor);
            }
        }
    }

    protected static AbstractLock lockCFA(IPath path, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaManager manager = CopyFileAreaManager.instance;
        CopyFileArea cfa = manager.getExistingCopyFileArea(path);
        if (cfa == null) {
            cfa = manager.createCopyFileArea(path, (IProgressMonitor)progress.newChild(20));
        }
        IPath root = cfa.getRoot();
        while (true) {
            progress.setWorkRemaining(100);
            AbstractLock lock = manager.batchingLock.acquire(new CFAReadLock(root), manager, CopyFileAreaManager.NULL_PARTICIPANT, true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = manager.getExistingCopyFileArea(path);
                if (cfa != null) {
                    if (root.equals((Object)cfa.getRoot())) {
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                } else {
                    manager.batchingLock.release(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = manager.createCopyFileArea(path, (IProgressMonitor)progress.newChild(20));
                }
                root = cfa.getRoot();
                continue;
            }
            finally {
                if (success) continue;
                manager.batchingLock.release(lock, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
    }

    @Override
    public boolean validateLocks(IProgressMonitor monitor) throws FileSystemClientException {
        for (IShareable s : this.shareables) {
            IPath root = s.getSandbox().getRoot();
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(root);
            if (cfa == null) {
                return false;
            }
            ISharingDescriptor desc = cfa.findSharingDescriptor(s.getLocalPath());
            if (!(desc != null ? !CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(cfa.getRoot(), desc.getConnectionHandle(), desc.getComponent())) : !CopyFileAreaManager.instance.batchingLock.isLocked(new CFAReadLock(cfa.getRoot())))) continue;
            return false;
        }
        return true;
    }
}

