/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAListReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalConfigurationLockRequest
extends CopyFileAreaLockRequest {
    private final Collection<? extends ConfigurationDescriptor> configurationsToLock;
    private final boolean expandToIncludeEntireCopyFileArea;

    public GlobalConfigurationLockRequest(Set<? extends ConfigurationDescriptor> configurationsToLock2, boolean expandToIncludeEntireCopyFileArea) {
        this.configurationsToLock = configurationsToLock2;
        this.expandToIncludeEntireCopyFileArea = expandToIncludeEntireCopyFileArea;
    }

    @Override
    public void addLocks(Set<? super AbstractLock> rules, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.configurationsToLock.size());
        if (this.configurationsToLock.isEmpty()) {
            progress.done();
            return;
        }
        rules.add(CFAListReadLock.INSTANCE);
        if (this.expandToIncludeEntireCopyFileArea) {
            HashSet<IPath> hashSet = new HashSet<IPath>();
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    IPath root = cfa.getRoot();
                    if (!hashSet.add(root)) continue;
                    rules.add(new GlobalCFALock(root));
                }
            }
        } else {
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    IPath root = cfa.getRoot();
                    rules.add(new ComponentLock(root, configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle));
                }
            }
        }
        progress.done();
    }

    @Override
    public boolean validateLocks(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.configurationsToLock.size());
        if (this.configurationsToLock.isEmpty()) {
            progress.done();
            return true;
        }
        if (this.expandToIncludeEntireCopyFileArea) {
            HashSet<IPath> hashSet = new HashSet<IPath>();
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    IPath root = cfa.getRoot();
                    if (!hashSet.add(root) || CopyFileAreaManager.instance.batchingLock.isLocked(new GlobalCFALock(root))) continue;
                    progress.done();
                    return false;
                }
            }
        } else {
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    IPath root = cfa.getRoot();
                    if (CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(root, configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle))) continue;
                    progress.done();
                    return false;
                }
            }
        }
        progress.done();
        return true;
    }
}

