/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileAreaRemovalLockRequest
extends CopyFileAreaLockRequest {
    private final Set<IPath> cfaPaths;

    public CopyFileAreaRemovalLockRequest(Set<IPath> cfas) {
        this.cfaPaths = cfas;
    }

    @Override
    public void addLocks(Set<? super AbstractLock> locks, IProgressMonitor monitor) throws FileSystemClientException {
        for (IPath path : this.cfaPaths) {
            CFARemoveLock lock = new CFARemoveLock(path);
            locks.add(lock);
        }
    }

    @Override
    public boolean validateLocks(IProgressMonitor monitor) throws FileSystemClientException {
        for (IPath path : this.cfaPaths) {
            if (CopyFileAreaManager.instance.batchingLock.isLocked(new CFARemoveLock(path))) continue;
            monitor.done();
            return false;
        }
        return true;
    }
}

