/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.BiPartitionLock;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFACreateLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequestFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaNotifier;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileAreaManager
implements ICopyFileAreaManager,
IFlushOperation {
    public static final CopyFileAreaManager instance = new CopyFileAreaManager();
    private static final String SCM_PRIVATE = ".jazz5";
    private static final String INTERUM_METADATA_FOLDER = ".jazz4";
    private static final String OLD_METADATA_FOLDER_NAME = ".jazz3";
    public static final String[] SUPPORTED_METADATA_FOLDERS = new String[]{".jazz5", ".jazz4", ".jazz3"};
    static final ILockParticipant NULL_PARTICIPANT = new ILockParticipant(){

        public AbstractLock locking(AbstractLock rule) {
            return rule;
        }

        public void waiting() {
        }
    };
    protected final BatchingLock batchingLock = new BatchingLock();
    protected final ConcurrentHashMap<IPath, CopyFileArea> cfas = new ConcurrentHashMap();
    protected final CopyFileAreaNotifier notifier = new CopyFileAreaNotifier();
    protected final BiPartitionLock cfaListLock = new BiPartitionLock();
    protected final ListenerList corruptionListenerList = new ListenerList();

    private CopyFileAreaManager() {
    }

    @Override
    public void addCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.corruptionListenerList.add((Object)listener);
        for (CopyFileArea cfa : this.cfas.values()) {
            cfa.internalGetMetadata().addCorruptionListener(listener);
        }
    }

    @Override
    public void removeCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.corruptionListenerList.remove((Object)listener);
        for (CopyFileArea cfa : this.cfas.values()) {
            cfa.internalGetMetadata().removeCorruptionListener(listener);
        }
    }

    @Override
    public void addListener(ICopyFileAreaListener listener) {
        this.notifier.addGlobalListener(listener);
    }

    @Override
    public void removeListener(ICopyFileAreaListener listener) {
        this.notifier.removeGlobalListener(listener);
    }

    @Override
    public void flush(BatchingLock.ThreadInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        this.notifier.fireEvents(info.getEvents());
    }

    public boolean isLocked(AbstractLock lock) {
        return this.batchingLock.isLocked(lock);
    }

    @Override
    public Object beginAvoidNotify() {
        return this.batchingLock.acquire(BatchingLock.AVOID_NOTIFICATION_RULE, this, NULL_PARTICIPANT, true, null);
    }

    @Override
    public void endAvoidNotify(Object beginNotifyToken, IProgressMonitor monitor) throws FileSystemClientException {
        this.batchingLock.release((AbstractLock)beginNotifyToken, monitor);
    }

    @Override
    public boolean copyFileAreaExists(IPath root, int option) {
        if (option == 1) {
            return CopyFileAreaManager.getMetadataPathForRoot(root).toFile().exists();
        }
        if (option == 0) {
            if (this.cfas.containsKey(root)) {
                return true;
            }
            return this.cfas.containsKey(CopyFileAreaManager.getCanonicalPath(root));
        }
        if (option == 2) {
            boolean exists = false;
            String[] stringArray = SUPPORTED_METADATA_FOLDERS;
            int n = SUPPORTED_METADATA_FOLDERS.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                exists = root.append(name).toFile().exists();
                if (exists) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    private static IPath getCanonicalPath(IPath path) {
        try {
            return new Path(path.toFile().getCanonicalPath()).removeTrailingSeparator();
        }
        catch (IOException iOException) {
            return path;
        }
    }

    private ISharingMetadata createSharingMetadata(IPath root) throws FileSystemClientException {
        Assert.isLegal((root != null ? 1 : 0) != 0);
        IPath metadataPath = CopyFileAreaManager.getMetadataPathForRoot(root);
        MetadataChangeTracker md = new MetadataChangeTracker(new SharingMetadata2(root, metadataPath), root, metadataPath);
        Object[] objectArray = this.corruptionListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            md.addCorruptionListener((ICorruptCopyFileAreaListener)listener);
            ++n2;
        }
        return md;
    }

    public static IPath getMetadataPathForRoot(IPath root) {
        return root.append(SCM_PRIVATE);
    }

    @Override
    public CopyFileArea createCopyFileArea(IPath root, IProgressMonitor monitor) throws FileSystemClientException {
        this.batchingLock.validateAcquire(CFACreateLock.INSTANCE);
        CopyFileArea cfa = this.cfas.get(root);
        if (cfa != null) {
            return cfa;
        }
        cfa = this.cfas.get(root = CopyFileAreaManager.getCanonicalPath(root));
        if (cfa != null) {
            return cfa;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = this.batchingLock.acquire(CFACreateLock.INSTANCE, this, NULL_PARTICIPANT, true, (IProgressMonitor)progress.newChild(40));
        try {
            root = CopyFileAreaManager.getCanonicalPath(root);
            cfa = this.cfas.get(root);
            if (cfa != null) {
                CopyFileArea copyFileArea = cfa;
                return copyFileArea;
            }
            for (IPath cfaRoot : this.cfas.keySet()) {
                if (!cfaRoot.isPrefixOf(root) && !root.isPrefixOf(cfaRoot)) continue;
                throw new IllegalArgumentException("Cannot nest CFAs " + root + " and " + cfaRoot);
            }
            cfa = new CopyFileArea(root, this.createSharingMetadata(root));
            this.cfaListLock.acquirePart1();
            try {
                this.cfas.put(root, cfa);
            }
            finally {
                this.cfaListLock.releasePart1();
            }
            this.batchingLock.addChange(new CopyFileAreaEvent(null, cfa, null, 9));
            if (instance.requiresMigration(root)) {
                cfa.internalGetMetadata().setCorrupt(true, "Metadata migration is required", null);
            }
        }
        finally {
            this.batchingLock.release(lock, (IProgressMonitor)progress.newChild(40));
        }
        return cfa;
    }

    @Override
    public void deregister(IPath root, boolean eraseCopyFileArea, IProgressMonitor monitor) throws FileSystemClientException {
        if (!this.cfas.containsKey(root) && !this.cfas.containsKey(root = CopyFileAreaManager.getCanonicalPath(root))) {
            this.batchingLock.validateAcquire(new CFARemoveLock(root));
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = this.batchingLock.acquire(new CFARemoveLock(root), this, NULL_PARTICIPANT, true, (IProgressMonitor)progress.newChild(40));
        try {
            CopyFileArea cfa = this.cfas.get(root);
            if (cfa == null) {
                return;
            }
            this.cfaListLock.acquirePart1();
            try {
                cfa.internalClose();
                if (eraseCopyFileArea) {
                    cfa.internalClear();
                }
                this.cfas.remove(root);
            }
            finally {
                this.cfaListLock.releasePart1();
            }
            this.batchingLock.addChange(new CopyFileAreaEvent(null, cfa, null, 10));
        }
        finally {
            this.batchingLock.release(lock, (IProgressMonitor)progress.newChild(40));
        }
    }

    @Override
    public Collection<ICopyFileArea> getAllCopyFileAreas() {
        this.cfaListLock.acquirePart2();
        try {
            ArrayList<ICopyFileArea> arrayList = new ArrayList<ICopyFileArea>(this.cfas.values());
            return arrayList;
        }
        finally {
            this.cfaListLock.releasePart2();
        }
    }

    @Override
    public ICopyFileArea getCopyFileAreaForPath(IPath path) {
        Path absolutePath;
        if (path.isAbsolute()) {
            for (ICopyFileArea cfa : this.getAllCopyFileAreas()) {
                if (!cfa.getRoot().isPrefixOf(path)) continue;
                return cfa;
            }
        }
        if (!(absolutePath = new Path(path.toFile().getAbsolutePath())).equals((Object)path)) {
            ArrayList<ICopyFileArea> allCopyFileAreas = new ArrayList<ICopyFileArea>(this.getAllCopyFileAreas());
            Collections.sort(allCopyFileAreas, new Comparator<ICopyFileArea>(){

                @Override
                public int compare(ICopyFileArea cfa1, ICopyFileArea cfa2) {
                    return cfa1.getRoot().segmentCount() - cfa2.getRoot().segmentCount();
                }
            });
            for (ICopyFileArea cfa : allCopyFileAreas) {
                if (absolutePath.segmentCount() < cfa.getRoot().segmentCount()) continue;
                IPath prefix = absolutePath.removeLastSegments(absolutePath.segmentCount() - cfa.getRoot().segmentCount());
                IPath canon = CopyFileAreaManager.getCanonicalPath(prefix);
                if (!cfa.getRoot().equals((Object)canon)) continue;
                return cfa;
            }
        }
        return null;
    }

    @Override
    public Collection<ICopyFileArea> getCopyFileAreasForConnection(IConnection connection, IProgressMonitor monitor) throws FileSystemClientException {
        ArrayList<ICopyFileArea> found;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            found = new ArrayList<ICopyFileArea>(cfas.size());
            progress.setWorkRemaining(cfas.size());
            for (CopyFileArea cfa : cfas) {
                Collection<ConnectionDescriptor> contexts = cfa.internalAllLoadedContexts((IProgressMonitor)progress.newChild(1));
                for (ConnectionDescriptor connectionDescriptor : contexts) {
                    if (!connection.getContextHandle().sameItemId((IItemHandle)connectionDescriptor.connectionHandle)) continue;
                    found.add(cfa);
                }
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        progress.done();
        return found;
    }

    @Override
    public Collection<ICopyFileArea> getCopyFileAreasForConfiguration(ConfigurationDescriptor configuration, IProgressMonitor monitor) throws FileSystemClientException {
        ArrayList<ICopyFileArea> found;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            found = new ArrayList<ICopyFileArea>(cfas.size());
            progress.setWorkRemaining(cfas.size());
            for (CopyFileArea cfa : cfas) {
                if (!cfa.internalIsLoaded(configuration.componentHandle, configuration.connectionHandle, (IProgressMonitor)progress.newChild(1))) continue;
                found.add(cfa);
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        progress.done();
        return found;
    }

    @Override
    public CopyFileArea getExistingCopyFileArea(IPath root) {
        CopyFileArea cfa = this.cfas.get(root);
        if (cfa != null) {
            return cfa;
        }
        return this.cfas.get(CopyFileAreaManager.getCanonicalPath(root));
    }

    @Override
    public int getNumShares(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        int cnt = 0;
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            progress.setWorkRemaining(cfas.size());
            for (CopyFileArea cfa : cfas) {
                cnt += cfa.internalGetNumShares(component, connection, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        progress.done();
        return cnt;
    }

    @Override
    public AbstractLock getSchedulingRule(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        IShare share = shareable.getShare(monitor);
        if (share != null) {
            ISharingDescriptor desc = share.getSharingDescriptor();
            return new ComponentLock(shareable.getSandbox().getRoot(), desc.getConnectionHandle(), desc.getComponent());
        }
        return null;
    }

    @Override
    public boolean isConnectionShared(IContextHandle connection) throws FileSystemClientException {
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            for (CopyFileArea cfa : cfas) {
                if (!cfa.internalIsConnectionShared(connection)) continue;
                return true;
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        return false;
    }

    @Override
    public CopyFileAreasLock lock(Collection<ICopyFileAreaLockRequest> locksToObtain, IProgressMonitor progress) throws FileSystemClientException {
        CopyFileAreasLock lock = new CopyFileAreasLock(locksToObtain);
        lock.acquire(progress);
        return lock;
    }

    @Override
    public CopyFileAreaLockRequestFactory lockRequestFactory() {
        return CopyFileAreaLockRequestFactory.instance;
    }

    public void internalClear() throws FileSystemClientException {
        this.waitForJobs(30000L);
        AbstractLock lock = this.batchingLock.acquire(GlobalLock.INSTANCE, this, NULL_PARTICIPANT, true, null);
        try {
            this.cfaListLock.acquirePart1();
            try {
                for (CopyFileArea cfa : this.cfas.values()) {
                    cfa.internalClear();
                }
                this.cfas.clear();
            }
            finally {
                this.cfaListLock.releasePart1();
            }
        }
        finally {
            this.batchingLock.release(lock, null);
        }
    }

    @Override
    public void shutdown(IProgressMonitor monitor) throws FileSystemClientException {
        this.waitForJobs(300000L);
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = this.batchingLock.acquire(GlobalLock.INSTANCE, this, NULL_PARTICIPANT, true, (IProgressMonitor)progress.newChild(10));
        try {
            SubMonitor subProgress = progress.newChild(80);
            this.cfaListLock.acquirePart1();
            try {
                subProgress.setWorkRemaining(this.cfas.size());
                for (CopyFileArea cfa : this.cfas.values()) {
                    try {
                        this.deregister(cfa.getRoot(), false, (IProgressMonitor)subProgress.newChild(1));
                    }
                    catch (Exception e) {
                        errors.add(FileSystemStatus.getStatusFor(e));
                    }
                }
                this.notifier.shutdown();
                subProgress.done();
            }
            finally {
                this.cfaListLock.releasePart1();
            }
        }
        finally {
            this.batchingLock.release(lock, (IProgressMonitor)progress.newChild(10));
        }
        int size = errors.size();
        if (size != 0) {
            throw new FileSystemClientException((IStatus)new MultiStatus("com.ibm.team.filesystem.client", 0, errors.toArray(new IStatus[size]), Messages.SharingManager_2, null));
        }
    }

    private void waitForJobs(long waitTimeInMillis) {
        try {
            boolean needWait = true;
            long start = System.currentTimeMillis();
            while (needWait) {
                Job[] jobs;
                needWait = false;
                Job[] jobArray = jobs = Job.getJobManager().find((Object)this);
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job.belongsTo((Object)this) && job.getState() != 0) {
                        if (System.currentTimeMillis() - start > waitTimeInMillis) {
                            LoggingHelper.log(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Job {0} has been in state {1} for too long", (Object)job.getName(), (Object)job.getState()), null));
                            return;
                        }
                        needWait = true;
                        break;
                    }
                    ++n2;
                }
                if (!needWait) continue;
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean hasOldMetaDataFolder(IPath cfaRoot) {
        IPath path = CopyFileAreaManager.getCanonicalPath(cfaRoot);
        return CopyFileAreaManager.getOldMetadataPathForRoot(path).toFile().exists();
    }

    public static IPath getOldMetadataPathForRoot(IPath root) {
        return root.append(OLD_METADATA_FOLDER_NAME);
    }

    public static IPath getInterumMetadataPathForRoot(IPath root) {
        return root.append(INTERUM_METADATA_FOLDER);
    }

    public boolean hasInterumMetadataFolder(IPath cfaRoot) {
        IPath path = CopyFileAreaManager.getCanonicalPath(cfaRoot);
        return CopyFileAreaManager.getInterumMetadataPathForRoot(path).toFile().exists();
    }

    public boolean requiresMigration(IPath root) {
        return this.hasOldMetaDataFolder(root) || this.hasInterumMetadataFolder(root);
    }
}

