/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileArea
extends CopyFileAreaStore
implements ICopyFileArea {
    protected CopyFileArea(IPath path, ISharingMetadata metadataStore) {
        super(path, metadataStore);
    }

    @Override
    public Collection<IShare> allShares() throws FileSystemClientException {
        this.assertReadLocked();
        ArrayList<IShare> result = new ArrayList<IShare>();
        Map<IPath, ISharingDescriptor> shareInfo = this.metadata.getSharingDescriptors();
        for (Map.Entry<IPath, ISharingDescriptor> entry : shareInfo.entrySet()) {
            result.add(new Share(this.path, entry.getKey(), this.isCaseSensitive(), entry.getValue()));
        }
        return result;
    }

    @Override
    public Collection<IShare> allShares(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        Map<IPath, ISharingDescriptor> shareInfo = super.getShares(connection, component, monitor);
        ArrayList<IShare> result = new ArrayList<IShare>(shareInfo.size());
        for (Map.Entry<IPath, ISharingDescriptor> entry : shareInfo.entrySet()) {
            result.add(new Share(this.path, entry.getKey(), this.isCaseSensitive(), entry.getValue()));
        }
        return result;
    }

    @Override
    public void newItem(IPath shareablePath, IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemClientException {
        if (handle instanceof IFolderHandle) {
            this.setItemInfo(shareablePath, new FileItemInfo((IFolderHandle)handle, null, null, false), monitor);
        } else {
            this.setItemInfo(shareablePath, new FileItemInfo(handle, false, -1L, null, null, false, null, -1L, null, null, null, null, null, -1L, null, null, -1L, false, false), monitor);
        }
    }

    @Override
    public boolean forget(IPath shareablePath, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        boolean unshare = true;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaStore.RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
        try {
            if (pair.desc == null) {
                throw new IllegalArgumentException();
            }
            SubMonitor uncancelableProgress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(98)), (int)98);
            if (this.metadata.getSharingDescriptor(shareablePath) == null) {
                unshare = false;
                uncancelableProgress.setWorkRemaining(49);
            }
            this.deleteTreeInfo(shareablePath, true, (IProgressMonitor)uncancelableProgress.newChild(49));
            if (unshare) {
                this.removeSharingInfo(shareablePath, (IProgressMonitor)uncancelableProgress.newChild(49));
            }
        }
        finally {
            CopyFileArea.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return unshare;
    }

    @Override
    public boolean forget(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemClientException {
        boolean unshare = true;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            InverseFileItemInfo info;
            if (!this.isShareRoot(item, component, connectionHandle)) {
                unshare = false;
                progress.setWorkRemaining(50);
            }
            if ((info = this.getItemInfo(item, component, connectionHandle)) != null) {
                this.deleteTreeInfo(item, component, connectionHandle, (IProgressMonitor)progress.newChild(49));
            }
            if (unshare) {
                this.removeSharingInfo(connectionHandle, component, item, (IProgressMonitor)progress.newChild(49));
            }
        }
        finally {
            CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return unshare;
    }

    @Override
    public void restoreVersionable(IPath shareablePath, ISharingDescriptor descriptor, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), descriptor.getConnectionHandle(), descriptor.getComponent()), (IProgressMonitor)progress.newChild(1));
        try {
            InverseFileItemInfo oldInfo = this.getItemInfo(item, descriptor.getComponent(), descriptor.getConnectionHandle());
            Assert.isTrue((oldInfo != null ? 1 : 0) != 0);
            Assert.isTrue((oldInfo.getParent() != null ? 1 : 0) != 0);
            this.setItemInfo(shareablePath, new FileItemInfo(oldInfo.getVersionableHandle(), !(item instanceof IFolderHandle), -1L, oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getContentType(), oldInfo.getStoredPredecessorHintHash(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredHash(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isOriginalExecutable(), oldInfo.isOriginalExecutable()), (IProgressMonitor)progress.newChild(98));
        }
        finally {
            CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    @Override
    public Share getShare(IPath path) {
        this.assertReadLocked();
        try {
            ISharingMetadata.ISharingDescriptorPath dp = this.metadata.findSharingDescriptorPath(path);
            if (dp != null) {
                return new Share(this.getRoot(), dp.getPath(), this.isCaseSensitive(), dp.getDescriptor());
            }
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IShare getShare(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
        try {
            while (!this.isShareRoot(versionable, component, connection)) {
                InverseFileItemInfo info = this.getItemInfo(versionable, component, connection);
                if (info == null) {
                    return null;
                }
                versionable = info.getLocalParent();
                if (versionable != null) continue;
                versionable = info.getParent();
            }
            IPath sharePath = this.getLocalPathFor(connection, component, versionable, (IProgressMonitor)progress.newChild(98));
            if (sharePath == null) return null;
            ISharingDescriptor descriptor = this.getSharingInfo(sharePath);
            if (descriptor == null) return null;
            Share share = new Share(this.getRoot(), sharePath, this.isCaseSensitive(), descriptor);
            return share;
        }
        finally {
            CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    @Override
    public void syncMetaData() throws FileSystemClientException {
        this.sync();
    }

    @Override
    public IPath getLocalPathFor(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        return this.getLocalPathFor(versionable, component, connection, monitor);
    }

    @Override
    public IPath getRemotePathFor(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        return super.getRemotePathFor(versionable, component, connectionHandle, monitor);
    }

    @Override
    public Collection<IPath> getLocalPathsFor(IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        return this.getLocalItemPaths(versionable, component, monitor);
    }

    @Override
    public Collection<IPath> getLocalPathsFor(IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        return this.getLocalItemPaths(versionable, monitor);
    }

    @Override
    public void share(final IPath sharePath, final ISharingDescriptor sharingDescriptor, FileItemInfo fileItemInfo, int options, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)102);
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        AbstractLock lock = null;
        try {
            lock = CopyFileArea.beginBatchingWithLock(null, new ILockParticipant(){

                public AbstractLock locking(AbstractLock rule) {
                    CopyFileArea.this.sharingInfoLock.lock();
                    try {
                        oldInfo[0] = CopyFileArea.this.metadata.findSharingDescriptor(sharePath);
                        rule = oldInfo[0] != null ? MultiLock.combine(new ComponentLock(CopyFileArea.this.getRoot(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent()), new ComponentLock(CopyFileArea.this.getRoot(), oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent())) : new ComponentLock(CopyFileArea.this.getRoot(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
                        return rule;
                    }
                    catch (FileSystemClientException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                public void waiting() {
                    CopyFileArea.this.sharingInfoLock.unlock();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (oldInfo[0] != null) {
                if (this.metadata.getPathForShareRoot(oldInfo[0].getRootVersionable(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle()).segmentCount() != sharePath.segmentCount()) {
                    throw new IllegalArgumentException();
                }
                if ((options & 1) == 1) {
                    if (fileItemInfo != null) {
                        progress.setWorkRemaining(151);
                    }
                    this.forget(sharePath, (IProgressMonitor)progress.newChild(50));
                } else if ((options & 2) != 2) {
                    throw new FileSystemClientException(new FileSystemStatus(4, NLS.bind((String)Messages.CopyFileArea_0, (Object)sharePath, (Object[])new Object[0])));
                }
            }
            if (fileItemInfo == null) {
                progress.setWorkRemaining(51);
            }
            this.setSharingInfo(sharePath, sharingDescriptor, (IProgressMonitor)progress.newChild(50));
            if (fileItemInfo != null) {
                this.setItemInfo(sharePath, fileItemInfo, (IProgressMonitor)progress.newChild(50));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (lock != null) {
                CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (lock != null) {
            CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    @Override
    public void setItemMetaData(IPath shareablePath, FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        this.setItemInfo(shareablePath, info, monitor);
    }

    @Override
    public void setItemMetaData(IContextHandle connectionHandle, IComponentHandle component, FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        this.setItemInfo(info.getVersionableHandle(), component, connectionHandle, info, monitor);
    }

    @Override
    public void moveInfo(IPath sourcePath, IPath destinationPath, boolean remoteMove, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaStore.RuleDescriptorPair pair = this.beginBatching(sourcePath, (IProgressMonitor)progress.newChild(1));
        try {
            if (pair.desc == null) {
                throw new IllegalArgumentException();
            }
            if (this.getSharingInfo(sourcePath) != null) {
                this.moveSharingInfo(sourcePath, destinationPath, monitor);
            } else {
                this.moveTreeInfo(sourcePath, destinationPath, remoteMove, monitor);
            }
        }
        finally {
            CopyFileArea.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
        }
    }

    @Override
    public boolean isConfigurationShared(IContextHandle connection, IComponentHandle component, IProgressMonitor progress) throws FileSystemClientException {
        return this.isLoaded(component, connection, progress);
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedConfigurations(IProgressMonitor monitor) throws FileSystemClientException {
        return this.allLoadedComponents(monitor);
    }

    @Override
    public void makePendingDeletion(IPath shareablePath, IProgressMonitor monitor) throws FileSystemClientException {
        this.deleteTreeInfo(shareablePath, false, monitor);
    }
}

