/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CFALockUtil {
    public static final int LOCK_OBTAINED = 0;
    public static final int PATH_NOT_MANAGED = 1;
    public static final int LOCK_HELD_BY_ANOTHER_THREAD = 2;
    public static final int LOCK_REQUEST_CANCELED = 3;
    public static final int LOCK_REQUEST_FAILED = 4;

    private CFALockUtil() {
    }

    public static boolean isLocked(AbstractLock lock) {
        return CopyFileAreaManager.instance.isLocked(lock);
    }

    public static boolean isLockedForUpdate(IPath cfaRoot, IComponentHandle component, IContextHandle connection) {
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            return false;
        }
        return CFALockUtil.isLocked(new ComponentLock(cfa.getRoot(), connection, component));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractLock lockExistingForUpdate(IPath cfaRoot, IPath rootRelativePath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfaRoot, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            progress.done();
            return null;
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            ISharingDescriptor desc = cfa.findSharingDescriptor(rootRelativePath);
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            if (desc == null) {
                progress.done();
                return null;
            }
            IPath rootPath = cfa.getRoot();
            while (true) {
                lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent()), true, (IProgressMonitor)progress.newChild(30));
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    progress.done();
                    success = true;
                    return null;
                }
                IPath newRoot = cfa.getRoot();
                if (!newRoot.equals((Object)rootPath)) {
                    rootPath = newRoot;
                } else {
                    ISharingDescriptor newDesc = cfa.findSharingDescriptor(rootRelativePath);
                    if (newDesc == null) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                        progress.done();
                        success = true;
                        return null;
                    }
                    if (newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) && newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    desc = newDesc;
                }
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock lockExistingForRead(IPath cfaRoot, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        IPath rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                IPath newRootPath = cfa.getRoot();
                if (newRootPath.equals((Object)rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForGlobalUpdate(IPath cfaRoot, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        IPath rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new GlobalCFALock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                IPath newRootPath = cfa.getRoot();
                if (newRootPath.equals((Object)rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForUpdate(IPath cfaRoot, IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        IPath rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, connection, component), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                IPath newRootPath = cfa.getRoot();
                if (newRootPath.equals((Object)rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForReadForLocation(IPath location, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ICopyFileArea cfa = CopyFileAreaManager.instance.getCopyFileAreaForPath(location);
        if (cfa == null) {
            progress.done();
            return null;
        }
        IPath rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    IPath newRootPath = cfa.getRoot();
                    if (newRootPath.equals((Object)rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.getCopyFileAreaForPath(location);
                    if (cfa == null) {
                        progress.done();
                        return null;
                    }
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock beginBatching(AbstractLock resourceRule, boolean waitForLock, IProgressMonitor monitor) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, CopyFileAreaManager.NULL_PARTICIPANT, waitForLock, monitor);
    }

    public static void endBatching(AbstractLock rule, IProgressMonitor monitor) throws FileSystemClientException {
        CopyFileAreaManager.instance.batchingLock.release(rule, monitor);
    }

    public static AbstractLock createAndLockSuperExclusive(IPath cfaRoot, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        IPath rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFARemoveLock(rootPath), true, (IProgressMonitor)progress.newChild(20));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    IPath newRootPath = cfa.getRoot();
                    if (newRootPath.equals((Object)rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
    }

    public static AbstractLock createAndLockForReading(IPath cfaRoot, boolean waitForLock, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        IPath rootPath = cfa.getRoot();
        AbstractLock lock;
        while ((lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), waitForLock, (IProgressMonitor)progress.newChild(20))) != null) {
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    IPath newRootPath = cfa.getRoot();
                    if (newRootPath.equals((Object)rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AbstractLock createAndLockForUpdate(IPath cfaRoot, IPath rootRelativePath, boolean waitForLock, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return null;
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            ISharingDescriptor desc = cfa.findSharingDescriptor(rootRelativePath);
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            if (desc == null) {
                progress.done();
                return null;
            }
            IPath rootPath = cfa.getRoot();
            while (true) {
                if ((lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent()), waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    return null;
                }
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                } else {
                    IPath newRoot = cfa.getRoot();
                    if (!newRoot.equals((Object)rootPath)) {
                        rootPath = newRoot;
                    } else {
                        ISharingDescriptor newDesc = cfa.findSharingDescriptor(rootRelativePath);
                        if (newDesc == null) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            progress.done();
                            success = true;
                            return null;
                        }
                        if (newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) && newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                            progress.done();
                            success = true;
                            AbstractLock abstractLock = lock;
                            return abstractLock;
                        }
                        desc = newDesc;
                    }
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                }
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock createAndLockForUpdate(IPath cfaRoot, IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        IPath rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, connection, component), true, (IProgressMonitor)progress.newChild(20));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    IPath newRootPath = cfa.getRoot();
                    if (newRootPath.equals((Object)rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
    }

    public static LockResult createAndLockForUpdateOfChildren(IPath cfaRoot, IPath rootRelativePath, boolean waitForLock, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return new LockResult(waitForLock, progress);
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            IPath rootPath = cfa.getRoot();
            ISharingDescriptor desc = null;
            IPath[] sharePaths = cfa.allSharePaths();
            ISharingMetadata md = cfa.internalGetMetadata();
            IPath convertedPath = md.getCanonicalPath(rootRelativePath, true);
            IShare containingShare = null;
            boolean parentOfShare = false;
            IPath[] iPathArray = sharePaths;
            int n = sharePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath sharePath = iPathArray[n2];
                IPath shareRootPath = md.getCanonicalPath(sharePath, true);
                if (shareRootPath.isPrefixOf(convertedPath)) {
                    containingShare = cfa.getShare(sharePath);
                    if (containingShare != null) break;
                    LoggingHelper.log(new FileSystemStatus(NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)sharePath.toOSString())));
                }
                if (convertedPath.isPrefixOf(shareRootPath)) {
                    parentOfShare = true;
                    break;
                }
                ++n2;
            }
            if (containingShare != null) {
                desc = containingShare.getSharingDescriptor();
            } else if (!parentOfShare) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.done();
                LockResult lockResult = new LockResult(1);
                return lockResult;
            }
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            while (true) {
                lock = desc == null ? new GlobalCFALock(rootPath) : new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent());
                if ((lock = CFALockUtil.beginBatching(lock, waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    LockResult lockResult = new LockResult(waitForLock, progress);
                    return lockResult;
                }
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                } else {
                    IPath newRoot = cfa.getRoot();
                    if (!newRoot.equals((Object)rootPath)) {
                        rootPath = newRoot;
                    } else {
                        ISharingDescriptor newDesc;
                        sharePaths = cfa.allSharePaths();
                        md = cfa.internalGetMetadata();
                        convertedPath = md.getCanonicalPath(rootRelativePath, true);
                        containingShare = null;
                        parentOfShare = false;
                        IPath[] iPathArray2 = sharePaths;
                        int n3 = sharePaths.length;
                        n = 0;
                        while (n < n3) {
                            IPath sharePath = iPathArray2[n];
                            IPath shareRootPath = md.getCanonicalPath(sharePath, true);
                            if (shareRootPath.isPrefixOf(convertedPath)) {
                                containingShare = cfa.getShare(sharePath);
                                if (containingShare != null) break;
                                LoggingHelper.log(new FileSystemStatus(NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)sharePath.toOSString())));
                            }
                            if (convertedPath.isPrefixOf(shareRootPath)) {
                                parentOfShare = true;
                                break;
                            }
                            ++n;
                        }
                        if (containingShare != null) {
                            newDesc = containingShare.getSharingDescriptor();
                        } else {
                            if (!parentOfShare) {
                                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                                success = true;
                                progress.done();
                                LockResult lockResult = new LockResult(1);
                                return lockResult;
                            }
                            newDesc = null;
                        }
                        if (desc == null) {
                            if (newDesc == null) {
                                progress.done();
                                success = true;
                                LockResult lockResult = new LockResult(lock);
                                return lockResult;
                            }
                        } else if (newDesc != null && newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) && newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                            progress.done();
                            success = true;
                            LockResult lockResult = new LockResult(lock);
                            return lockResult;
                        }
                        desc = newDesc;
                    }
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                }
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock createAndLockForReading(List<? extends IPath> cfaRoots, boolean waitForLocks, IProgressMonitor monitor) throws FileSystemClientException {
        int size = cfaRoots.size();
        Assert.isTrue((size != 0 ? 1 : 0) != 0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath[] cfas = new IPath[size];
        SubMonitor createMonitor = progress.newChild(30);
        createMonitor.setWorkRemaining(size);
        int i = 0;
        AbstractLock[] readLocks = new AbstractLock[size];
        for (IPath iPath : cfaRoots) {
            IPath iPath2;
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            if (cfa == null) {
                cfa = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)createMonitor.newChild(1));
            }
            cfas[i] = iPath2 = cfa.getRoot();
            readLocks[i] = new CFAReadLock(iPath2);
            ++i;
        }
        AbstractLock abstractLock;
        while ((abstractLock = CFALockUtil.beginBatching(MultiLock.combine(readLocks), waitForLocks, (IProgressMonitor)progress.newChild(20))) != null) {
            boolean unlocked = false;
            try {
                i = 0;
                SubMonitor checkProgress = progress.newChild(1);
                checkProgress.setWorkRemaining(size + 1);
                for (IPath iPath : cfaRoots) {
                    IPath newRootPath;
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                    if (cfa != null) {
                        newRootPath = cfa.getRoot();
                        if (!newRootPath.equals((Object)cfas[i])) {
                            if (!unlocked) {
                                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)checkProgress.newChild(1));
                                unlocked = true;
                            }
                            cfas[i] = newRootPath;
                            readLocks[i] = new CFAReadLock(newRootPath);
                        }
                    } else {
                        if (!unlocked) {
                            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)checkProgress.newChild(1));
                            unlocked = true;
                        }
                        cfa = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)checkProgress.newChild(1));
                        cfas[i] = newRootPath = cfa.getRoot();
                        readLocks[i] = new CFAReadLock(newRootPath);
                    }
                    ++i;
                }
                checkProgress.done();
                if (!unlocked) {
                    progress.done();
                    unlocked = true;
                    AbstractLock abstractLock2 = abstractLock;
                    return abstractLock2;
                }
            }
            finally {
                if (!unlocked) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
        return null;
    }

    public static LockResult createAndLockForUpdateOfChildren(List<? extends IPath> cfaRoots, List<? extends IPath> rootRelativePaths, boolean waitForLock, IProgressMonitor monitor) throws FileSystemClientException {
        int size = cfaRoots.size();
        Assert.isTrue((size == rootRelativePaths.size() ? 1 : 0) != 0);
        Assert.isTrue((size != 0 ? 1 : 0) != 0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoots, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return new LockResult(waitForLock, progress);
        }
        boolean success = false;
        try {
            IPath shareRootPath;
            ISharingDescriptor[] descriptors = new ISharingDescriptor[size];
            AbstractLock[] locks = new AbstractLock[size];
            IPath[] paths = new IPath[size];
            Iterator<? extends IPath> cfaIt = cfaRoots.iterator();
            Iterator<? extends IPath> pathIt = rootRelativePaths.iterator();
            int i = 0;
            while (i != size) {
                IPath cfaRoot = cfaIt.next();
                IPath rootRelativePath = pathIt.next();
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                IPath rootPath = cfa.getRoot();
                IPath[] sharePaths = cfa.allSharePaths();
                ISharingMetadata md = cfa.internalGetMetadata();
                IPath convertedPath = md.getCanonicalPath(rootRelativePath, true);
                IShare containingShare = null;
                IPath[] iPathArray = sharePaths;
                int n = sharePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath sharePath = iPathArray[n2];
                    shareRootPath = md.getCanonicalPath(sharePath, true);
                    if (shareRootPath.isPrefixOf(convertedPath)) {
                        containingShare = cfa.getShare(sharePath);
                        if (containingShare != null) break;
                        LoggingHelper.log(new FileSystemStatus(NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)sharePath.toOSString())));
                    }
                    if (convertedPath.isPrefixOf(shareRootPath)) break;
                    ++n2;
                }
                paths[i] = rootPath;
                if (containingShare != null) {
                    descriptors[i] = containingShare.getSharingDescriptor();
                    locks[i] = new ComponentLock(rootPath, descriptors[i].getConnectionHandle(), descriptors[i].getComponent());
                } else {
                    descriptors[i] = null;
                    locks[i] = new GlobalCFALock(rootPath);
                }
                ++i;
            }
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            while (true) {
                if ((lock = CFALockUtil.beginBatching(MultiLock.combine(locks), waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    LockResult lockResult = new LockResult(waitForLock, progress);
                    return lockResult;
                }
                success = false;
                cfaIt = cfaRoots.iterator();
                pathIt = rootRelativePaths.iterator();
                boolean goAgain = false;
                boolean noneContainShares = true;
                int i2 = 0;
                while (i2 != size) {
                    IPath cfaRoot = cfaIt.next();
                    IPath rootRelativePath = pathIt.next();
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                    if (cfa == null) {
                        if (!success) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            success = true;
                        }
                        cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                        IPath rootPath = cfa.getRoot();
                        descriptors[i2] = null;
                        locks[i2] = new GlobalCFALock(rootPath);
                        paths[i2] = rootPath;
                        goAgain = true;
                    } else {
                        IPath newRoot = cfa.getRoot();
                        if (!newRoot.equals((Object)paths[i2])) {
                            paths[i2] = newRoot;
                            goAgain = true;
                        } else if (!success) {
                            Collection<IShare> shares = cfa.allShares();
                            ISharingMetadata md = cfa.internalGetMetadata();
                            IPath convertedPath = md.getCanonicalPath(rootRelativePath, true);
                            IShare containingShare = null;
                            for (IShare share : shares) {
                                shareRootPath = md.getCanonicalPath(share.getPath(), true);
                                if (shareRootPath.isPrefixOf(convertedPath)) {
                                    containingShare = share;
                                    break;
                                }
                                if (!convertedPath.isPrefixOf(shareRootPath)) continue;
                                noneContainShares = false;
                                break;
                            }
                            if (containingShare != null) {
                                ISharingDescriptor newDesc = containingShare.getSharingDescriptor();
                                noneContainShares = false;
                                ISharingDescriptor desc = descriptors[i2];
                                if (desc == null || !newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) || !newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                                    descriptors[i2] = newDesc;
                                    locks[i2] = new ComponentLock(newRoot, newDesc.getConnectionHandle(), newDesc.getComponent());
                                    goAgain = true;
                                }
                            } else if (descriptors[i2] != null) {
                                descriptors[i2] = null;
                                locks[i2] = new GlobalCFALock(newRoot);
                                goAgain = true;
                            }
                        }
                    }
                    ++i2;
                }
                if (!goAgain) {
                    if (noneContainShares) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                        success = true;
                        progress.done();
                        LockResult lockResult = new LockResult(1);
                        return lockResult;
                    }
                    progress.done();
                    success = true;
                    LockResult lockResult = new LockResult(lock);
                    return lockResult;
                }
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static void endBatching(LockResult lock, SubMonitor monitor) throws FileSystemClientException {
        if (lock.code == 0) {
            CFALockUtil.endBatching(lock.lock, (IProgressMonitor)monitor);
        }
    }

    public static class LockResult {
        public final AbstractLock lock;
        public final int code;

        public LockResult(AbstractLock lock) {
            this.code = 0;
            this.lock = lock;
        }

        public LockResult(int code) {
            this.code = code;
            this.lock = null;
        }

        public LockResult(boolean waitForLock, SubMonitor progress) {
            this.lock = null;
            this.code = progress.isCanceled() ? 3 : (!waitForLock ? 2 : 4);
        }
    }
}

