/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shed {
    public static final String JAZZ_SHED = ".jazzShed";
    private static final String PREFIX = "b";
    private static final String FORMAT = "yy-MM-dd HH.mm.ss.SSS";
    private BackupDilemmaHandler problemHandler;
    private boolean backupEnabled;
    private long maxFileSize;
    private boolean shedEntryCreated;
    private String preferredName;
    private IPath shedEntry;
    private SimpleDateFormat formatter;

    public Shed(BackupDilemmaHandler backupDilemmaHandler) {
        this.problemHandler = backupDilemmaHandler == null ? BackupDilemmaHandler.getDefault() : backupDilemmaHandler;
        this.backupEnabled = this.problemHandler.backupEnabled();
        this.maxFileSize = this.problemHandler.getMaxFileSize() * 0x100000;
        this.shedEntryCreated = false;
        this.formatter = new SimpleDateFormat(FORMAT);
        this.preferredName = PREFIX + this.formatter.format(new Date(System.currentTimeMillis()));
    }

    public void forceBackup(final Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    try {
                        boolean backedUp = Shed.this.backup(shareable, (IProgressMonitor)progress.newChild(50));
                        if (!backedUp) {
                            IFileStorage storage = shareable.getFileStorage();
                            storage.preserveHistory((IProgressMonitor)progress.newChild(50));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new CoreException(FileSystemStatus.getStatusFor(e));
                    }
                }
            });
        }
        catch (FileSystemClientException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public boolean backupIfDirty(final Shareable shareable, final IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final boolean[] backupResult = new boolean[1];
        if (this.backupEnabled) {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        try {
                            backupResult[0] = Shed.this.backup(shareable, monitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new CoreException(FileSystemStatus.getStatusFor(e));
                        }
                    }
                });
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        return backupResult[0];
    }

    private boolean backup(Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean dirty = false;
        try {
            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
            FileItemInfo info = shareable.getFileItemInfo((IProgressMonitor)progress.newChild(1));
            if (resourceType == ResourceType.FILE) {
                if (info == null || !info.isFile() || info.isContentChanged() || info.getContentLength() != shareable.getFileStorage().getSize((IProgressMonitor)progress.newChild(1))) {
                    dirty = true;
                } else if (shareable.getFileStorage().getModificationStamp() > info.getLastContentChangeCheckStamp()) {
                    dirty = true;
                }
            } else if (resourceType == ResourceType.FOLDER) {
                String[] children = shareable.getFullPath().toFile().list();
                if (children != null && children.length != 0) {
                    dirty = true;
                }
            } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                if (info == null || info.isContentChanged() || !info.isSymbolicLink()) {
                    dirty = true;
                } else {
                    String linkTarget = shareable.getFileStorage().getTarget((IProgressMonitor)progress.newChild(1));
                    if (linkTarget == null) {
                        dirty = true;
                    } else {
                        ContentHash code = FileItemInfoProxy.getLinkTargetHash(linkTarget);
                        if (!code.equals((Object)info.getHash())) {
                            dirty = true;
                        }
                    }
                }
            }
        }
        catch (FileSystemClientException fileSystemClientException) {
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (!dirty) {
            dirty = shareable.getFileStorage().requiresBackup((IProgressMonitor)progress.newChild(1));
        }
        if (dirty) {
            shareable.getFileStorage().backup(this, this.problemHandler, (IProgressMonitor)progress.newChild(98));
        }
        return dirty;
    }

    public void backupInShed(Shareable itemToBackup, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.shedEntryCreated) {
            this.cleanup(itemToBackup.getSandbox().getRoot().append(JAZZ_SHED), (IProgressMonitor)progress.newChild(9));
            this.shedEntry = itemToBackup.getSandbox().getRoot().append(JAZZ_SHED).append(this.preferredName);
            File shedEntryFile = this.shedEntry.toFile();
            if (!shedEntryFile.exists() && !shedEntryFile.mkdirs()) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.Shed_0, (Object)this.shedEntry.toString(), (Object[])new Object[0]));
            }
            this.shedEntryCreated = true;
        }
        ResourceType type = itemToBackup.getResourceType((IProgressMonitor)progress.newChild(1));
        byte[] buffer = new byte[32768];
        if (type != null) {
            IPath shedLocation = this.shedEntry.append(itemToBackup.getLocalPath().removeLastSegments(1));
            File shedLocationFile = shedLocation.toFile();
            if (!shedLocationFile.exists() && !shedLocationFile.mkdirs()) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.Shed_1, (Object)shedLocation.toString(), (Object[])new Object[]{itemToBackup.getLocalPath().toString()}));
            }
            this.makeBackupCopy(itemToBackup.getSandbox().getRoot(), itemToBackup.getLocalPath(), shedLocationFile, buffer, (IProgressMonitor)progress.newChild(90));
            this.problemHandler.backedUpInShed(itemToBackup, shedLocation.append(itemToBackup.getLocalPath().lastSegment()));
        }
    }

    private void makeBackupCopy(IPath sandboxPath, IPath toBackupPath, File shedLocationFile, byte[] buffer, IProgressMonitor progress) {
        block17: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IPath fullPath = sandboxPath.append(toBackupPath);
            IFileStore storage = EFS.getLocalFileSystem().getStore(fullPath);
            try {
                IFileInfo fileInfo = storage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                if (fileInfo.getAttribute(32)) {
                    IPath shedPath = new Path(shedLocationFile.getAbsolutePath()).append(fullPath.lastSegment());
                    IFileStore shedStorage = EFS.getLocalFileSystem().getStore(shedPath);
                    IPath relativeShedPath = shedPath.removeFirstSegments(sandboxPath.segmentCount());
                    relativeShedPath = relativeShedPath.setDevice(null);
                    relativeShedPath = relativeShedPath.makeRelative();
                    ManagedFileStore managed = new ManagedFileStore(sandboxPath, relativeShedPath, shedStorage);
                    String target = fileInfo.getStringAttribute(64);
                    managed.symlink(target == null ? "" : target, (IProgressMonitor)monitor.newChild(98));
                    break block17;
                }
                if (fileInfo.isDirectory()) {
                    File copy = new File(shedLocationFile, fullPath.lastSegment());
                    if (copy.mkdir()) {
                        String[] children = fullPath.toFile().list();
                        if (children != null) {
                            monitor.setWorkRemaining(children.length);
                            String[] stringArray = children;
                            int target = children.length;
                            int managed = 0;
                            while (managed < target) {
                                String child = stringArray[managed];
                                this.makeBackupCopy(sandboxPath, toBackupPath.append(child), copy, buffer, (IProgressMonitor)monitor.newChild(1));
                                ++managed;
                            }
                        }
                    } else {
                        LoggingHelper.log(new FileSystemStatus(2, NLS.bind((String)Messages.Shed_2, (Object)toBackupPath.toString(), (Object[])new Object[0])));
                    }
                    break block17;
                }
                if (!fileInfo.exists() || fileInfo.getLength() > this.maxFileSize) break block17;
                File copy = new File(shedLocationFile, fullPath.lastSegment());
                try {
                    FileInputStream inputStream = new FileInputStream(fullPath.toFile());
                    UnsynchronizedBufferedInputStream input = new UnsynchronizedBufferedInputStream((InputStream)inputStream);
                    try {
                        if (!copy.createNewFile()) break block17;
                        FileOutputStream stream = new FileOutputStream(copy);
                        try {
                            int numbytes = input.read(buffer);
                            while (numbytes != -1) {
                                stream.write(buffer, 0, numbytes);
                                numbytes = input.read(buffer);
                            }
                        }
                        finally {
                            stream.close();
                        }
                    }
                    finally {
                        input.close();
                    }
                }
                catch (IOException e) {
                    LoggingHelper.log(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.Shed_2, (Object)toBackupPath.toString(), (Object[])new Object[0]), (Throwable)e));
                }
            }
            catch (CoreException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.Shed_2, (Object)toBackupPath.toString(), (Object[])new Object[0]), (Throwable)e));
            }
        }
    }

    private void cleanup(IPath shedRoot, IProgressMonitor progress) {
        File[] children;
        File shedRootFile = shedRoot.toFile();
        if (!shedRootFile.exists()) {
            return;
        }
        if (!shedRootFile.isDirectory()) {
            shedRootFile.delete();
            return;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, -1 * this.problemHandler.getPreferredShedLifespan());
        Date age = calendar.getTime();
        File[] fileArray = children = shedRootFile.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String child = file.getName();
            if (child.startsWith(PREFIX)) {
                String timeStampString = child.substring(PREFIX.length());
                try {
                    Date date = this.formatter.parse(timeStampString);
                    if (date.before(age)) {
                        this.delete(file, progress);
                    }
                }
                catch (ParseException parseException) {
                    this.delete(file, progress);
                }
            } else {
                this.delete(file, progress);
            }
            ++n2;
        }
    }

    private void delete(File file, IProgressMonitor monitor) {
        if (file.delete() || !file.exists()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
        try {
            IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
            if (!fileInfo.getAttribute(32) && fileInfo.isDirectory()) {
                File[] children = file.listFiles();
                progress.setWorkRemaining(1 + children.length);
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.delete(child, (IProgressMonitor)progress.newChild(1));
                    ++n2;
                }
            }
            file.delete();
        }
        catch (CoreException coreException) {}
        progress.done();
    }

    public static int getShedEntryCount(ISandbox sandbox) {
        return Shed.getShedEntryCount(sandbox.getRoot());
    }

    public static int getShedEntryCount(IPath sandboxRoot) {
        File shedLocation = Shed.getShedLocation(sandboxRoot);
        if (!shedLocation.exists() || !shedLocation.isDirectory()) {
            return 0;
        }
        String[] children = shedLocation.list();
        if (children == null) {
            return 0;
        }
        return children.length;
    }

    private static File getShedLocation(IPath sandboxRoot) {
        return sandboxRoot.append(JAZZ_SHED).toFile();
    }

    public static Iterable<IPath> getShedEntries(IPath sandboxRoot) {
        File shedRoot = Shed.getShedLocation(sandboxRoot);
        final File[] files = shedRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                return pathname.getName().startsWith(Shed.PREFIX);
            }
        });
        return new Iterable<IPath>(){

            @Override
            public Iterator<IPath> iterator() {
                return new Iterator<IPath>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < files.length;
                    }

                    @Override
                    public IPath next() {
                        return new Path(files[this.i++].getAbsolutePath());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

