/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.AsyncSavePDBHMJob;
import com.ibm.team.filesystem.client.internal.DiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoadedComponentsStore;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.SharingDescriptorsMap;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.filesystem.client.internal.utils.IPersistentFlag;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.filesystem.client.internal.utils.PersistentFlag;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingMetadata2
implements ISharingMetadata {
    public static final String JAZZLOCK_NAME = ".jazzlock";
    static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    public static final String SCM_DESCRIPTORS = ".descriptors.dat";
    public static final String SCM_ITEM_INFOS = ".iteminfo.dat";
    public static final String SCM_INVERSE_ITEM_INFOS = ".inverseiteminfo.dat";
    public static final String SCM_LOADED_COMPONENTS = ".components";
    protected static final String SCM_COMPLETED_FLAGS = ".flags";
    protected static final String SCM_FLAG_MAP_MGR = ".mapMgr";
    protected static final String SCM_FLAG_DESCRIPTORS = ".descriptors";
    protected static final String SCM_FLAG_INVERSE_ITEM_INFOS = ".inverseItemInfos";
    protected static final String SCM_FLAG_LOADED_COMPONENTS = ".loadedComponents";
    protected static final String SCM_FLAG_IS_CORRUPT = ".isCorrupt";
    private final IPath cfaRoot;
    private IPath metadataRoot;
    private ReadWriteLock globalLock;
    private AsyncSavePDBHMJob saveDescriptorsJob;
    private AsyncSavePDBHMJob saveInverseMapJob;
    private AsyncSavePDBHMJob saveLoadedComponentsJob;
    private PersistentDiskBackedHashMap<StringWrapper, ISharingDescriptor> descriptors;
    private Map<ShareRoot, IPath> inverseDescriptors;
    private PersistentDiskBackedHashMap<String, Map<ISharingMetadata.IConnectionComponent, InverseFileItemInfo>> inverseItemInfos;
    private Object inverseItemInfosLock;
    private PersistentDiskBackedHashMap<ISharingMetadata.IConnectionComponent, LoadedConfigurationDescriptor> loadedComponents;
    private Object loadedComponentsLock;
    private MetadataDiskBackedMapManager mapMgr;
    private PersistentHeapManager heapMgr;
    private boolean isCaseSensitive;
    private final PersistentBusyFlag mapMgrFlag;
    private final PersistentBusyFlag descriptorsFlag;
    private final PersistentBusyFlag inverseItemInfosFlag;
    private final PersistentBusyFlag loadedComponentsFlag;
    private final PersistentBusyFlag persistentMetadataFlag;
    final FilesystemLock fsLock;
    private final Object corruptionLock = new Object();
    private final IPersistentFlag isCorruptFlag;
    final HashSet<ICorruptCopyFileAreaListener> corruptionListeners = new HashSet();

    public SharingMetadata2(IPath copyFileAreaRoot, IPath metadataRoot) throws FileSystemClientException {
        this.cfaRoot = copyFileAreaRoot;
        this.globalLock = new ReadWriteLock();
        this.fsLock = new FilesystemLock(CopyFileAreaManager.getMetadataPathForRoot(this.cfaRoot).append(JAZZLOCK_NAME));
        this.ensureExclusiveCFAAccess(null);
        IPath flagDir = metadataRoot.append(SCM_COMPLETED_FLAGS);
        this.mapMgrFlag = new PersistentBusyFlag(flagDir.append(".metadata.isComplete").toFile());
        this.descriptorsFlag = new PersistentBusyFlag(flagDir.append(".descriptors.isComplete").toFile());
        this.inverseItemInfosFlag = new PersistentBusyFlag(flagDir.append(".inverseItemInfos.isComplete").toFile());
        this.loadedComponentsFlag = new PersistentBusyFlag(flagDir.append(".loadedComponents.isComplete").toFile());
        this.persistentMetadataFlag = new PersistentBusyFlag(flagDir.append(".persistentMetadata.isComplete").toFile());
        this.isCorruptFlag = new PersistentFlag(flagDir.append(SCM_FLAG_IS_CORRUPT).toFile());
        this.validateFlags(flagDir);
        this.mapMgr = new MetadataDiskBackedMapManager(this.globalLock, this.mapMgrFlag);
        this.heapMgr = new PersistentHeapManager();
        this.saveDescriptorsJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_7, this.descriptorsFlag, this, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                return SharingMetadata2.this.descriptors;
            }
        };
        this.inverseItemInfosLock = new Object();
        this.saveInverseMapJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_8, this.inverseItemInfosFlag, this.inverseItemInfosLock, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                return SharingMetadata2.this.inverseItemInfos;
            }
        };
        this.loadedComponentsLock = new Object();
        this.saveLoadedComponentsJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_9, this.loadedComponentsFlag, this.loadedComponentsLock, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                return SharingMetadata2.this.loadedComponents;
            }
        };
        this.metadataRoot = metadataRoot;
        this.isCaseSensitive = !copyFileAreaRoot.append("a").toFile().equals(copyFileAreaRoot.append("A").toFile());
    }

    private void validateFlags(IPath flagDir) {
        if (FileSystemCore.isShutDown()) {
            return;
        }
        if (!flagDir.toFile().exists()) {
            if (!flagDir.toFile().mkdirs()) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_10, null));
                return;
            }
            this.mapMgrFlag.setComplete(null);
            this.descriptorsFlag.setComplete(null);
            this.inverseItemInfosFlag.setComplete(null);
            this.loadedComponentsFlag.setComplete(null);
            this.persistentMetadataFlag.setComplete(null);
            this.setCorrupt(false, "First run", null);
            return;
        }
        if (this.isCorruptFlag.getState() || this.mapMgrFlag.isBusy() || this.descriptorsFlag.isBusy() || this.inverseItemInfosFlag.isBusy() || this.loadedComponentsFlag.isBusy() || this.persistentMetadataFlag.isBusy()) {
            this.setCorrupt(true, "isCorruptFlag: " + this.isCorruptFlag.getState() + " mapMgrFlag: " + this.mapMgrFlag.isBusy() + " descriptorsFlag: " + this.descriptorsFlag.isBusy() + " inverseItemInfosFlag: " + this.inverseItemInfosFlag.isBusy() + " loadedComponentsFlag: " + this.loadedComponentsFlag.isBusy() + " persistentMetadataFlag: " + this.persistentMetadataFlag.isBusy(), null);
        }
    }

    private IPath getLocation(IPath path) {
        return this.metadataRoot.append(path);
    }

    private void initInverseItemInfos() throws IOException, FileSystemClientException {
        if (this.inverseItemInfos == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File f = this.metadataRoot.append(SCM_INVERSE_ITEM_INFOS).toFile();
            try {
                this.inverseItemInfos = new InverseMetadataStore(f);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on inverseItemItemInfos load: " + f.toString(), e.getCause());
                throw e;
            }
            this.inverseItemInfos.persist();
        }
    }

    private void initLoadedComponents() throws IOException, FileSystemClientException {
        if (this.loadedComponents == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File f = this.metadataRoot.append(SCM_LOADED_COMPONENTS).toFile();
            try {
                this.loadedComponents = new LoadedComponentsStore(this.heapMgr, f);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on loadedComponents load: " + f.toString(), e.getCause());
                throw e;
            }
            this.loadedComponents.persist();
        }
    }

    private void initDescriptors() throws IOException, FileSystemClientException {
        if (this.descriptors == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File f = this.metadataRoot.append(SCM_DESCRIPTORS).toFile();
            try {
                this.descriptors = new SharingDescriptorsMap(f, this.isCaseSensitive);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on descriptors load: " + f.toString(), e.getCause());
                throw e;
            }
            this.descriptors.persist();
            this.inverseDescriptors = new HashMap<ShareRoot, IPath>((int)((double)this.descriptors.size() / 0.75));
            for (Map.Entry e : this.descriptors.entrySet()) {
                Path path = new Path(null, ((StringWrapper)e.getKey()).toString());
                ISharingDescriptor desc = (ISharingDescriptor)e.getValue();
                this.inverseDescriptors.put(new ShareRoot(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle()), (IPath)path);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void accept(IVisitor visitor, IPath base, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        Directory initial = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            block13: {
                block12: {
                    block11: {
                        FileItemInfo info;
                        if (base.segmentCount() == 0) break block11;
                        initial = this.loadDirectory(base.removeLastSegments(1), mutable);
                        try {
                            info = (FileItemInfo)initial.entries().get(new StringWrapper(base.lastSegment(), this.isCaseSensitive));
                        }
                        catch (DBHMException e) {
                            this.setCorrupt(e);
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_11, (Object)base.toOSString(), (Object[])new Object[0]), e.getCause()));
                        }
                        if (info != null && !visitor.visit(base, info, (IProgressMonitor)progress.newChild(5))) break block12;
                    }
                    if (depth != 0) break block13;
                }
                if (initial != null) {
                    this.releaseDirectory(initial);
                }
                progress.done();
                return;
            }
            this.acceptAll(visitor, base, depth, mutable, (IProgressMonitor)progress.newChild(95));
        }
        catch (Throwable throwable) {
            if (initial != null) {
                this.releaseDirectory(initial);
            }
            progress.done();
            throw throwable;
        }
        if (initial != null) {
            this.releaseDirectory(initial);
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptAll(IVisitor visitor, IPath base, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Directory current = this.loadDirectory(base, mutable);
        try {
            HashMap copy;
            HashSet<StringWrapper> skip = new HashSet<StringWrapper>();
            Map map = current.entries();
            synchronized (map) {
                copy = new HashMap(current.entries());
            }
            SubMonitor subProgress = progress.newChild(10);
            subProgress.setWorkRemaining(copy.size());
            for (Map.Entry entry : copy.entrySet()) {
                FileItemInfo info = (FileItemInfo)entry.getValue();
                StringWrapper sw = (StringWrapper)entry.getKey();
                IPath entryPath = base.append(sw.toString());
                if (visitor.visit(entryPath, info, (IProgressMonitor)subProgress.newChild(1))) continue;
                skip.add(sw);
            }
            subProgress.done();
            if (depth == 1) {
                return;
            }
            try {
                --depth;
                IPath[] childPaths = current.children();
                progress.setWorkRemaining(childPaths.length - skip.size());
                int i = 0;
                while (i < childPaths.length) {
                    if (!skip.contains(new StringWrapper(childPaths[i].lastSegment(), this.isCaseSensitive))) {
                        this.acceptAll(visitor, childPaths[i], depth, mutable, (IProgressMonitor)progress.newChild(1));
                    }
                    ++i;
                }
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_12, e.getCause()));
            }
        }
        finally {
            this.releaseDirectory(current);
            progress.done();
        }
    }

    public IPath getRemotePath(IVersionableHandle base, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            try {
                IPath root;
                this.initInverseItemInfos();
                ArrayList<String> segments = new ArrayList<String>();
                int pathLength = 0;
                while (true) {
                    Map inverseMap;
                    if ((root = this.getPathForShareRoot(base, component, connection)) != null) break;
                    try {
                        inverseMap = (Map)this.inverseItemInfos.get((Object)base.getItemId().getUuidValue());
                    }
                    catch (DBHMException e) {
                        this.setCorrupt(e);
                        throw e;
                    }
                    if (inverseMap == null) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_13, (Object)base.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                    }
                    InverseFileItemInfo info = (InverseFileItemInfo)inverseMap.get(new ConnectionComponent(connection, component));
                    if (info == null) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_14, (Object)base.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                    }
                    if (info.getParent() == null || info.getName() == null) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_15, (Object)base.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                    }
                    pathLength += info.getName().length();
                    segments.add(info.getName());
                    base = info.getParent();
                }
                String rootPath = root.removeTrailingSeparator().toString();
                StringBuffer path = new StringBuffer(rootPath.length() + pathLength + segments.size());
                path.append(rootPath);
                ListIterator i = segments.listIterator(segments.size());
                while (i.hasPrevious()) {
                    String segment = (String)i.previous();
                    path.append('/');
                    path.append(segment);
                }
                return new Path(null, path.toString());
            }
            catch (DBHMException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_16, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_17, (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(IRemoteVisitor visitor, IVersionableHandle base, IComponentHandle component, IContextHandle connection, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.globalLock.acquireWrite();
        try {
            try {
                Object object = this.inverseItemInfosLock;
                synchronized (object) {
                    this.initInverseItemInfos();
                    ArrayList<IVersionableHandle> toVisitItem = new ArrayList<IVersionableHandle>();
                    ArrayList<IPath> toVisitPath = new ArrayList<IPath>();
                    ArrayList<Integer> toVisitDepth = new ArrayList<Integer>();
                    toVisitItem.add(base);
                    toVisitPath.add(this.getRemotePath(base, component, connection));
                    toVisitDepth.add(0);
                    ConnectionComponent cc = new ConnectionComponent(connection, component);
                    do {
                        int idx;
                        IVersionableHandle item;
                        Map inverseMap;
                        if ((inverseMap = (Map)this.inverseItemInfos.get((Object)(item = (IVersionableHandle)toVisitItem.remove(idx = toVisitItem.size() - 1)).getItemId().getUuidValue())) == null) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_18, (Object)item.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                        }
                        InverseFileItemInfo info = (InverseFileItemInfo)inverseMap.get(cc);
                        if (info == null) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_19, (Object)item.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                        }
                        IPath path = (IPath)toVisitPath.remove(idx);
                        Integer visitingDepth = (Integer)toVisitDepth.remove(idx);
                        progress.setWorkRemaining(toVisitItem.size() + 1);
                        boolean visitChildren = visitor.visit(path, info, (IProgressMonitor)progress.newChild(1));
                        if (depth == visitingDepth || !visitChildren) continue;
                        Integer childDepth = visitingDepth + 1;
                        for (Map.Entry<String, IVersionableHandle> entry : info.getRemoteChildren().entrySet()) {
                            String name = entry.getKey();
                            IVersionableHandle child = entry.getValue();
                            toVisitItem.add(child);
                            toVisitPath.add(path.append(name));
                            toVisitDepth.add(childDepth);
                        }
                    } while (!toVisitItem.isEmpty());
                }
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_20, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_21, (Throwable)e));
            }
        }
        finally {
            this.globalLock.release();
            progress.done();
        }
    }

    private Directory loadDirectory(IPath path, boolean exclusive) throws FileSystemClientException {
        IPath canonicalPath = this.getCanonicalPath(path, true);
        try {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            return (Directory)this.mapMgr.loadMap(canonicalPath, exclusive, path);
        }
        catch (DBHMException e) {
            this.setCorrupt(true, "Problem reading Directory at " + canonicalPath, e.getCause());
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_0, e.getCause()));
        }
    }

    @Override
    public IPath getCanonicalPath(IPath path, boolean convertCase) {
        if (this.isCaseSensitive || !convertCase) {
            return path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator();
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            sb.append('/');
            sb.append(segment.toUpperCase().toLowerCase());
            ++n2;
        }
        return new Path(null, sb.toString()).makeAbsolute();
    }

    private void releaseDirectory(Directory dir) throws FileSystemClientException {
        this.mapMgr.releaseMap(dir);
    }

    @Override
    public synchronized IPath[] allShares() throws FileSystemClientException {
        try {
            this.initDescriptors();
            return this.inverseDescriptors.values().toArray(new IPath[this.inverseDescriptors.size()]);
        }
        catch (DBHMException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_22, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_23, (Throwable)e));
        }
    }

    @Override
    public synchronized Collection<IPath> allShares(IPath parent) throws FileSystemClientException {
        try {
            IPath[] allShares;
            this.initDescriptors();
            ArrayList<IPath> result = new ArrayList<IPath>();
            parent = this.getCanonicalPath(parent, true);
            IPath[] iPathArray = allShares = this.allShares();
            int n = allShares.length;
            int n2 = 0;
            while (n2 < n) {
                IPath p = iPathArray[n2];
                if (parent.isPrefixOf(this.getCanonicalPath(p, true))) {
                    result.add(p);
                }
                ++n2;
            }
            return result;
        }
        catch (DBHMException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_22, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_23, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll((IPath)Path.ROOT);
            Object object = this.inverseItemInfosLock;
            synchronized (object) {
                Object object2 = this.loadedComponentsLock;
                synchronized (object2) {
                    SharingMetadata2 sharingMetadata2 = this;
                    synchronized (sharingMetadata2) {
                        try {
                            if (this.descriptors != null) {
                                this.descriptors.close();
                                this.descriptors = null;
                                this.inverseDescriptors = null;
                            }
                            if (this.loadedComponents != null) {
                                this.loadedComponents.close();
                                this.loadedComponents = null;
                            }
                            if (this.inverseItemInfos != null) {
                                this.inverseItemInfos.close();
                                this.inverseItemInfos = null;
                            }
                        }
                        catch (DBHMException e) {
                            this.setCorrupt(true, "Problem in " + (this.descriptors == null ? "" : "descriptors? ") + (this.loadedComponents == null ? "" : "loadedComponents? ") + (this.inverseItemInfos == null ? "" : "inverseItemInfos?"), e.getCause());
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_24, e.getCause()));
                        }
                        catch (IOException e) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_25, (Throwable)e));
                        }
                        this.releaseExclusiveCFAAccess(null);
                        try {
                            EFS.getLocalFileSystem().getStore(this.metadataRoot).delete(0, null);
                        }
                        catch (CoreException e) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_26, (Throwable)e));
                        }
                    }
                }
            }
        }
        finally {
            this.globalLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FileSystemClientException {
        MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.SharingMetadata2_27, null);
        this.globalLock.acquireWrite();
        try {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.descriptors != null) {
                        this.descriptors.close();
                        this.descriptors = null;
                        this.inverseDescriptors = null;
                    }
                    this.descriptorsFlag.setComplete(status);
                }
                object = this.loadedComponentsLock;
                synchronized (object) {
                    if (this.loadedComponents != null) {
                        this.loadedComponents.close();
                        this.loadedComponentsFlag.setComplete(status);
                        this.loadedComponents = null;
                    }
                    this.loadedComponentsFlag.setComplete(status);
                }
                object = this.inverseItemInfosLock;
                synchronized (object) {
                    if (this.inverseItemInfos != null) {
                        this.inverseItemInfos.close();
                        this.inverseItemInfos = null;
                    }
                    this.inverseItemInfosFlag.setComplete(status);
                }
                this.mapMgr.closeAll((IPath)Path.ROOT);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Problem in " + (this.descriptors == null ? "" : "descriptors? ") + (this.loadedComponents == null ? "" : "loadedComponents? ") + (this.inverseItemInfos == null ? "" : "inverseItemInfos?"), e.getCause());
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_28, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_29, (Throwable)e));
            }
        }
        finally {
            this.globalLock.release();
            if (this.descriptors == null && this.loadedComponents == null && this.inverseItemInfos == null) {
                this.releaseExclusiveCFAAccess(null);
            }
            if (status.getChildren().length > 0) {
                LoggingHelper.log((IStatus)status);
            }
        }
    }

    @Override
    public FileItemInfo deleteFileItemInfo(IPath path, IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info;
        this.globalLock.acquireWrite();
        try {
            block11: {
                if (path.segmentCount() != 0) {
                    Directory dir = this.loadDirectory(path.removeLastSegments(1), true);
                    try {
                        try {
                            info = (FileItemInfo)dir.entries().remove(new StringWrapper(path.lastSegment(), this.isCaseSensitive));
                            break block11;
                        }
                        catch (DBHMException e) {
                            this.setCorrupt(e);
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_30, e.getCause()));
                        }
                    }
                    finally {
                        this.releaseDirectory(dir);
                    }
                }
                info = null;
            }
            this.mapMgr.closeAll(path);
            IFileStore store = EFS.getLocalFileSystem().getStore(this.getLocation(path));
            try {
                store.delete(0, null);
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_31, (Throwable)e));
            }
        }
        finally {
            this.globalLock.release();
        }
        return info;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public FileItemInfo getFileItemInfo(IPath path) throws FileSystemClientException {
        if (path.segmentCount() == 0) {
            return null;
        }
        path = path.makeAbsolute();
        Directory dir = this.loadDirectory(path.removeLastSegments(1), false);
        try {
            FileItemInfo fileItemInfo = (FileItemInfo)dir.entries().get(new StringWrapper(path.lastSegment(), this.isCaseSensitive));
            return fileItemInfo;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_32, e.getCause()));
        }
        finally {
            this.releaseDirectory(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<StringWrapper, FileItemInfo> getChildInfos(IPath path) throws FileSystemClientException {
        path = path.makeAbsolute();
        Directory dir = this.loadDirectory(path, false);
        try {
            HashMap<StringWrapper, FileItemInfo> copy;
            Map entries;
            Map map = entries = dir.entries();
            synchronized (map) {
                copy = new HashMap<StringWrapper, FileItemInfo>(entries);
            }
            HashMap<StringWrapper, FileItemInfo> hashMap = copy;
            return hashMap;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_33, e.getCause()));
        }
        finally {
            this.releaseDirectory(dir);
        }
    }

    @Override
    public InverseFileItemInfo getFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            Map inverseMap;
            block7: {
                this.initInverseItemInfos();
                inverseMap = (Map)this.inverseItemInfos.get((Object)item.getItemId().getUuidValue());
                if (inverseMap != null) break block7;
                return null;
            }
            try {
                return (InverseFileItemInfo)inverseMap.get(new ConnectionComponent(connection, component));
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_34, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_35, (Throwable)e));
            }
        }
    }

    @Override
    public Collection<ISharingMetadata.IConnectionComponent> getLocations(IVersionableHandle item) throws FileSystemClientException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            try {
                Map inverseMap;
                this.initInverseItemInfos();
                try {
                    inverseMap = (Map)this.inverseItemInfos.get((Object)item.getItemId().getUuidValue());
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
                if (inverseMap == null) {
                    return Collections.emptyList();
                }
                return new ArrayList<ISharingMetadata.IConnectionComponent>(inverseMap.keySet());
            }
            catch (DBHMException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_36, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_37, (Throwable)e));
            }
        }
    }

    @Override
    public synchronized IPath findConflictingShare(IPath sharePath) throws FileSystemClientException {
        this.initDescriptors();
        try {
            sharePath = this.getCanonicalPath(sharePath, true);
            for (IPath path : this.inverseDescriptors.values()) {
                IPath convertedPath = this.getCanonicalPath(path, true);
                if (!convertedPath.isPrefixOf(sharePath) && !sharePath.isPrefixOf(convertedPath)) continue;
                return convertedPath;
            }
            return null;
        }
        catch (DBHMException e) {
            try {
                this.setCorrupt(e);
                throw e;
            }
            catch (DBHMException e2) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_38, e2.getCause()));
            }
            catch (IOException e3) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_39, (Throwable)e3));
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized ISharingDescriptor findSharingDescriptor(IPath path) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                ISharingDescriptor result;
                path = this.getCanonicalPath(path, false);
                int numSegments = path.segmentCount();
                if (numSegments >= 1 && (result = (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(path.removeLastSegments(numSegments - 1), false).toString(), this.isCaseSensitive))) != null) {
                    return result;
                }
                result = (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath((IPath)Path.ROOT, false).toString(), this.isCaseSensitive));
                if (result != null) {
                    return result;
                }
                if (numSegments <= 1) {
                    return null;
                }
                numSegments -= 2;
                do {
                    if ((result = (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(path.removeLastSegments(numSegments), false).toString(), this.isCaseSensitive))) == null) continue;
                    return result;
                } while (numSegments-- != 0);
                return null;
            }
            catch (DBHMException e) {
                try {
                    this.setCorrupt(e);
                    throw e;
                }
                catch (DBHMException e2) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_38, e2.getCause()));
                }
            }
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_39, (Throwable)e));
        }
    }

    @Override
    public synchronized ISharingMetadata.ISharingDescriptorPath findSharingDescriptorPath(IPath path) throws FileSystemClientException {
        final ISharingDescriptor desc = this.findSharingDescriptor(path);
        if (desc == null) {
            return null;
        }
        final IPath dPath = this.inverseDescriptors.get(new ShareRoot(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle()));
        return new ISharingMetadata.ISharingDescriptorPath(){

            public ISharingDescriptor getDescriptor() {
                return desc;
            }

            public IPath getPath() {
                return dPath;
            }
        };
    }

    @Override
    public synchronized ISharingDescriptor getSharingDescriptor(IPath sharePath) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                return (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(sharePath, false).toString(), this.isCaseSensitive));
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
        }
        catch (DBHMException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_38, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_39, (Throwable)e));
        }
    }

    private void setCorrupt(DBHMException e) {
        this.setCorrupt(true, null, e.getCause());
    }

    @Override
    public synchronized IPath getPathForShareRoot(IVersionableHandle root, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                return this.inverseDescriptors.get(new ShareRoot(root, component, connection));
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
        }
        catch (DBHMException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_40, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_41, (Throwable)e));
        }
    }

    @Override
    public FileItemInfo moveFileItemInfo(IPath sourcePath, IPath destinationPath) throws FileSystemClientException {
        FileItemInfo sourceInfo;
        block17: {
            Assert.isLegal((!(sourcePath = this.getCanonicalPath(sourcePath, false)).equals((Object)(destinationPath = this.getCanonicalPath(destinationPath, false))) ? 1 : 0) != 0);
            IPath canonicalSource = this.getCanonicalPath(sourcePath, true);
            IPath canonicalDest = this.getCanonicalPath(destinationPath, true);
            if (!canonicalSource.equals((Object)canonicalDest)) {
                Assert.isLegal((!canonicalSource.isPrefixOf(canonicalDest) ? 1 : 0) != 0);
                Assert.isLegal((!canonicalDest.isPrefixOf(canonicalSource) ? 1 : 0) != 0);
            }
            this.globalLock.acquireWrite();
            try {
                IPath sourceBucketPath = canonicalSource.removeLastSegments(1);
                Directory source = this.loadDirectory(sourceBucketPath, true);
                try {
                    IPath destinationBucketPath = canonicalDest.removeLastSegments(1);
                    boolean sameParent = sourceBucketPath.equals((Object)destinationBucketPath);
                    Directory destination = sameParent ? source : this.loadDirectory(destinationBucketPath, true);
                    try {
                        try {
                            sourceInfo = (FileItemInfo)source.entries().remove(new StringWrapper(sourcePath.lastSegment(), this.isCaseSensitive));
                            if (sourceInfo != null) {
                                destination.entries().put(new StringWrapper(destinationPath.lastSegment(), this.isCaseSensitive), sourceInfo);
                            }
                        }
                        catch (DBHMException e) {
                            this.setCorrupt(e);
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_42, e.getCause()));
                        }
                    }
                    finally {
                        if (!sameParent) {
                            this.releaseDirectory(destination);
                        }
                    }
                }
                finally {
                    this.releaseDirectory(source);
                }
                this.mapMgr.closeAll(canonicalSource);
                this.mapMgr.closeAll(canonicalDest);
                IFileStore sourceStore = EFS.getLocalFileSystem().getStore(this.getLocation(sourcePath));
                IFileStore destinationStore = EFS.getLocalFileSystem().getStore(this.getLocation(destinationPath));
                if (!sourceStore.fetchInfo().exists()) break block17;
                try {
                    sourceStore.move(destinationStore, 0, null);
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_43, (Throwable)e));
                }
            }
            finally {
                this.globalLock.release();
            }
        }
        return sourceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ISharingMetadata.ITransaction transaction) throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            Object object = this.inverseItemInfosLock;
            synchronized (object) {
                Object object2 = this.loadedComponentsLock;
                synchronized (object2) {
                    SharingMetadata2 sharingMetadata2 = this;
                    synchronized (sharingMetadata2) {
                        transaction.run();
                    }
                }
            }
        }
        finally {
            this.globalLock.release();
        }
    }

    @Override
    public FileItemInfo setFileItemInfo(IPath path, FileItemInfo itemInfo) throws FileSystemClientException {
        path = path.makeAbsolute();
        Directory dir = this.loadDirectory(path.removeLastSegments(1), true);
        try {
            FileItemInfo oldInfo = itemInfo == null ? (FileItemInfo)dir.entries().remove(new StringWrapper(path.lastSegment(), this.isCaseSensitive)) : dir.entries().put(new StringWrapper(path.lastSegment(), this.isCaseSensitive), itemInfo);
            FileItemInfo fileItemInfo = oldInfo;
            return fileItemInfo;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_44, e.getCause()));
        }
        finally {
            this.releaseDirectory(dir);
        }
    }

    @Override
    public InverseFileItemInfo setFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, InverseFileItemInfo itemInfo) throws FileSystemClientException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            try {
                this.initInverseItemInfos();
                try {
                    this.setBusy(this.inverseItemInfosFlag);
                    Map inverseMap = (Map)this.inverseItemInfos.get((Object)item.getItemId().getUuidValue());
                    if (inverseMap == null) {
                        inverseMap = Collections.emptyMap();
                    }
                    LinkedHashMap<ConnectionComponent, InverseFileItemInfo> newMap = new LinkedHashMap<ConnectionComponent, InverseFileItemInfo>(inverseMap);
                    ConnectionComponent cc = new ConnectionComponent((IContextHandle)connection.getItemType().createItemHandle(connection.getItemId(), null), (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(component.getItemId(), null));
                    InverseFileItemInfo oldInfo = (InverseFileItemInfo)inverseMap.get(cc);
                    if (itemInfo == null) {
                        newMap.remove(cc);
                    } else {
                        newMap.put(cc, itemInfo);
                    }
                    if (newMap.isEmpty()) {
                        this.inverseItemInfos.remove((Object)item.getItemId().getUuidValue());
                    } else {
                        this.inverseItemInfos.put((Object)item.getItemId().getUuidValue(), newMap);
                    }
                    this.saveInverseMapJob.requestSave();
                    return oldInfo;
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
            }
            catch (DBHMException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_45, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_46, (Throwable)e));
            }
        }
    }

    @Override
    public synchronized ISharingDescriptor setSharingDescriptor(IPath sharePath, ISharingDescriptor descriptor, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                ISharingDescriptor oldDesc;
                this.setBusy(this.descriptorsFlag);
                sharePath = this.getCanonicalPath(sharePath, false);
                if (descriptor == null) {
                    oldDesc = (ISharingDescriptor)this.descriptors.remove((Object)new StringWrapper(sharePath.toString(), this.isCaseSensitive));
                    if (oldDesc != null) {
                        this.inverseDescriptors.remove(new ShareRoot(oldDesc.getRootVersionable(), oldDesc.getComponent(), oldDesc.getConnectionHandle()));
                    }
                } else {
                    IPath oldPath;
                    ShareRoot oldRoot;
                    oldDesc = (ISharingDescriptor)this.descriptors.put((Object)new StringWrapper(sharePath.toString(), this.isCaseSensitive), (Object)descriptor);
                    ShareRoot newRoot = new ShareRoot(descriptor.getRootVersionable(), descriptor.getComponent(), descriptor.getConnectionHandle());
                    if (oldDesc != null && !(oldRoot = new ShareRoot(oldDesc.getRootVersionable(), oldDesc.getComponent(), oldDesc.getConnectionHandle())).equals(newRoot)) {
                        this.inverseDescriptors.remove(oldRoot);
                    }
                    if ((oldPath = this.inverseDescriptors.put(newRoot, sharePath)) != null && !sharePath.equals((Object)oldPath) && !this.getCanonicalPath(sharePath, true).equals((Object)this.getCanonicalPath(oldPath, true))) {
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.SharingMetadata2_47, (Object[])new Object[]{oldPath, sharePath}, (Object[])new Object[0])));
                    }
                }
                this.saveDescriptorsJob.requestSave();
                return oldDesc;
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
        }
        catch (DBHMException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_48, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_49, (Throwable)e));
        }
    }

    private void setBusy(PersistentBusyFlag flag) {
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", -1, NLS.bind((String)Messages.SharingMetadata2_50, (Object)flag, (Object[])new Object[0]), null);
        flag.setBusy(multi);
        if (!multi.isOK()) {
            LoggingHelper.log((IStatus)multi);
        }
    }

    @Override
    public synchronized Map<IPath, ISharingDescriptor> getSharingDescriptors(IComponentHandle component, IContextHandle connectionHandle) throws FileSystemClientException {
        try {
            Set entrySet;
            this.initDescriptors();
            HashMap<IPath, ISharingDescriptor> result = new HashMap<IPath, ISharingDescriptor>();
            try {
                entrySet = this.descriptors.entrySet();
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
            for (Map.Entry entry : entrySet) {
                ISharingDescriptor descriptor = (ISharingDescriptor)entry.getValue();
                if (descriptor == null || !descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle) || !descriptor.getComponent().sameItemId((IItemHandle)component)) continue;
                result.put((IPath)new Path(null, ((StringWrapper)entry.getKey()).toString()), descriptor);
            }
            return result;
        }
        catch (DBHMException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_51, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_52, (Throwable)e));
        }
    }

    @Override
    public synchronized Map<IPath, ISharingDescriptor> getSharingDescriptors() throws FileSystemClientException {
        try {
            Set entrySet;
            this.initDescriptors();
            HashMap<IPath, ISharingDescriptor> result = new HashMap<IPath, ISharingDescriptor>();
            try {
                entrySet = this.descriptors.entrySet();
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
            for (Map.Entry entry : entrySet) {
                ISharingDescriptor descriptor = (ISharingDescriptor)entry.getValue();
                result.put((IPath)new Path(null, ((StringWrapper)entry.getKey()).toString()), descriptor);
            }
            return result;
        }
        catch (DBHMException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_51, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_52, (Throwable)e));
        }
    }

    @Override
    public String toDebugString() {
        final StringBuffer result = new StringBuffer();
        try {
            this.accept(new IVisitor(){

                public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                    result.append(path.toString());
                    result.append(" -> ");
                    result.append(entry.getVersionableHandle().getItemId());
                    result.append('\n');
                    return true;
                }
            }, (IPath)Path.ROOT, Integer.MAX_VALUE, false, null);
        }
        catch (FileSystemClientException e) {
            StringWriter output = new StringWriter();
            PrintWriter pw = new PrintWriter(output);
            e.printStackTrace(pw);
            pw.flush();
            result.append(output);
        }
        return result.toString();
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedComponents(IProgressMonitor monitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                return new ArrayList<LoadedConfigurationDescriptor>(this.loadedComponents.values());
            }
            catch (DBHMException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_53, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_54, (Throwable)e));
            }
        }
    }

    @Override
    public Collection<ConnectionDescriptor> allLoadedContexts(IProgressMonitor monitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                HashSet<ConnectionDescriptor> result = new HashSet<ConnectionDescriptor>();
                for (ConfigurationDescriptor loadedComponent : this.loadedComponents.values()) {
                    result.add(new ConnectionDescriptor(loadedComponent.id, loadedComponent.uri, loadedComponent.connectionHandle));
                }
                return result;
            }
            catch (DBHMException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_55, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_56, (Throwable)e));
            }
        }
    }

    @Override
    public LoadedConfigurationDescriptor componentLoaded(LoadedConfigurationDescriptor desc, IProgressMonitor monitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                this.setBusy(this.loadedComponentsFlag);
                LoadedConfigurationDescriptor oldDesc = (LoadedConfigurationDescriptor)this.loadedComponents.put((Object)new ConnectionComponent(desc.connectionHandle, desc.componentHandle), (Object)desc);
                this.saveLoadedComponentsJob.requestSave();
                return oldDesc;
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_57, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_58, (Throwable)e));
            }
        }
    }

    @Override
    public LoadedConfigurationDescriptor componentUnloaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                LoadedConfigurationDescriptor oldDesc;
                this.initLoadedComponents();
                this.setBusy(this.loadedComponentsFlag);
                try {
                    oldDesc = (LoadedConfigurationDescriptor)this.loadedComponents.remove((Object)new ConnectionComponent(connection, component));
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
                this.saveLoadedComponentsJob.requestSave();
                return oldDesc;
            }
            catch (DBHMException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_59, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_60, (Throwable)e));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean hasShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            ShareRoot r;
            this.initDescriptors();
            Iterator<ShareRoot> iterator = this.inverseDescriptors.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(r = iterator.next()).cc.getComponent().sameItemId((IItemHandle)component) || !r.cc.getConnection().sameItemId((IItemHandle)connection));
            return true;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_61, e.getCause()));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_62, (Throwable)e));
        }
    }

    @Override
    public boolean isLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                try {
                    return this.loadedComponents.containsKey((Object)new ConnectionComponent(connection, component));
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
            }
            catch (DBHMException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_63, e.getCause()));
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_64, (Throwable)e));
            }
        }
    }

    @Override
    public PersistentBusyFlag getPersistentMetadataFlag() {
        return this.persistentMetadataFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCorruptionListener(ICorruptCopyFileAreaListener listener) {
        Object object = this.corruptionLock;
        synchronized (object) {
            if (this.isCorruptFlag.getState()) {
                listener.corrupt(this.getCorruptionEvent());
            }
            this.corruptionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCorruptionListener(ICorruptCopyFileAreaListener listener) {
        Object object = this.corruptionLock;
        synchronized (object) {
            this.corruptionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorrupt(boolean newValue, String debugExplanation, Throwable cause) {
        if (FileSystemCore.isShutDown()) {
            return;
        }
        Object object = this.corruptionLock;
        synchronized (object) {
            if (newValue == this.isCorruptFlag.getState()) {
                return;
            }
            try {
                this.isCorruptFlag.setState(newValue);
            }
            catch (IOException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, "Could not write corruption bit", (Throwable)e));
            }
            if (newValue) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, debugExplanation == null ? null : debugExplanation, cause));
            }
            ICorruptCopyFileAreaEvent event = this.getCorruptionEvent();
            for (ICorruptCopyFileAreaListener listener : this.corruptionListeners) {
                listener.corrupt(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ICorruptCopyFileAreaEvent getCorruptionEvent() {
        Object object = this.corruptionLock;
        synchronized (object) {
            final boolean localCorrupt = this.isCorruptFlag.getState();
            return new ICorruptCopyFileAreaEvent(){

                public boolean isCorrupt() {
                    return localCorrupt;
                }

                public IPath getRoot() {
                    return SharingMetadata2.this.cfaRoot;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrupted() {
        Object object = this.corruptionLock;
        synchronized (object) {
            return this.isCorruptFlag.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExclusiveCFAAccess(IProgressMonitor progress) throws FileSystemClientException {
        FilesystemLock filesystemLock = this.fsLock;
        synchronized (filesystemLock) {
            if (!this.fsLock.isAcquired() && !this.fsLock.acquire(progress)) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 209, NLS.bind((String)Messages.CopyFileArea_LOCK_FAILED_ON_PATH, (Object)this.fsLock.getFile().getAbsolutePath(), (Object[])new Object[0]), null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExclusiveCFAAccess(IProgressMonitor progress) {
        FilesystemLock filesystemLock = this.fsLock;
        synchronized (filesystemLock) {
            this.fsLock.release(progress);
        }
    }

    @Override
    public boolean isSamePath(IPath path1, IPath path2) {
        return this.getCanonicalPath(path1, true).equals((Object)this.getCanonicalPath(path2, true));
    }

    static class ConnectionComponent
    implements ISharingMetadata.IConnectionComponent {
        private IContextHandle connectionHandle;
        private IComponentHandle component;

        public ConnectionComponent(IContextHandle connectionHandle, IComponentHandle component) {
            this.connectionHandle = connectionHandle;
            this.component = component;
        }

        public IComponentHandle getComponent() {
            return this.component;
        }

        public IContextHandle getConnection() {
            return this.connectionHandle;
        }

        public int hashCode() {
            return this.connectionHandle.getItemId().getUuidValue().hashCode() ^ this.component.getItemId().getUuidValue().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConnectionComponent)) {
                return false;
            }
            ConnectionComponent other = (ConnectionComponent)obj;
            return this.connectionHandle.sameItemId((IItemHandle)other.connectionHandle) && this.component.sameItemId((IItemHandle)other.component);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Directory
    extends LockableMap<StringWrapper, FileItemInfo> {
        protected final IPath realPath;
        protected boolean doInit;

        public Directory(IPath path, IPath realPath) {
            super(path, null);
            this.realPath = realPath;
            this.doInit = true;
            this.init(SharingMetadata2.this.getLocation(realPath).append(SharingMetadata2.SCM_ITEM_INFOS).toFile());
        }

        @Override
        protected void init(File f) {
            if (this.doInit) {
                super.init(f);
            }
        }

        @Override
        protected void initEntries() {
            try {
                this.entries = new MetadataStore(SharingMetadata2.this.getLocation(this.getRealPath()).append(SharingMetadata2.SCM_ITEM_INFOS).toFile());
            }
            catch (DBHMException e) {
                SharingMetadata2.this.setCorrupt(e);
                throw e;
            }
        }

        public IPath[] children() {
            File[] childDirs = SharingMetadata2.this.getLocation(this.getRealPath()).toFile().listFiles(DIRECTORY_FILTER);
            if (childDirs == null) {
                return new IPath[0];
            }
            IPath[] childPaths = new IPath[childDirs.length];
            int i = 0;
            while (i < childDirs.length) {
                childPaths[i] = this.getRealPath().append(childDirs[i].getName());
                ++i;
            }
            return childPaths;
        }

        public IPath getRealPath() {
            return this.realPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InverseMetadataStore
    extends Store<String, Map<ISharingMetadata.IConnectionComponent, InverseFileItemInfo>> {
        private static final int METADATA_VERSION = 1;
        private static final int IS_FOLDER = 1;
        private static final int IS_CONTENT_CHANGED = 2;
        private static final int HAS_PARENT = 4;
        private static final int IS_REMOTE = 8;
        private static final int IS_ORIGINAL_EXECUTABLE = 16;
        private static final int HAS_LINE_DELIMITER = 32;
        private static final int IS_FLAGS_EXTENDED = 32;
        private static final int HAS_CURRENT_PROPERTIES = 64;
        private static final int IS_EXECUTABLE = 128;
        private static final int HAS_PREDECESSOR_HINT_HASH = 256;
        private static final int HAS_ORIGINAL_ENCODING = 512;
        private static final int HAS_ORIGINAL_PROPERTIES = 1024;
        private static final int HAS_LAST_CONTENT_CHANGE_CHECK_STAMP = 2048;
        private static final int HAS_LOCAL_PARENT = 4096;
        private static final int HAS_REMOTE_CHILDREN = 8192;
        private static final int HAS_LOCAL_NAME = 16384;
        private static final int IS_LOADED_WITH_ALTERNATIVE_NAME = 32768;
        private static final int IS_SYMBOLIC_LINK = 2;

        public InverseMetadataStore(File file) {
            super(file, SharingMetadata2.this.heapMgr);
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(1);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            int v = in.readInt();
            if (v != 1) {
                throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 1);
            }
        }

        protected long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if ((flags & 1) != 0) {
                dos.writeUTF((String)o);
                return this.persistStream(out);
            }
            Map inverseMap = (Map)o;
            dos.writeInt(inverseMap.size());
            for (Map.Entry e : inverseMap.entrySet()) {
                boolean hasLocalParent;
                boolean hasLocalName;
                boolean hasParent;
                ISharingMetadata.IConnectionComponent component = (ISharingMetadata.IConnectionComponent)e.getKey();
                InverseFileItemInfo info = (InverseFileItemInfo)e.getValue();
                dos.writeUTF(component.getConnection().getItemType().getName());
                dos.writeUTF(component.getConnection().getItemType().getNamespaceURI());
                dos.writeUTF(component.getConnection().getItemId().getUuidValue());
                dos.writeUTF(component.getComponent().getItemId().getUuidValue());
                boolean isRemote = info.getVersionableHandle().hasStateId();
                int fiFlags = isRemote ? 8 : 0;
                int fiFlags2 = 0;
                boolean bl = hasParent = info.getParent() != null;
                if (hasParent) {
                    fiFlags |= 4;
                }
                boolean bl2 = hasLocalName = info.getLocalName() != null;
                if (hasLocalName) {
                    fiFlags |= 0x4000;
                }
                boolean bl3 = hasLocalParent = info.getLocalParent() != null;
                if (hasLocalParent) {
                    fiFlags |= 0x1000;
                }
                if (info.isLoadedWithAnotherName()) {
                    fiFlags |= 0x8000;
                }
                boolean folder = info.isFolder();
                boolean file = info.isFile();
                boolean hasLineDelimiter = false;
                boolean hasContentType = false;
                boolean hasPredecessorHintHash = false;
                boolean hasOriginalEncoding = false;
                boolean hasOriginalContentProperties = false;
                boolean hasLastContentChangeCheckStamp = false;
                boolean hasRemoteChildren = false;
                if (folder) {
                    fiFlags |= 1;
                    if (!info.getRemoteChildren().isEmpty()) {
                        hasRemoteChildren = true;
                        fiFlags |= 0x2000;
                    }
                } else if (file) {
                    if (info.isContentChanged()) {
                        fiFlags |= 2;
                    }
                    if (info.isOriginalExecutable()) {
                        fiFlags |= 0x10;
                    }
                    if (info.getLineDelimiter() != null) {
                        hasLineDelimiter = true;
                        fiFlags |= 0x20;
                    }
                    if (info.getContentType() != null) {
                        hasContentType = true;
                        fiFlags |= 0x40;
                    }
                    if (isRemote) {
                        fiFlags |= 0x400;
                    }
                    if (info.isExecutable()) {
                        fiFlags |= 0x80;
                    }
                    if (info.getStoredPredecessorHintHash() != null) {
                        hasPredecessorHintHash = true;
                        fiFlags |= 0x100;
                    }
                    if (info.getStoredEncoding() != null) {
                        hasOriginalEncoding = true;
                        fiFlags |= 0x200;
                    }
                    if (info.getStoredNumLineDelimiters() != -1L) {
                        hasOriginalContentProperties = true;
                        fiFlags |= 0x400;
                    }
                    if (info.getLastContentChangeCheckStamp() != -1L) {
                        hasLastContentChangeCheckStamp = true;
                        fiFlags |= 0x800;
                    }
                } else {
                    fiFlags |= 1;
                    fiFlags |= 0x20;
                    fiFlags2 |= 2;
                    if (info.isContentChanged()) {
                        fiFlags |= 2;
                    }
                }
                dos.writeShort(fiFlags);
                if ((fiFlags & 1) != 0 && (fiFlags & 0x20) != 0) {
                    dos.writeShort(fiFlags2);
                }
                IVersionableHandle h = info.getVersionableHandle();
                dos.writeUTF(h.getItemId().getUuidValue());
                if (isRemote) {
                    dos.writeUTF(h.getStateId().getUuidValue());
                }
                if (hasParent) {
                    dos.writeUTF(info.getParent().getItemId().getUuidValue());
                    dos.writeUTF(info.getName());
                }
                if (hasLocalName) {
                    dos.writeUTF(info.getLocalName());
                }
                if (hasLocalParent) {
                    dos.writeUTF(info.getLocalParent().getItemId().getUuidValue());
                }
                if (folder) {
                    if (!hasRemoteChildren) continue;
                    dos.writeInt(info.getRemoteChildren().size());
                    Iterator<Map.Entry<String, IVersionableHandle>> entryIt = info.getRemoteChildren().entrySet().iterator();
                    Iterator<IVersionableHandle> j = info.getRemoteChildren().values().iterator();
                    while (j.hasNext()) {
                        int folderFlags = 0;
                        int k = 8;
                        while (k != 0 && j.hasNext()) {
                            folderFlags = folderFlags << 1 | (j.next() instanceof IFolderHandle ? 1 : 0);
                            --k;
                        }
                        dos.writeByte(folderFlags);
                        k = 8 - k;
                        while (k != 0) {
                            Map.Entry<String, IVersionableHandle> childEntry = entryIt.next();
                            String name = childEntry.getKey();
                            IVersionableHandle child = childEntry.getValue();
                            dos.writeUTF(name);
                            dos.writeUTF(child.getItemId().getUuidValue());
                            --k;
                        }
                    }
                    continue;
                }
                if (file) {
                    if (hasLineDelimiter) {
                        dos.writeInt(info.getLineDelimiter().dbValue());
                    }
                    if (hasContentType) {
                        dos.writeInt(1);
                        dos.writeUTF("contentType");
                        dos.writeUTF(info.getContentType());
                    }
                    if (!isRemote) continue;
                    if (hasLastContentChangeCheckStamp) {
                        dos.writeLong(info.getLastContentChangeCheckStamp());
                    }
                    dos.writeUTF(info.getHash().toString());
                    dos.writeLong(info.getContentLength());
                    dos.writeInt(info.getOriginalLineDelimiter().dbValue());
                    dos.writeInt(1);
                    dos.writeUTF("contentType");
                    dos.writeUTF(info.getOriginalContentType());
                    if (hasPredecessorHintHash) {
                        dos.writeUTF(info.getStoredPredecessorHintHash().toString());
                    }
                    dos.writeLong(info.getStoredSize());
                    if (hasOriginalEncoding) {
                        dos.writeUTF(info.getStoredEncoding());
                    }
                    dos.writeUTF(info.getStoredHash().toString());
                    if (hasOriginalContentProperties) {
                        dos.writeInt(1);
                        dos.writeUTF("numLineDelim");
                        dos.writeUTF(Long.toString(info.getStoredNumLineDelimiters()));
                        continue;
                    }
                    dos.writeInt(0);
                    continue;
                }
                if (!isRemote) continue;
                dos.writeUTF(info.getHash().toString());
                dos.writeUTF(info.getStoredHash().toString());
            }
            return this.persistStream(out);
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            DataInputStream dis = new DataInputStream(in);
            if ((flags & 1) != 0) {
                return dis.readUTF();
            }
            int size = dis.readInt();
            LinkedHashMap<ConnectionComponent, InverseFileItemInfo> inverseMap = new LinkedHashMap<ConnectionComponent, InverseFileItemInfo>((int)((float)size / 0.75f));
            int i = size;
            while (i != 0) {
                long storedNumLineDelimiters;
                ContentHash predecessorHintHash;
                String originalEncoding;
                String originalContentType;
                FileLineDelimiter originalLineDelimiter;
                boolean originalExecutable;
                boolean executable;
                String contentType;
                FileLineDelimiter lineDelimiter;
                long lastContentChangeCheckStamp;
                long storedContentSize;
                long contentLength;
                ContentHash storedHash;
                ContentHash hash;
                LinkedHashMap<String, IVersionableHandle> remoteChildren;
                boolean contentChanged;
                ISymbolicLinkHandle v;
                IFolderHandle localParent;
                String localName;
                IFolderHandle parent;
                String name = dis.readUTF();
                String namespace = dis.readUTF();
                IItemType type = IItemType.IRegistry.INSTANCE.getItemType(name, namespace);
                String itemId = dis.readUTF();
                IContextHandle connectionHandle = (IContextHandle)type.createItemHandle(UUID.valueOf((String)itemId), null);
                itemId = dis.readUTF();
                IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null);
                ConnectionComponent key = new ConnectionComponent(connectionHandle, component);
                short fiFlags = dis.readShort();
                short fiFlags2 = (fiFlags & 1) != 0 && (fiFlags & 0x20) != 0 ? dis.readShort() : (short)0;
                boolean isRemote = (fiFlags & 8) != 0;
                itemId = dis.readUTF();
                UUID stateId = isRemote ? UUID.valueOf((String)dis.readUTF()) : null;
                if ((fiFlags & 4) != 0) {
                    UUID parentId = UUID.valueOf((String)dis.readUTF());
                    parent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(parentId, null);
                    name = dis.readUTF();
                } else {
                    parent = null;
                    name = null;
                }
                if ((fiFlags & 0x4000) != 0) {
                    localName = dis.readUTF();
                } else {
                    localParent = null;
                    localName = null;
                }
                if ((fiFlags & 0x1000) != 0) {
                    UUID parentId = UUID.valueOf((String)dis.readUTF());
                    localParent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(parentId, null);
                } else {
                    localParent = null;
                }
                boolean isLoadedWithAlternativeName = (fiFlags & 0x8000) != 0;
                if ((fiFlags2 & 2) != 0) {
                    v = (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), stateId);
                    contentChanged = (fiFlags & 2) != 0;
                    remoteChildren = Collections.EMPTY_MAP;
                    if (isRemote) {
                        hash = ContentHash.valueOf((String)dis.readUTF());
                        storedHash = ContentHash.valueOf((String)dis.readUTF());
                    } else {
                        hash = null;
                        storedHash = null;
                    }
                    contentLength = -1L;
                    storedContentSize = -1L;
                    lastContentChangeCheckStamp = -1L;
                    lineDelimiter = null;
                    contentType = null;
                    executable = false;
                    originalExecutable = false;
                    originalLineDelimiter = null;
                    originalContentType = null;
                    originalEncoding = null;
                    predecessorHintHash = null;
                    storedNumLineDelimiters = -1L;
                } else if ((fiFlags & 1) != 0 && (fiFlags & 0x20) == 0 || (fiFlags2 & 1) != 0) {
                    v = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), stateId);
                    contentChanged = false;
                    lastContentChangeCheckStamp = -1L;
                    hash = null;
                    contentLength = -1L;
                    storedContentSize = -1L;
                    storedHash = null;
                    if ((fiFlags & 0x2000) != 0) {
                        int numChildren = dis.readInt();
                        remoteChildren = new LinkedHashMap((int)((double)numChildren / 0.75));
                        while (numChildren != 0) {
                            int folderFlags = dis.readUnsignedByte();
                            int mask = 1 << Math.min(numChildren - 1, 7);
                            while (mask != 0) {
                                String childName = dis.readUTF();
                                IItemType childType = (folderFlags & mask) == 0 ? IFileItem.ITEM_TYPE : IFolder.ITEM_TYPE;
                                IVersionableHandle childHandle = (IVersionableHandle)childType.createItemHandle(UUID.valueOf((String)dis.readUTF()), null);
                                remoteChildren.put(childName, childHandle);
                                --numChildren;
                                mask >>= 1;
                            }
                        }
                        remoteChildren = Collections.unmodifiableMap(remoteChildren);
                    } else {
                        remoteChildren = Collections.EMPTY_MAP;
                    }
                    lineDelimiter = null;
                    contentType = null;
                    executable = false;
                    originalExecutable = false;
                    originalLineDelimiter = null;
                    originalContentType = null;
                    originalEncoding = null;
                    predecessorHintHash = null;
                    storedNumLineDelimiters = -1L;
                } else {
                    String propertyValue;
                    int j;
                    v = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), stateId);
                    contentChanged = (fiFlags & 2) != 0;
                    executable = (fiFlags & 0x80) != 0;
                    originalExecutable = (fiFlags & 0x10) != 0;
                    lineDelimiter = (fiFlags & 0x20) != 0 ? FileLineDelimiter.getLineDelimiter((int)dis.readInt()) : null;
                    contentType = null;
                    if ((fiFlags & 0x40) != 0) {
                        int numFileItemProperties = dis.readInt();
                        j = 0;
                        while (j < numFileItemProperties) {
                            String propertyName = dis.readUTF();
                            propertyValue = dis.readUTF();
                            if (propertyName.equals("contentType")) {
                                contentType = propertyValue;
                            }
                            ++j;
                        }
                    }
                    remoteChildren = Collections.EMPTY_MAP;
                    if (isRemote) {
                        lastContentChangeCheckStamp = (fiFlags & 0x800) != 0 ? dis.readLong() : -1L;
                        hash = ContentHash.valueOf((String)dis.readUTF());
                        contentLength = dis.readLong();
                        originalLineDelimiter = FileLineDelimiter.getLineDelimiter((int)dis.readInt());
                        originalContentType = null;
                        if ((fiFlags & 0x400) != 0) {
                            int numFileItemProperties = dis.readInt();
                            j = 0;
                            while (j < numFileItemProperties) {
                                String propertyName = dis.readUTF();
                                propertyValue = dis.readUTF();
                                if (propertyName.equals("contentType")) {
                                    originalContentType = propertyValue;
                                }
                                ++j;
                            }
                        }
                        predecessorHintHash = (fiFlags & 0x100) != 0 ? ContentHash.valueOf((String)dis.readUTF()) : null;
                        storedContentSize = dis.readLong();
                        originalEncoding = (fiFlags & 0x200) != 0 ? dis.readUTF() : null;
                        storedHash = ContentHash.valueOf((String)dis.readUTF());
                        storedNumLineDelimiters = -1L;
                        int originalContentPropertiesSize = dis.readInt();
                        j = 0;
                        while (j < originalContentPropertiesSize) {
                            String propertyName = dis.readUTF();
                            propertyValue = dis.readUTF();
                            if (propertyName.equals("numLineDelim")) {
                                storedNumLineDelimiters = Long.parseLong(propertyValue);
                            }
                            ++j;
                        }
                    } else {
                        lastContentChangeCheckStamp = -1L;
                        hash = null;
                        contentLength = -1L;
                        originalLineDelimiter = null;
                        originalContentType = null;
                        predecessorHintHash = null;
                        storedContentSize = -1L;
                        originalEncoding = null;
                        storedHash = null;
                        storedNumLineDelimiters = -1L;
                    }
                }
                InverseFileItemInfo value = new InverseFileItemInfo((IVersionableHandle)v, contentChanged, lastContentChangeCheckStamp, parent, name, isLoadedWithAlternativeName, remoteChildren, localParent, localName, hash, contentLength, originalLineDelimiter, lineDelimiter, originalContentType, contentType, predecessorHintHash, storedContentSize, originalEncoding, storedHash, storedNumLineDelimiters, executable, originalExecutable);
                inverseMap.put(key, value);
                --i;
            }
            return Collections.unmodifiableMap(inverseMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetadataDiskBackedMapManager
    extends DiskBackedMapManager<StringWrapper, FileItemInfo> {
        public MetadataDiskBackedMapManager(ReadWriteLock lock, PersistentBusyFlag busyFlag) {
            super(lock, busyFlag, SharingMetadata2.this);
        }

        @Override
        protected LockableMap<StringWrapper, FileItemInfo> getLockableMap(IPath path, IPath realPath) {
            return new Directory(path, realPath);
        }

        public void closeAll(IPath basePath) throws FileSystemClientException {
            basePath = SharingMetadata2.this.getCanonicalPath(basePath, true);
            Assert.isTrue((this.lock.threadWrites() > 0 ? 1 : 0) != 0);
            MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.SharingMetadata2_4, null);
            Iterator i = this.inUse.values().iterator();
            while (i.hasNext()) {
                LockableMap current = (LockableMap)i.next();
                if (!basePath.isPrefixOf(current.getPath())) continue;
                try {
                    i.remove();
                    current.close();
                }
                catch (DBHMException e) {
                    SharingMetadata2.this.setCorrupt(true, "Corruption detected on " + basePath, e.getCause());
                    result.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_5, (Object)current.getPath(), (Object[])new Object[0]), e.getCause()));
                }
                catch (IOException e) {
                    result.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_6, (Object)current.getPath(), (Object[])new Object[0]), (Throwable)e));
                }
                this.lockedExclusively.remove(current.getPath());
            }
            if (this.lockedExclusively.isEmpty()) {
                this.saveJob.busyFlag.setComplete(result);
            }
            if (!result.isOK()) {
                throw new FileSystemClientException((IStatus)result);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetadataStore
    extends Store<StringWrapper, FileItemInfo> {
        private static final int METADATA_VERSION = 1;
        private static final int IS_FOLDER = 1;
        private static final int IS_CONTENT_CHANGED = 2;
        private static final int HAS_PARENT = 4;
        private static final int IS_REMOTE = 8;
        private static final int IS_ORIGINAL_EXECUTABLE = 16;
        private static final int HAS_LINE_DELIMITER = 32;
        private static final int HAS_CURRENT_PROPERTIES = 64;
        private static final int IS_EXECUTABLE = 128;
        private static final int HAS_PREDECESSOR_HINT_HASH = 256;
        private static final int HAS_ORIGINAL_ENCODING = 512;
        private static final int HAS_ORIGINAL_PROPERTIES = 1024;
        private static final int HAS_LAST_CONTENT_CHANGE_CHECK_STAMP = 2048;
        private static final int IS_LOADED_WITH_ANOTHER_NAME = 4096;
        private static final int IS_SYMBOLIC_LINK = 8192;

        public MetadataStore(File file) {
            super(file, SharingMetadata2.this.heapMgr);
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(1);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            int v = in.readInt();
            if (v != 1) {
                throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 1);
            }
        }

        protected long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            boolean hasParent;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if ((flags & 1) != 0) {
                dos.writeUTF(o.toString());
                return this.persistStream(out);
            }
            FileItemInfo info = (FileItemInfo)o;
            boolean isRemote = info.getVersionableHandle().hasStateId();
            int fiFlags = isRemote ? 8 : 0;
            boolean bl = hasParent = info.getParent() != null;
            if (hasParent) {
                fiFlags |= 4;
            }
            boolean folder = info.isFolder();
            boolean file = info.isFile();
            boolean hasLineDelimiter = false;
            boolean hasContentType = false;
            boolean hasPredecessorHintHash = false;
            boolean hasOriginalEncoding = false;
            boolean hasOriginalContentProperties = false;
            boolean hasLastContentChangeCheckStamp = false;
            if (folder) {
                fiFlags |= 1;
            } else if (file) {
                if (info.isContentChanged()) {
                    fiFlags |= 2;
                }
                if (info.isOriginalExecutable()) {
                    fiFlags |= 0x10;
                }
                if (info.getLineDelimiter() != null) {
                    hasLineDelimiter = true;
                    fiFlags |= 0x20;
                }
                if (info.getContentType() != null) {
                    hasContentType = true;
                    fiFlags |= 0x40;
                }
                if (isRemote) {
                    fiFlags |= 0x400;
                }
                if (info.isExecutable()) {
                    fiFlags |= 0x80;
                }
                if (info.getStoredPredecessorHintHash() != null) {
                    hasPredecessorHintHash = true;
                    fiFlags |= 0x100;
                }
                if (info.getStoredEncoding() != null) {
                    hasOriginalEncoding = true;
                    fiFlags |= 0x200;
                }
                if (info.getStoredNumLineDelimiters() != -1L) {
                    hasOriginalContentProperties = true;
                }
                if (info.getLastContentChangeCheckStamp() != -1L) {
                    hasLastContentChangeCheckStamp = true;
                    fiFlags |= 0x800;
                }
            } else {
                fiFlags |= 0x2000;
                if (info.isContentChanged()) {
                    fiFlags |= 2;
                }
            }
            if (info.isLoadedWithAnotherName()) {
                fiFlags |= 0x1000;
            }
            dos.writeShort(fiFlags);
            IVersionableHandle h = info.getVersionableHandle();
            dos.writeUTF(h.getItemId().getUuidValue());
            if (isRemote) {
                dos.writeUTF(h.getStateId().getUuidValue());
            }
            if (hasParent) {
                dos.writeUTF(info.getParent().getItemId().getUuidValue());
                dos.writeUTF(info.getName());
            }
            if (file) {
                if (hasLineDelimiter) {
                    dos.writeInt(info.getLineDelimiter().dbValue());
                }
                if (hasContentType) {
                    dos.writeInt(1);
                    dos.writeUTF("contentType");
                    dos.writeUTF(info.getContentType());
                } else {
                    dos.writeInt(0);
                }
                if (isRemote) {
                    if (hasLastContentChangeCheckStamp) {
                        dos.writeLong(info.getLastContentChangeCheckStamp());
                    }
                    dos.writeUTF(info.getHash().toString());
                    dos.writeLong(info.getContentLength());
                    dos.writeInt(info.getOriginalLineDelimiter().dbValue());
                    dos.writeInt(1);
                    dos.writeUTF("contentType");
                    dos.writeUTF(info.getOriginalContentType());
                    if (hasPredecessorHintHash) {
                        dos.writeUTF(info.getStoredPredecessorHintHash().toString());
                    }
                    dos.writeLong(info.getStoredSize());
                    if (hasOriginalEncoding) {
                        dos.writeUTF(info.getStoredEncoding());
                    }
                    dos.writeUTF(info.getStoredHash().toString());
                    if (hasOriginalContentProperties) {
                        dos.writeInt(1);
                        dos.writeUTF("numLineDelim");
                        dos.writeUTF(Long.toString(info.getStoredNumLineDelimiters()));
                    } else {
                        dos.writeInt(0);
                    }
                }
            } else if (!folder && isRemote) {
                dos.writeUTF(info.getHash().toString());
                dos.writeUTF(info.getStoredHash().toString());
            }
            return this.persistStream(out);
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            long storedNumLineDelimiters;
            String originalEncoding;
            ContentHash predecessorHintHash;
            String originalContentType;
            FileLineDelimiter originalLineDelimiter;
            long contentLength;
            boolean originalExecutable;
            boolean executable;
            String contentType;
            FileLineDelimiter lineDelimiter;
            long lastContentChangeCheckStamp;
            long storedContentSize;
            ContentHash storedHash;
            ContentHash hash;
            boolean contentChanged;
            ISymbolicLinkHandle v;
            String name;
            IFolderHandle parent;
            DataInputStream dis = new DataInputStream(in);
            if ((flags & 1) != 0) {
                return new StringWrapper(dis.readUTF(), SharingMetadata2.this.isCaseSensitive);
            }
            short fiFlags = dis.readShort();
            boolean isRemote = (fiFlags & 8) != 0;
            UUID itemId = UUID.valueOf((String)dis.readUTF());
            UUID stateId = isRemote ? UUID.valueOf((String)dis.readUTF()) : null;
            if ((fiFlags & 4) != 0) {
                UUID parentId = UUID.valueOf((String)dis.readUTF());
                parent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(parentId, null);
                name = dis.readUTF();
            } else {
                parent = null;
                name = null;
            }
            boolean loadedWithAnotherName = (fiFlags & 0x1000) != 0;
            if ((fiFlags & 0x2000) != 0) {
                v = (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(itemId, stateId);
                boolean bl = contentChanged = (fiFlags & 2) != 0;
                if (isRemote) {
                    hash = ContentHash.valueOf((String)dis.readUTF());
                    storedHash = ContentHash.valueOf((String)dis.readUTF());
                } else {
                    contentChanged = false;
                    hash = null;
                    storedHash = null;
                }
                storedContentSize = -1L;
                lastContentChangeCheckStamp = -1L;
                lineDelimiter = null;
                contentType = null;
                executable = false;
                originalExecutable = false;
                contentLength = -1L;
                originalLineDelimiter = null;
                originalContentType = null;
                predecessorHintHash = null;
                originalEncoding = null;
                storedNumLineDelimiters = -1L;
            } else if ((fiFlags & 1) != 0) {
                v = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(itemId, stateId);
                contentChanged = false;
                lastContentChangeCheckStamp = -1L;
                hash = null;
                storedContentSize = -1L;
                storedHash = null;
                lineDelimiter = null;
                contentType = null;
                executable = false;
                originalExecutable = false;
                contentLength = -1L;
                originalLineDelimiter = null;
                originalContentType = null;
                predecessorHintHash = null;
                originalEncoding = null;
                storedNumLineDelimiters = -1L;
            } else {
                String propertyValue;
                String propertyName;
                int i;
                int numFileItemProperties;
                v = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(itemId, stateId);
                contentChanged = (fiFlags & 2) != 0;
                executable = (fiFlags & 0x80) != 0;
                originalExecutable = (fiFlags & 0x10) != 0;
                lineDelimiter = (fiFlags & 0x20) != 0 ? FileLineDelimiter.getLineDelimiter((int)dis.readInt()) : null;
                contentType = null;
                if ((fiFlags & 0x40) != 0) {
                    numFileItemProperties = dis.readInt();
                    i = 0;
                    while (i < numFileItemProperties) {
                        propertyName = dis.readUTF();
                        propertyValue = dis.readUTF();
                        if (propertyName.equals("contentType")) {
                            contentType = propertyValue;
                        }
                        ++i;
                    }
                }
                if (isRemote) {
                    lastContentChangeCheckStamp = (fiFlags & 0x800) != 0 ? dis.readLong() : -1L;
                    hash = ContentHash.valueOf((String)dis.readUTF());
                    contentLength = dis.readLong();
                    originalLineDelimiter = FileLineDelimiter.getLineDelimiter((int)dis.readInt());
                    originalContentType = null;
                    if ((fiFlags & 0x400) != 0) {
                        numFileItemProperties = dis.readInt();
                        i = 0;
                        while (i < numFileItemProperties) {
                            propertyName = dis.readUTF();
                            propertyValue = dis.readUTF();
                            if (propertyName.equals("contentType")) {
                                originalContentType = propertyValue;
                            }
                            ++i;
                        }
                    }
                    predecessorHintHash = (fiFlags & 0x100) != 0 ? ContentHash.valueOf((String)dis.readUTF()) : null;
                    storedContentSize = dis.readLong();
                    originalEncoding = (fiFlags & 0x200) != 0 ? dis.readUTF() : null;
                    storedHash = ContentHash.valueOf((String)dis.readUTF());
                    storedNumLineDelimiters = -1L;
                    int originalContentPropertiesSize = dis.readInt();
                    i = 0;
                    while (i < originalContentPropertiesSize) {
                        propertyName = dis.readUTF();
                        propertyValue = dis.readUTF();
                        if (propertyName.equals("numLineDelim")) {
                            storedNumLineDelimiters = Long.parseLong(propertyValue);
                        }
                        ++i;
                    }
                } else {
                    lastContentChangeCheckStamp = -1L;
                    hash = null;
                    contentLength = -1L;
                    originalLineDelimiter = null;
                    originalContentType = null;
                    predecessorHintHash = null;
                    storedContentSize = -1L;
                    originalEncoding = null;
                    storedHash = null;
                    storedNumLineDelimiters = -1L;
                }
            }
            return new FileItemInfo((IVersionableHandle)v, contentChanged, lastContentChangeCheckStamp, parent, name, loadedWithAnotherName, hash, contentLength, originalLineDelimiter, lineDelimiter, originalContentType, contentType, predecessorHintHash, storedContentSize, originalEncoding, storedHash, storedNumLineDelimiters, executable, originalExecutable);
        }
    }

    static class ShareRoot {
        private IVersionableHandle root;
        private ConnectionComponent cc;

        public ShareRoot(IVersionableHandle root, IComponentHandle component, IContextHandle connection) {
            this.cc = new ConnectionComponent(connection, component);
            this.root = root;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShareRoot)) {
                return false;
            }
            ShareRoot other = (ShareRoot)obj;
            return this.root.sameItemId((IItemHandle)other.root) && other.cc.equals(this.cc);
        }

        public int hashCode() {
            return this.root.getItemId().hashCode() ^ this.cc.hashCode();
        }
    }
}

